/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.util.ArrayList;
import tno.geoenergy.data.Grid;
import tno.geoenergy.data.Voxet;

public class Sgrid {
    float[][][] xval = null;
    float[][][] yval = null;
    float[][][] zval = null;
    private int nx;
    private int ny;
    private int nz;
    String fileName;
    ArrayList<Voxet> props = new ArrayList();

    public int getNx() {
        return this.nx;
    }

    public void setNx(int nx) {
        this.nx = nx;
    }

    public int getNy() {
        return this.ny;
    }

    public void setNy(int ny) {
        this.ny = ny;
    }

    public int getNz() {
        return this.nz;
    }

    public void setNz(int nz) {
        this.nz = nz;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileNamePath() {
        return String.valueOf(this.fileName) + ".sg";
    }

    public float[][][] getXval() {
        return this.xval;
    }

    public float[][][] getYval() {
        return this.yval;
    }

    public float[][][] getZval() {
        return this.zval;
    }

    public ArrayList<Voxet> getProps() {
        return this.props;
    }

    public Sgrid() {
    }

    public Sgrid(Grid gtvdtop, Grid h, String newfilename) {
        this.setNx(gtvdtop.nx + 1);
        this.setNy(gtvdtop.ny + 1);
        this.setNz(2);
        this.xval = new float[this.nx][this.ny][this.nz];
        this.yval = new float[this.nx][this.ny][this.nz];
        this.zval = new float[this.nx][this.ny][this.nz];
        float dx = gtvdtop.dx;
        float dy = gtvdtop.dy;
        float orx = gtvdtop.originx - 0.5f * gtvdtop.dx;
        float ory = gtvdtop.originy - 0.5f * gtvdtop.dy;
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                int k = 0;
                while (k < this.nz) {
                    this.xval[i][j][k] = orx + (float)i * dx;
                    this.yval[i][j][k] = ory + (float)j * dy;
                    this.zval[i][j][k] = gtvdtop.getValueAtxy(this.xval[i][j][k], this.yval[i][j][k]) + (float)((double)k - 0.5) * h.getValueAtxy(this.xval[i][j][k], this.yval[i][j][k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.setFileName(newfilename);
    }

    public Sgrid(double[][] topdepth, double dx, double dy, double originx, double originy, double[][] h, String newfilename) {
        this.setNx(topdepth.length + 1);
        this.setNy(topdepth[0].length + 1);
        this.setNz(2);
        this.xval = new float[this.nx][this.ny][this.nz];
        this.yval = new float[this.nx][this.ny][this.nz];
        this.zval = new float[this.nx][this.ny][this.nz];
        double orx = originx - 0.5 * dx;
        double ory = originy - 0.5 * dy;
        int jmax = 0;
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                int k = 0;
                while (k < this.nz) {
                    int imin = Math.max(i - 1, 0);
                    int jmin = Math.max(j - 1, 0);
                    int imax = Math.min(this.nx - 2, i);
                    jmax = Math.min(this.ny - 2, j);
                    this.xval[i][j][k] = (float)(orx + (double)i * dx);
                    this.yval[i][j][k] = (float)(ory + (double)j * dy);
                    this.zval[i][j][k] = (float)(0.25 * (topdepth[imin][jmax] + (double)(k - 1) * h[imin][jmax] + topdepth[imin][jmin] + (double)(k - 1) * h[imin][jmin] + topdepth[imax][jmin] + (double)(k - 1) * h[imax][jmin] + topdepth[imax][jmax] + (double)(k - 1) * h[imax][jmax]));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.setFileName(newfilename);
    }

    public Sgrid(double[][] topdepth, double dx, double dy, double originx, double originy, double[][][] h, String newfilename) {
        this.setNx(topdepth.length + 1);
        this.setNy(topdepth[0].length + 1);
        this.setNz(h[0][0].length + 1);
        this.xval = new float[this.nx][this.ny][this.nz];
        this.yval = new float[this.nx][this.ny][this.nz];
        this.zval = new float[this.nx][this.ny][this.nz];
        double orx = originx - 0.5 * dx;
        double ory = originy - 0.5 * dy;
        int jmax = 0;
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                int k = 0;
                while (k < this.nz) {
                    int imin = Math.max(i - 1, 0);
                    int jmin = Math.max(j - 1, 0);
                    int imax = Math.min(this.nx - 2, i);
                    jmax = Math.min(this.ny - 2, j);
                    this.xval[i][j][k] = (float)(orx + (double)i * dx);
                    this.yval[i][j][k] = (float)(ory + (double)j * dy);
                    this.zval[i][j][k] = k == 0 ? (float)(0.25 * (topdepth[imin][jmax] - 0.5 * h[imin][jmax][0] + topdepth[imin][jmin] - 0.5 * h[imin][jmin][0] + topdepth[imax][jmin] - 0.5 * h[imax][jmin][0] + topdepth[imax][jmax] - 0.5 * h[imax][jmax][0])) : this.zval[i][j][k - 1] + (float)(0.25 * (h[imin][jmax][k - 1] + h[imin][jmin][k - 1] + h[imax][jmin][k - 1] + h[imax][jmax][k - 1]));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.setFileName(newfilename);
    }

    public Voxet addProperty(String propname, float unknown) {
        Voxet v = new Voxet(this.nx - 1, this.ny - 1, this.nz - 1, 1.0f, String.valueOf(this.getFileName()) + "_propname", propname, unknown);
        this.props.add(v);
        return v;
    }

    public Voxet addProperty(Grid g, String propname) {
        return this.addProperty(g.values, g.unknown, propname);
    }

    public Voxet addProperty(float[][] values, float unknown, String propname) {
        Voxet v = this.addProperty(propname, unknown);
        int i = 0;
        while (i < this.nx - 1) {
            int j = 0;
            while (j < this.ny - 1) {
                v.getValues()[0][j][i] = values[i][j];
                ++j;
            }
            ++i;
        }
        return v;
    }

    public Voxet addProperty(double[][] values, double unknown, String propname) {
        Voxet v = this.addProperty(propname, (float)unknown);
        int i = 0;
        while (i < this.nx - 1) {
            int j = 0;
            while (j < this.ny - 1) {
                v.getValues()[0][j][i] = (float)values[i][j];
                ++j;
            }
            ++i;
        }
        return v;
    }

    public Voxet addProperty(double[][][] values, double unknown, String propname) {
        Voxet v = this.addProperty(propname, (float)unknown);
        int i = 0;
        while (i < this.nx - 1) {
            int j = 0;
            while (j < this.ny - 1) {
                int k = 0;
                while (k < this.nz - 1) {
                    v.getValues()[k][j][i] = (float)values[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return v;
    }

    public Voxet getProperty(int i) {
        if (i < this.props.size()) {
            return this.props.get(i);
        }
        return null;
    }
}

