/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import tno.geoenergy.data.Sgrid;
import tno.geoenergy.data.Voxet;
import tno.geoenergy.util.ByteBufferHelper;
import tno.geoenergy.util.ProcessException;

public class SgridWriter {
    public static void writeHeaderData(Sgrid sg) throws ProcessException, IOException {
        PrintStream pos = null;
        try {
            pos = new PrintStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(sg.fileName) + ".sg")));
            File fsg = new File(sg.fileName);
            String sg_name = fsg.getName();
            String pointsfile = String.valueOf(sg_name) + "__points@@";
            pos.println("GOCAD SGrid 1");
            pos.println("HEADER {");
            pos.println("name:" + sg_name);
            pos.println("*skin:false");
            pos.println("*sections*solid:true");
            pos.println("*sections*grid:false");
            pos.println("*edge*color:black");
            pos.println("*property:litho");
            pos.println("*painted:true");
            pos.println("cage:false");
            pos.println("*sections:3 1 0 0 2 0 0 3 1 0");
            pos.println("*volume*grid:true");
            pos.println("*volume:false");
            pos.println("*grid*color:gray80");
            pos.println("}");
            pos.println();
            pos.println("AXIS_N " + sg.getNx() + " " + sg.getNy() + " " + sg.getNz());
            pos.println("PROP_ALIGNMENT CELLS");
            pos.println("POINTS_OFFSET 0");
            pos.println("POINTS_FILE " + pointsfile);
            pos.println();
            int i = 0;
            while (i < sg.props.size()) {
                Voxet voxet = sg.getProperty(i);
                int iprop = i + 1;
                pos.println("PROPERTY " + iprop + " \"" + voxet.propName + "\"");
                pos.println("PROPERTY_CLASS 1 \"" + voxet.propName + "\"");
                pos.println("PROPERTY_CLASS_HEADER 1 \"" + voxet.propName + "\" {");
                pos.println(" *pclip:99");
                pos.println("last_selected_folder:Property");
                pos.println("*colormap*low_clip_transparent:true");
                pos.println("*colormap*high_clip_transparent:true");
                pos.println("*scale_function:linear");
                pos.println("*low_clip:200");
                pos.println("*high_clip:4386.596");
                pos.println("}");
                pos.println("PROP_ORIGINAL_UNIT 1 none");
                pos.println("PROP_UNIT 1 none");
                pos.println("PROP_NO_DATA_VALUE 1 " + voxet.getUnknown());
                pos.println("PROP_SAMPLE_STATS 1 75000 1367.9 108839 50 1500");
                pos.println("PROP_ESIZE 1 4");
                pos.println("PROP_ETYPE 1  IEEE");
                pos.println("PROP_FORMAT 1 RAW");
                pos.println("PROP_OFFSET 1 0");
                String fname = new File(voxet.fileName).getName();
                pos.println("PROP_FILE " + iprop + " " + fname + "_" + voxet.propName + "@@");
                if (i == sg.props.size() - 1) {
                    pos.println("END");
                } else {
                    pos.println();
                }
                FileOutputStream is = null;
                FileChannel channel = null;
                File f = new File(String.valueOf(voxet.fileName) + "_" + voxet.propName + "@@");
                is = new FileOutputStream(f);
                channel = is.getChannel();
                ByteBufferHelper buffer = new ByteBufferHelper(channel);
                SgridWriter.writeVoxetValues(voxet, buffer);
                buffer.flipwrite();
                ++i;
            }
            pos.close();
        }
        catch (Exception e) {
            System.err.println("Exception\n  " + e);
        }
    }

    private static void writePointValues(Sgrid sg, ByteBufferHelper buffer) throws IOException {
        float[][][] xval = sg.getXval();
        float[][][] yval = sg.getYval();
        float[][][] zval = sg.getZval();
        int k = 0;
        while (k < sg.getNz()) {
            int j = 0;
            while (j < sg.getNy()) {
                int i = 0;
                while (i < sg.getNx()) {
                    buffer.putFloat(xval[i][j][k]);
                    buffer.putFloat(yval[i][j][k]);
                    buffer.putFloat(zval[i][j][k]);
                    ++i;
                }
                ++j;
            }
            ++k;
        }
    }

    private static void writeVoxetValues(Voxet voxet, ByteBufferHelper buffer) throws IOException {
        System.out.println(" Nx " + voxet.getNx());
        System.out.println(" Ny " + voxet.getNy());
        System.out.println(" Nz " + voxet.getNz());
        float[][][] values = voxet.getValues();
        int i = 0;
        while (i < voxet.getNz()) {
            int j = 0;
            while (j < voxet.getNy()) {
                int k = 0;
                while (k < voxet.getNx()) {
                    buffer.putFloat(values[i][j][k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void write(Sgrid sg) {
        FileOutputStream is = null;
        AbstractInterruptibleChannel channel = null;
        try {
            try {
                System.out.println(" writing Sgrid " + sg.fileName + ".sg");
                SgridWriter.writeHeaderData(sg);
                File f = new File(String.valueOf(sg.fileName) + "__points@@");
                is = new FileOutputStream(f);
                channel = is.getChannel();
                ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
                SgridWriter.writePointValues(sg, buffer);
                buffer.flipwrite();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            catch (ProcessException e) {
                block29: {
                    e.printStackTrace();
                    if (channel == null) break block29;
                    try {
                        channel.close();
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e5) {
                        e5.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

