/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import tno.geoenergy.data.Grid;
import tno.geoenergy.util.ProcessException;

public class SmartGrid {
    public Grid m_Grid;
    public float[][] values;
    public int nx;
    public int ny;
    public float unknown;
    public float originx;
    public float originy;
    public float dx;
    public float dy;
    String m_file = null;
    String m_name = null;

    public SmartGrid(String filename, String gridname) {
        System.out.println(" reading : " + filename);
        this.m_file = new String(filename);
        this.m_name = new String(gridname);
        this.m_Grid = null;
        if (filename.endsWith("asc") || filename.endsWith("ASC") || filename.endsWith("arc") || filename.endsWith("ARC")) {
            try {
                try {
                    System.out.println("reading ARC");
                    this.m_Grid = new Grid(1.0f, 1.0f, 1.0f, "ARC", filename);
                }
                catch (FileNotFoundException e) {
                    System.err.println("ARC Exception  " + e);
                }
            }
            catch (ProcessException e2) {
                this.m_Grid = null;
                System.err.println("Exception  " + e2);
            }
        }
        if (filename.endsWith("grd") || filename.endsWith("GRD")) {
            try {
                try {
                    System.out.println("reading SURFER");
                    this.m_Grid = new Grid(1.0f, 1.0f, 1.0f, "SURFER", filename);
                }
                catch (FileNotFoundException e) {
                    this.m_Grid = null;
                    System.err.println("SURFER Exception  " + e);
                }
            }
            catch (ProcessException e2) {
                System.err.println("Exception  " + e2);
            }
        }
        if (this.m_Grid == null) {
            try {
                try {
                    System.out.println("reading ZYCOR");
                    this.m_Grid = new Grid(1.0f, 1.0f, 1.0f, "ZYCOR", filename);
                }
                catch (FileNotFoundException e) {
                    System.err.println("ZYCOR Exception  " + e);
                }
            }
            catch (ProcessException e2) {
                System.err.println("Exception  " + e2);
            }
        }
        this.values = this.m_Grid.values;
        this.nx = this.m_Grid.nx;
        this.ny = this.m_Grid.ny;
        this.unknown = this.m_Grid.unknown;
        this.originx = this.m_Grid.originx;
        this.originy = this.m_Grid.originy;
        this.dx = this.m_Grid.dx;
        this.dy = this.m_Grid.dy;
    }

    public SmartGrid() {
        this.m_Grid = new Grid();
        this.values = this.m_Grid.values;
        this.nx = this.m_Grid.nx;
        this.ny = this.m_Grid.ny;
        this.unknown = this.m_Grid.unknown;
        this.originx = this.m_Grid.originx;
        this.originy = this.m_Grid.originy;
        this.dx = this.m_Grid.dx;
        this.dy = this.m_Grid.dy;
    }

    public SmartGrid(Grid g) {
        this.m_Grid = g;
        this.values = this.m_Grid.values;
        this.nx = this.m_Grid.nx;
        this.ny = this.m_Grid.ny;
        this.unknown = this.m_Grid.unknown;
        this.originx = this.m_Grid.originx;
        this.originy = this.m_Grid.originy;
        this.dx = this.m_Grid.dx;
        this.dy = this.m_Grid.dy;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPath() {
        return this.m_file;
    }

    public void shrink(int ntimes) {
        while (ntimes > 0) {
            int j;
            boolean[][] todelete = new boolean[this.nx][this.ny];
            int i = 0;
            while (i < this.nx) {
                j = 0;
                while (j < this.ny) {
                    todelete[i][j] = false;
                    ++j;
                }
                ++i;
            }
            i = 1;
            while (i < this.nx - 1) {
                j = 1;
                while (j < this.ny - 1) {
                    if (!(!this.m_Grid.defined(i, j) || this.m_Grid.defined(i + 1, j) && this.m_Grid.defined(i - 1, j) && this.m_Grid.defined(i, j - 1) && this.m_Grid.defined(i, j + 1))) {
                        todelete[i][j] = true;
                    }
                    ++j;
                }
                ++i;
            }
            i = 1;
            while (i < this.nx - 1) {
                j = 1;
                while (j < this.ny - 1) {
                    if (todelete[i][j]) {
                        this.values[i][j] = this.unknown;
                    }
                    ++j;
                }
                ++i;
            }
            --ntimes;
        }
    }

    public void fillHoles(int niter) {
        if (niter > 0) {
            int icountall = 0;
            boolean[][] defined = new boolean[this.nx][this.ny];
            boolean[][] allowed = new boolean[this.nx][this.ny];
            int i = 0;
            while (i < this.nx) {
                int j = 0;
                while (j < this.ny) {
                    defined[i][j] = !this.m_Grid.defined(i, j);
                    ++j;
                }
                ++i;
            }
            int iter = 0;
            while (iter < niter) {
                int j;
                boolean ok = false;
                int i2 = 0;
                while (i2 < this.nx) {
                    j = 0;
                    while (j < this.ny) {
                        boolean bl = allowed[i2][j] = !this.m_Grid.defined(i2, j);
                        if (allowed[i2][j]) {
                            ok = false;
                            if (!ok && i2 > 0) {
                                ok = this.m_Grid.defined(i2 - 1, j);
                            }
                            if (!ok && i2 < this.nx - 1) {
                                ok = this.m_Grid.defined(i2 + 1, j);
                            }
                            if (!ok && j > 0) {
                                ok = this.m_Grid.defined(i2, j - 1);
                            }
                            if (!ok && j < this.ny - 1) {
                                ok = this.m_Grid.defined(i2, j + 1);
                            }
                            allowed[i2][j] = ok;
                        }
                        ++j;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.nx) {
                    j = 0;
                    while (j < this.ny) {
                        if (allowed[i2][j]) {
                            int ncount = 0;
                            float sum = 0.0f;
                            if (i2 < this.nx - 1 && this.m_Grid.defined(this.values[i2 + 1][j])) {
                                sum += this.values[i2 + 1][j];
                                ++ncount;
                            }
                            if (j < this.ny - 1 && this.m_Grid.defined(this.values[i2][j + 1])) {
                                sum += this.values[i2][j + 1];
                                ++ncount;
                            }
                            if (i2 > 1 && this.m_Grid.defined(this.values[i2 - 1][j])) {
                                sum += this.values[i2 - 1][j];
                                ++ncount;
                            }
                            if (j > 1 && this.m_Grid.defined(this.values[i2][j - 1])) {
                                sum += this.values[i2][j - 1];
                                ++ncount;
                            }
                            if (ncount > 0) {
                                this.values[i2][j] = sum / (float)ncount;
                                ++icountall;
                            }
                        }
                        ++j;
                    }
                    ++i2;
                }
                ++iter;
            }
            System.out.println("icountall " + icountall);
        }
    }

    public void fillHolesOld(int niter) {
        if (niter > 0) {
            int icountall = 0;
            boolean[][] defined = new boolean[this.nx][this.ny];
            int i = 0;
            while (i < this.nx) {
                int j = 0;
                while (j < this.ny) {
                    defined[i][j] = this.m_Grid.defined(i, j);
                    ++j;
                }
                ++i;
            }
            int iter = 0;
            while (iter < niter) {
                int i2 = 0;
                while (i2 < this.nx) {
                    int j = 0;
                    while (j < this.ny) {
                        if (!defined[i2][j]) {
                            int ncount = 0;
                            float sum = 0.0f;
                            if (i2 < this.nx - 1 && this.m_Grid.defined(this.m_Grid.values[i2 + 1][j])) {
                                sum += this.m_Grid.values[i2 + 1][j];
                                ++ncount;
                            }
                            if (j < this.ny - 1 && this.m_Grid.defined(this.m_Grid.values[i2][j + 1])) {
                                sum += this.m_Grid.values[i2][j + 1];
                                ++ncount;
                            }
                            if (i2 > 1 && this.m_Grid.defined(this.m_Grid.values[i2 - 1][j])) {
                                sum += this.m_Grid.values[i2 - 1][j];
                                ++ncount;
                            }
                            if (j > 1 && this.m_Grid.defined(this.m_Grid.values[i2][j - 1])) {
                                sum += this.m_Grid.values[i2][j - 1];
                                ++ncount;
                            }
                            if (ncount > 0) {
                                this.m_Grid.values[i2][j] = sum / (float)ncount;
                                ++icountall;
                            }
                        }
                        ++j;
                    }
                    ++i2;
                }
                ++iter;
            }
        }
    }

    public double getTop(Rectangle2D.Double rect) {
        double top = 1.0E9;
        int ixmin = (int)Math.floor((rect.x - (double)this.originx) / (double)this.dx);
        int ixmax = (int)Math.ceil((rect.x + rect.width - (double)this.originx) / (double)this.dx);
        int iymin = (int)Math.floor((rect.y - (double)this.originy) / (double)this.dy);
        int iymax = (int)Math.ceil((rect.y + rect.height - (double)this.originy) / (double)this.dy);
        if (ixmin < 0) {
            ixmin = 0;
        }
        if (iymin < 0) {
            iymin = 0;
        }
        if (ixmax > this.nx) {
            ixmax = this.nx;
        }
        if (iymax > this.ny) {
            iymax = this.ny;
        }
        int ix = ixmin;
        while (ix < ixmax) {
            int iy = iymin;
            while (iy < iymax) {
                if (this.m_Grid.defined(ix, iy) && (double)this.values[ix][iy] < top) {
                    top = this.values[ix][iy];
                }
                ++iy;
            }
            ++ix;
        }
        return top;
    }

    public double getBase(Rectangle2D.Double rect) {
        double base = -1.0E9;
        int ixmin = (int)Math.floor((rect.x - (double)this.originx) / (double)this.dx);
        int ixmax = (int)Math.ceil((rect.x + rect.width - (double)this.originx) / (double)this.dx);
        int iymin = (int)Math.floor((rect.y - (double)this.originy) / (double)this.dy);
        int iymax = (int)Math.ceil((rect.y + rect.height - (double)this.originy) / (double)this.dy);
        if (ixmin < 0) {
            ixmin = 0;
        }
        if (iymin < 0) {
            iymin = 0;
        }
        if (ixmax > this.nx) {
            ixmax = this.nx;
        }
        if (iymax > this.ny) {
            iymax = this.ny;
        }
        int ix = ixmin;
        while (ix < ixmax) {
            int iy = iymin;
            while (iy < iymax) {
                if (this.m_Grid.defined(ix, iy) && (double)this.values[ix][iy] > base) {
                    base = this.values[ix][iy];
                }
                ++iy;
            }
            ++ix;
        }
        return base;
    }

    public double getTop() {
        double top = 1.0E9;
        int ixmin = 0;
        int ixmax = 100000000;
        int iymin = 0;
        int iymax = 100000000;
        if (ixmin < 0) {
            ixmin = 0;
        }
        if (iymin < 0) {
            iymin = 0;
        }
        if (ixmax > this.nx) {
            ixmax = this.nx;
        }
        if (iymax > this.ny) {
            iymax = this.ny;
        }
        int ix = ixmin;
        while (ix < ixmax) {
            int iy = iymin;
            while (iy < iymax) {
                if (this.m_Grid.defined(ix, iy) && (double)this.values[ix][iy] < top) {
                    top = this.values[ix][iy];
                }
                ++iy;
            }
            ++ix;
        }
        return top;
    }

    public double getBase() {
        double base = -1.0E9;
        int ixmin = 0;
        int ixmax = 100000000;
        int iymin = 0;
        int iymax = 100000000;
        if (ixmin < 0) {
            ixmin = 0;
        }
        if (iymin < 0) {
            iymin = 0;
        }
        if (ixmax > this.nx) {
            ixmax = this.nx;
        }
        if (iymax > this.ny) {
            iymax = this.ny;
        }
        int ix = ixmin;
        while (ix < ixmax) {
            int iy = iymin;
            while (iy < iymax) {
                if (this.m_Grid.defined(ix, iy) && (double)this.values[ix][iy] > base) {
                    base = this.values[ix][iy];
                }
                ++iy;
            }
            ++ix;
        }
        return base;
    }

    public static void main(String[] args) {
        String fname = "d:/test/n_TCamb.asc";
        SmartGrid g = new SmartGrid(fname, "test");
        float z1 = g.m_Grid.getValueAtxy(531750.0f, 5677850.0f);
        g.fillHoles(100);
        float z2 = g.m_Grid.getValueAtxy(531750.0f, 5677850.0f);
        System.out.println(" z1 " + z1 + "  z2 " + z2);
        try {
            g.m_Grid.setFileName(String.valueOf(g.m_Grid.getFileName()) + ".grd");
            g.m_Grid.writeSurfer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("finished");
    }

    public Grid getAsGrid() {
        Grid g = this.m_Grid;
        g.unknown = this.unknown;
        return g;
    }
}

