/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.util.Vector;
import tno.geoenergy.data.EclipseGrid;
import tno.geoenergy.data.Voxet;
import tno.geoenergy.data.VoxetReader;

public class SmartVoxet {
    private Voxet m_Voxet;
    private Vector<String> m_VoxetProperties;
    String m_file = null;
    String m_name = null;
    boolean geometry_only = false;

    public SmartVoxet(String filename, String voxetname) {
        this.m_file = new String(filename);
        this.m_name = new String(voxetname);
        this.m_Voxet = null;
        if (filename.endsWith("vo") || filename.endsWith("VO")) {
            System.out.println("reading voxet");
            this.m_Voxet = VoxetReader.read(filename);
        }
        if (this.m_Voxet == null) {
            String[] filenamesplit = filename.split("\\*");
            EclipseGrid egr = new EclipseGrid(filenamesplit[0]);
            this.m_VoxetProperties = egr.keywords;
            if (filenamesplit.length > 1) {
                this.geometry_only = false;
                if (this.m_VoxetProperties.contains(filenamesplit[1])) {
                    this.m_Voxet = egr.getPropertyVoxet(filenamesplit[1]);
                }
            } else {
                this.geometry_only = true;
                this.m_Voxet = egr.getGeomVoxet();
            }
        }
    }

    public Vector<String> getVoxetProperyNames() {
        return this.m_VoxetProperties;
    }

    public boolean isGeometry_only() {
        return this.geometry_only;
    }

    public Voxet getVoxet() {
        return this.m_Voxet;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPath() {
        return this.m_file;
    }

    public double getOriginx() {
        return this.m_Voxet.getOriginx();
    }

    public double getOriginy() {
        return this.m_Voxet.getOriginy();
    }

    public double getOriginz() {
        return this.m_Voxet.getOriginz();
    }

    public int getNx() {
        return this.m_Voxet.getNx();
    }

    public int getNy() {
        return this.m_Voxet.getNy();
    }

    public int getNz() {
        return this.m_Voxet.getNz();
    }

    public double getDx() {
        return this.m_Voxet.getDx();
    }

    public double getDy() {
        return this.m_Voxet.getDy();
    }

    public double getDz() {
        return this.m_Voxet.getDz();
    }
}

