/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import tno.geoenergy.data.VTKgrid;
import tno.geoenergy.data.Voxet;
import tno.geoenergy.util.ByteBufferHelper;

public class VTKgridWriter {
    public static void writeVTK(VTKgrid vtkg) {
        int nx = vtkg.getNx();
        int ny = vtkg.getNy();
        int nz = vtkg.getNz();
        float[][][] xval = vtkg.getXval();
        float[][][] yval = vtkg.getYval();
        float[][][] zval = vtkg.getZval();
        int ncells = (nx - 1) * (ny - 1) * (nz - 1);
        PrintStream pos = null;
        try {
            pos = new PrintStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(vtkg.getFileName()) + ".vtk")));
            pos.println("# vtk DataFile Version 3.1");
            pos.println("vtk output");
            pos.println("ASCII");
            pos.println("DATASET UNSTRUCTURED_GRID");
            pos.println("POINTS " + nx * ny * nz + " " + "float");
            int k = 0;
            while (k < nz) {
                int j = 0;
                while (j < ny) {
                    int i = 0;
                    while (i < nx) {
                        pos.println(String.valueOf(xval[i][j][k]) + " " + yval[i][j][k] + " " + zval[i][j][k]);
                        ++i;
                    }
                    ++j;
                }
                ++k;
            }
            pos.println();
            int ntotal = 9 * ncells;
            pos.println("CELLS " + ncells + " " + ntotal);
            int k2 = 0;
            while (k2 < nz - 1) {
                int j = 0;
                while (j < ny - 1) {
                    int i = 0;
                    while (i < nx - 1) {
                        int p1 = k2 * nx * ny + j * ny + i;
                        int p2 = k2 * nx * ny + j * ny + (i + 1);
                        int p3 = k2 * nx * ny + (j + 1) * ny + i;
                        int p4 = k2 * nx * ny + (j + 1) * ny + (i + 1);
                        int p5 = (k2 + 1) * nx * ny + j * ny + i;
                        int p6 = (k2 + 1) * nx * ny + j * ny + (i + 1);
                        int p7 = (k2 + 1) * nx * ny + (j + 1) * ny + i;
                        int p8 = (k2 + 1) * nx * ny + (j + 1) * ny + (i + 1);
                        pos.println("8 " + p1 + " " + p2 + " " + p3 + " " + p4 + " " + p5 + " " + p6 + " " + p7 + " " + p8);
                        ++i;
                    }
                    ++j;
                }
                ++k2;
            }
            pos.println();
            pos.println("CELL_TYPES " + ncells);
            int i = 0;
            while (i < ncells) {
                pos.println("11");
                ++i;
            }
            pos.println();
            pos.println("CELL_DATA " + ncells);
            int l = 0;
            while (l < vtkg.getProps().size()) {
                Voxet voxet = vtkg.getProperty(l);
                float[][][] values = voxet.getValues();
                pos.println("SCALARS " + voxet.propName + " " + "float");
                pos.println("LOOKUP_TABLE default");
                int k3 = 0;
                while (k3 < voxet.getNz()) {
                    int j = 0;
                    while (j < voxet.getNy()) {
                        int i2 = 0;
                        while (i2 < voxet.getNx()) {
                            pos.println(values[k3][j][i2]);
                            ++i2;
                        }
                        ++j;
                    }
                    ++k3;
                }
                pos.println();
                ++l;
            }
            pos.close();
        }
        catch (Exception e) {
            System.err.println("Exception\n  " + e);
        }
    }

    public void writeVTKunstructuredGrid(VTKgrid vtkg, ByteBufferHelper buffer) throws IOException {
        float[][][] xval = vtkg.getXval();
        float[][][] yval = vtkg.getYval();
        float[][][] zval = vtkg.getZval();
        int k = 0;
        while (k < vtkg.getNz()) {
            int j = 0;
            while (j < vtkg.getNy()) {
                int i = 0;
                while (i < vtkg.getNx()) {
                    buffer.putFloat(xval[i][j][k]);
                    buffer.putFloat(yval[i][j][k]);
                    buffer.putFloat(zval[i][j][k]);
                    ++i;
                }
                ++j;
            }
            ++k;
        }
    }

    public void writeVTKcellProperty(Voxet voxet, ByteBufferHelper buffer) throws IOException {
        float[][][] values = voxet.getValues();
        int i = 0;
        while (i < voxet.getNz()) {
            int j = 0;
            while (j < voxet.getNy()) {
                int k = 0;
                while (k < voxet.getNx()) {
                    buffer.putFloat(values[i][j][k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

