/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import tno.geoenergy.data.Grid;

public class Voxet {
    private static final float UNKNOWN = 99999.0f;
    private int nx;
    private int ny;
    private int nz;
    private float originx;
    private float originy;
    private float originz;
    private float dx;
    private float dy;
    private float dz;
    private float min;
    private float max;
    public static int IDIR = 0;
    public static int JDIR = 1;
    public static int KDIR = 2;
    String fileName;
    String propName;
    private float unknown;
    private float[][][] values;

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileNamePath() {
        return String.valueOf(this.fileName) + ".vo";
    }

    public float getUnknown() {
        return this.unknown;
    }

    public void setUnknown(float unknown) {
        this.unknown = unknown;
    }

    public float[][][] getValues() {
        return this.values;
    }

    public void setValues(float[][][] values) {
        this.values = values;
        this.getMinMax();
    }

    public void setXYZValues(float[][][] values) {
        float[][][] emptyvalues = new float[this.getNz()][this.getNy()][this.getNx()];
        this.setValues(emptyvalues);
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                int k = 0;
                while (k < this.getNz()) {
                    this.getValues()[k][j][i] = values[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.getMinMax();
    }

    public Voxet() {
    }

    public Voxet(Voxet v, String newfilename, String newpropname) {
        this.setDz(v.dz);
        this.setFileName(newfilename);
        this.setOriginx(v.originx);
        this.setOriginy(v.originy);
        this.setOriginz(v.originz);
        this.setDx(v.dx);
        this.setDy(v.dy);
        this.setNx(v.nx);
        this.setNy(v.ny);
        this.setNz(v.nz);
        this.setUnknown(v.unknown);
        this.setPropName(newpropname);
        float[][][] values = new float[v.getNz()][v.getNy()][v.getNx()];
        this.setValues(values);
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                int k = 0;
                while (k < this.getNz()) {
                    this.getValues()[k][j][i] = v.getValues()[k][j][i];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public float getX(int i, int j, int k) {
        return this.originx + (float)i * this.dx;
    }

    public float getY(int i, int j, int k) {
        return this.originy + (float)j * this.dy;
    }

    public float getZ(int i, int j, int k) {
        return this.originz + (float)k * this.dz;
    }

    public void getMinMax() {
        this.min = 1.0E38f;
        this.max = -1.0E38f;
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                int k = 0;
                while (k < this.getNz()) {
                    float val = this.getValues()[k][j][i];
                    if (this.defined(val)) {
                        if (val > this.max) {
                            this.max = val;
                        }
                        if (val < this.min) {
                            this.min = val;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.max = (float)((double)this.max + 0.1 * (double)(this.max - this.min));
        this.min = (float)((double)this.min - 0.1 * (double)(this.max - this.min));
    }

    public void printValues() {
        System.out.println(" origin " + this.originx + "  " + this.originy + "  " + this.originz);
        System.out.println(" nx,ny,nz " + this.nx + "  " + this.ny + "  " + this.nz);
        System.out.println(" dx,dy,dz " + this.dx + "  " + this.dy + "  " + this.dz);
        int i = 0;
        while (i < this.nz) {
            int j = 0;
            while (j < this.ny) {
                int k = 0;
                while (k < this.nx) {
                    System.out.println(String.valueOf((double)this.originx + ((double)k + 0.5) * (double)(this.dx / (float)this.nx)) + "  " + ((double)this.originy + ((double)j + 0.5) * (double)(this.dy / (float)this.ny)) + " " + ((double)this.originz + ((double)i + 0.5) * (double)(this.dz / (float)this.nz)) + "  " + this.values[i][j][k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        System.out.println(" origin " + this.originx + "  " + this.originy + "  " + this.originz);
        System.out.println(" nx,ny,nz " + this.nx + "  " + this.ny + "  " + this.nz);
        System.out.println(" dx,dy,dz " + this.dx + "  " + this.dy + "  " + this.dz);
    }

    public void printXYZValues(String fname) {
        PrintStream pos = null;
        try {
            pos = new PrintStream(new BufferedOutputStream(new FileOutputStream(fname)));
            pos.println("origin " + this.originx + "  " + this.originy + "  " + this.originz);
            pos.println("nx,ny,nz " + this.nx + "  " + this.ny + "  " + this.nz);
            pos.println("dx,dy,dz " + this.dx + "  " + this.dy + "  " + this.dz);
            pos.println("nodata " + this.unknown);
            pos.println("x,y,z,temp");
            int i = 0;
            while (i < this.nz) {
                int j = 0;
                while (j < this.ny) {
                    int k = 0;
                    while (k < this.nx) {
                        pos.println(String.valueOf((double)this.originx + ((double)k + 0.5) * (double)this.dx) + "  " + ((double)this.originy + ((double)j + 0.5) * (double)this.dy) + " " + ((double)this.originz + ((double)i + 0.5) * (double)this.dz) + "  " + this.values[i][j][k]);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            pos.close();
        }
        catch (Exception e) {
            System.err.println("Exception\n  " + e);
        }
    }

    public boolean defined(float value) {
        if (Math.abs(this.unknown) < 100.0f) {
            return (double)Math.abs(value - this.unknown) > 1.0E-5;
        }
        float test = Math.abs(value / this.unknown - 1.0f);
        return (double)test > 1.0E-5;
    }

    public double getCellValueXyzConstantXYZ(double x, double y, double z) {
        double val = 0.0;
        double kres = 0.0;
        double ires = 0.0;
        double jres = 0.0;
        int k = (int)((x - (double)this.originx) / (double)this.dx);
        k = Math.min(Math.max(0, k), this.nx - 1);
        int j = (int)((y - (double)this.originy) / (double)this.dy);
        j = Math.min(Math.max(0, j), this.ny - 1);
        int i = (int)((z - (double)this.originz) / (double)this.dz);
        val = !this.defined(this.values[i = Math.min(Math.max(0, i), this.nz - 1)][j][k]) ? (double)this.unknown : (double)this.values[i][j][k];
        return val;
    }

    public float[][] getValuesK(int kindex, float[][] val, boolean inverseJ) {
        if (val == null) {
            val = new float[this.getNx()][this.getNy()];
        }
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                int jj = j;
                if (inverseJ) {
                    jj = this.getNy() - j - 1;
                }
                val[i][j] = this.values[kindex][j][i];
                ++j;
            }
            ++i;
        }
        return val;
    }

    public float[][] getValuesI(int iindex, float[][] val, boolean inverseJ) {
        if (val == null) {
            val = new float[this.getNy()][this.getNz()];
        }
        int i = 0;
        while (i < this.getNy()) {
            int j = 0;
            while (j < this.getNz()) {
                int jj = j;
                if (inverseJ) {
                    jj = this.getNz() - j - 1;
                }
                val[i][jj] = this.values[j][i][iindex];
                ++j;
            }
            ++i;
        }
        return val;
    }

    public float[][] getValuesJ(int jindex, float[][] val, boolean inverseJ) {
        System.out.println("getValuesJ  jindex " + jindex);
        if (val == null) {
            val = new float[this.getNx()][this.getNz()];
        }
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNz()) {
                int jj = j;
                if (inverseJ) {
                    jj = this.getNz() - j - 1;
                }
                val[i][jj] = this.values[j][jindex][i];
                ++j;
            }
            ++i;
        }
        return val;
    }

    public double getCellValueXyzConstantXY(double x, double y, double z) {
        double val = 0.0;
        double kres = 0.0;
        double ires = 0.0;
        double jres = 0.0;
        int k = (int)((x - (double)this.originx) / (double)this.dx);
        k = Math.min(Math.max(0, k), this.nx - 1);
        int j = (int)((y - (double)this.originy) / (double)this.dy);
        j = Math.min(Math.max(0, j), this.ny - 1);
        int i = (int)Math.floor((z - (double)this.originz) / (double)this.dz);
        ires = (z - (double)this.originz - (double)((float)i * this.dz)) / (double)this.dz;
        int i2 = i + 1;
        i = Math.min(Math.max(0, i), this.nz - 1);
        i2 = Math.min(Math.max(0, i2), this.nz - 1);
        val = !this.defined(this.values[i][j][k]) || !this.defined(this.values[i2][j][k]) ? (double)this.unknown : (1.0 - ires) * (double)this.values[i][j][k] + ires * (double)this.values[i2][j][k];
        return val;
    }

    public double getCellValueXyz(double x, double y, double z) {
        double val = 0.0;
        double kres = 0.0;
        double ires = 0.0;
        double jres = 0.0;
        int k = (int)Math.floor((x - (double)this.originx) / (double)this.dx);
        kres = (x - (double)this.originx - (double)((float)k * this.dx)) / (double)this.dx;
        int k2 = k + 1;
        k = Math.min(Math.max(0, k), this.nx - 1);
        k2 = Math.min(Math.max(0, k2), this.nx - 1);
        int j = (int)Math.floor((y - (double)this.originy) / (double)this.dy);
        jres = (y - (double)this.originy - (double)((float)j * this.dy)) / (double)this.dy;
        int j2 = j + 1;
        j = Math.min(Math.max(0, j), this.ny - 1);
        j2 = Math.min(Math.max(0, j2), this.ny - 1);
        int i = (int)Math.floor((z - (double)this.originz) / (double)this.dz);
        ires = (z - (double)this.originz - (double)((float)i * this.dz)) / (double)this.dz;
        int i2 = i + 1;
        i = Math.min(Math.max(0, i), this.nz - 1);
        i2 = Math.min(Math.max(0, i2), this.nz - 1);
        val = !this.defined(this.values[i][j][k]) || !this.defined(this.values[i][j][k2]) || !this.defined(this.values[i2][j][k]) || !this.defined(this.values[i2][j][k2]) || !this.defined(this.values[i][j2][k]) || !this.defined(this.values[i][j2][k2]) || !this.defined(this.values[i2][j2][k]) || !this.defined(this.values[i2][j2][k2]) ? (double)this.unknown : (1.0 - ires) * (1.0 - jres) * (1.0 - kres) * (double)this.values[i][j][k] + (1.0 - ires) * (1.0 - jres) * kres * (double)this.values[i][j][k2] + ires * (1.0 - jres) * (1.0 - kres) * (double)this.values[i2][j][k] + ires * (1.0 - jres) * kres * (double)this.values[i2][j][k2] + (1.0 - ires) * jres * (1.0 - kres) * (double)this.values[i][j2][k] + (1.0 - ires) * jres * kres * (double)this.values[i][j2][k2] + ires * jres * (1.0 - kres) * (double)this.values[i2][j2][k] + ires * jres * kres * (double)this.values[i2][j2][k2];
        return val;
    }

    public Voxet(Grid gtvdtop, float zmin, float zmax, float dz, float res, String newfilename, String propname) {
        this.setDx(res);
        this.setDy(res);
        this.setNx((int)((float)gtvdtop.nx * gtvdtop.dx / res + 1.0f));
        this.setNy((int)((float)gtvdtop.ny * gtvdtop.dy / res + 1.0f));
        this.setOriginx(gtvdtop.originx);
        this.setOriginy(gtvdtop.originy);
        this.setOriginz(zmin);
        this.setDz(dz);
        int nz = (int)((zmax - zmin) / dz + 1.0f);
        this.setNz(nz);
        this.setFileName(newfilename);
        this.setUnknown(99999.0f);
        this.setPropName(propname);
        float[][][] values = new float[this.getNz()][this.getNy()][this.getNx()];
        this.setValues(values);
        this.clear();
    }

    public Voxet(int nx, int ny, int nz, float dxdydz, String newfilename, String propname, float unknown) {
        this.setDx(dxdydz);
        this.setDy(dxdydz);
        this.setDz(dxdydz);
        this.setNx(nx);
        this.setNy(ny);
        this.setNz(nz);
        this.setOriginx(0.0f);
        this.setOriginy(0.0f);
        this.setOriginz(0.0f);
        this.setFileName(newfilename);
        this.setUnknown(99999.0f);
        this.setPropName(propname);
        float[][][] values = new float[this.getNz()][this.getNy()][this.getNx()];
        this.setValues(values);
        this.clear();
    }

    public void clear() {
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                int k = 0;
                while (k < this.getNz()) {
                    this.getValues()[k][j][i] = this.unknown;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public Voxet cutVoxet(int imin, int imax, int jmin, int jmax, String name) {
        Voxet v = new Voxet();
        v.setDx(this.getDx());
        v.setDy(this.getDy());
        v.setNx(imax - imin);
        v.setNy(jmax - jmin);
        v.setOriginx(this.originx + (float)imin * this.getDx());
        v.setOriginy(this.originy + (float)jmin * this.getDy());
        v.setOriginz(this.originz);
        v.setDz(this.dz);
        v.setNz(this.nz);
        v.setFileName(String.valueOf(this.getFileName()) + name);
        v.setUnknown(this.unknown);
        v.setPropName(this.propName);
        float[][][] values = new float[v.getNz()][v.getNy()][v.getNx()];
        v.setValues(values);
        v.clear();
        System.out.println("cutting voxet to :" + imin + ", " + imax + ", " + jmin + ", " + jmax);
        int i = 0;
        while (i < v.getNx()) {
            int j = 0;
            while (j < v.getNy()) {
                int k = 0;
                while (k < v.getNz()) {
                    try {
                        v.getValues()[k][j][i] = this.getValues()[k][j + jmin][i + imin];
                    }
                    catch (Exception e) {
                        System.out.println(" i ,j,k " + i + ", " + j + ", " + k);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return v;
    }

    public Voxet cutVoxet(double xmin, double xmax, double ymin, double ymax, String name) {
        int imin = (int)((xmin - (double)this.originx) / (double)this.getDx());
        int imax = (int)((xmax - (double)this.originx) / (double)this.getDx());
        imin = Math.min(Math.max(0, imin), this.nx);
        imax = Math.min(Math.max(0, imax), this.nx);
        int jmin = (int)((ymin - (double)this.originy) / (double)this.getDy());
        int jmax = (int)((ymax - (double)this.originy) / (double)this.getDy());
        jmin = Math.min(Math.max(0, jmin), this.ny);
        jmax = Math.min(Math.max(0, jmax), this.ny);
        return this.cutVoxet(imin, imax, jmin, jmax, name);
    }

    public Voxet upscaleVoxetXY(float dx, float dy, String name) {
        Voxet v = new Voxet();
        int samplerange = (int)(this.dx / dx);
        int nx = (int)((float)(this.nx - 1) * this.dx / dx) + 1;
        int ny = (int)((float)(this.ny - 1) * this.dy / dy) + 1;
        v.setNx(nx);
        v.setNy(ny);
        v.setDx(dx);
        v.setDy(dy);
        v.setOriginx(this.originx);
        v.setOriginy(this.originy);
        v.setOriginz(this.originz);
        v.setDz(this.dz);
        v.setNz(this.nz);
        v.setFileName(String.valueOf(this.getFileName()) + name);
        v.setUnknown(this.unknown);
        v.setPropName(this.propName);
        float[][][] values = new float[v.getNz()][v.getNy()][v.getNx()];
        v.setValues(values);
        int i = 0;
        while (i < v.getNx()) {
            int j = 0;
            while (j < v.getNy()) {
                int k = 0;
                while (k < v.getNz()) {
                    double x = this.getX(i, j, k);
                    double y = this.getY(i, j, k);
                    double z = this.getZ(i, j, k);
                    v.getValues()[k][j][i] = (float)this.getCellValueXyz(x, y, z);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return v;
    }

    public void averageFromSurroundingGrid(Grid g, int i, int j) {
        float val = 0.0f;
        int isum = 0;
        if (i > 0 && g.defined(i - 1, j)) {
            val += g.values[i - 1][j];
            ++isum;
        }
        if (i < g.nx - 1 && g.defined(i + 1, j)) {
            val += g.values[i + 1][j];
            ++isum;
        }
        if (j > 0 && g.defined(i, j - 1)) {
            val += g.values[i][j - 1];
            ++isum;
        }
        if (j < g.ny - 1 && g.defined(i, j + 1)) {
            val += g.values[i][j + 1];
            ++isum;
        }
        if (isum > 0) {
            g.values[i][j] = val / (float)isum;
        }
    }

    public void sampleGrid(Grid sampled, Grid definedarea) {
        int i = 0;
        while (i < sampled.nx) {
            int j = 0;
            while (i < sampled.ny) {
                double x = sampled.originx + (float)i * sampled.dx;
                double y = sampled.originy + (float)j * sampled.dy;
                double z = sampled.values[i][j];
                float val = (float)this.getCellValueXyz(x, y, z);
                sampled.values[i][j] = !this.defined(val) ? sampled.unknown : val;
                ++j;
            }
            ++i;
        }
        int iter = 0;
        while (iter < 100) {
            int i2 = 0;
            while (i2 < sampled.nx) {
                int j = 0;
                while (i2 < sampled.ny) {
                    if (!sampled.defined(i2, j) && definedarea.defined(i2, j)) {
                        this.averageFromSurroundingGrid(sampled, i2, j);
                    }
                    ++j;
                }
                ++i2;
            }
            ++iter;
        }
    }

    public int getI(double x) {
        int i = (int)((x - (double)this.originx) / (double)this.dx);
        if (i < 0 || i > this.nx - 1) {
            i = -1;
        }
        return i;
    }

    public int getJ(double y) {
        int i = (int)((y - (double)this.originy) / (double)this.dy);
        if (i < 0 || i > this.ny - 1) {
            i = -1;
        }
        return i;
    }

    public int getK(double z) {
        int i = (int)((z - (double)this.originz) / (double)this.dz);
        if (i < 0 || i > this.nz - 1) {
            i = -1;
        }
        return i;
    }

    public float getDx() {
        return this.dx;
    }

    public void setDx(float dx) {
        this.dx = dx;
    }

    public float getDy() {
        return this.dy;
    }

    public void setDy(float dy) {
        this.dy = dy;
    }

    public float getDz() {
        return this.dz;
    }

    public void setDz(float dz) {
        this.dz = dz;
    }

    public int getNx() {
        return this.nx;
    }

    public void setNx(int nx) {
        this.nx = nx;
    }

    public int getNy() {
        return this.ny;
    }

    public void setNy(int ny) {
        this.ny = ny;
    }

    public int getNz() {
        return this.nz;
    }

    public void setNz(int nz) {
        this.nz = nz;
    }

    public double getOriginx() {
        return this.originx;
    }

    public void setOriginx(float originx) {
        this.originx = originx;
    }

    public float getOriginy() {
        return this.originy;
    }

    public void setOriginy(float originy) {
        this.originy = originy;
    }

    public float getOriginz() {
        return this.originz;
    }

    public void setOriginz(float originz) {
        this.originz = originz;
    }

    public static void main(String[] args) {
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getPropName() {
        return this.propName;
    }

    public void setPropName(String propName) {
        this.propName = propName;
    }

    public Grid getGrid(String gridname, int IJKDIR, int index) {
        Grid grid = new Grid();
        boolean k_is_depth = true;
        if (IJKDIR == IDIR) {
            grid.nx = this.getNy();
            grid.ny = this.getNz();
            grid.originx = this.getOriginy();
            grid.originy = this.getOriginz();
            grid.dx = this.getDy();
            grid.dy = this.getDz();
            grid.values = this.getValuesI(index, null, k_is_depth);
        } else if (IJKDIR == JDIR) {
            grid.nx = this.getNx();
            grid.ny = this.getNz();
            grid.originx = (float)this.getOriginx();
            grid.originy = this.getOriginz();
            grid.dx = this.getDx();
            grid.dy = this.getDz();
            grid.values = this.getValuesJ(index, null, k_is_depth);
        } else if (IJKDIR == KDIR) {
            grid.nx = this.getNx();
            grid.ny = this.getNy();
            grid.originx = (float)this.getOriginx();
            grid.originy = this.getOriginy();
            grid.dx = this.getDx();
            grid.dy = this.getDy();
            grid.values = this.getValuesK(index, null, !k_is_depth);
        }
        grid.setDataFormat("SURFER");
        grid.setFileName(gridname);
        grid.unknown = this.unknown;
        grid.determine_low_high();
        return grid;
    }

    public void scaleValues(float scale) {
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                int k = 0;
                while (k < this.getNz()) {
                    if (this.defined(this.getValues()[k][j][i])) {
                        float[] fArray = this.getValues()[k][j];
                        int n = i;
                        fArray[n] = fArray[n] * scale;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.getMinMax();
    }

    public Grid gridFromVerticalSum(String gridfilename, String format, boolean divide_over_surfacearea, float scale) {
        Grid g = this.getGrid(gridfilename, KDIR, 0);
        g.setDataFormat(format);
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                float sum = 0.0f;
                int k = 0;
                while (k < this.getNz()) {
                    if (this.defined(this.getValues()[k][j][i])) {
                        sum += this.getValues()[k][j][i];
                    }
                    ++k;
                }
                if (divide_over_surfacearea) {
                    sum /= this.getDx() * this.getDy();
                }
                g.values[i][j] = sum *= scale;
                ++j;
            }
            ++i;
        }
        g.determine_low_high();
        return g;
    }

    public Grid gridFromVerticalSum(String gridfilename, String format, boolean divide_over_surfacearea, float scale, float zmaxsum) {
        float z = 0.0f;
        Grid g = this.getGrid(gridfilename, KDIR, 0);
        g.setDataFormat(format);
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                float sum = 0.0f;
                int k = 0;
                while (k < this.getNz()) {
                    z = this.getZ(i, j, k);
                    if (z <= zmaxsum && this.defined(this.getValues()[k][j][i])) {
                        sum += this.getValues()[k][j][i];
                    }
                    ++k;
                }
                if (divide_over_surfacearea) {
                    sum /= this.getDx() * this.getDy();
                }
                g.values[i][j] = sum *= scale;
                ++j;
            }
            ++i;
        }
        g.determine_low_high();
        return g;
    }

    public float getX(int i, int j) {
        return this.originx + (float)i * this.dx;
    }

    public float getY(int i, int j) {
        return this.originy + (float)j * this.dy;
    }

    public void fillfromVoxet(int imin, int imax, int jmin, int jmax, int istart, int jstart, Voxet vt) {
        int i = imin;
        while (i < imax) {
            int j = jmin;
            while (j < jmax) {
                int k = 0;
                while (k < this.nz) {
                    this.getValues()[k][j][i] = vt.getValues()[k][j - jmin + jstart][i - imin + istart];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

