/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.StringTokenizer;
import tno.geoenergy.data.Voxet;
import tno.geoenergy.util.AsciiStream;
import tno.geoenergy.util.ByteBufferHelper;
import tno.geoenergy.util.ProcessException;

public class VoxetReader {
    public static void readHeaderData(Voxet voxet, AsciiStream ds) throws ProcessException, IOException {
        String line_str;
        int newLineCount = 0;
        String AxisO = "AXIS_O";
        String AxisU = "AXIS_U";
        String AxisV = "AXIS_V";
        String AxisW = "AXIS_W";
        String AxisN = "AXIS_N";
        String asciiDataFile = "ASCII_DATA_FILE";
        while (ds.more() && (line_str = ds.readString(150, false)) != null) {
            ++newLineCount;
            StringTokenizer st = new StringTokenizer(line_str);
            if (st.countTokens() != 0) {
                double d;
                String singleWord = st.nextToken();
                if (singleWord.equals(AxisO)) {
                    voxet.setOriginx(Float.valueOf(st.nextToken()).floatValue());
                    voxet.setOriginy(Float.valueOf(st.nextToken()).floatValue());
                    voxet.setOriginz(Float.valueOf(st.nextToken()).floatValue());
                }
                if (singleWord.equals(AxisU)) {
                    voxet.setDx(Float.valueOf(st.nextToken()).floatValue());
                }
                if (singleWord.equals(AxisV)) {
                    d = Float.valueOf(st.nextToken()).floatValue();
                    voxet.setDy(Float.valueOf(st.nextToken()).floatValue());
                }
                if (singleWord.equals(AxisW)) {
                    d = Float.valueOf(st.nextToken()).floatValue();
                    d = Float.valueOf(st.nextToken()).floatValue();
                    voxet.setDz(Float.valueOf(st.nextToken()).floatValue());
                }
                if (singleWord.equals(AxisN)) {
                    voxet.setNx((int)Float.valueOf(st.nextToken()).floatValue());
                    voxet.setNy((int)Float.valueOf(st.nextToken()).floatValue());
                    voxet.setNz((int)Float.valueOf(st.nextToken()).floatValue());
                    return;
                }
            }
            ds.nextLine();
        }
    }

    static boolean readNextProperty(AsciiStream d, String[] s) throws ProcessException, IOException {
        String t;
        while (d.more() && (t = d.readString()) != null) {
            if (t.equals("PROP_NO_DATA_VALUE")) {
                d.readString();
                s[1] = new String(d.readString());
            }
            if (!t.equals("PROP_FILE")) continue;
            d.readString();
            s[0] = new String(d.readString());
            String[] s2 = s[0].split("_");
            if (s2.length > 2) {
                s[0] = "";
                int i = s2.length / 2;
                while (i < s2.length) {
                    s[0] = i == s2.length - 1 ? String.valueOf(s[0]) + s2[i] : String.valueOf(s[0]) + s2[i] + "_";
                    ++i;
                }
            } else {
                s[0] = s2[1];
            }
            s[0] = s[0].substring(0, s[0].length() - 2);
            return true;
        }
        return false;
    }

    private static void readValues(Voxet voxet, ByteBufferHelper buffer) throws IOException {
        float[][][] values = new float[voxet.getNz()][voxet.getNy()][voxet.getNx()];
        int i = 0;
        while (i < voxet.getNz()) {
            int j = 0;
            while (j < voxet.getNy()) {
                int k = 0;
                while (k < voxet.getNx()) {
                    values[i][j][k] = buffer.getFloat();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        voxet.setValues(values);
        voxet.getMinMax();
    }

    public static Voxet read(String fileName) {
        FileInputStream is = null;
        AbstractInterruptibleChannel channel = null;
        if (fileName.endsWith(".vo")) {
            fileName = fileName.substring(0, fileName.indexOf(".vo"));
        }
        Voxet voxet = new Voxet();
        voxet.setFileName(fileName);
        try {
            FileInputStream inputStream = new FileInputStream(String.valueOf(fileName) + ".vo");
            AsciiStream ast = new AsciiStream(inputStream, 4098);
            VoxetReader.readHeaderData(voxet, ast);
            String[] s = new String[2];
            VoxetReader.readNextProperty(ast, s);
            voxet.setPropName(s[0]);
            voxet.setUnknown(Float.parseFloat(s[1]));
            ast.close();
            File f = new File(String.valueOf(fileName) + "_" + voxet.getPropName() + "@@");
            is = new FileInputStream(f);
            channel = is.getChannel();
            ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
            buffer.clearread();
            VoxetReader.readValues(voxet, buffer);
            Voxet voxet2 = voxet;
            return voxet2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ProcessException e) {
            e.printStackTrace();
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void main(String[] args) throws FileNotFoundException, ProcessException {
        String fname = "d:\\voxet\\vox_x";
        Voxet v1 = VoxetReader.read(fname);
        v1.printValues();
    }
}

