/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import tno.geoenergy.data.Voxet;
import tno.geoenergy.data.VoxetReader;
import tno.geoenergy.util.ByteBufferHelper;
import tno.geoenergy.util.ProcessException;

public class VoxetWriter {
    public static void writeHeaderData(Voxet voxet) throws ProcessException, IOException {
        PrintStream pos = null;
        try {
            pos = new PrintStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(voxet.fileName) + ".vo")));
            pos.println("GOCAD Voxet 1");
            pos.println("HEADER {");
            pos.println(" name:density2");
            pos.println("*painted:on");
            pos.println("\t         *painted*variable:density");
            pos.println(" *regions*painted_grid:density");
            pos.println("last_selected_folder:Property Sections");
            pos.println("*psections*solid:true");
            pos.println("*density*psections:1 1 1 1 1 1 1 1 1 0");
            pos.println("*psections*grid:false");
            pos.println("properties_movie:off");
            pos.println("movie:on");
            pos.println("*movie_property:density");
            pos.println("*low_clip:0");
            pos.println("*colormap*low_clip_transparent:false");
            pos.println("*colormap*high_clip_transparent:false");
            pos.println("*high_clip:1500");
            pos.println("ascii:off");
            pos.println("}");
            pos.println("GOCAD_ORIGINAL_COORDINATE_SYSTEM");
            pos.println("NAME Default");
            pos.println("AXIS_NAME \"X\" \"Y\" \"Z\"");
            pos.println("AXIS_UNIT \"m\" \"m\" \"ms\"");
            pos.println("ZPOSITIVE Depth");
            pos.println("END_ORIGINAL_COORDINATE_SYSTEM");
            pos.println("AXIS_O " + voxet.getOriginx() + " " + voxet.getOriginy() + " " + voxet.getOriginz());
            pos.println("AXIS_U " + voxet.getDx() + " 0  0");
            pos.println("AXIS_V  0 " + voxet.getDy() + " 0");
            pos.println("AXIS_W  0 0 " + voxet.getDz());
            pos.println("AXIS_MIN 0 0 0");
            pos.println("AXIS_MAX 1 1 1");
            pos.println("AXIS_N " + voxet.getNx() + " " + voxet.getNy() + " " + voxet.getNz());
            pos.println("AXIS_NAME \"axis-1\" \"axis-2\" \"axis-3\"");
            pos.println("AXIS_UNIT \" number\" \" number\" \" number\"");
            pos.println("AXIS_TYPE even even even");
            pos.println("PROPERTY 1 \"" + voxet.propName + "\"");
            pos.println("PROPERTY_CLASS 1 \"" + voxet.propName + "\"");
            pos.println("PROPERTY_CLASS_HEADER 1 \"" + voxet.propName + "\" {");
            pos.println(" *pclip:99");
            pos.println("last_selected_folder:Property");
            pos.println("*colormap*low_clip_transparent:true");
            pos.println("*colormap*high_clip_transparent:true");
            pos.println("*scale_function:linear");
            pos.println("*low_clip:200");
            pos.println("*high_clip:4386.596");
            pos.println("}");
            pos.println("PROP_ORIGINAL_UNIT 1 none");
            pos.println("PROP_UNIT 1 none");
            pos.println("PROP_NO_DATA_VALUE 1 " + voxet.getUnknown());
            pos.println("PROP_SAMPLE_STATS 1 75000 1367.9 108839 50 1500");
            pos.println("PROP_ESIZE 1 4");
            pos.println("PROP_ETYPE 1  IEEE");
            pos.println("PROP_FORMAT 1 RAW");
            pos.println("PROP_OFFSET 1 0");
            String fname = new File(voxet.fileName).getName();
            pos.println("PROP_FILE 1 " + fname + "_" + voxet.propName + "@@");
            pos.println("END");
            pos.close();
        }
        catch (Exception e) {
            System.err.println("Exception\n  " + e);
        }
    }

    private static void writeValues(Voxet voxet, ByteBufferHelper buffer) throws IOException {
        System.out.println(" Nx " + voxet.getNx());
        System.out.println(" Ny " + voxet.getNy());
        System.out.println(" Nz " + voxet.getNz());
        float[][][] values = voxet.getValues();
        int i = 0;
        while (i < voxet.getNz()) {
            int j = 0;
            while (j < voxet.getNy()) {
                int k = 0;
                while (k < voxet.getNx()) {
                    buffer.putFloat(values[i][j][k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void write(Voxet voxet) {
        FileOutputStream is = null;
        AbstractInterruptibleChannel channel = null;
        try {
            try {
                System.out.println(" writing voxet " + voxet.fileName + "_" + voxet.propName + ".vo");
                VoxetWriter.writeHeaderData(voxet);
                File f = new File(String.valueOf(voxet.fileName) + "_" + voxet.propName + "@@");
                is = new FileOutputStream(f);
                channel = is.getChannel();
                ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
                VoxetWriter.writeValues(voxet, buffer);
                buffer.flipwrite();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            catch (ProcessException e) {
                block29: {
                    e.printStackTrace();
                    if (channel == null) break block29;
                    try {
                        channel.close();
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e5) {
                        e5.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void SaveFileCSV(Voxet[] v, String[] name, String filename) {
        String[] getColNames = new String[]{"X", "Y", "Z"};
        StringBuffer Strbuf = new StringBuffer();
        File myfile = new File(filename);
        FileOutputStream StreamOut = null;
        try {
            StreamOut = new FileOutputStream(filename);
        }
        catch (IOException e) {
            System.out.println("Error opening output file: " + filename);
        }
        double[] nrs = new double[getColNames.length];
        int i = 0;
        while (i < nrs.length) {
            if (i > 0) {
                Strbuf.append(",");
            }
            Strbuf.append(getColNames[i]);
            ++i;
        }
        int iv = 0;
        while (iv < v.length) {
            Strbuf.append("," + name[iv]);
            ++iv;
        }
        Strbuf.append("\n");
        int k = 0;
        while (k < v[0].getNz()) {
            int j = 0;
            while (j < v[0].getNy()) {
                int i2 = 0;
                while (i2 < v[0].getNx()) {
                    double x = v[0].getX(i2, j);
                    double y = v[0].getY(i2, j);
                    double z = v[0].getZ(i2, j, k);
                    try {
                        Strbuf.append(String.valueOf(x) + "," + y + "," + z);
                        int iv2 = 0;
                        while (iv2 < v.length) {
                            Strbuf.append("," + v[iv2].getValues()[i2][j][k]);
                            ++iv2;
                        }
                        Strbuf.append("\n");
                    }
                    catch (NumberFormatException er) {
                        break;
                    }
                    catch (NullPointerException en) {
                        break;
                    }
                    String Str = Strbuf.toString();
                    byte[] byteDataOut = Str.getBytes();
                    Strbuf = new StringBuffer();
                    try {
                        StreamOut.write(byteDataOut);
                    }
                    catch (IOException e) {
                        System.out.println("Error writing to output file " + filename);
                    }
                    ++i2;
                }
                ++j;
            }
            ++k;
        }
        try {
            StreamOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e);
        }
    }

    public static void SaveFileCSV(Voxet v, String name, String filename) {
        String[] getColNames = new String[]{"X", "Y", "Z", name};
        StringBuffer Strbuf = new StringBuffer();
        File myfile = new File(filename);
        FileOutputStream StreamOut = null;
        try {
            StreamOut = new FileOutputStream(filename);
        }
        catch (IOException e) {
            System.out.println("Error opening output file: " + filename);
        }
        double[] nrs = new double[getColNames.length];
        int i = 0;
        while (i < nrs.length) {
            if (i > 0) {
                Strbuf.append(",");
            }
            Strbuf.append(getColNames[i]);
            ++i;
        }
        Strbuf.append("\n");
        int k = 0;
        while (k < v.getNz()) {
            int j = 0;
            while (j < v.getNy()) {
                int i2 = 0;
                while (i2 < v.getNx()) {
                    double x = v.getX(i2, j);
                    double y = v.getY(i2, j);
                    double z = v.getZ(i2, j, k);
                    try {
                        Strbuf.append(String.valueOf(x) + "," + y + "," + z + "," + v.getValues()[i2][j][k] + "\n");
                    }
                    catch (NumberFormatException er) {
                        break;
                    }
                    catch (NullPointerException en) {
                        break;
                    }
                    String Str = Strbuf.toString();
                    byte[] byteDataOut = Str.getBytes();
                    Strbuf = new StringBuffer();
                    try {
                        StreamOut.write(byteDataOut);
                    }
                    catch (IOException e) {
                        System.out.println("Error writing to output file " + filename);
                    }
                    ++i2;
                }
                ++j;
            }
            ++k;
        }
        try {
            StreamOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e);
        }
    }

    public static void main(String[] args) throws FileNotFoundException, ProcessException {
        String fname = "d:\\voxet\\voxettest";
        Voxet v1 = VoxetReader.read(fname);
        v1.fileName = String.valueOf(v1.fileName) + "_copy";
        v1.propName = String.valueOf(v1.propName) + "_copy";
        VoxetWriter.write(v1);
    }
}

