/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

public class ZcornLine {
    int nz = 0;
    double[] zc1 = null;
    double[] zc2 = null;
    double[] zc3 = null;
    double[] zc4 = null;

    public ZcornLine(int nz, double[] zcorn1, double[] zcorn2, double[] zcorn3, double[] zcorn4) {
        this.nz = nz;
        this.zc1 = zcorn1;
        this.zc2 = zcorn2;
        this.zc3 = zcorn3;
        this.zc4 = zcorn4;
    }

    public int connection(int ifa, double[] zc10, double[] zc11, double[] zc20, double[] zc21) {
        double m1 = 0.25 * (zc10[ifa * 2] + zc10[ifa * 2 + 1] + zc20[ifa * 2] + zc20[ifa * 2 + 1]);
        double m2 = 0.25 * (zc11[ifa * 2] + zc11[ifa * 2 + 1] + zc21[ifa * 2] + zc21[ifa * 2 + 1]);
        double diff = Math.abs(m1 - m2);
        double delz = Math.abs(0.5 * (zc10[ifa * 2] - zc10[ifa * 2 + 1] + (zc20[ifa * 2] - zc20[ifa * 2 + 1])));
        if (diff < 0.001) {
            return ifa;
        }
        if (delz < 1.0E-10) {
            return -1;
        }
        double[] difar = new double[this.nz];
        double[] kdelz = new double[this.nz];
        int ifb = 0;
        while (ifb < this.nz) {
            m2 = 0.25 * (zc11[ifb * 2] + zc11[ifb * 2 + 1] + zc21[ifb * 2] + zc21[ifb * 2 + 1]);
            difar[ifb] = Math.abs(m1 - m2);
            kdelz[ifb] = Math.abs(0.5 * (zc11[ifb * 2] - zc11[ifb * 2 + 1] + (zc21[ifb * 2] - zc21[ifb * 2 + 1])));
            ++ifb;
        }
        int isel = -1;
        double max = 0.0;
        int ifb2 = 0;
        while (ifb2 < this.nz) {
            double conn = (0.5 * kdelz[ifb2] - difar[ifb2]) / delz;
            if (conn > max) {
                max = conn;
                isel = ifb2;
            }
            ++ifb2;
        }
        return isel;
    }

    public double[][] getZData() {
        double[][] data = new double[][]{this.zc1, this.zc2, this.zc3, this.zc4};
        return data;
    }
}

