/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.integration;

import tno.geoenergy.fdintegration.integration.Ftool;
import tno.geoenergy.fdintegration.integration.FtoolCollection;
import tno.geoenergy.fdintegration.integration.LoopException;
import tno.geoenergy.fdintegration.integration.M3rkBackup;
import tno.geoenergy.fdintegration.integration.M3rkBackupContainer;
import tno.geoenergy.fdintegration.integration.M3rkarrays;
import tno.geoenergy.fdintegration.integration.Ran;
import tno.geoenergy.fdintegration.integration.Step;
import tno.geoenergy.fdintegration.model.ModelRealisation;
import tno.geoenergy.logging.Logger;

public class M3rk {
    private static Logger logger = Logger.getLogger(M3rk.class.getName());
    boolean newstart;
    double timestart;
    public double x;
    public double xe;
    public int n;
    double h;
    double hmin;
    double[] sigma = M3rkarrays.getM3rk2ar();
    double tol;
    static double[] y = M3rkarrays.getM3rkGeotar();
    static double[] y1 = M3rkarrays.getM3rkGeotar();
    static double[] y2 = M3rkarrays.getM3rkGeotar();
    static double[] yxe = M3rkarrays.getM3rkGeotar();
    static double[] dy = M3rkarrays.getM3rkGeotar();
    static double[] dy1 = M3rkarrays.getM3rkGeotar();
    public static double[] ty = M3rkarrays.getM3rkGeotar();
    int iflag;
    public static int[] info = M3rkarrays.getM3rkiar();
    static double apr;
    Ftool ftool;
    FtoolCollection availftools;
    int nrftools;
    private ModelRealisation modelrealisation;
    Step stepcon;
    Ran ran;
    public double fys;
    M3rkBackupContainer mbackupc = new M3rkBackupContainer();
    public static int NUMBER_BACKUPS;
    double[] p = null;
    double[] s = null;
    final double[] d = new double[]{0.0, 0.54545454545454, 0.32974222139503, 0.01587454096372, 0.54545454545454, 0.32957779372404, 0.018807742712872, 2.6931406295668E-4, 0.54545454545454, 0.32959633626966, 0.019843848141588, 3.8370516974646E-4, 2.3214008199836E-6, 0.54545454545454, 0.32940480780399, 0.020289622974884, 4.3922728369494E-4, 3.8881393659393E-6, 1.2058633806519E-8, 0.54545454545454, 0.32915730747582, 0.020529934599533, 4.701456507018E-4, 4.8729959290595E-6, 2.3293337843875E-8, 4.1768893290961E-11, 0.54545454545454, 0.32940290556199, 0.020695785946957, 4.8959305208277E-4, 5.5250561672575E-6, 3.204257286654E-8, 9.2217187087773E-11, 1.0431596770258E-13, 0.54545454545454, 0.32904622047855, 0.020769127247467, 5.0144873108237E-4, 5.9538312498493E-6, 3.8413639404624E-8, 1.3735161731261E-10, 2.5579038177072E-13, 1.935532554926E-16, 0.54545454545454, 0.32902403825404, 0.020835887364795, 5.1019371265378E-4, 6.2671263848834E-6, 4.327329421167E-8, 1.7557956622083E-10, 4.1529099936815E-13, 5.297776063801E-16, 2.8162396623902E-19, 0.54545454545454, 0.32900701770523, 0.020847709891773, 5.1474022625718E-4, 6.4655444450446E-6, 4.669468155356E-8, 2.0545752812528E-10, 5.5985683650846E-13, 9.2238940881933E-16, 8.4171480799272E-19, 3.2655765072494E-22, 0.54545454545454, 0.32923047518706, 0.02094210551445, 5.2155114179973E-4, 6.6698403229501E-6, 4.9787290971999E-8, 2.3175109073032E-10, 6.9290153772379E-13, 1.3309584971259E-15, 1.5876152476718E-18, 1.0702794409632E-21, 3.1159779644428E-25, 0.54545454545454, 0.32888824622955, 0.020930564082556, 5.2398048369937E-4, 6.7865318951772E-6, 5.1892263386503E-8, 2.5160762750795E-10, 8.0319349035922E-13, 1.7105594522426E-15, 2.4063258323529E-18, 2.1467888957759E-21, 1.100273956954E-24, 2.4672233557657E-28, 0.45454545454545, 0.39753050587769, 0.019106034236683, 0.45454545454545, 0.39769493354868, 0.022675100922608, 3.2438614977749E-4, 0.45454545454545, 0.39767639100306, 0.023921246939481, 4.6221334545758E-4, 2.7945492539796E-6, 0.45454545454545, 0.39786791946874, 0.024509754044867, 5.3071848010798E-4, 4.7002589400275E-6, 1.4585303356181E-8, 0.45454545454545, 0.39811541979691, 0.024864589588956, 5.6998860293388E-4, 5.913834060351E-6, 2.8300608926316E-8, 5.0812598486162E-11, 0.45454545454545, 0.39786982171073, 0.025000002282553, 5.9148858437864E-4, 6.6757562996758E-6, 3.872046896477E-8, 1.1144761163396E-10, 1.2608153728E-13, 0.45454545454545, 0.39822650679417, 0.025183525013803, 6.0880314013113E-4, 7.2358433014328E-6, 4.6725317100106E-8, 1.6719594503501E-10, 3.1157527742621E-13, 2.359037048211E-16, 0.45454545454545, 0.39824868901869, 0.025265819897767, 6.1910411544859E-4, 7.607471114885E-6, 5.2536344101559E-8, 2.1317642667569E-10, 5.0421345500406E-13, 6.4317688539028E-16, 3.4187163161474E-19, 0.45454545454545, 0.3982657095675, 0.025287844091655, 6.2494425734623E-4, 7.854029693845E-6, 5.6743151456408E-8, 2.4973869169769E-10, 6.8066567167935E-13, 1.1216260688042E-15, 1.0236802978533E-18, 3.9720657964596E-22, 0.45454545454545, 0.39804225208567, 0.025341708058167, 6.3151501325496E-4, 8.0807554649258E-6, 6.0354664402269E-8, 2.8111642092611E-10, 8.4106334638657E-13, 1.6167280397671E-15, 1.9299941789907E-18, 1.3021732956413E-21, 3.79444536647E-25, 0.45454545454545, 0.39838448104318, 0.025416762495946, 6.3697712076076E-4, 8.2551983508228E-6, 6.314972988877E-8, 3.0629858708888E-10, 9.780868191644E-13, 2.0836563130596E-15, 2.9320679574331E-18, 2.6166497017204E-21, 1.3415328284784E-24, 3.0092796196223E-28, -0.58064516129032, -0.21559395174672, -0.030544696579492, -0.58064516129032, -0.19115223031554, -0.029473834786102, -0.0010066347258135, -0.58064516129032, -0.18233307297138, -0.028236544473632, -0.0012030039601232, -1.5208008334815E-5, -0.58064516129032, -0.17833069941496, -0.028475246894827, -0.0014606302030482, -2.99641113646E-5, -2.1343804115613E-7, -0.58064516129032, -0.17610367098315, -0.02826067664509, -0.0015322458810336, -3.6586320114212E-5, -3.9867529427935E-7, -1.6226665135199E-9, -0.58064516129032, -0.17483390114911, -0.027741186226246, -0.0014815956989918, -3.6301045393729E-5, -4.4685007550778E-7, -2.6875584507281E-9, -6.2831231083352E-12, -0.58064516129032, -0.17396071288671, -0.028684134226593, -0.0017432495919146, -5.0845860092993E-5, -7.9137773126678E-7, -6.7374753547729E-9, -2.9589252318632E-11, -5.2416294063507E-14, -0.58064516129032, -0.17339878373842, -0.028044727272007, -0.0016253143532453, -4.5810065724231E-5, -7.1155788003856E-7, -6.404907274814E-9, -3.3259355915939E-11, -9.2392278190522E-14, -1.0625147968957E-16, -0.58064516129032, -0.17144173377009, -0.028015092938518, -0.0016157222373633, -4.6227724829057E-5, -7.5479222345544E-7, -7.4894835017511E-9, -4.5979053535837E-11, -1.706013779677E-13, -3.5056663086597E-16, -3.0628886618191E-19, -0.58064516129032, -0.17300284166294, -0.027328009024214, -0.0015056021545051, -4.1367453292114E-5, -6.5884289780074E-7, -6.5536146317341E-9, -4.2091025159364E-11, -1.7479977056317E-13, -4.5368406820998E-16, -6.6928703208412E-19, -4.2844311155752E-22, -0.58064516129032, -0.17229366960984, -0.028800272381574, -0.001859617443042, -5.9976978730906E-5, -1.1090566945359E-6, -1.2745935692238E-8, -9.5158694657869E-11, -4.6969406476975E-13, -1.5218064136528E-15, -3.1130952108508E-18, -3.6466961532119E-21, -1.8644934368193E-24, 1.5806451612903, 1.5059165323919, 0.16978945451019, 1.5806451612903, 1.4814748109607, 0.19316031414798, 0.0062334163398843, 1.5806451612903, 1.4726556536165, 0.20074218117966, 0.0086336976630508, 1.1558084587197E-4, 1.5806451612903, 1.4686532800601, 0.20498325715728, 0.0099938118863291, 1.9922348036296E-4, 1.3919201448922E-6, 1.5806451612903, 1.4664262516283, 0.20699571533935, 0.010680275405545, 2.4933405067263E-4, 2.6855039111666E-6, 1.0854850713601E-8, 1.5806451612903, 1.4651564817943, 0.20774599475456, 0.010971861052267, 2.7524368830002E-4, 3.5403656934423E-6, 2.2575321236761E-8, 5657.4487882585, 1.5806451612903, 1.4642832935319, 0.2095621310173, 0.011509566107375, 3.1097988163828E-4, 4.5630986133302E-6, 3.7079641130883E-8, 1.5682590950194E-10, 2.6933430035588E-13, 1.5806451612903, 1.4637213643836, 0.20948465321101, 0.011536416747709, 3.1784614870548E-4, 4.9116720047009E-6, 4.4528196080481E-8, 2.3505328331393E-10, 6.6870118493809E-13, 7.9239438466385E-16, 1.5806451612903, 1.4617643144152, 0.21141206884584, 0.011805056288024, 3.3440743994479E-4, 5.441423529388E-6, 5.3918086434111E-8, 3.3075450191903E-10, 1.2264057386754E-12, 2.5181064036724E-15, 2.197761607281E-18, 1.5806451612903, 1.4633254223081, 0.20916387703869, 0.011579454550239, 3.2857305529008E-4, 5.4458388015784E-6, 5.6371977519294E-8, 3.754508369244E-10, 1.6091005950325E-12, 4.2884398776166E-15, 6.4665832685414E-18, 4.2148457924105E-21, 1.5806451612903, 1.462616250255, 0.21134531244915, 0.012108121568554, 3.589415374545E-4, 6.2664422624671E-6, 6.9193362616297E-8, 5.0195179261835E-10, 2.4253292036317E-12, 7.7310365461803E-15, 1.5613921810526E-17, 1.8102819599155E-20, 9.1776107476727E-24, 1.0, 1.0, 0.5, 1.0, 1.0, 0.5, 0.063304085, 1.0, 1.0, 0.5, 0.079027358, 0.0037089254, 1.0, 1.0, 0.5, 0.085605575, 0.0056773923, 1.2758716E-4, 1.0, 1.0, 0.5, 0.089018496, 0.0067947003, 2.3143226E-4, 2.898388E-6, 1.0, 1.0, 0.5, 0.091025408, 0.0074822425, 3.056758E-4, 6.072001E-6, 4.679323E-8, 1.0, 1.0, 0.5, 0.092308224, 0.0079335426, 3.5849723E-4, 8.800161E-6, 1.1108474E-7, 5.648779E-10, 1.0, 1.0, 0.5, 0.093178948, 0.0082451157, 3.9680345E-4, 1.1000301E-5, 1.7552367E-7, 1.4976734E-9, 5.293311E-12, 1.0, 1.0, 0.5, 0.093797465, 0.0084690176, 4.2524183E-4, 1.2746945E-5, 2.3355062E-7, 2.5642831E-9, 1.5495967E-11, 3.962808E-16, 1.0, 1.0, 0.5, 0.094252811, 0.0086352191, 4.4683802E-4, 1.413517E-5, 2.8359079E-7, 3.6242802E-9, 2.8591262E-11, 1.2691526E-13, 2.4249737E-16, 1.0, 1.0, 0.5, 0.094597848, 0.0087619296, 4.6357872E-4, 1.524691E-5, 3.2599754E-7, 4.6107927E-9, 4.2819928E-11, 2.5110371E-13, 8.4319465E-16, 1.2357105E-18};
    double[] b = M3rkarrays.getM3rk2ar();
    double[] hmax = M3rkarrays.getM3rk2ar();
    double[] epsArray = new double[1];
    double[] errorArray = new double[1];
    double[] c = M3rkarrays.getM3rk15ar();
    double[] la = M3rkarrays.getM3rk15ar();

    static {
        NUMBER_BACKUPS = 0;
    }

    public void backup(double starttime) {
        if (NUMBER_BACKUPS > 0) {
            M3rkBackup b = null;
            if (this.mbackupc.size() == NUMBER_BACKUPS) {
                this.mbackupc.remove(0);
            }
            b = new M3rkBackup(starttime, this);
            this.mbackupc.add(b);
        }
    }

    public void restore(double starttime) {
        M3rkBackup b = this.mbackupc.find(starttime);
        if (b != null) {
            b.restore(this);
        } else {
            logger.error("could not find correct starttime " + starttime);
        }
    }

    public M3rk(double tolin) {
        this.availftools = new FtoolCollection();
        apr = 1.0E-14;
        this.tol = tolin;
        this.newstart = true;
        this.nrftools = 0;
        Ftool htool = new Ftool(this);
        this.addftool(htool);
        this.fys = 3.15576E7;
        this.ran = new Ran();
    }

    public void dostepForward(Step stepcont, ModelRealisation geot) {
        double dtsec;
        int j;
        this.stepcon = stepcont;
        this.modelrealisation = geot;
        boolean bl = this.newstart = Math.abs(stepcont.starttime - geot.timepres) < 1.0E-6;
        if (this.newstart) {
            double dtma = stepcont.endtime - geot.timepres;
            if (dtma < 0.0) {
                this.ferror("dtma < 0");
            }
            this.x = 0.0;
            this.timestart = geot.timepres;
            this.xe = dtma * this.fys;
            this.n = geot.maxnodes;
            M3rk.info[1] = 0;
            M3rk.info[2] = 2;
            M3rk.info[3] = 10000000;
            j = 4;
            while (j <= 15) {
                M3rk.info[j] = 0;
                ++j;
            }
            this.selectftool(stepcont.idftool);
            j = 1;
            while (j <= this.n) {
                M3rk.y[j] = ModelRealisation.geotherm[j];
                ++j;
            }
            this.ftool.prepf();
            this.xe = 0.0;
        }
        if (geot.timepres + stepcont.steptime > stepcont.endtime) {
            dtsec = (stepcont.endtime - geot.timepres) * this.fys;
            this.xe = (stepcont.endtime - stepcont.starttime) * this.fys;
        } else {
            dtsec = stepcont.steptime * this.fys;
            this.xe += stepcont.steptime * this.fys;
        }
        this.ftool.updategeom(geot.timepres + 0.5 * dtsec / this.fys, 0.5 * dtsec);
        this.m3rk();
        this.ftool.updategeom(geot.timepres + dtsec / this.fys, 0.5 * dtsec);
        this.ftool.updategeomm3rk(geot.timepres + dtsec / this.fys, 0.5 * dtsec);
        if (this.m3rkerror()) {
            this.ferror("fatal error iteration m3rk");
        }
        geot.timepres = stepcont.starttime + this.xe / this.fys;
        j = 1;
        while (j <= this.n) {
            ModelRealisation.geotherm[j] = yxe[j];
            ++j;
        }
        boolean bl2 = stepcont.finish = Math.abs(geot.timepres - stepcont.endtime) <= 1.0E-6;
        if (stepcont.finish) {
            this.ftool.finfinish();
        }
    }

    public void dostepForwardNoRestart(Step stepcont, ModelRealisation geot) {
        double dtsec;
        int j;
        this.stepcon = stepcont;
        this.modelrealisation = geot;
        this.newstart = false;
        if (this.newstart) {
            double dtma = stepcont.endtime - geot.timepres;
            if (dtma < 0.0) {
                this.ferror("dtma < 0");
            }
            this.x = 0.0;
            this.timestart = geot.timepres;
            this.xe = dtma * this.fys;
            this.n = geot.maxnodes;
            M3rk.info[1] = 0;
            M3rk.info[2] = 2;
            M3rk.info[3] = 10000000;
            j = 4;
            while (j <= 15) {
                M3rk.info[j] = 0;
                ++j;
            }
            this.selectftool(stepcont.idftool);
            j = 1;
            while (j <= this.n) {
                M3rk.y[j] = ModelRealisation.geotherm[j];
                ++j;
            }
            this.ftool.prepf();
            this.xe = 0.0;
        }
        if (geot.timepres + stepcont.steptime > stepcont.endtime) {
            dtsec = (stepcont.endtime - geot.timepres) * this.fys;
            this.xe = (stepcont.endtime - stepcont.starttime) * this.fys;
        } else {
            dtsec = stepcont.steptime * this.fys;
            this.xe += stepcont.steptime * this.fys;
        }
        this.ftool.updategeom(geot.timepres + 0.5 * dtsec / this.fys, 0.5 * dtsec);
        this.m3rk();
        this.ftool.updategeom(geot.timepres + dtsec / this.fys, 0.5 * dtsec);
        this.ftool.updategeomm3rk(geot.timepres + dtsec / this.fys, 0.5 * dtsec);
        if (this.m3rkerror()) {
            this.ferror("fatal error iteration m3rk");
        }
        geot.timepres = stepcont.starttime + this.xe / this.fys;
        j = 1;
        while (j <= this.n) {
            ModelRealisation.geotherm[j] = yxe[j];
            ++j;
        }
        boolean bl = stepcont.finish = Math.abs(geot.timepres - stepcont.endtime) <= 1.0E-6;
        if (stepcont.finish) {
            this.ftool.finfinish();
        }
    }

    public void dostep(Step stepcont, ModelRealisation geot) {
        double dtsec;
        int j;
        this.stepcon = stepcont;
        this.modelrealisation = geot;
        boolean bl = this.newstart = Math.abs(stepcont.starttime - geot.timepres) < 1.0E-5;
        if (this.newstart) {
            double dtma = geot.timepres - stepcont.endtime;
            if (dtma < 0.0) {
                this.ferror("dtma < 0");
            }
            this.x = 0.0;
            this.timestart = geot.timepres;
            this.xe = dtma * this.fys;
            this.n = geot.maxnodes;
            M3rk.info[1] = 0;
            M3rk.info[2] = 2;
            M3rk.info[3] = 10000000;
            j = 4;
            while (j <= 15) {
                M3rk.info[j] = 0;
                ++j;
            }
            this.selectftool(stepcont.idftool);
            j = 1;
            while (j <= this.n) {
                M3rk.y[j] = ModelRealisation.geotherm[j];
                ++j;
            }
            this.ftool.prepf();
            this.xe = 0.0;
        }
        if (geot.timepres - stepcont.steptime < stepcont.endtime) {
            dtsec = (geot.timepres - stepcont.endtime) * this.fys;
            this.xe = (stepcont.starttime - stepcont.endtime) * this.fys;
        } else {
            dtsec = stepcont.steptime * this.fys;
            this.xe += stepcont.steptime * this.fys;
        }
        try {
            this.ftool.updategeom(geot.timepres - 0.5 * dtsec / this.fys, 0.5 * dtsec);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("ftool is null: requested model start is not part of surface temperature");
        }
        this.m3rk();
        this.ftool.updategeom(geot.timepres - dtsec / this.fys, 0.5 * dtsec);
        this.ftool.updategeomm3rk(geot.timepres - dtsec / this.fys, 0.5 * dtsec);
        if (this.m3rkerror()) {
            this.ferror("fatal error iteration m3rk");
        }
        geot.timepres = stepcont.starttime - this.xe / this.fys;
        j = 1;
        while (j <= this.n) {
            ModelRealisation.geotherm[j] = yxe[j];
            ++j;
        }
        stepcont.finish = Math.abs(geot.timepres - stepcont.endtime) <= 1.0E-5;
        System.out.println("-------------------------------------------------------------");
        System.out.println("M3RK time pres " + geot.timepres + "  time end " + stepcont.endtime);
        System.out.println("--------------------------------------------------------------");
        if (stepcont.finish) {
            System.out.println("-------------------------------------------------------------");
            System.out.println("FINFINISH");
            System.out.println("--------------------------------------------------------------");
            this.ftool.finfinish();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void ferror(String bb) {
        try {
            throw new Exception("ferror");
        }
        catch (Exception e) {
            e.printStackTrace();
            M3rk.logger.error("fatal error in m3rkobj ");
            M3rk.logger.error("message" + bb);
            i = 1;
            ** while (i <= 15)
        }
lbl-1000:
        // 1 sources

        {
            M3rk.logger.error("info" + i + "  : " + M3rk.info[i]);
            ++i;
            continue;
        }
lbl12:
        // 1 sources

        M3rk.logger.error(" iflag " + this.iflag);
        M3rk.logger.error("prestime" + this.modelrealisation.timepres);
        i = 1;
        while (i <= this.n) {
            ModelRealisation.geotherm[i] = M3rk.y[i];
            ++i;
        }
        M3rk.logger.error(" x " + this.x);
        M3rk.logger.error("fys " + this.fys);
        M3rk.logger.fatal("end of progam");
    }

    public void addftool(Ftool htool) {
        ++this.nrftools;
        if (this.nrftools > 20) {
            this.ferror("not enough toolspace to add tool");
        }
        this.availftools.ftools[this.nrftools] = htool;
    }

    public void selectftool(String id) {
        int i = this.nrftools + 1;
        boolean found = false;
        while (!found && i > 1) {
            found = id.equals(this.availftools.ftools[--i].id);
        }
        if (found) {
            this.ftool = this.availftools.ftools[i];
        } else {
            this.ferror(" tool  " + id + " not found in toolbox ");
        }
    }

    public boolean m3rkerror() {
        boolean m3rkerror_result = this.iflag != 0;
        return m3rkerror_result;
    }

    void m3rk() {
        if (this.ftool.id.equals("bdstretchm")) {
            this.explicit_integration();
        } else {
            this.m3rk_integration();
        }
    }

    static double powerab(double a, double b) {
        return Math.pow(a, b);
    }

    void estima(double[] epsOut, double[] errorOut) {
        double[] constant = new double[]{0.0, 2.85, 45.0};
        constant[1] = 2.85;
        constant[2] = 0.49;
        int order = info[12];
        double eps = 0.0;
        double error = 0.0;
        if (order != 2) {
            int i = 1;
            while (i <= this.n) {
                double yi = y[i];
                eps += yi * yi;
                double e = y1[i] - yi - yi + yxe[i];
                error += e * e;
                ++i;
            }
        } else {
            int i = 1;
            while (i <= this.n) {
                eps += y[i] * y[i];
                double e = -y2[i] + 3.0 * (y1[i] - y[i]) + yxe[i];
                error += e * e;
                ++i;
            }
        }
        eps = this.tol + this.tol * Math.sqrt(eps / (double)this.n);
        error = constant[order] * Math.sqrt(error / (double)this.n);
        epsOut[0] = eps;
        errorOut[0] = error;
    }

    double hstart(double sigma1) {
        double rmmax;
        double beta;
        int i = 1;
        while (i <= this.n) {
            M3rk.yxe[i] = y[i] + dy[i] / sigma1;
            ++i;
        }
        this.ftool.f(yxe);
        M3rk.info[7] = info[7] + 1;
        double etat = 0.0;
        double etae = 0.0;
        i = 1;
        while (i <= this.n) {
            etat += y[i] * y[i];
            double e = yxe[i] - dy[i];
            etae += e * e;
            ++i;
        }
        double hh = Math.sqrt((etat = this.tol + this.tol * Math.sqrt(etat / (double)this.n)) / (etae = Math.sqrt(etae / (double)this.n) / sigma1 + apr)) / sigma1 / 10.0;
        if (hh > (beta = (0.03 * (rmmax = (double)info[11]) + 0.44) * rmmax * rmmax) / sigma1) {
            hh = beta / sigma1;
        }
        if (Double.isNaN(hh)) {
            logger.warn("NaN step " + hh);
        }
        return hh;
    }

    void inter1(double alfa) {
        double nu = 2.0 - alfa;
        double c12 = (nu - 1.0) * (nu - 2.0) / 2.0;
        double c11 = nu * (2.0 - nu);
        double c10 = nu * (nu - 1.0) / 2.0;
        nu = 2.0 - 2.0 * alfa;
        double c22 = (nu - 1.0) * (nu - 2.0) / 2.0;
        double c21 = nu * (2.0 - nu);
        double c20 = nu * (nu - 1.0) / 2.0;
        int i = 1;
        while (i <= this.n) {
            double cy0 = y[i];
            double cy1 = y1[i];
            double cy2 = y2[i];
            M3rk.y1[i] = c12 * cy2 + c11 * cy1 + c10 * cy0;
            M3rk.dy1[i] = y1[i];
            M3rk.y2[i] = c22 * cy2 + c21 * cy1 + c20 * cy0;
            ++i;
        }
        this.ftool.f(dy1);
        M3rk.info[7] = info[7] + 1;
        M3rk.info[14] = 0;
    }

    void inter2(double a) {
        double nu = 2.0 - a;
        double c12 = (nu - 1.0) * (nu - 2.0) / 2.0;
        double c11 = nu * (2.0 - nu);
        double c10 = nu * (nu - 1.0) / 2.0;
        int i = 1;
        while (i <= this.n) {
            M3rk.yxe[i] = c12 * y2[i] + c11 * y1[i] + c10 * y[i];
            ++i;
        }
    }

    void maxdeg() {
        int j;
        double[] q = new double[]{0.0, 30.0, 100.0, 700.0, 4000.0, 30000.0, 200000.0, 900000.0, 5000000.0, 3.0E7, 2.0E8, 1.0E9};
        double e = this.tol / apr;
        boolean converged = false;
        int i = 1;
        do {
            if (!(q[j = 13 - ++i] <= e)) continue;
            converged = true;
        } while (!converged && i != 12);
        if (!converged) {
            this.iflag = 2;
        }
        if (converged) {
            M3rk.info[10] = 14 - i;
            converged = false;
            i = 2;
            do {
                if (!(100.0 * q[j = 13 - ++i] <= e)) continue;
                converged = true;
            } while (!converged && i != 12);
            if (!converged) {
                this.iflag = 2;
            } else {
                M3rk.info[11] = 14 - i;
            }
        }
    }

    void mindeg(double hh, double sigma1) {
        boolean start;
        double betac = 0.0;
        int l = info[12] + 9;
        int mmax = info[l];
        boolean bl = start = info[13] < 2;
        if (!start) {
            betac = 5.15 + 2.86 * (1.0 - (double)info[12]);
        }
        int m = 1;
        boolean converged = false;
        do {
            double rm = ++m;
            if (start) {
                betac = 0.03 * rm + 0.44;
            }
            if (!(hh <= betac * rm * rm / sigma1)) continue;
            converged = true;
        } while (!converged && m < mmax);
        if (!converged) {
            m = mmax;
        }
        M3rk.info[9] = m;
    }

    double newh(double epserr, double hold, double[] hmax) {
        double alfa = 1.0;
        if (info[14] >= 3 || epserr <= 1.0) {
            int order = info[12];
            alfa = M3rk.powerab(epserr, 1.0 / (double)(order + 1)) / (2.0 - (double)(order - 1) * 0.4);
            if (alfa > 0.9 && alfa < 1.1) {
                alfa = 1.0;
            }
            if (alfa != 1.0) {
                if (alfa > 3.0) {
                    alfa = 3.0;
                }
                if (alfa < 0.1) {
                    alfa = 0.1;
                }
                this.h = hold * alfa;
                if (this.h > hmax[order]) {
                    this.h = hmax[order];
                }
                alfa = this.h / hold;
            }
        }
        return alfa;
    }

    void param(double[] c, double[] la, double[] b) {
        block7: {
            int m;
            block6: {
                if (this.p == null) {
                    this.p = M3rkarrays.getM3rk15ar();
                    this.s = M3rkarrays.getM3rk15ar();
                }
                int order = info[12];
                m = info[9];
                if (info[13] < 2) break block6;
                int m1 = 176 * (order - 1) + m * (m + 1) / 2 - 3;
                int m2 = 88 + m1;
                int mm = m + 1;
                int j = 1;
                while (j <= mm) {
                    int m1pj = m1 + j;
                    int m2pj = m2 + j;
                    this.p[j] = this.d[m1pj];
                    this.s[j] = this.d[m2pj];
                    ++j;
                }
                if (m <= 2) {
                    this.p[4] = 0.0;
                    this.s[4] = 0.0;
                }
                double dd = 1.375 - 0.6 * (double)(order - 1);
                double e = this.p[2] + 2.0 * (-this.p[3] + this.p[4] + this.s[4]);
                c[m] = (e / dd - Math.pow((dd - 0.5) / dd, 2.0)) / (2.0 + e);
                la[m] = 1.0 / dd - c[m];
                la[m - 1] = this.s[3] / la[m];
                c[m - 1] = this.p[3] / la[m];
                b[1] = (this.p[2] - c[m]) / la[m];
                b[2] = this.p[1];
                if (m <= 2) break block7;
                mm = m - 2;
                j = 1;
                while (j <= mm) {
                    int mp2mj = m + 2 - j;
                    int mp1mj = m + 1 - j;
                    c[j] = this.p[mp2mj] / this.s[mp1mj];
                    la[j] = this.s[mp2mj] / this.s[mp1mj];
                    ++j;
                }
                break block7;
            }
            int m1 = 352 + m * (m + 1) / 2 - 3;
            int mm = m + 1;
            int j = 1;
            while (j <= mm) {
                int m1pj = m1 + j;
                this.s[j] = this.d[m1pj];
                ++j;
            }
            b[1] = 0.0;
            b[2] = 0.0;
            c[m] = 0.0;
            la[m] = this.s[1];
            mm = m - 1;
            j = 1;
            while (j <= mm) {
                int mp2mj = m + 2 - j;
                int mp1mj = m + 1 - j;
                la[j] = this.s[mp2mj] / this.s[mp1mj];
                c[j] = 0.0;
                ++j;
            }
        }
    }

    void powerm() {
        int maxit = 100;
        if (info[2] == 3) {
            M3rk.info[2] = 1;
        }
        M3rk.info[15] = 0;
        double tollip = 10000.0 * apr;
        double sigm = 0.0;
        double s0 = 0.0;
        int i = 1;
        while (i <= this.n) {
            double ra = 2.0 * Ran.ran3() - 1.0;
            M3rk.yxe[i] = dy[i];
            M3rk.dy[i] = y[i] == 0.0 ? ra * tollip : y[i] * (1.0 + tollip * ra);
            M3rk.dy1[i] = dy[i];
            s0 += dy[i] * dy[i];
            ++i;
        }
        double norm0 = tollip * Math.sqrt(s0);
        if (norm0 < tollip) {
            norm0 = tollip;
        }
        this.ftool.f(dy1);
        M3rk.info[7] = info[7] + 1;
        M3rk.info[8] = info[8] + 1;
        int k = 0;
        boolean converged = false;
        do {
            if (++k > 100) {
                this.iflag = 3;
                continue;
            }
            s0 = 0.0;
            i = 1;
            while (i <= this.n) {
                double s1 = yxe[i] - dy1[i];
                s0 += s1 * s1;
                ++i;
            }
            double norm = Math.sqrt(s0);
            double sigm1 = sigm;
            sigm = norm / norm0;
            if (k == 3 && Math.abs(this.sigma[1]) <= 1.0E-60) {
                this.sigma[2] = sigm;
            }
            if (k > 2 && !(Math.abs(this.sigma[1]) <= 1.0E-60)) {
                if (sigm >= 0.9 * this.sigma[2]) {
                    converged = true;
                } else {
                    this.sigma[2] = sigm;
                    this.sigma[1] = 0.0;
                }
            }
            if (!converged && k > 4 && !(Math.abs(sigm1 - sigm) / sigm > 0.001)) {
                this.sigma[1] = 1.1 * sigm;
                converged = true;
                continue;
            }
            i = 1;
            while (i <= this.n) {
                M3rk.yxe[i] = dy[i] + (yxe[i] - dy1[i]) / sigm;
                ++i;
            }
            this.ftool.f(yxe);
            M3rk.info[7] = info[7] + 1;
            M3rk.info[8] = info[8] + 1;
        } while (k <= 100 && !converged);
        i = 1;
        while (i <= this.n) {
            M3rk.dy[i] = y[i];
            ++i;
        }
        this.ftool.f(dy);
        M3rk.info[7] = info[7] + 1;
        M3rk.info[8] = info[8] + 1;
        if (info[13] == 0) {
            i = 1;
            while (i <= this.n) {
                M3rk.dy1[i] = y1[i];
                ++i;
            }
            this.ftool.f(dy1);
            M3rk.info[7] = info[7] + 1;
            M3rk.info[8] = info[8] + 1;
        }
    }

    void shift(double hh) {
        int i = 1;
        while (i <= this.n) {
            M3rk.y2[i] = y1[i];
            M3rk.y1[i] = y[i];
            M3rk.y[i] = yxe[i];
            M3rk.dy1[i] = dy[i];
            M3rk.dy[i] = y[i];
            ++i;
        }
        this.ftool.f(dy);
        M3rk.info[7] = info[7] + 1;
        this.x += hh;
    }

    void step(double[] c, double[] la, double[] b) {
        double hla;
        double hc;
        int m = info[9];
        double d = 1.375 - 0.6 * (double)(info[12] - 1);
        if (info[13] < 2) {
            d = 1.0;
        }
        int i = 1;
        while (i <= this.n) {
            M3rk.yxe[i] = dy[i];
            ++i;
        }
        if (m != 2) {
            int mm = m - 2;
            int j = 1;
            while (j <= mm) {
                hc = this.h * c[j];
                hla = this.h * la[j];
                i = 1;
                while (i <= this.n) {
                    M3rk.yxe[i] = y[i] + hc * dy1[i] + hla * yxe[i];
                    ++i;
                }
                this.ftool.f(yxe);
                M3rk.info[7] = info[7] + 1;
                ++j;
            }
        }
        double bm1 = b[1];
        double bm11 = 1.0 - bm1;
        hc = this.h * c[m - 1];
        hla = this.h * la[m - 1];
        i = 1;
        while (i <= this.n) {
            M3rk.yxe[i] = bm11 * y[i] + bm1 * y1[i] + hc * dy1[i] + hla * yxe[i];
            ++i;
        }
        double d1 = 1.0 - d;
        bm1 = b[2] * d;
        bm11 = (1.0 - b[2]) * d;
        hc = this.h * c[m] * d;
        hla = this.h * la[m] * d;
        this.ftool.f(yxe);
        M3rk.info[7] = info[7] + 1;
        i = 1;
        while (i <= this.n) {
            M3rk.yxe[i] = bm11 * y[i] + bm1 * y1[i] + d1 * y2[i] + hc * dy1[i] + hla * yxe[i];
            ++i;
        }
    }

    void explicit_integration() {
        int i;
        double dxrad = this.ftool.dz;
        int istep = 0;
        do {
            i = 1;
            while (i <= this.n) {
                M3rk.dy[i] = y[i];
                ++i;
            }
            this.ftool.f(dy);
            double radius = 0.0;
            i = 1;
            while (i <= this.n) {
                if (Math.abs(dy[i]) > radius) {
                    radius = dy[i];
                }
                ++i;
            }
            this.h = 0.02 * dxrad / radius;
            double xend = this.x + this.h;
            if (xend > this.xe) {
                xend = this.xe;
                this.h = xend - this.x;
            }
            if (istep % 1 == 0) {
                logger.info("relative at: " + this.x / this.xe + ' ' + this.x + ' ' + this.xe + " with h" + this.h);
            }
            i = 1;
            while (i <= this.n) {
                M3rk.y1[i] = y[i];
                M3rk.y[i] = y[i] + dy[i] * this.h;
                M3rk.dy1[i] = dy[i];
                ++i;
            }
            ++istep;
            double hold = this.h;
            this.x += this.h;
        } while (!(this.x >= this.xe - 10.0));
        i = 1;
        while (i <= this.n) {
            M3rk.yxe[i] = y[i];
            ++i;
        }
    }

    void m3rk_integration() {
        double hold = 0.0;
        double eps = 0.0;
        double error = 0.0;
        boolean m3rkfail = false;
        if (info[1] != 0 && !(this.x < this.xe)) {
            this.inter2((this.x - this.xe) / this.h);
        } else {
            int i;
            int reject;
            this.iflag = 0;
            this.maxdeg();
            if (this.iflag == 2) {
                return;
            }
            M3rk.info[9] = 0;
            if (info[1] != 0) {
                reject = 0;
                hold = this.h;
                if (Math.abs(this.sigma[1]) < 1.0E-60) {
                    logger.warn("spetral radius very small " + this.sigma[1]);
                }
                this.hmax[1] = 5.15 * (double)info[10] * (double)info[10] * 1.0 / this.sigma[1];
                this.hmax[2] = 2.29 * (double)info[11] * (double)info[11] * 1.0 / this.sigma[1];
            } else {
                boolean test;
                M3rk.info[1] = 1;
                reject = 0;
                i = 4;
                while (i <= 8) {
                    M3rk.info[i] = 0;
                    ++i;
                }
                i = 13;
                while (i <= 15) {
                    M3rk.info[i] = 0;
                    ++i;
                }
                M3rk.info[12] = 2;
                i = 1;
                while (i <= this.n) {
                    M3rk.dy[i] = y[i];
                    M3rk.dy1[i] = 0.0;
                    M3rk.y1[i] = 0.0;
                    M3rk.y2[i] = 0.0;
                    ++i;
                }
                this.ftool.f(dy);
                M3rk.info[7] = info[7] + 1;
                boolean bl = test = info[2] == 1;
                if (!test) {
                    this.sigma[1] = 0.0;
                    this.powerm();
                    if (this.iflag != 3) {
                        test = true;
                    } else {
                        this.ferror("something wrong in POWERM1");
                    }
                }
                if (test) {
                    this.hmax[1] = 5.15 * (double)info[10] * (double)info[10] * 1.0 / this.sigma[1];
                    this.hmax[2] = 2.29 * (double)info[11] * (double)info[11] * 1.0 / this.sigma[1];
                    hold = this.h = (this.hmin = this.hstart(this.sigma[1]));
                }
            }
            do {
                boolean loopexception;
                int mold = info[9];
                this.mindeg(this.h, this.sigma[1]);
                if (info[9] != mold) {
                    this.param(this.c, this.la, this.b);
                }
                do {
                    try {
                        loopexception = false;
                        do {
                            if (info[7] >= info[3]) {
                                this.iflag = 1;
                            }
                            if (this.iflag == 1) {
                                return;
                            }
                            if (this.h < this.hmin) {
                                this.hmin = this.h;
                            }
                            this.step(this.c, this.la, this.b);
                            M3rk.info[13] = info[13] + 1;
                            M3rk.info[4] = info[4] + 1;
                            boolean bl = m3rkfail = info[13] >= 3;
                            if (m3rkfail) continue;
                            this.shift(hold);
                            M3rk.info[14] = info[14] + 1;
                            M3rk.info[15] = info[15] + 1;
                        } while (!m3rkfail && info[13] == 1);
                        if (!m3rkfail) {
                            M3rk.info[9] = 0;
                        }
                        if (this.x >= this.xe && !m3rkfail) {
                            this.inter2((this.x - this.xe) / hold);
                        }
                        if (!m3rkfail) continue;
                        this.epsArray[0] = eps;
                        this.errorArray[0] = error;
                        this.estima(this.epsArray, this.errorArray);
                        eps = this.epsArray[0];
                        error = this.errorArray[0];
                        m3rkfail = false;
                        if (eps >= error || info[13] != 3) {
                            if (info[2] != 1 && info[15] != 0 && !(eps >= error)) {
                                this.sigma[1] = 0.0;
                                this.powerm();
                                if (this.iflag == 3) {
                                    m3rkfail = true;
                                    this.ferror("powerm2 failed");
                                } else {
                                    this.hmax[1] = 5.15 * (double)info[10] * (double)info[10] * 1.0 / this.sigma[1];
                                    this.hmax[2] = 2.29 * (double)info[11] * (double)info[11] * 1.0 / this.sigma[1];
                                }
                            }
                            if (m3rkfail) continue;
                            hold = this.h;
                            double alfa = this.newh(eps / error, hold, this.hmax);
                            if (info[12] == 1 && this.h < this.hmax[2]) {
                                M3rk.info[9] = 0;
                            }
                            if (info[9] == 0) {
                                M3rk.info[12] = 2;
                            }
                            if (eps >= error) {
                                if (info[14] >= 3 && info[12] != 1 && hold == this.hmax[2] && this.h == this.hmax[2]) {
                                    M3rk.info[12] = 1;
                                    this.epsArray[0] = eps;
                                    this.errorArray[0] = error;
                                    this.estima(this.epsArray, this.errorArray);
                                    eps = this.epsArray[0];
                                    error = this.errorArray[0];
                                    alfa = this.newh(eps / error, hold, this.hmax);
                                    if (alfa <= 1.0) {
                                        M3rk.info[12] = 2;
                                    }
                                    this.h = this.hmax[2];
                                    M3rk.info[14] = -1;
                                    if (info[12] != 2) {
                                        M3rk.info[9] = 0;
                                    }
                                }
                                this.shift(hold);
                                reject = 0;
                                M3rk.info[14] = info[14] + 1;
                                M3rk.info[15] = info[15] + 1;
                                if (info[2] != 1 && info[15] == 25) {
                                    this.powerm();
                                    if (this.iflag == 3) {
                                        m3rkfail = true;
                                        this.ferror("powerm3 failed");
                                    } else {
                                        this.hmax[1] = 5.15 * (double)info[10] * (double)info[10] * 1.0 / this.sigma[1];
                                        this.hmax[2] = 2.29 * (double)info[11] * (double)info[11] * 1.0 / this.sigma[1];
                                    }
                                }
                                if (m3rkfail) continue;
                                if (this.x >= this.xe) {
                                    this.inter2((this.x - this.xe) / hold);
                                    if (this.h == hold) continue;
                                    this.inter1(alfa);
                                    continue;
                                }
                                if (this.h != hold) {
                                    this.inter1(alfa);
                                }
                                if (this.h != hold || info[9] == 0) continue;
                                throw new LoopException("continue");
                            }
                            M3rk.info[5] = info[5] + 1;
                            if (++reject == 3) {
                                reject = 0;
                                M3rk.info[6] = info[6] + 1;
                                M3rk.info[9] = 0;
                                M3rk.info[12] = 2;
                                M3rk.info[13] = 0;
                                M3rk.info[14] = 0;
                                hold = this.h = this.hstart(this.sigma[1]);
                                continue;
                            }
                            this.inter1(alfa);
                            continue;
                        }
                        M3rk.info[6] = info[6] + 1;
                        M3rk.info[5] = info[5] + 3;
                        M3rk.info[9] = 0;
                        M3rk.info[13] = 0;
                        M3rk.info[14] = 0;
                        M3rk.info[15] = 0;
                        this.x -= 2.0 * this.h;
                        this.h /= 10.0;
                        i = 1;
                        while (i <= this.n) {
                            M3rk.y[i] = y2[i];
                            M3rk.dy[i] = y[i];
                            ++i;
                        }
                        this.ftool.f(dy);
                        M3rk.info[7] = info[7] + 1;
                        m3rkfail = false;
                    }
                    catch (LoopException e) {
                        loopexception = true;
                    }
                } while (loopexception);
            } while (!m3rkfail && !(this.x >= this.xe));
        }
    }

    public static void main(String[] args) {
    }

    public ModelRealisation getGeom() {
        return this.modelrealisation;
    }

    public void setGeom(ModelRealisation geom) {
        this.modelrealisation = geom;
    }

    public double getFys() {
        return this.fys;
    }

    public void setFys(double fys) {
        this.fys = fys;
    }

    public Step getStepcon() {
        return this.stepcon;
    }
}

