/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.integration;

import tno.geoenergy.fdintegration.integration.Step;
import tno.geoenergy.fdintegration.model.ModelRealisation;
import tno.geoenergy.logging.Logger;

public class Step3D
extends Step {
    private static Logger logger = Logger.getLogger(Step3D.class.getName());
    double[][] sedimentationthickness = null;
    double[][] sedimentdepth = null;
    double[][] delta = null;
    double dtstretch = 0.0;
    double surftempstart = 0.0;
    double surftempend = 0.0;

    public Step3D(ModelRealisation geot, double stime, double etime, String tid) {
        this.update(geot, stime, etime, tid);
    }

    public void update(ModelRealisation geot, double stime, double etime, String tid) {
        if (etime > stime) {
            logger.fatal("starttime (" + stime + ") must be > endtime (" + etime + ")");
        }
        this.finish = false;
        this.starttime = stime;
        this.steptime = stime - etime;
        this.endtime = etime;
        this.idftool = tid;
    }

    public static void main(String[] args) {
    }

    public double[][] getDelta() {
        return this.delta;
    }

    public void setDelta(double[][] delta) {
        this.delta = delta;
    }

    public static String getFileName(double endtime) {
        String name = "temp";
        int it = (int)endtime;
        if (it < 10) {
            name = String.valueOf(name) + "00";
        } else if (it < 100) {
            name = String.valueOf(name) + "0";
        }
        name = String.valueOf(name) + it + "%";
        int it2 = (int)(endtime * 100.0) % 100;
        if (it2 < 10) {
            name = String.valueOf(name) + "0";
        }
        name = String.valueOf(name) + it2;
        return name;
    }

    public double[][] getSedimentationthickness() {
        return this.sedimentationthickness;
    }

    public void setSedimentationthickness(double[][] sedimentationspeed) {
        this.sedimentationthickness = sedimentationspeed;
    }

    public double[][] getSedimentdepth() {
        return this.sedimentdepth;
    }

    public void setSedimentdepth(double[][] sedimentdepth) {
        this.sedimentdepth = sedimentdepth;
    }

    public double getSurftempend() {
        return this.surftempend;
    }

    public void setSurftempend(double surftempend) {
        this.surftempend = surftempend;
    }

    public double getSurftempstart() {
        return this.surftempstart;
    }

    public void setSurftempstart(double surftempstart) {
        this.surftempstart = surftempstart;
    }

    public double getDtstretch() {
        return this.dtstretch;
    }

    public void setDtstretch(double dtstretch) {
        this.dtstretch = dtstretch;
    }
}

