/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.model;

import tno.geoenergy.TnoWaterProperties;
import tno.geoenergy.fdintegration.model.ModelComponent;
import tno.geoenergy.properties.Property;

public class GAPropertiesPres
extends ModelComponent {
    public static final double PA2BAR = 100000.0;
    public static final double GRAVITY = 9.8;
    double permeability;
    public double viscosityinjection;
    double tempinjection;
    public double viscosityproduction;
    double tempproduction;
    double viscoalfa;
    double k;
    double c;
    double salinity = 0.0;
    double aquiferdepth = 0.0;
    double aquiferpressure = 0.0;

    public double getK() {
        return this.k;
    }

    public void setK(double k) {
        this.k = k;
    }

    public double getC() {
        return this.c;
    }

    public void setC(double c) {
        this.c = c;
    }

    public GAPropertiesPres(Property pmodel, Property pinitial) {
        super(pmodel, pinitial);
    }

    public double getHydraulicConductivity(double permeability, double viscosity) {
        return permeability / viscosity;
    }

    public double getViscosityRatioOld(double temperature) {
        return 1.0 + this.viscoalfa * (temperature - this.tempinjection);
    }

    public double getViscosityRatio(double temperature) {
        double v = 0.0;
        if (this.aquiferpressure > 0.0) {
            v = TnoWaterProperties.Viscosity(this.aquiferpressure, temperature, this.salinity);
            return v / this.viscosityinjection;
        }
        return 1.0 + this.viscoalfa * (temperature - this.tempinjection);
    }

    public static void main(String[] args) {
    }
}

