/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.model;

import tno.geoenergy.fdintegration.model.CellBC;
import tno.geoenergy.fdintegration.model.WellPerforation;
import tno.geoenergy.fdintegration.model.model1d.Grid1D;
import tno.geoenergy.fdintegration.model.model2d.Grid2D;

public class ModelBC {
    public static final int CELLVALUE = 0;
    public static final int BACKWARDI = 1;
    public static final int FORWARDI = 2;
    public static final int BACKWARDJ = 3;
    public static final int FORWARDJ = 4;
    public static final int BACKWARDK = 5;
    public static final int FORWARDK = 6;
    public static final int SOURCEVALUE = 7;
    public static final int HWELL = 8;
    double value;
    double cwc;
    double Q_calculated = 0.0;
    int wellid;
    int type;
    int ncomponent;
    int ilow;
    int ihigh;
    int jlow;
    int jhigh;
    int klow;
    int khigh;

    public int getWellid() {
        return this.wellid;
    }

    public int getIlow() {
        return this.ilow;
    }

    public int getJlow() {
        return this.jlow;
    }

    public int getKlow() {
        return this.klow;
    }

    public ModelBC(int wellid, int type, double value) {
        this.wellid = wellid;
        this.value = value;
        this.cwc = 0.0;
        this.type = type;
    }

    public ModelBC(int wellid, int type, double value, int ilow, int ihigh, int jlow, int jhigh, int klow, int khigh) {
        this.wellid = wellid;
        this.value = value;
        this.type = type;
        this.ilow = ilow;
        this.ihigh = ihigh;
        this.jlow = jlow;
        this.jhigh = jhigh;
        this.klow = klow;
        this.khigh = khigh;
    }

    public void convert2CellBC(CellBC[][] r) {
        int i = this.ilow;
        while (i <= this.ihigh) {
            int j = this.jlow;
            while (j <= this.jhigh) {
                if (r[i][j] == null) {
                    r[i][j] = new CellBC();
                }
                r[i][j].addModelBC(this);
                ++j;
            }
            ++i;
        }
    }

    public void convert1CellBC(CellBC[] r) {
        int i = this.ilow;
        while (i <= this.ihigh) {
            if (r[i] == null) {
                r[i] = new CellBC();
            }
            r[i].addModelBC(this);
            ++i;
        }
    }

    public void convert3CellBC(CellBC[][][] r) {
        int k = this.klow;
        while (k <= this.khigh) {
            int i = this.ilow;
            while (i <= this.ihigh) {
                int j = this.jlow;
                while (j <= this.jhigh) {
                    System.out.println("adding BC in grid" + i + "," + j + "," + k + " type " + this.type + " value " + this.getValue());
                    if (r[i][j][k] == null) {
                        r[i][j][k] = new CellBC();
                    }
                    r[i][j][k].addModelBC(this);
                    ++j;
                }
                ++i;
            }
            ++k;
        }
    }

    public double getValue() {
        return this.value;
    }

    public double getCwc() {
        return this.cwc;
    }

    public void setCwc(double cwc) {
        this.cwc = cwc;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public double getQ_calculated() {
        return this.Q_calculated;
    }

    public void setQ_calculated(double qCalculated) {
        this.Q_calculated = qCalculated;
    }

    public double getPresfromQValue(Grid2D g) {
        WellPerforation wp = g.getWpContainer().getWellPerforation(this.wellid);
        if (wp.getNewPcell() < 0.0) {
            return this.value;
        }
        return wp.getNewPcell();
    }

    public double getPresfromQValue(Grid1D g) {
        WellPerforation wp = g.getWpContainer().getWellPerforation(this.wellid);
        if (wp.getNewPcell() < 0.0) {
            return this.value;
        }
        return wp.getNewPcell();
    }
}

