/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.model;

import java.io.File;
import tno.geoenergy.fdintegration.model.FaultLine;
import tno.geoenergy.fdintegration.model.FaultLineContainer;
import tno.geoenergy.fdintegration.model.MaxNodes;
import tno.geoenergy.fdintegration.model.ModelComponentContainer;
import tno.geoenergy.fdintegration.model.WellPerforation;
import tno.geoenergy.fdintegration.model.WellPerforationContainer;
import tno.geoenergy.logging.Logger;

public class ModelRealisation
implements MaxNodes {
    private static Logger logger = Logger.getLogger(ModelRealisation.class.getName());
    ModelComponentContainer gpContainer = null;
    WellPerforationContainer wpContainer = null;
    FaultLineContainer flContainer = null;
    public static final double fys = 3.15576E7;
    public static int icount = 0;
    File fout;
    public int maxnodes;
    public double dz;
    protected double time0;
    public static double[] inigeotherm = ModelRealisation.getGeotar();
    public static double[] geotherm = ModelRealisation.getGeotar();
    public double timepres;

    public static double[] getGeotar() {
        System.out.println("getGeotar" + icount++);
        return new double[2000000];
    }

    public static int[] getiGeotar() {
        return new int[2000000];
    }

    public static double[] getInigeotherm() {
        return inigeotherm;
    }

    public static double[] getGeotherm() {
        return geotherm;
    }

    public ModelRealisation(ModelComponentContainer gp, double starttime) {
        this.timepres = this.time0 = starttime;
        this.gpContainer = gp;
        this.maxnodes = 1;
        this.wpContainer = new WellPerforationContainer();
        this.flContainer = new FaultLineContainer();
    }

    public ModelComponentContainer getGpContainer() {
        return this.gpContainer;
    }

    public void setGpContainer(ModelComponentContainer gp) {
        this.gpContainer = gp;
    }

    public void addWellPerforation(WellPerforation wp) {
        this.wpContainer.addWellPerforation(wp);
    }

    public WellPerforationContainer getWpContainer() {
        return this.wpContainer;
    }

    public void addFaultLine(FaultLine fl) {
        this.flContainer.addFaultLine(fl);
    }

    public FaultLineContainer getFlContainer() {
        return this.flContainer;
    }
}

