/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.model;

import tno.geoenergy.fdintegration.model.ModelBC;
import tno.geoenergy.fdintegration.model.ModelBCContainer;
import tno.geoenergy.fdintegration.model.WellPerforation;
import tno.geoenergy.fdintegration.model.WellPerforationContainer;

public class WellFunctions {
    private static final double LARGECWC = 1.0;

    public static double calcCWC(double dx, double dy, double rw, double Tx, double Ty, double skin) {
        double cwc = 1.0;
        double dx2 = Math.pow(dx, 2.0);
        double dy2 = Math.pow(dy, 2.0);
        if (Math.abs(1.0 - Tx / Ty) < 0.001) {
            double r0 = 0.14 * Math.pow(dx2 + dy2, 0.5);
            cwc = 1.0 / (Math.log(r0 / rw) / (Math.PI * 2 * Tx) + skin / (Math.PI * 2 * Tx));
        } else {
            double TxTy = Tx / Ty;
            double TyTx = Ty / Tx;
            double sqrtTxTy = Math.pow(TxTy, 0.5);
            double sqrtTyTx = Math.pow(TyTx, 0.5);
            double r0 = 0.28 * Math.pow((dx2 * sqrtTyTx + dy2 * sqrtTxTy) / (Math.pow(TyTx, 0.25) + Math.pow(TxTy, 0.25)), 0.5);
            cwc = 1.0 / (Math.log(r0 / rw) / (Math.PI * 2 * Math.pow(Tx * Ty, 0.5)) + skin / (Math.PI * 2 * Math.pow(Tx * Ty, 0.5)));
        }
        if (cwc < 0.0) {
            cwc = 1.0;
        }
        return cwc;
    }

    public static void getCalculatedWellData(ModelBCContainer bcContainer, WellPerforationContainer wpc, double dx, double dy, double[][] h, double[][] pres, boolean consistentpressure) {
        int i = 0;
        while (i < wpc.size()) {
            WellPerforation wp = wpc.getWellPerforation(i);
            wp.setPwell_calculated(0.0);
            wp.setQ_calculated(0.0);
            ++i;
        }
        i = 0;
        while (i < bcContainer.size()) {
            double qcell;
            ModelBC bc = bcContainer.getModelBoundaryCondition(i);
            int ii = bc.getIlow();
            int jj = bc.getJlow();
            int kk = bc.getKlow();
            WellPerforation wp = wpc.getWellPerforation(bc.getWellid());
            if (bc.getType() == 7) {
                qcell = bc.getValue() * h[ii][jj] * dx * dy;
                double cwc = bc.getCwc();
                double pp = pres[ii][jj];
                double p = (qcell + bc.getCwc() * pp) / bc.getCwc();
                bc.setQ_calculated(qcell);
                wp.setPwell_calculated(p);
                wp.setQ_calculated(qcell);
                wp.setNewPcell(pres[ii][jj]);
            } else if (bc.getType() == 8) {
                qcell = (bc.getValue() - pres[ii][jj]) * bc.getCwc();
                if (!consistentpressure) {
                    qcell = wp.getQ() * wp.getScale();
                }
                double p = (qcell + bc.getCwc() * pres[ii][jj]) / bc.getCwc();
                wp.setPwell_calculated(p);
                bc.setQ_calculated(qcell);
                wp.setQ_calculated(wp.getQ_calculated() + qcell);
                wp.setNewPcell(pres[ii][jj]);
            }
            ++i;
        }
    }

    public static double getUpdatedWellPressureFromQTarget(WellPerforation wp, double[][] pres) {
        double qmodel = wp.getQ_calculated();
        double qtarget = wp.getQ() * wp.scale;
        double pcell = qtarget / qmodel * pres[wp.icell][wp.jcell];
        System.out.println(" input qmodel " + qmodel + " qtarget " + qtarget + " pres  cell " + pres[wp.icell][wp.jcell] + " pcell " + pcell);
        return wp.pwell / 2.0;
    }
}

