/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.model;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import tno.geoenergy.TnoWaterProperties;
import tno.geoenergy.data.SmartGrid;
import tno.geoenergy.fdintegration.model.GAPropertiesPres;
import tno.geoenergy.fdintegration.model.GAPropertiesTemp;
import tno.geoenergy.fdintegration.model.ModelBC;
import tno.geoenergy.fdintegration.model.ModelComponent;
import tno.geoenergy.fdintegration.model.ModelGrid;
import tno.geoenergy.fdintegration.model.WellFunctions;
import tno.geoenergy.fdintegration.model.model1d.Grid1D;
import tno.geoenergy.fdintegration.model.model2d.Grid2Dregular;
import tno.geoenergy.fdintegration.model.model3d.Grid3Dregular;
import tno.geoenergy.properties.AquiferProperties;
import tno.geoenergy.properties.PropertyFactory;

public class WellPerforation {
    double x;
    double y;
    int id;
    int icell = 0;
    int jcell = 0;
    double pwell = 0.0;
    double skin = 0.0;
    double rwell = 0.0;
    double vwellbore = 0.0;
    double areawell = 0.0;
    double Q = 0.0;
    double scale = 1.0;
    int kstart = -1;
    int kend = -1;
    double newPcell = -1.0;
    double Q_calculated = 0.0;
    double pwell_calculated = 0.0;
    double injectiontemp = 0.0;
    ModelGrid g = null;
    final int NOUTPUTMAX = 1000;
    public static final int HWELL = 1;
    public static final int SOURCE = 2;
    public static final int INACTIVE = 3;
    private static final int NCATAGORIES = 9;
    int dischargemode = 2;
    double mindist = 0.0;
    int noutput = 0;
    double[][] outputVal = null;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public double getNewPcell() {
        return this.newPcell;
    }

    public void setPwell(double pwell) {
        this.pwell = pwell;
    }

    public double getQ() {
        return this.Q;
    }

    public int getDischargemode() {
        return this.dischargemode;
    }

    public void setDischargemode(int dischargemode) {
        this.dischargemode = dischargemode;
    }

    public WellPerforation(double x, double y, double volrate, double pwell, double rwell, double skin) {
        this.x = x;
        this.y = y;
        this.rwell = rwell;
        this.skin = skin;
        this.Q = volrate;
        this.pwell = pwell;
    }

    public void init(double injectiontemp, Grid2Dregular g) {
        this.g = g;
        this.icell = g.getIcell(this.x);
        this.jcell = g.getJcell(this.y);
        this.x = g.getX(this.icell);
        this.y = g.getY(this.jcell);
        System.out.println("modified well location " + this.x + " " + this.y);
        double[][] porosity = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IPOROSITY));
        double[][] h = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ITHICKNESS));
        this.areawell = Math.PI * 2 * this.rwell * porosity[this.icell][this.jcell] * h[this.icell][this.jcell];
        this.vwellbore = this.Q / this.areawell;
        this.injectiontemp = injectiontemp;
        this.dischargemode = 2;
        this.outputVal = new double[1000][g.getGpContainer().size() + 9];
    }

    public void init(double injectiontemp, Grid3Dregular g) {
        this.g = g;
        this.icell = g.getIcell(this.x);
        this.jcell = g.getJcell(this.y);
        this.x = g.getX(this.icell);
        this.y = g.getY(this.jcell);
        System.out.println("modified well location " + this.x + " " + this.y);
        int nz = g.getNz();
        double[] porosity = new double[nz];
        double[] h = new double[nz];
        double[] actnum = new double[nz];
        double hsum = 0.0;
        this.areawell = 0.0;
        int k = 0;
        while (k < nz) {
            porosity[k] = PropertyFactory.getProperty(AquiferProperties.IPOROSITY).getValue(this.icell, this.jcell, k);
            h[k] = PropertyFactory.getProperty(AquiferProperties.ITHICKNESS).getValue(this.icell, this.jcell, k);
            actnum[k] = PropertyFactory.getProperty(AquiferProperties.IACTNUM).getValue(this.icell, this.jcell, k);
            if (actnum[k] > 0.0) {
                hsum += h[k];
                this.areawell += Math.PI * 2 * this.rwell * porosity[k] * h[k];
            }
            ++k;
        }
        this.vwellbore = this.Q / this.areawell;
        this.injectiontemp = injectiontemp;
        this.dischargemode = 2;
        this.outputVal = new double[1000][g.getGpContainer().size() + 9];
    }

    public WellPerforation(double x, double y, double volrate, double injectiontemp, double pwell, double rwell, Grid2Dregular g) {
        this.x = x;
        this.y = y;
        this.rwell = rwell;
        this.skin = 0.0;
        this.Q = volrate;
        this.pwell = pwell;
        this.g = g;
        this.icell = g.getIcell(x);
        this.jcell = g.getJcell(y);
        this.x = g.getX(this.icell);
        this.y = g.getY(this.jcell);
        System.out.println("modified well location " + x + " " + y);
        double[][] porosity = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IPOROSITY));
        double[][] h = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ITHICKNESS));
        this.areawell = Math.PI * 2 * rwell * porosity[this.icell][this.jcell] * h[this.icell][this.jcell];
        this.vwellbore = volrate / this.areawell;
        this.injectiontemp = injectiontemp;
        this.dischargemode = 2;
        this.outputVal = new double[1000][g.getGpContainer().size() + 9];
    }

    public WellPerforation(double x, double y, double volrate, double injectiontemp, double pwell, double rwell, double skin, Grid2Dregular g) {
        this.x = x;
        this.y = y;
        this.rwell = rwell;
        this.skin = skin;
        this.Q = volrate;
        this.pwell = pwell;
        this.g = g;
        this.icell = g.getIcell(x);
        this.jcell = g.getJcell(y);
        this.x = g.getX(this.icell);
        this.y = g.getY(this.jcell);
        System.out.println("modified well location " + this.x + " " + this.y + " (" + this.icell + " " + this.jcell + ")");
        double[][] porosity = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IPOROSITY));
        double[][] h = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ITHICKNESS));
        this.areawell = Math.PI * 2 * rwell * porosity[this.icell][this.jcell] * h[this.icell][this.jcell];
        this.vwellbore = volrate / this.areawell;
        this.injectiontemp = injectiontemp;
        this.dischargemode = 2;
        this.outputVal = new double[1000][g.getGpContainer().size() + 9];
    }

    public WellPerforation(double x, double y, double volrate, double injectiontemp, double pwell, double rwell, Grid3Dregular g) {
        this.x = x;
        this.y = y;
        this.rwell = rwell;
        this.pwell = pwell;
        this.g = g;
        this.icell = g.getIcell(x);
        this.jcell = g.getJcell(y);
        this.x = g.getX(this.icell);
        this.y = g.getY(this.jcell);
        System.out.println("modified well location " + this.x + " " + this.y + " (" + this.icell + " " + this.jcell + ")");
        int nz = g.getNz();
        double[] porosity = new double[nz];
        double[] h = new double[nz];
        double[] actnum = new double[nz];
        double hsum = 0.0;
        this.areawell = 0.0;
        int k = 0;
        while (k < nz) {
            porosity[k] = PropertyFactory.getProperty(AquiferProperties.IPOROSITY).getValue(this.icell, this.jcell, k);
            h[k] = PropertyFactory.getProperty(AquiferProperties.ITHICKNESS).getValue(this.icell, this.jcell, k);
            actnum[k] = PropertyFactory.getProperty(AquiferProperties.IACTNUM).getValue(this.icell, this.jcell, k);
            if (actnum[k] > 0.0) {
                hsum += h[k];
                this.areawell += Math.PI * 2 * rwell * porosity[k] * h[k];
            }
            ++k;
        }
        this.vwellbore = volrate / this.areawell;
        this.Q = volrate;
        this.injectiontemp = injectiontemp;
        this.dischargemode = 2;
        this.outputVal = new double[1000][g.getGpContainer().size() + 9];
    }

    public WellPerforation(double volrate, double injectiontemp, double pwell, double rwell, Grid1D g) {
        this.x = 0.0;
        this.y = 0.0;
        this.rwell = rwell;
        this.pwell = pwell;
        this.g = g;
        this.icell = 0;
        this.jcell = 0;
        int nz = g.getNz();
        double[] porosity = new double[nz];
        double[] h = new double[nz];
        double[] actnum = new double[nz];
        double hsum = 0.0;
        this.areawell = 0.0;
        int k = 0;
        while (k < nz) {
            porosity[k] = PropertyFactory.getProperty(AquiferProperties.IPOROSITY).getValue(this.icell, this.jcell, k);
            h[k] = PropertyFactory.getProperty(AquiferProperties.ITHICKNESS).getValue(this.icell, this.jcell, k);
            actnum[k] = PropertyFactory.getProperty(AquiferProperties.IACTNUM).getValue(this.icell, this.jcell, k);
            if (actnum[k] > 0.0) {
                hsum += h[k];
                this.areawell += Math.PI * 2 * rwell * porosity[k] * h[k];
            }
            ++k;
        }
        this.vwellbore = volrate / this.areawell;
        this.Q = volrate;
        this.injectiontemp = injectiontemp;
        this.dischargemode = 2;
        this.outputVal = new double[1000][g.getGpContainer().size() + 9];
    }

    public void init(double injectiontemp, Grid1D g) {
        this.g = g;
        this.x = 0.0;
        this.y = 0.0;
        this.icell = 0;
        this.jcell = 0;
        int nz = g.getNz();
        double[] porosity = new double[nz];
        double[] h = new double[nz];
        double[] actnum = new double[nz];
        double hsum = 0.0;
        this.areawell = 0.0;
        int k = 0;
        while (k < nz) {
            porosity[k] = PropertyFactory.getProperty(AquiferProperties.IPOROSITY).getValue(this.icell, this.jcell, k);
            h[k] = PropertyFactory.getProperty(AquiferProperties.ITHICKNESS).getValue(this.icell, this.jcell, k);
            actnum[k] = PropertyFactory.getProperty(AquiferProperties.IACTNUM).getValue(this.icell, this.jcell, k);
            if (actnum[k] > 0.0) {
                hsum += h[k];
                this.areawell += Math.PI * 2 * this.rwell * porosity[k] * h[k];
            }
            ++k;
        }
        this.vwellbore = this.Q / this.areawell;
        this.injectiontemp = injectiontemp;
        this.dischargemode = 2;
        this.outputVal = new double[1000][g.getGpContainer().size() + 9];
    }

    public ModelBC getTemperatureBC(int k) {
        ModelBC mbc = null;
        double actnum = PropertyFactory.getProperty(AquiferProperties.IACTNUM).getValue(this.icell, this.jcell, k);
        if (actnum > 0.0 && this.injectiontemp > 0.0) {
            mbc = new ModelBC(this.id, 0, this.injectiontemp, this.icell, this.icell, this.jcell, this.jcell, k, k);
        }
        return mbc;
    }

    public ModelBC getSourceBC(ModelComponent mc, int k, int nz) {
        ModelBC mbc = null;
        double actnum = PropertyFactory.getProperty(AquiferProperties.IACTNUM).getValue(this.icell, this.jcell, k);
        int actnum_count = 0;
        int i = 0;
        while (i < nz) {
            actnum_count += (int)PropertyFactory.getProperty(AquiferProperties.IACTNUM).getValue(this.icell, this.jcell, i);
            ++i;
        }
        if (actnum > 0.0) {
            double h = PropertyFactory.getProperty(AquiferProperties.ITHICKNESS).getValue(this.icell, this.jcell, k);
            mbc = new ModelBC(this.id, 7, this.Q * this.scale / (h * (double)actnum_count * this.g.getDx() * this.g.getDy()), this.icell, this.icell, this.jcell, this.jcell, k, k);
            double visc = PropertyFactory.getProperty(AquiferProperties.IVISCOSITY).getValue(this.icell, this.jcell, k);
            double permx = PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYI).getValue(this.icell, this.jcell, k);
            double permy = PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYJ).getValue(this.icell, this.jcell, k);
            double ranfactor = PropertyFactory.getProperty(AquiferProperties.ICALC_RANFACTORS).getValue(this.icell, this.jcell, k);
            double ng = PropertyFactory.getProperty(AquiferProperties.ING).getValue(this.icell, this.jcell, k);
            if (visc < 1.0E-10) {
                visc = 1.0E-4;
            }
            double kx = ranfactor * permx * ng * 100000.0 / (1.0132502738308866E15 * visc);
            double ky = ranfactor * permy * ng * 100000.0 / (1.0132502738308866E15 * visc);
            double Tx = kx * h;
            double Ty = ky * h;
            double cwc = 1.0E-38;
            if (Tx > 1.0E-38) {
                cwc = WellFunctions.calcCWC(this.g.getDx(), this.g.getDy(), this.rwell, Tx, Ty, this.skin);
            }
            mbc.setCwc(cwc);
        }
        return mbc;
    }

    public ModelBC getPresBC(ModelComponent mc) {
        ModelBC mbc = null;
        double actnum = PropertyFactory.getProperty(AquiferProperties.IACTNUM).getValue(this.icell, this.jcell, 0);
        if (actnum > 0.0) {
            mbc = new ModelBC(this.id, 0, this.pwell * this.scale, this.icell, this.icell, this.jcell, this.jcell, 0, 0);
        }
        return mbc;
    }

    public ModelBC getHwellBC(ModelComponent mc, int k) {
        ModelBC mbc = null;
        double actnum = PropertyFactory.getProperty(AquiferProperties.IACTNUM).getValue(this.icell, this.jcell, k);
        if (actnum > 0.0) {
            double visc = PropertyFactory.getProperty(AquiferProperties.IVISCOSITY).getValue(this.icell, this.jcell, k);
            double permx = PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYI).getValue(this.icell, this.jcell, k);
            double permy = PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYJ).getValue(this.icell, this.jcell, k);
            double ranfactor = PropertyFactory.getProperty(AquiferProperties.ICALC_RANFACTORS).getValue(this.icell, this.jcell, k);
            double ng = PropertyFactory.getProperty(AquiferProperties.ING).getValue(this.icell, this.jcell, k);
            if (visc < 1.0E-10) {
                visc = 1.0E-4;
            }
            double kx = ranfactor * permx * ng * 100000.0 / (1.0132502738308866E15 * visc);
            double ky = ranfactor * permy * ng * 100000.0 / (1.0132502738308866E15 * visc);
            double h = PropertyFactory.getProperty(AquiferProperties.ITHICKNESS).getValue(this.icell, this.jcell, k);
            double Tx = kx * h;
            double Ty = ky * h;
            double cwc = 1.0E-38;
            if (Tx > 1.0E-38) {
                cwc = WellFunctions.calcCWC(this.g.getDx(), this.g.getDy(), this.rwell, Tx, Ty, this.skin);
            }
            mbc = new ModelBC(this.id, 8, this.pwell * this.scale, this.icell, this.icell, this.jcell, this.jcell, k, k);
            mbc.setCwc(cwc);
        }
        return mbc;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double[] getStreamlineVelocity(double xx, double yy) {
        double r = Math.pow(Math.pow(xx - this.x, 2.0) + Math.pow(yy - this.y, 2.0), 0.5);
        double dx = (xx - this.x) / r;
        double dy = (yy - this.y) / r;
        double areafac = this.rwell / r;
        double[] vel = new double[]{areafac * this.vwellbore * dx, areafac * this.vwellbore * dy};
        return vel;
    }

    public double getPressure(double xx, double yy, double kh, double ch, double tyrs) {
        double p;
        double ts = tyrs * 365.0 * 3600.0 * 24.0;
        double r = Math.pow(Math.pow(xx - this.x, 2.0) + Math.pow(yy - this.y, 2.0), 0.5);
        if (r < this.rwell) {
            r = this.rwell;
        }
        if (r < this.mindist) {
            this.mindist = r;
        }
        if (Double.isNaN(p = this.Q / (Math.PI * 4 * kh) * (Math.log(4.0 * (kh / ch) * ts / Math.pow(r, 2.0)) - 0.5772))) {
            System.out.println("");
        }
        return p;
    }

    public int getIcell() {
        return this.icell;
    }

    public int getJcell() {
        return this.jcell;
    }

    public void getBC(ModelComponent mc, int nz) {
        ModelBC mbc = null;
        int ks = 0;
        int ke = nz;
        if (this.kstart != -1 && this.kend != -1) {
            ks = Math.min(this.kstart, nz - 1);
            ke = Math.min(this.kend, nz);
        }
        int k = ks;
        while (k < ke) {
            if (mc instanceof GAPropertiesTemp) {
                mbc = this.getTemperatureBC(k);
                if (mbc != null) {
                    mc.getBcContainer().add(mbc);
                }
            } else if (mc instanceof GAPropertiesPres) {
                if (this.dischargemode == 2) {
                    mbc = this.getSourceBC(mc, k, nz);
                } else if (this.dischargemode == 1) {
                    mbc = this.getHwellBC(mc, k);
                } else {
                    int n = this.dischargemode;
                }
                if (mbc != null) {
                    mc.getBcContainer().add(mbc);
                }
            }
            ++k;
        }
    }

    public double getMindist() {
        return this.mindist;
    }

    public void setMindist(double mindist) {
        this.mindist = mindist;
    }

    public double getPwell() {
        return this.pwell;
    }

    public void setOutputPresQViscRhoCp(int component, double viscosity, double salinity, double totalcellpressure) {
        this.outputVal[this.noutput][component + 2] = this.getPwell();
        this.outputVal[this.noutput][component + 3] = this.getPwell_calculated();
        this.outputVal[this.noutput][component + 4] = this.getQ() * 3600.0;
        this.outputVal[this.noutput][component + 5] = this.getQ_calculated() * 3600.0;
        double temp = this.outputVal[this.noutput][component];
        double pres = totalcellpressure;
        double visc = TnoWaterProperties.Viscosity(pres * 100000.0, temp, salinity * 1.0E-6);
        double dens = TnoWaterProperties.Density(pres * 100000.0, temp, salinity * 1.0E-6);
        double cp = TnoWaterProperties.HeatCapacity(pres * 100000.0, temp, salinity * 1.0E-6);
        this.outputVal[this.noutput][component + 6] = visc;
        this.outputVal[this.noutput][component + 7] = dens;
        this.outputVal[this.noutput][component + 8] = cp;
        this.outputVal[this.noutput][component + 9] = salinity;
    }

    public void setOutput(int component, SmartGrid grid, boolean average, double[][] viscosity, double salinity, double[][] hydrostaticpressure) {
        this.outputVal[this.noutput][component + 1] = average ? 0.25 * (double)(grid.values[this.icell + 1][this.jcell] + grid.values[this.icell - 1][this.jcell] + grid.values[this.icell][this.jcell + 1] + grid.values[this.icell][this.jcell - 1]) : (double)grid.values[this.icell][this.jcell];
        if (component == 1) {
            this.setOutputPresQViscRhoCp(component, viscosity[this.icell][this.jcell], salinity, hydrostaticpressure[this.icell][this.jcell]);
        }
    }

    public void setOutput(int component, double value, double[][][] viscosity, double salinity, double[][][] totalpressure) {
        this.outputVal[this.noutput][component + 1] = value;
        int kmid = 0 * (this.kstart + this.kend);
        if (component == 1) {
            this.setOutputPresQViscRhoCp(component, viscosity[this.icell][this.jcell][kmid], salinity, totalpressure[this.icell][this.jcell][kmid]);
        }
    }

    public void setOutputTime(double time) {
        this.outputVal[this.noutput][0] = time;
        ++this.noutput;
    }

    public void outputWells2File(String fname) {
        PrintStream pos = null;
        try {
            pos = new PrintStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(fname) + "i" + this.icell + "j" + this.jcell + ".txt")));
            pos.println("time cell_T cell_P well_P well_Pcalc well_Q well_Qcalc viscosity density cp salinity");
            int i = 0;
            while (i < this.noutput) {
                int j = 0;
                while (j < this.outputVal[i].length) {
                    if (j > 0) {
                        pos.print(" ");
                    }
                    pos.print("" + this.outputVal[i][j]);
                    ++j;
                }
                pos.println();
                ++i;
            }
            pos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double[][] outputWell2Chart() {
        double[][] res = new double[this.outputVal[0].length][this.noutput];
        int i = 0;
        while (i < this.outputVal[0].length) {
            int j = 0;
            while (j < this.noutput) {
                res[i][j] = Math.abs(this.outputVal[j][i]);
                ++j;
            }
            ++i;
        }
        return res;
    }

    public String getNiceWellname(int index) {
        String wellname = this.dischargemode == 2 ? (this.getQ() < 0.0 ? "Well " + index + " [producer]" : "Well " + index + " [injector]") : (this.getPwell() < 0.0 ? "Well " + index + " [producer]" : "Well " + index + " [injector]");
        return wellname;
    }

    public double getQ_calculated() {
        return this.Q_calculated;
    }

    public void setQ_calculated(double qCalculated) {
        this.Q_calculated = qCalculated;
    }

    public double getPwell_calculated() {
        return this.pwell_calculated;
    }

    public void setPwell_calculated(double pwellCalculated) {
        this.pwell_calculated = pwellCalculated;
    }

    public int getKstart() {
        return this.kstart;
    }

    public void setKstart(int kstart) {
        this.kstart = kstart;
    }

    public int getKend() {
        return this.kend;
    }

    public void setKend(int kend) {
        this.kend = kend;
    }

    public void setNewPcell(double p) {
        this.newPcell = p;
    }
}

