/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.model;

import java.util.Vector;
import tno.geoenergy.data.SmartGrid;
import tno.geoenergy.fdintegration.model.ModelComponent;
import tno.geoenergy.fdintegration.model.WellPerforation;
import tno.geoenergy.properties.AquiferProperties;
import tno.geoenergy.properties.PropertyFactory;

public class WellPerforationContainer
extends Vector {
    public WellPerforation getWellPerforation(int i) {
        return (WellPerforation)this.get(i);
    }

    public void addWellPerforation(WellPerforation p) {
        p.setId(this.size());
        this.add(p);
    }

    public void sort() {
        this.sort();
    }

    public void initializeWellBC(ModelComponent mc, int nz) {
        int i = 0;
        while (i < this.size()) {
            WellPerforation wp = this.getWellPerforation(i);
            wp.getBC(mc, nz);
            ++i;
        }
    }

    public void setDischargeMode(int dischargemode) {
        int i = 0;
        while (i < this.size()) {
            WellPerforation wp = this.getWellPerforation(i);
            wp.setDischargemode(dischargemode);
            ++i;
        }
    }

    public void setOutput(int component, SmartGrid grid, double[][] viscosity, double salinity, double[][] totalpressure) {
        int i = 0;
        while (i < this.size()) {
            this.getWellPerforation(i).setOutput(component, grid, false, viscosity, salinity, totalpressure);
            ++i;
        }
    }

    public void setOutput(int component, int iwell, double value, double[][][] viscosity, double salinity, double[][][] totalpressure) {
        this.getWellPerforation(iwell).setOutput(component, value, viscosity, salinity, totalpressure);
    }

    public void setOutputTime(double time) {
        int i = 0;
        while (i < this.size()) {
            this.getWellPerforation(i).setOutputTime(time);
            ++i;
        }
    }

    public void outputWells2File(String dirname) {
        int i = 0;
        while (i < this.size()) {
            this.getWellPerforation(i).outputWells2File(String.valueOf(dirname) + "/well" + i);
            ++i;
        }
    }

    public void setRanFactor(double d, int nz) {
        int i = 0;
        while (i < this.size()) {
            int ii = this.getWellPerforation(i).getIcell();
            int jj = this.getWellPerforation(i).getJcell();
            int kk = 0;
            while (kk < nz) {
                PropertyFactory.getProperty(AquiferProperties.ICALC_RANFACTORS).setValue(ii, jj, kk, d);
                PropertyFactory.getProperty(AquiferProperties.ICALC_RANFACTORS).setValue(ii - 1, jj, kk, d / 2.0);
                PropertyFactory.getProperty(AquiferProperties.ICALC_RANFACTORS).setValue(ii + 1, jj, kk, d / 2.0);
                PropertyFactory.getProperty(AquiferProperties.ICALC_RANFACTORS).setValue(ii, jj - 1, kk, d / 2.0);
                PropertyFactory.getProperty(AquiferProperties.ICALC_RANFACTORS).setValue(ii, jj + 1, kk, d / 2.0);
                ++kk;
            }
            ++i;
        }
    }

    public void setRanFactor2(double d, int nz, int ni) {
        int iw = 0;
        while (iw < this.size()) {
            int ii = this.getWellPerforation(iw).getIcell();
            int jj = this.getWellPerforation(iw).getJcell();
            int i = ii - ni;
            while (i < ii + ni + 1) {
                int j = jj - ni;
                while (j < jj + ni + 1) {
                    int kk = 0;
                    while (kk < nz) {
                        PropertyFactory.getProperty(AquiferProperties.ICALC_RANFACTORS).setValue(i, j, kk, d);
                        ++kk;
                    }
                    ++j;
                }
                ++i;
            }
            ++iw;
        }
    }

    public void setScale(double d) {
        int i = 0;
        while (i < this.size()) {
            this.getWellPerforation(i).setScale(d);
            ++i;
        }
    }

    public boolean checkInactive() {
        boolean inactive = true;
        int i = 0;
        while (i < this.size()) {
            if (this.getWellPerforation((int)i).dischargemode != 3) {
                inactive = false;
            }
            ++i;
        }
        return inactive;
    }
}

