/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.model.model1d;

import tno.geoenergy.data.Grid;
import tno.geoenergy.fdintegration.model.CellBC;
import tno.geoenergy.fdintegration.model.ModelBC;
import tno.geoenergy.fdintegration.model.ModelComponent;
import tno.geoenergy.fdintegration.model.ModelComponentContainer;
import tno.geoenergy.fdintegration.model.ModelGrid;
import tno.geoenergy.fdintegration.model.WellPerforation;
import tno.geoenergy.logging.Logger;
import tno.geoenergy.properties.Property;
import tno.geoenergy.vinsome.Vinsome;

public class Grid1D
extends ModelGrid {
    protected double[][] values = null;
    protected double[] r = null;
    protected double[] oldtemp = null;
    protected boolean useVelocities = false;
    private double[] velx = null;
    private Vinsome[] vinsome = null;
    private static Logger logger = Logger.getLogger(Grid1D.class.getName());

    public boolean isUseVelocities() {
        return this.useVelocities;
    }

    public void setUseVelocities(boolean useVelocities) {
        this.useVelocities = useVelocities;
    }

    public Grid1D(ModelComponentContainer gp, double starttime, int nx, double startradius, double startstep, double incradius, double incmax) {
        super(gp, starttime);
        int i;
        this.orx = 0.0;
        if (nx > 2000000) {
            logger.error("nx > 2000000");
        } else {
            this.orx = this.orx;
            this.nx = nx;
            this.ny = 1;
            this.nz = 1;
            this.values = new double[gp.getNcomponents()][nx];
            this.r = new double[nx];
            i = 0;
            while (i < nx) {
                this.r[i] = i == 0 ? startradius : this.r[i - 1] + Math.min(incmax, Math.pow(incradius, i) * startstep);
                ++i;
            }
            this.maxnodes = gp.getNcomponents() * nx;
        }
        if (this.vinsome == null) {
            this.vinsome = new Vinsome[nx];
        }
        i = 0;
        while (i < nx) {
            this.vinsome[i] = new Vinsome();
            ++i;
        }
        this.initializeValuesConstant();
    }

    public void calculateVelfromWP(int mode) {
        int nx = this.getNx();
        double[] vel = new double[nx];
        if (mode == 0) {
            this.calculateVelAnalytical(vel);
        }
        this.velx = vel;
    }

    private void calculateVelAnalytical(double[] vel) {
        int i = 0;
        while (i < this.nx) {
            int iw = 0;
            while (iw < this.getWpContainer().size()) {
                WellPerforation wp = this.getWpContainer().getWellPerforation(iw);
                double xx = this.getX(i);
                double[] val = wp.getStreamlineVelocity(xx, 0.0);
                int n = i;
                vel[n] = vel[n] + val[0];
                ++iw;
            }
            ++i;
        }
    }

    private double getX(int i) {
        return this.r[i];
    }

    public CellBC[] getBC(ModelComponent mc) {
        CellBC[] r = new CellBC[this.nx];
        int i = 0;
        while (i < mc.getBcContainer().size()) {
            ModelBC mbc = mc.getBcContainer().getModelBoundaryCondition(i);
            mbc.convert1CellBC(r);
            ++i;
        }
        return r;
    }

    public void initializeBC() {
        int i = 0;
        while (i < this.getGpContainer().size()) {
            CellBC[] cellBC = this.getBC(this.getGpContainer().getModelComponent(i));
            this.initializeBCValues(i, cellBC);
            ++i;
        }
    }

    public void initializeBCValues(int component, CellBC[] cellBC) {
        int i = 0;
        while (i < this.getNx()) {
            ModelBC mbc;
            CellBC cbc = cellBC[i];
            if (cbc != null && cbc.getTypes()[0] != null) {
                mbc = cbc.getTypes()[0];
                System.out.println("applying boundary WEll CELL VALUE " + mbc.getValue());
                Grid1D.geotherm[this.getM3rkIndex((int)component, (int)i)] = mbc.getValue();
                Grid1D.inigeotherm[this.getM3rkIndex((int)component, (int)i)] = mbc.getValue();
            }
            if (cbc != null && cbc.getTypes()[8] != null) {
                mbc = cbc.getTypes()[8];
                System.out.println("applying boundary WEll pressure " + mbc.getValue());
                System.out.println("applying boundary CELL pressure (taking half or updated value) " + mbc.getPresfromQValue(this));
                Grid1D.geotherm[this.getM3rkIndex((int)component, (int)i)] = mbc.getPresfromQValue(this);
                Grid1D.inigeotherm[this.getM3rkIndex((int)component, (int)i)] = mbc.getPresfromQValue(this);
            }
            ++i;
        }
    }

    public void initializeValuesConstant() {
        int i = 0;
        while (i < this.getGpContainer().size()) {
            this.initializeValues(i, this.getGpContainer().getModelComponent(i).getDefaultvalue());
            ++i;
        }
    }

    public void initializeValues() {
        int i = 0;
        while (i < this.getGpContainer().size()) {
            this.initializeValues(i, this.getGpContainer().getModelComponent(i).getInitialvalues());
            ++i;
        }
    }

    protected void initializeValues(int component, double value) {
        int i = 0;
        while (i < this.getNx()) {
            Grid1D.geotherm[this.getM3rkIndex((int)component, (int)i)] = value;
            Grid1D.inigeotherm[this.getM3rkIndex((int)component, (int)i)] = value;
            ++i;
        }
    }

    protected void initializeValues(int component, Property p) {
        int i = 0;
        while (i < this.getNx()) {
            Grid1D.geotherm[this.getM3rkIndex((int)component, (int)i)] = p.getValue(i, 0, 0);
            Grid1D.inigeotherm[this.getM3rkIndex((int)component, (int)i)] = p.getValue(i, 0, 0);
            ++i;
        }
    }

    public double[] getR() {
        return this.r;
    }

    public void setR(double[] r) {
        this.r = r;
    }

    @Override
    public int getNx() {
        return this.nx;
    }

    @Override
    public double getOrx() {
        return this.orx;
    }

    public double[][] getValues() {
        return this.values;
    }

    public int getM3rkIndex(int component, int i) {
        return component * this.nx + i + 1;
    }

    public void output(int istart, int iend) {
        int i = istart;
        while (i < iend) {
            System.out.print(" " + this.values[0][i]);
            ++i;
        }
        System.out.println();
    }

    public void outputRadius(int istart, int iend) {
        int i = istart;
        while (i < iend) {
            System.out.print(" " + this.r[i]);
            ++i;
        }
        System.out.println();
    }

    public void output(int component, boolean initial, String label) {
        System.out.println("printing output values at time " + label);
        System.out.println("x, T");
        int i = 0;
        while (i < this.nx) {
            float v = 0.0f;
            v = initial ? (float)inigeotherm[this.getM3rkIndex(component, i)] : (float)geotherm[this.getM3rkIndex(component, i)];
            System.out.println(this.r[i] + " " + v);
            ++i;
        }
    }

    public double[] getVelx() {
        return this.velx;
    }

    public void updatePQ(double newtime) {
        double newtheta = 0.0;
        int i = 0;
        while (i < this.nx) {
            newtheta = this.getGpContainer().getModelComponent(0).getDefaultvalue() - geotherm[this.getM3rkIndex(0, i)];
            this.vinsome[i].updatePcQc(newtime, newtheta);
            ++i;
        }
    }

    public void outputVinsomeTemperature(int inode, int nz, double dz) {
        System.out.println("temperature profile for node :" + inode);
        System.out.println("z[m]  temp[C] ");
        double step = dz;
        double[] temp = this.vinsome[inode].getTemperature(inigeotherm[this.getM3rkIndex(0, inode)], nz, step);
        int i = 0;
        while (i < nz) {
            System.out.println((double)i * step + " " + temp[i]);
            ++i;
        }
    }

    public float[] getVinsomeTemperature(double rtarget, int nx, int nz, double dz) {
        int ioff = 0;
        while (ioff < nx - 1 && this.r[ioff + 1] < rtarget) {
            ++ioff;
        }
        if (ioff == nx - 1) {
            logger.error("serious error in determining the offset ");
            System.out.println("rtarget " + rtarget);
            float[] temperature = new float[nz];
            int i = 0;
            while (i < nz) {
                temperature[i] = (float)this.getGpContainer().getModelComponent(0).getDefaultvalue();
                ++i;
            }
            return temperature;
        }
        double w = Math.max(0.0, (rtarget - this.r[ioff]) / (this.r[ioff + 1] - this.r[ioff]));
        System.out.println("ioffset for rtarget " + rtarget + " " + ioff + " " + w);
        double inittemp = this.getGpContainer().getModelComponent(0).getDefaultvalue();
        double[] t1 = this.vinsome[ioff].getTemperature(inittemp, nz, dz);
        double[] t2 = this.vinsome[ioff + 1].getTemperature(inittemp, nz, dz);
        float[] temperature = new float[nz];
        int i = 0;
        while (i < nz) {
            temperature[i] = (float)(t1[i] * (1.0 - w) + t2[i] * w);
            ++i;
        }
        return temperature;
    }

    public void getTemperature(Grid g) {
        int i = 0;
        while (i < g.nx) {
            g.values[i] = this.getVinsomeTemperature(g.originx + (float)i * g.dx, g.nx, g.ny, g.dy);
            ++i;
        }
    }

    public void storeOldTemp() {
        if (this.oldtemp == null) {
            this.oldtemp = new double[this.nx];
        }
        int i = 0;
        while (i < this.nx) {
            this.oldtemp[i] = geotherm[this.getM3rkIndex(0, i)];
            ++i;
        }
    }
}

