/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.model.model2d;

import java.util.Random;
import tno.geoenergy.TnoWaterProperties;
import tno.geoenergy.fdintegration.integration.M3rk;
import tno.geoenergy.fdintegration.integration.Step;
import tno.geoenergy.fdintegration.model.CellBC;
import tno.geoenergy.fdintegration.model.FaultLine;
import tno.geoenergy.fdintegration.model.GAPropertiesPres;
import tno.geoenergy.fdintegration.model.GAPropertiesTemp;
import tno.geoenergy.fdintegration.model.ModelComponentContainer;
import tno.geoenergy.fdintegration.model.ModelRealisation;
import tno.geoenergy.fdintegration.model.WellPerforation;
import tno.geoenergy.fdintegration.model.model2d.FtoolGrid2DregularGATemp;
import tno.geoenergy.fdintegration.model.model2d.Grid2Dregular;
import tno.geoenergy.pcg.PCG3DBand;
import tno.geoenergy.properties.AquiferProperties;
import tno.geoenergy.properties.Property;
import tno.geoenergy.properties.PropertyFactory;

public class FtoolGrid2DregularGAPres
extends FtoolGrid2DregularGATemp {
    static final int NZ = 1;
    static final double RATIOPERMXY = 1.0;
    static final double RATIOPERMX = Math.sqrt(1.0);
    static final double RATIOPERMY = Math.sqrt(1.0);
    boolean useWPpressure = false;
    double[][] ranFactors = null;
    double[][] pres = null;
    public double[][] totalpres = null;
    CellBC[][] cellBC = null;
    GAPropertiesPres gpp;
    double c_pres = 1.0E-9;
    double[][] overc_pres = null;
    double[][] permx = null;
    double[][] permy = null;
    double[][] massbal = null;
    double[][] actnum = null;
    double[][] ng = null;
    double[][] conductancei = null;
    double[][] conductancej = null;
    double[][] porosity = null;
    double[][] h = null;
    double[][] topdepth = null;
    double[][] reftemp = null;
    double[][] temp = null;
    public double[][] initialtemp = null;
    public double[][] viscosity = null;
    public double[][] density = null;
    public double[][] rightHandSide = null;
    public double[][] densityPseudoSourcei = null;
    public double[][] densityPseudoSourcej = null;
    public double refDensity;
    static final double REFDENSITY = 1000.0;
    public double[][] depth;
    double[][] prespcg = null;
    boolean[][] modifiedpermeability = null;
    public double salinity;
    boolean update_viscosity = true;
    private int icomponent = 1;
    private int calcmode;
    private final double LMULTFD = 1.0;
    private final double LMULTPCG = 1.0;
    boolean firstpassafterprepf = false;
    boolean usepcg = false;

    public FtoolGrid2DregularGAPres(M3rk m3rk) {
        super(m3rk);
        this.id = "grid2dregular_pres";
        this.m3rk = m3rk;
    }

    private void scaleOvercpres() {
        double LMULT = 1.0;
        if (this.usepcg) {
            LMULT = 1.0;
        }
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                if (i == 0 || i == this.NX - 1) {
                    double[] dArray = this.overc_pres[i];
                    int n = j;
                    dArray[n] = dArray[n] * LMULT;
                }
                if (j == 0 || j == this.NY - 1) {
                    double[] dArray = this.overc_pres[i];
                    int n = j;
                    dArray[n] = dArray[n] * LMULT;
                }
                ++j;
            }
            ++i;
        }
    }

    private void scaleActnum(double d, int ii, int nX, int jj, int nY) {
        int i = ii;
        while (i < nX) {
            int j = jj;
            while (j < nY) {
                this.actnum[i][j] = d;
                ++j;
            }
            ++i;
        }
    }

    public double[][] getRanFactors() {
        int j;
        if (this.ranFactors == null) {
            this.ranFactors = new double[this.NX][this.NY];
        }
        Random ran = new Random();
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                this.ranFactors[i][j] = 1.0;
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i < this.NX - 1) {
            j = 1;
            while (j < this.NY - 1) {
                this.ranFactors[i][j] = Math.pow(10.0, ran.nextDouble() * 3.0 - 2.0);
                if (this.ranFactors[i][j] > 1.0) {
                    this.ranFactors[i][j] = 1.0;
                }
                ++j;
            }
            ++i;
        }
        return this.ranFactors;
    }

    private double[][] getRanFactors(double d, int ii, int nX, int jj, int nY) {
        if (this.ranFactors == null) {
            this.ranFactors = new double[this.NX][this.NY];
        }
        int i = ii;
        while (i < nX) {
            int j = jj;
            while (j < nY) {
                this.ranFactors[i][j] = d;
                ++j;
            }
            ++i;
        }
        return this.ranFactors;
    }

    @Override
    public void prepf() {
        int j;
        super.prepf();
        this.firstpassafterprepf = true;
        this.gpp = (GAPropertiesPres)this.m3rk.getGeom().getGpContainer().getModelComponent(this.icomponent);
        this.g = (Grid2Dregular)this.m3rk.getGeom();
        this.pres = this.g.getValues()[this.icomponent];
        this.cellBC = this.g.getBC(this.gpp);
        double switch_use_pcg = PropertyFactory.getProperty(AquiferProperties.ISWITCH_STEADYSTATE).getDefaultvalue();
        this.usepcg = switch_use_pcg > 0.001;
        System.out.println("USEPCG" + this.usepcg);
        double c_pres = PropertyFactory.getProperty(AquiferProperties.ISTORAGECAPACITY).getDefaultvalue();
        this.overc_pres = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_P_OVERC));
        this.porosity = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IPOROSITY));
        this.h = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ITHICKNESS));
        this.ng = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ING));
        this.totalpres = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_TOTALPRES));
        this.actnum = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IACTNUM));
        this.topdepth = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IAQUIFERDEPTH));
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                if (i == 0) {
                    this.topdepth[i][j] = this.topdepth[i + 1][j];
                }
                if (i == this.NX - 1) {
                    this.topdepth[i][j] = this.topdepth[i - 1][j];
                }
                if (j == 0) {
                    this.topdepth[i][j] = this.topdepth[i][j + 1];
                }
                if (j == this.NY - 1) {
                    this.topdepth[i][j] = this.topdepth[i][j - 1];
                }
                ++j;
            }
            ++i;
        }
        this.salinity = PropertyFactory.getProperty(AquiferProperties.IWATERSALINITY).getDefaultvalue();
        this.reftemp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE));
        this.initialtemp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IINITIALTEMPERATURE), this.initialtemp);
        this.viscosity = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IVISCOSITY));
        this.density = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IDENSITY));
        this.rightHandSide = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IRHS));
        this.densityPseudoSourcei = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IDENSITYPSEUDOSOURCEI));
        this.densityPseudoSourcej = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IDENSITYPSEUDOSOURCEJ));
        this.conductancei = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_P_CONDUCTANCEI));
        this.conductancej = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_P_CONDUCTANCEJ));
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                this.overc_pres[i][j] = 1.0 / (c_pres * this.porosity[i][j] * 100000.0 * this.h[i][j] * this.g.getDx() * this.g.getDy());
                ++j;
            }
            ++i;
        }
        this.permx = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYI));
        this.permy = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYJ));
        this.massbal = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IOUTPUTMASSBAL), this.massbal);
        if (this.modifiedpermeability == null) {
            this.modifiedpermeability = new boolean[this.NX][this.NY];
        }
        this.scaleOvercpres();
        if (this.g.isUseVelocities()) {
            this.velx = this.g.getVelx();
            this.vely = this.g.getVely();
        }
        this.setDepth();
        this.setRefDensity();
    }

    private void hardcodefaults() {
        FaultLine fl1 = new FaultLine(2000.0, 2000.0, 2000.0, 3000.0, 104000.0, 0.006);
        this.g.getFlContainer().addFaultLine(fl1);
        fl1 = new FaultLine(3000.0, 2000.0, 3000.0, 3000.0, 104000.0, 0.006);
        this.g.getFlContainer().addFaultLine(fl1);
    }

    private void hardcodefaultsFracture() {
        FaultLine fl1 = new FaultLine(1000.0, 0.0, 2500.0, 0.0, 10000.0, 1.0);
        this.g.getFlContainer().addFaultLine(fl1);
    }

    private void modifypermxy_forfaults(double[][] permx, double[][] permy, double[][] overcpres) {
        this.hardcodefaultsFracture();
        this.g.getFlContainer().initializeFaults(this.g);
        int[][] faults = this.g.getFaultCells();
        double faultPermeability = this.g.getFaultPermeability();
        int i = 0;
        while (i < this.NX - 1) {
            int j = 0;
            while (j < this.NY - 1) {
                FaultLine fl;
                if (faults[i][j] >= 0 && faults[i + 1][j] >= 0) {
                    fl = this.g.getFlContainer().getFaultLine(faults[i][j]);
                    faultPermeability = fl.getPermeability();
                    if (faultPermeability > 0.0) {
                        if (!this.modifiedpermeability[i][j]) {
                            double[] dArray = permx[i];
                            int n = j;
                            dArray[n] = dArray[n] + faultPermeability / this.g.getDy();
                            this.modifiedpermeability[i][j] = true;
                        }
                        double[] dArray = overcpres[i];
                        int n = j;
                        dArray[n] = dArray[n] * 1.0;
                    } else {
                        permy[i + 1][j] = 0.0;
                        permy[i][j] = 0.0;
                        permx[i + 1][j] = 0.0;
                        permx[i][j] = 0.0;
                    }
                }
                if (faults[i][j] >= 0 && faults[i][j + 1] >= 0) {
                    fl = this.g.getFlContainer().getFaultLine(faults[i][j]);
                    faultPermeability = fl.getPermeability();
                    if (faultPermeability > 0.0) {
                        if (!this.modifiedpermeability[i][j]) {
                            double[] dArray = permy[i];
                            int n = j;
                            dArray[n] = dArray[n] + faultPermeability / this.g.getDx();
                            this.modifiedpermeability[i][j] = true;
                        }
                        double[] dArray = overcpres[i];
                        int n = j;
                        dArray[n] = dArray[n] * 1.0;
                    } else {
                        permy[i + 1][j] = 0.0;
                        permy[i][j] = 0.0;
                        permx[i + 1][j] = 0.0;
                        permx[i][j] = 0.0;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private double getConduc(int i, int j, double[][] perm) {
        return this.ranFactors[i][j] * perm[i][j] * this.ng[i][j] * 100000.0 / (1.0132502738308866E15 * this.viscosity[i][j]);
    }

    public double[][] updateConducViscosity(double[] fy) {
        this.ranFactors = this.getRanFactors(1.0, 0, this.NX, 0, this.NY);
        boolean updateviscosity = PropertyFactory.getProperty(AquiferProperties.ISWITCH_PTS_VISCOSITY).getDefaultvalue() == 1.0;
        boolean updateDensity = PropertyFactory.getProperty(AquiferProperties.ISWITCH_PTS_DENSITY).getDefaultvalue() == 1.0;
        this.getPres(fy);
        this.getTemp(fy);
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                double depth = this.topdepth[i][j] + 0.5 * this.h[i][j];
                int ncount = this.g.getM3rkIndex(this.icomponent, i, j);
                this.totalpres[i][j] = depth * 0.1 + fy[ncount];
                if (updateviscosity) {
                    double visc;
                    this.viscosity[i][j] = visc = TnoWaterProperties.Viscosity(this.totalpres[i][j] * 100000.0, this.reftemp[i][j], this.salinity * 1.0E-6);
                }
                if (updateDensity) {
                    double dens;
                    this.density[i][j] = dens = TnoWaterProperties.Density(this.totalpres[i][j] * 100000.0, this.temp[i][j], this.salinity * 1.0E-6);
                }
                ++j;
            }
            ++i;
        }
        double LMULT = 1.0;
        if (this.usepcg) {
            LMULT = 1.0;
        }
        int i2 = 0;
        while (i2 < this.NX) {
            int j = 0;
            while (j < this.NY) {
                double c2;
                double kh2;
                double dl2;
                double dl1;
                double kh1;
                double conduc;
                boolean ok = this.checkConnect(i2, j, i2 + 1, j);
                if (ok) {
                    conduc = this.getConduc(i2, j, this.permx);
                    kh1 = this.h[i2][j] * conduc;
                    dl1 = this.g.getDx();
                    if (i2 == 0 || i2 == this.NX - 1) {
                        dl1 *= LMULT;
                    }
                    dl2 = this.g.getDx();
                    if (i2 < this.NX - 1) {
                        conduc = this.getConduc(i2 + 1, j, this.permx);
                        kh2 = this.h[i2 + 1][j] * conduc;
                        if (i2 == this.NX - 2) {
                            dl2 *= LMULT;
                        }
                    } else {
                        kh2 = kh1;
                    }
                    this.conductancei[i2][j] = c2 = 2.0 * this.g.getDy() * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                } else {
                    this.conductancei[i2][j] = 0.0;
                }
                ok = this.checkConnect(i2, j, i2, j + 1);
                if (ok) {
                    conduc = this.getConduc(i2, j, this.permy);
                    kh1 = this.h[i2][j] * conduc;
                    dl1 = this.g.getDy();
                    if (j == 0 || j == this.NY - 1) {
                        dl1 *= LMULT;
                    }
                    dl2 = this.g.getDy();
                    if (j < this.NY - 1) {
                        conduc = this.getConduc(i2, j + 1, this.permy);
                        kh2 = this.h[i2][j + 1] * conduc;
                        if (i2 == this.NY - 2) {
                            dl2 *= LMULT;
                        }
                    } else {
                        kh2 = kh1;
                    }
                    this.conductancej[i2][j] = c2 = 2.0 * this.g.getDx() * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                } else {
                    this.conductancej[i2][j] = 0.0;
                }
                ++j;
            }
            ++i2;
        }
        if (this.usepcg) {
            this.prespcg = this.pcgpres();
        }
        return this.prespcg;
    }

    private boolean checkConnect(int i, int j, int i2, int j2) {
        if (i2 > this.NX - 1 || j2 > this.NY - 1) {
            return this.actnum[i][j] > 0.0;
        }
        return this.actnum[i][j] > 0.0 && this.actnum[i2][j2] > 0.0;
    }

    private void getPres(double[] fy) {
        if (this.prespcg == null) {
            this.prespcg = new double[this.NX][this.NY];
        }
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                this.prespcg[i][j] = fy[this.g.getM3rkIndex(this.icomponent, i, j)];
                ++j;
            }
            ++i;
        }
    }

    private void getTemp(double[] fy) {
        if (this.temp == null) {
            this.temp = new double[this.NX][this.NY];
        }
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                this.temp[i][j] = fy[this.g.getM3rkIndex(0, i, j)];
                ++j;
            }
            ++i;
        }
    }

    private void setRefDensity() {
        this.refDensity = 1000.0;
    }

    private void setDepth() {
        if (this.depth == null) {
            this.depth = new double[this.NX][this.NY];
        }
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                this.depth[i][j] = this.topdepth[i][j] + 0.5 * this.h[i][j];
                ++j;
            }
            ++i;
        }
    }

    private double[][] pcgpres() {
        boolean USECONSTANTPRES;
        PCG3DBand pcg = new PCG3DBand();
        PCG3DBand.DIAGSCALE = 1.0;
        PCG3DBand.DIRICHMULT = 1.0;
        double UNKNOWN = 1.2345E38;
        pcg.initGeometryProp(this.g.getNx(), this.g.getNy(), this.g.getDx(), this.g.getDy(), this.g.getOrx(), this.g.getOry(), this.conductancei, this.conductancej, UNKNOWN, this.refDensity, this.topdepth, this.h, this.actnum, this.overc_pres, this.density, this.densityPseudoSourcei, this.densityPseudoSourcej, this.rightHandSide);
        boolean bl = USECONSTANTPRES = PropertyFactory.getProperty(AquiferProperties.ISWITCH_NOFLOWBC).getDefaultvalue() == 0.0;
        if (USECONSTANTPRES) {
            pcg.initializeValPressure(1.0);
        } else {
            pcg.initializeValPressure2(1.0);
        }
        pcg.setDefaultvalue(0.0);
        boolean checkinactive = this.g.getWpContainer().checkInactive();
        if (!checkinactive) {
            this.calcmode = PropertyFactory.getProperty(AquiferProperties.ISWITCH_PRESSURE_CALC).getDefaultvalue() == 0.0 ? 2 : 1;
            this.g.getWpContainer().setDischargeMode(this.calcmode);
        }
        this.gpp.getBcContainer().clear();
        this.g.getWpContainer().initializeWellBC(this.gpp, 1);
        pcg.initBCPressure(this.gpp.getBcContainer());
        pcg.initializeDirichlet(null, USECONSTANTPRES);
        System.out.println(" number of equations after setting dirichlet :" + this.g.getNx());
        pcg.initializeDefaultValue();
        pcg.setDefaultvalue(0.0);
        pcg.setupstartvalue(this.prespcg);
        pcg.doPCG(1000, 1);
        System.out.println("ready");
        double[][] p = pcg.getValues(0, false);
        double[][][] prespcg = null;
        prespcg = pcg.getValues(false, prespcg);
        pcg.getCalculatedWellData(this.gpp.getBcContainer(), this.g.getWpContainer(), prespcg);
        pcg.get2DDensityPseudoSource(this.densityPseudoSourcei, this.densityPseudoSourcej);
        System.out.println("ready");
        return p;
    }

    public void iterateVelSteadyState() {
        this.velx = this.g.getVelx();
        this.vely = this.g.getVely();
        int i = 1;
        while (i < this.NX - 1) {
            int j = 1;
            while (j < this.NY - 1) {
                double txb = this.pres[i - 1][j];
                double tyb = this.pres[i][j - 1];
                double txf = this.pres[i + 1][j];
                double tyf = this.pres[i][j + 1];
                this.velx[i][j] = -0.5 * this.OVERDX * this.getConduc(i, j, this.permx) * (txf - txb) * (1.0 / (this.porosity[i][j] * this.ng[i][j]));
                this.vely[i][j] = -0.5 * this.OVERDY * this.getConduc(i, j, this.permy) * (tyf - tyb) * (1.0 / (this.porosity[i][j] * this.ng[i][j]));
                ++j;
            }
            ++i;
        }
        this.g.setVelx(this.velx);
        this.g.setVely(this.vely);
    }

    private void updatevel(double[] fy) {
        this.velx = this.g.getVelx();
        this.vely = this.g.getVely();
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                boolean ok;
                this.velx[i][j] = 0.0;
                this.vely[i][j] = 0.0;
                this.massbal[i][j] = 0.0;
                boolean bl = ok = this.actnum[i][j] > 0.0;
                if (ok) {
                    double tyf;
                    double txf;
                    double t;
                    if (!this.usepcg) {
                        t = fy[this.g.getM3rkIndex(this.icomponent, i, j)];
                        txf = i < this.NX - 1 ? fy[this.g.getM3rkIndex(this.icomponent, i + 1, j)] : t;
                        tyf = j < this.NY - 1 ? fy[this.g.getM3rkIndex(this.icomponent, i, j + 1)] : t;
                    } else {
                        txf = tyf = (t = this.prespcg[i][j]);
                        double txb = t;
                        double tyb = t;
                        if (i < this.NX - 1) {
                            txf = this.prespcg[i + 1][j];
                            double[] dArray = this.massbal[i];
                            int n = j;
                            dArray[n] = dArray[n] + this.conductancei[i][j] * (txf - this.densityPseudoSourcei[i][j] - t);
                        }
                        if (j < this.NY - 1) {
                            tyf = this.prespcg[i][j + 1];
                            double[] dArray = this.massbal[i];
                            int n = j;
                            dArray[n] = dArray[n] + this.conductancej[i][j] * (tyf - this.densityPseudoSourcej[i][j] - t);
                        }
                        if (i > 0) {
                            txb = this.prespcg[i - 1][j];
                            double[] dArray = this.massbal[i];
                            int n = j;
                            dArray[n] = dArray[n] + this.conductancei[i - 1][j] * (txb + this.densityPseudoSourcei[i - 1][j] - t);
                        }
                        if (j > 0) {
                            tyb = this.prespcg[i][j - 1];
                            double[] dArray = this.massbal[i];
                            int n = j;
                            dArray[n] = dArray[n] + this.conductancej[i][j - 1] * (tyb + this.densityPseudoSourcej[i][j - 1] - t);
                        }
                        double[] dArray = this.massbal[i];
                        int n = j;
                        dArray[n] = dArray[n] * 3600.0;
                    }
                    this.velx[i][j] = 0.0;
                    if (ok) {
                        this.velx[i][j] = -(this.conductancei[i][j] * (txf - this.densityPseudoSourcei[i][j] - t)) / (this.DY * this.porosity[i][j] * this.ng[i][j]);
                    }
                    this.vely[i][j] = 0.0;
                    if (ok) {
                        this.vely[i][j] = -(this.conductancej[i][j] * (tyf - this.densityPseudoSourcej[i][j] - t)) / (this.DX * this.porosity[i][j] * this.ng[i][j]);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.g.setVelx(this.velx);
        this.g.setVely(this.vely);
    }

    @Override
    public void f(double[] fy) {
        int ncount;
        int j;
        int i;
        if (this.firstpassafterprepf) {
            super.updateModelledTemperature(fy);
            this.prespcg = this.updateConducViscosity(fy);
            this.firstpassafterprepf = false;
        }
        this.updatevel(fy);
        super.f(fy);
        int i2 = 0;
        while (i2 < this.NX) {
            int j2 = 0;
            while (j2 < this.NY) {
                this.pres[i2][j2] = 0.0;
                ++j2;
            }
            ++i2;
        }
        double rxf = 1.0;
        double rxb = 1.0;
        double ryf = 1.0;
        double ryb = 1.0;
        int[][] faults = this.g.getFaultCells();
        CellBC cbc = null;
        if (!this.usepcg) {
            i = 0;
            while (i < this.NX) {
                j = 0;
                while (j < this.NY) {
                    cbc = this.cellBC[i][j];
                    ncount = this.g.getM3rkIndex(this.icomponent, i, j);
                    double t = fy[ncount];
                    double txf = this.gpp.getDefaultvalue();
                    double txb = this.gpp.getDefaultvalue();
                    double tyf = this.gpp.getDefaultvalue();
                    double tyb = this.gpp.getDefaultvalue();
                    int ib = Math.max(0, i - 1);
                    int jb = Math.max(0, j - 1);
                    if (i != 0) {
                        txb = fy[this.g.getM3rkIndex(this.icomponent, i - 1, j)];
                    }
                    if (j != 0) {
                        tyb = fy[this.g.getM3rkIndex(this.icomponent, i, j - 1)];
                    }
                    if (i != this.NX - 1) {
                        txf = fy[this.g.getM3rkIndex(this.icomponent, i + 1, j)];
                    }
                    if (j != this.NY - 1) {
                        tyf = fy[this.g.getM3rkIndex(this.icomponent, i, j + 1)];
                    }
                    if (cbc != null) {
                        if (cbc.getTypes()[0] != null) {
                            this.pres[i][j] = 0.0;
                        } else {
                            if (cbc.getTypes()[1] != null) {
                                txb = t + cbc.getTypes()[1].getValue() * this.DX / (RATIOPERMX * this.getConduc(i, j, this.permx) * rxb);
                            }
                            if (cbc.getTypes()[3] != null) {
                                tyb = t + cbc.getTypes()[3].getValue() * this.DY / (RATIOPERMY * this.getConduc(i, j, this.permy) * ryb);
                            }
                            if (cbc.getTypes()[2] != null) {
                                txf = t + cbc.getTypes()[2].getValue() * this.DX / (RATIOPERMX * this.getConduc(i, j, this.permx) * rxf);
                            }
                            if (cbc.getTypes()[4] != null) {
                                tyf = t + cbc.getTypes()[4].getValue() * this.DY / (RATIOPERMY * this.getConduc(i, j, this.permy) * ryf);
                            }
                            this.pres[i][j] = this.overc_pres[i][j] * (this.conductancei[i][j] * (txf - t) - this.conductancei[ib][j] * (t - txb) + this.conductancej[i][j] * (tyf - t) - this.conductancej[i][jb] * (t - tyb));
                            if (cbc.getTypes()[7] != null) {
                                double q = cbc.getTypes()[7].getValue();
                                double[] dArray = this.pres[i];
                                int n = j;
                                dArray[n] = dArray[n] + this.overc_pres[i][j] * (q *= this.h[i][j] * this.g.getDx() * this.g.getDy());
                            }
                            if (cbc.getTypes()[8] != null) {
                                this.pres[i][j] = 0.0;
                            }
                        }
                    } else {
                        this.pres[i][j] = this.overc_pres[i][j] * (this.conductancei[i][j] * (txf - t) - this.conductancei[ib][j] * (t - txb) + this.conductancej[i][j] * (tyf - t) - this.conductancej[i][jb] * (t - tyb));
                    }
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                ncount = this.g.getM3rkIndex(this.icomponent, i, j);
                M3rk.ty[ncount] = 0.0;
                fy[ncount] = 0.0;
                ++j;
            }
            ++i;
        }
        double maxdt = 0.0;
        int i3 = 0;
        while (i3 < this.NX) {
            int j3 = 0;
            while (j3 < this.NY) {
                if (Math.abs(this.pres[i3][j3]) > maxdt) {
                    maxdt = Math.abs(this.pres[i3][j3]);
                }
                ncount = this.g.getM3rkIndex(this.icomponent, i3, j3);
                fy[ncount] = this.pres[i3][j3];
                M3rk.ty[ncount] = fy[ncount];
                ++j3;
            }
            ++i3;
        }
        if (M3rk.info[4] % 100 == 0) {
            System.out.println(" f(   PRESSURE)  + time " + this.m3rk.x / this.m3rk.fys + "  " + fy.length + "  " + this.m3rk.getGeom().maxnodes + "   max DTdt : " + maxdt);
            if (Double.isNaN(this.m3rk.x)) {
                System.out.println("shoould not reach this");
            }
        }
    }

    @Override
    public void updategeom(double timepres, double dtsec) {
    }

    @Override
    public void updategeomm3rk(double timepres, double dtsec) {
    }

    @Override
    public void finfinish() {
        double[][] modelpres = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELPRESSURE));
        if (this.usepcg) {
            int j;
            int i = 0;
            while (i < this.NX) {
                j = 0;
                while (j < this.NY) {
                    int ncount = this.g.getM3rkIndex(this.icomponent, i, j);
                    this.m3rk.getGeom();
                    ModelRealisation.geotherm[ncount] = this.prespcg[i][j];
                    modelpres[i][j] = this.prespcg[i][j];
                    ++j;
                }
                ++i;
            }
            i = this.NX - 1;
            while (i >= 0) {
                j = this.NY - 1;
                while (j >= 0) {
                    if (i < this.NX - 1) {
                        this.velx[i + 1][j] = 0.5 * (this.velx[i + 1][j] + this.velx[i][j]) / this.h[i][j];
                    }
                    if (j < this.NY - 1) {
                        this.vely[i][j + 1] = 0.5 * (this.vely[i][j + 1] + this.vely[i][j]) / this.h[i][j];
                    }
                    --j;
                }
                --i;
            }
        }
    }

    public static void main(String[] args) {
        M3rk m = new M3rk(0.001);
        FtoolGrid2DregularGAPres ftool = new FtoolGrid2DregularGAPres(m);
        String dir = "C:\\Users\\Public\\wees\\data\\tests\\aquifer\\";
        double temperature = 57.6;
        double temperatureinjection = 30.1;
        double starttime = 0.0;
        double initialpressure = 0.0;
        AquiferProperties.instantiateProperties(2);
        Property pmodel = PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE);
        pmodel.setDefaultvalue(temperature);
        Property pinitial = PropertyFactory.getProperty(AquiferProperties.IINITIALTEMPERATURE);
        pinitial.setDefaultvalue(temperature);
        GAPropertiesTemp gp = new GAPropertiesTemp(pmodel, pinitial);
        pmodel = PropertyFactory.getProperty(AquiferProperties.IMODELPRESSURE);
        pmodel.setDefaultvalue(0.0);
        pinitial = PropertyFactory.getProperty(AquiferProperties.IINITIALPRESSURE);
        pinitial.setDefaultvalue(0.0);
        double permeability = 500.0;
        Property perm = PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYI);
        perm.setDefaultvalue(permeability);
        perm = PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYJ);
        perm.setDefaultvalue(permeability);
        perm = PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYK);
        perm.setDefaultvalue(permeability);
        GAPropertiesPres gpp = new GAPropertiesPres(pmodel, pinitial);
        ModelComponentContainer mcc = new ModelComponentContainer();
        mcc.add(gp);
        mcc.add(gpp);
        double thickness = 70.0;
        Grid2Dregular g = new Grid2Dregular(mcc, starttime, 0.0, 0.0, 100, 100, 50.0, 50.0, 70.0);
        PropertyFactory.updateGeometry(g);
        g.initializeValues();
        double volrate = 137.5;
        double welldiam = 8.0;
        WellPerforation wp1 = new WellPerforation(1500.0, 2500.0, volrate / 3600.0, temperatureinjection, 60.0, 0.5 * welldiam * 2.56 * 0.01, g);
        WellPerforation wp2 = new WellPerforation(3500.0, 2500.0, -volrate / 3600.0, -1.0, -40.0, 0.5 * welldiam * 2.56 * 0.01, g);
        WellPerforation wp3 = new WellPerforation(3800.0, 2500.0, volrate / 3600.0, temperatureinjection, 60.0, 0.5 * welldiam * 2.56 * 0.01, g);
        WellPerforation wp4 = new WellPerforation(2500.0, 2200.0, -volrate / 3600.0, -1.0, -40.0, 0.5 * welldiam * 2.56 * 0.01, g);
        g.addWellPerforation(wp1);
        g.addWellPerforation(wp2);
        g.getWpContainer().initializeWellBC(gp, g.getNz());
        g.getWpContainer().initializeWellBC(gpp, g.getNz());
        g.calculateVelfromWP(1);
        g.initializeBC();
        g.setUseVelocities(true);
        m.addftool(ftool);
        Step s = new Step();
        int it = 0;
        while (it <= 50) {
            s.update(g, g.timepres, it, it, ftool.id);
            m.dostepForward(s, g);
            System.out.println("PRES at time : " + it);
            g.output(0, it == 0, String.valueOf(dir) + "temp" + it, 0);
            g.output(ftool.icomponent, it == 0, String.valueOf(dir) + "pres" + it, 0);
            g.outputWells(mcc.size(), it == 0, it, ftool.viscosity, ftool.salinity, ftool.totalpres);
            PropertyFactory.outputGrid(PropertyFactory.getProperty(AquiferProperties.IVISCOSITY), dir, "viscosity" + it, 0);
            PropertyFactory.outputGrid(PropertyFactory.getProperty(AquiferProperties.ICALC_P_CONDUCTANCEI), dir, "conductancei" + it, 0);
            it += 5;
        }
        g.outputWells2File(dir);
        double depth = PropertyFactory.getProperty(AquiferProperties.IAQUIFERDEPTH).getDefaultvalue() + 0.5 * thickness;
        double presProp = depth * 9.8;
        double salinity = PropertyFactory.getProperty(AquiferProperties.IWATERSALINITY).getDefaultvalue();
        double visc = TnoWaterProperties.Viscosity(presProp * 100000.0, temperature, salinity * 1.0E-6);
        System.out.println("--------------------------");
        System.out.println("production pressure[bar], salinity[ppm], visocity [Poise] : " + presProp + ", " + salinity + ", " + visc);
        visc = TnoWaterProperties.Viscosity(presProp * 100000.0, temperatureinjection, salinity * 1.0E-6);
        System.out.println("injection pressure[bar], salinity[ppm], visocity [Poise] : " + presProp + ", " + salinity + ", " + visc);
        System.out.println("--------------------------");
    }
}

