/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.model.model2d;

import tno.geoenergy.TnoWaterProperties;
import tno.geoenergy.axisymetric.FractureProperties;
import tno.geoenergy.fdintegration.integration.Ftool;
import tno.geoenergy.fdintegration.integration.M3rk;
import tno.geoenergy.fdintegration.integration.Step;
import tno.geoenergy.fdintegration.model.CellBC;
import tno.geoenergy.fdintegration.model.FaultLine;
import tno.geoenergy.fdintegration.model.GAPropertiesTemp;
import tno.geoenergy.fdintegration.model.ModelComponentContainer;
import tno.geoenergy.fdintegration.model.WellPerforation;
import tno.geoenergy.fdintegration.model.model2d.Grid2Dregular;
import tno.geoenergy.properties.AquiferProperties;
import tno.geoenergy.properties.Property;
import tno.geoenergy.properties.PropertyFactory;

public class FtoolGrid2DregularGATemp
extends Ftool {
    static final int NZ = 1;
    public static double INFINITE_MINTIME = 500.0;
    static final double MULTPERMXYLOCAL = 1.0;
    static final int jpermlocalmin = 10;
    static final int jpermlocalmax = 110;
    static final int ipermlocalmin = 43;
    static final int ipermlocalmax = 43;
    private static final double COOLINGWALLTEMPTRESHOLD = 5.0;
    private GAPropertiesTemp gp = null;
    Grid2Dregular g = null;
    int NX = 0;
    int NY = 0;
    double DX = 0.0;
    double DY = 0.0;
    double DX2 = 0.0;
    double DY2 = 0.0;
    double OVERDX = 0.0;
    double OVERDX2 = 0.0;
    double OVERDY = 0.0;
    double OVERDY2 = 0.0;
    private double[][] temp = null;
    double[][] velx = null;
    double[][] vely = null;
    private CellBC[][] cellBC = null;
    private double[][] initialtemperature = null;
    private double[][] conduc = null;
    private double[][] conductancei = null;
    private double[][] conductancej = null;
    private static double[][] velxscale = null;
    private static double[][] velyscale = null;
    double[][] porosity;
    double[][] c;
    double[][] overc;
    double[][] ratiowaterrhocp;
    double[][] h;
    double[][] ng;
    double[][] topdepth;
    private int icomponent = 0;
    boolean firstpassafterprepf = false;
    double basetime = 0.0;
    boolean includewall = false;
    double rockdiffusivity = 1.0E-6;
    double rockconductivity = 2.0;

    public FtoolGrid2DregularGATemp(M3rk m3rk) {
        super(m3rk);
        this.id = "grid2dregular_temp";
        this.m3rk = m3rk;
    }

    private void modify_forfaults(double[][] overc, double[][] velxscale, double[][] velyscale) {
        int[][] faults = this.g.getFaultCells();
        double faultPermeability = this.g.getFaultPermeability();
        double faultThickness = this.g.getFaultThickness();
        int i = 0;
        while (i < this.NX - 1) {
            int j = 0;
            while (j < this.NY - 1) {
                FaultLine fl;
                velxscale[i][j] = 1.0;
                velyscale[i][j] = 1.0;
                velxscale[i + 1][j] = 1.0;
                velyscale[i + 1][j] = 1.0;
                if (faults[i][j] >= 0 && faults[i + 1][j] >= 0) {
                    fl = this.g.getFlContainer().getFaultLine(faults[i][j]);
                    faultPermeability = fl.getPermeability();
                    faultThickness = fl.getThickness();
                    if (faultPermeability > 0.0) {
                        velxscale[i][j] = 1.0;
                        double[] dArray = overc[i];
                        int n = j;
                        dArray[n] = dArray[n] * (this.g.getDy() / faultThickness);
                    }
                }
                if (faults[i][j] >= 0 && faults[i][j + 1] >= 0) {
                    fl = this.g.getFlContainer().getFaultLine(faults[i][j]);
                    faultPermeability = fl.getPermeability();
                    faultThickness = fl.getThickness();
                    if (faultPermeability > 0.0) {
                        velyscale[i][j] = 1.0;
                        double[] dArray = overc[i];
                        int n = j;
                        dArray[n] = dArray[n] * (this.g.getDx() / faultThickness);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void prepf() {
        this.gp = (GAPropertiesTemp)this.m3rk.getGeom().getGpContainer().getModelComponent(this.icomponent);
        this.g = (Grid2Dregular)this.m3rk.getGeom();
        this.temp = this.g.getValues()[0];
        this.cellBC = this.g.getBC(this.gp);
        this.NY = this.g.getNy();
        this.NX = this.g.getNx();
        this.DY = this.g.getDy();
        this.DX = this.g.getDx();
        this.DX2 = this.DX * this.DX;
        this.DY2 = this.DY * this.DY;
        this.OVERDX = 1.0 / this.DX;
        this.OVERDX2 = 1.0 / this.DX2;
        this.OVERDY = 1.0 / this.DY;
        this.OVERDY2 = 1.0 / this.DY2;
        this.c = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_T_C));
        this.overc = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_T_OVERC));
        this.ratiowaterrhocp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_T_RATIORHOCP));
        this.porosity = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IPOROSITY));
        this.h = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ITHICKNESS));
        this.ng = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ING));
        this.topdepth = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IAQUIFERDEPTH));
        this.initialtemperature = PropertyFactory.getValues(this.gp.getInitialvalues());
        double rhorock = PropertyFactory.getProperty(AquiferProperties.IROCKDENSITY).getDefaultvalue();
        double crock = PropertyFactory.getProperty(AquiferProperties.IROCKHEATCAPACITY).getDefaultvalue();
        double rhocprock = rhorock * crock;
        double salinity = PropertyFactory.getProperty(AquiferProperties.IWATERSALINITY).getDefaultvalue();
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                double pres = (this.topdepth[i][j] + 0.5 * this.h[i][j]) * 0.1;
                double rhowater = TnoWaterProperties.Density(pres * 100000.0, this.temp[i][j], salinity * 1.0E-6);
                double cwater = TnoWaterProperties.HeatCapacity(pres * 100000.0, this.temp[i][j], salinity * 1.0E-6);
                this.c[i][j] = this.porosity[i][j] * rhowater * cwater + (1.0 - this.porosity[i][j]) * rhocprock;
                if (i == 0 && j == 0) {
                    System.out.println("crock " + crock);
                    System.out.println("rhowater " + rhowater);
                    System.out.println("cwater" + cwater);
                    System.out.println("c[0][0] = " + this.c[i][j]);
                }
                this.overc[i][j] = 1.0 / (this.c[i][j] * this.h[i][j] * this.g.getDx() * this.g.getDy());
                this.ratiowaterrhocp[i][j] = rhowater * cwater / this.c[i][j];
                ++j;
            }
            ++i;
        }
        this.conduc = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_T_CONDUC));
        this.conductancei = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_T_CONDUCTANCEI));
        this.conductancej = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_T_CONDUCTANCEJ));
        double rockconduc = PropertyFactory.getProperty(AquiferProperties.IROCKCONDUCTIVITY).getDefaultvalue();
        double waterconduc = PropertyFactory.getProperty(AquiferProperties.IWATERCONDUCTIVITY).getDefaultvalue();
        if (velxscale == null || velxscale.length != this.NX || velxscale[0].length != this.NY) {
            velxscale = new double[this.NX][this.NY];
            velyscale = new double[this.NX][this.NY];
        }
        this.modify_forfaults(this.overc, velxscale, velyscale);
        this.rockconductivity = 0.0;
        int i2 = 0;
        while (i2 < this.NX) {
            int j = 0;
            while (j < this.NY) {
                this.conduc[i2][j] = TnoWaterProperties.getMixedLithologyConductivity(waterconduc, rockconduc, this.porosity[i2][j]);
                this.rockconductivity += this.conduc[i2][j];
                ++j;
            }
            ++i2;
        }
        this.rockconductivity /= (double)(this.NX * this.NY);
        System.out.println("conductivity of rock wall " + this.rockconductivity);
        this.basetime = this.g.timepres * 3.15576E7;
        this.includewall = Math.abs(PropertyFactory.getProperty(FractureProperties.ISWITCH_INCLUDEWALL).getDefaultvalue() - 1.0) < 0.001;
        this.rockdiffusivity = this.rockconductivity / rhocprock;
        double length = Math.sqrt(this.rockdiffusivity * Math.max(this.basetime, INFINITE_MINTIME) / Math.PI);
        double q = 0.5 * this.rockconductivity * 50.0 / length;
        if (this.includewall) {
            System.out.println("time [days] " + this.basetime / 86400.0 + " infinite length " + length + " hf " + q);
        }
        int i3 = 0;
        while (i3 < this.NX) {
            int j = 0;
            while (j < this.NY) {
                double c2;
                double kh1 = this.h[i3][j] * this.conduc[i3][j];
                double dl1 = this.g.getDx();
                double kh2 = i3 < this.NX - 1 ? this.h[i3 + 1][j] * this.conduc[i3 + 1][j] : kh1;
                double dl2 = this.g.getDx();
                this.conductancei[i3][j] = c2 = 2.0 * this.g.getDy() * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                kh1 = this.h[i3][j] * this.conduc[i3][j];
                dl1 = this.g.getDy();
                kh2 = j < this.NY - 1 ? this.h[i3][j + 1] * this.conduc[i3][j + 1] : kh1;
                dl2 = this.g.getDy();
                this.conductancej[i3][j] = c2 = 2.0 * this.g.getDx() * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                ++j;
            }
            ++i3;
        }
        if (this.g.isUseVelocities()) {
            this.velx = this.g.getVelx();
            this.vely = this.g.getVely();
        }
        System.out.println("ratiowaterrhocp " + this.ratiowaterrhocp);
        this.firstpassafterprepf = true;
    }

    protected void updateModelledTemperature(double[] fy) {
        double[][] reftemp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE));
        double[][] diftemp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELDIFTEMPERATURE));
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                double t;
                reftemp[i][j] = t = fy[this.g.getM3rkIndex(this.icomponent, i, j)];
                diftemp[i][j] = reftemp[i][j] - this.initialtemperature[i][j];
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void f(double[] fy) {
        int ncount;
        int j;
        double inf_time = Math.max(this.basetime + this.m3rk.x, INFINITE_MINTIME);
        double length_infinite = Math.pow(this.rockdiffusivity * inf_time / Math.PI, 0.5);
        if (this.firstpassafterprepf) {
            this.updateModelledTemperature(fy);
            this.firstpassafterprepf = false;
        }
        int i = 0;
        while (i < this.NX) {
            int j2 = 0;
            while (j2 < this.NY) {
                this.temp[i][j2] = 0.0;
                ++j2;
            }
            ++i;
        }
        if (this.g.isUseVelocities()) {
            this.velx = this.g.getVelx();
            this.vely = this.g.getVely();
        }
        int i2 = 1;
        while (i2 < this.NX - 1) {
            j = 1;
            while (j < this.NY - 1) {
                CellBC cbc = this.cellBC[i2][j];
                ncount = this.g.getM3rkIndex(this.icomponent, i2, j);
                double t = fy[ncount];
                double txf = fy[this.g.getM3rkIndex(this.icomponent, i2 + 1, j)];
                double txb = fy[this.g.getM3rkIndex(this.icomponent, i2 - 1, j)];
                double tyf = fy[this.g.getM3rkIndex(this.icomponent, i2, j + 1)];
                double tyb = fy[this.g.getM3rkIndex(this.icomponent, i2, j - 1)];
                if (i2 == this.NX - 2) {
                    txf = this.initialtemperature[i2 + 1][j];
                }
                if (i2 == 1) {
                    txb = this.initialtemperature[i2 - 1][j];
                }
                if (j == this.NY - 2) {
                    tyf = this.initialtemperature[i2][j + 1];
                }
                if (j == 1) {
                    tyb = this.initialtemperature[i2][j - 1];
                }
                if (cbc != null && cbc.getTypes()[0] != null) {
                    this.temp[i2][j] = 0.0;
                } else {
                    int imin = Math.max(0, i2 - 1);
                    int jmin = Math.max(0, j - 1);
                    this.temp[i2][j] = this.overc[i2][j] * (this.conductancei[i2][j] * (txf - t) - this.conductancei[imin][j] * (t - txb) + this.conductancej[i2][j] * (tyf - t) - this.conductancej[i2][jmin] * (t - tyb));
                    if (this.g.isUseVelocities()) {
                        if (txb < 50.0) {
                            int ikj = 0;
                            ikj = 2;
                        }
                        double facx = 0.5;
                        double facy = 0.5;
                        if (Math.abs(this.velx[i2][j]) > 1.0E-15) {
                            if (this.velx[i2 - 1][j] / this.velx[i2][j] < 0.0) {
                                facx = 1.0;
                            }
                        } else {
                            facx = 1.0;
                        }
                        if (Math.abs(this.vely[i2][j]) > 1.0E-15) {
                            if (this.vely[i2 - 1][j] / this.vely[i2][j] < 0.0) {
                                facy = 1.0;
                            }
                        } else {
                            facy = 1.0;
                        }
                        if (i2 > 0) {
                            if (this.velx[i2 - 1][j] > 0.0) {
                                double[] dArray = this.temp[i2];
                                int n = j;
                                dArray[n] = dArray[n] + -facx * (t - txb) * this.velx[i2 - 1][j] * velxscale[i2][j] * this.porosity[i2][j] * this.ng[i2][j] * this.ratiowaterrhocp[i2][j] * this.OVERDX / this.h[i2][j];
                            } else {
                                double[] dArray = this.temp[i2];
                                int n = j;
                                dArray[n] = dArray[n] + -facx * (txf - t) * this.velx[i2 - 1][j] * velxscale[i2][j] * this.porosity[i2][j] * this.ng[i2][j] * this.ratiowaterrhocp[i2][j] * this.OVERDX / this.h[i2][j];
                            }
                        }
                        if (j > 0) {
                            if (this.vely[i2][j - 1] > 0.0) {
                                double[] dArray = this.temp[i2];
                                int n = j;
                                dArray[n] = dArray[n] + -facy * (t - tyb) * this.vely[i2][j - 1] * velyscale[i2][j] * this.porosity[i2][j] * this.ng[i2][j] * this.ratiowaterrhocp[i2][j] * this.OVERDY / this.h[i2][j];
                            } else {
                                double[] dArray = this.temp[i2];
                                int n = j;
                                dArray[n] = dArray[n] + -facy * (tyf - t) * this.vely[i2][j - 1] * velyscale[i2][j] * this.porosity[i2][j] * this.ng[i2][j] * this.ratiowaterrhocp[i2][j] * this.OVERDY / this.h[i2][j];
                            }
                        }
                        if (this.velx[i2][j] > 0.0) {
                            double[] dArray = this.temp[i2];
                            int n = j;
                            dArray[n] = dArray[n] + -facx * (t - txb) * this.velx[i2][j] * velxscale[i2][j] * this.porosity[i2][j] * this.ng[i2][j] * this.ratiowaterrhocp[i2][j] * this.OVERDX / this.h[i2][j];
                        } else {
                            double[] dArray = this.temp[i2];
                            int n = j;
                            dArray[n] = dArray[n] + -facx * (txf - t) * this.velx[i2][j] * velxscale[i2][j] * this.porosity[i2][j] * this.ng[i2][j] * this.ratiowaterrhocp[i2][j] * this.OVERDX / this.h[i2][j];
                        }
                        if (this.vely[i2][j] > 0.0) {
                            double[] dArray = this.temp[i2];
                            int n = j;
                            dArray[n] = dArray[n] + -facy * (t - tyb) * this.vely[i2][j] * velyscale[i2][j] * this.porosity[i2][j] * this.ng[i2][j] * this.ratiowaterrhocp[i2][j] * this.OVERDY / this.h[i2][j];
                        } else {
                            double[] dArray = this.temp[i2];
                            int n = j;
                            dArray[n] = dArray[n] + -facy * (tyf - t) * this.vely[i2][j] * velyscale[i2][j] * this.porosity[i2][j] * this.ng[i2][j] * this.ratiowaterrhocp[i2][j] * this.OVERDY / this.h[i2][j];
                        }
                    }
                    if (this.includewall) {
                        ncount = this.g.getM3rkIndex(this.icomponent, i2, j);
                        double initialtemperature2 = this.initialtemperature[i2][j];
                        double q = this.rockconductivity * (initialtemperature2 - t) / length_infinite;
                        if (i2 == 40 && j == 39) {
                            System.out.println("q  dT/dt(0) t (40,39) " + q + ", " + this.temp[i2][j] + ", " + t);
                        }
                        q *= this.overc[i2][j] * this.DX * this.DY;
                        if (i2 == 40 && j == 39) {
                            System.out.println("dT/dtinc  dT/dt(0) t (40,39) " + q + ", " + this.temp[i2][j] + ", " + t);
                        }
                        double[] dArray = this.temp[i2];
                        int n = j;
                        dArray[n] = dArray[n] + q;
                    }
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.NX) {
            j = 0;
            while (j < this.NY) {
                ncount = this.g.getM3rkIndex(this.icomponent, i2, j);
                M3rk.ty[ncount] = 0.0;
                fy[ncount] = 0.0;
                ++j;
            }
            ++i2;
        }
        double maxdt = 0.0;
        int i3 = 0;
        while (i3 < this.NX) {
            int j3 = 0;
            while (j3 < this.NY) {
                if (Math.abs(this.temp[i3][j3]) > maxdt) {
                    maxdt = Math.abs(this.temp[i3][j3]);
                }
                ncount = this.g.getM3rkIndex(this.icomponent, i3, j3);
                fy[ncount] = this.temp[i3][j3];
                M3rk.ty[ncount] = fy[ncount];
                ++j3;
            }
            ++i3;
        }
        if (M3rk.info[4] % 100 == 0) {
            System.out.println(" f(TEMPERATURE)  + time " + this.m3rk.x / this.m3rk.fys + "  " + fy.length + "  " + this.m3rk.getGeom().maxnodes + "   max DTdt : " + maxdt);
            if (Double.isNaN(this.m3rk.x)) {
                System.out.println("shoould not reach this");
            }
        }
    }

    @Override
    public void updategeom(double timepres, double dtsec) {
    }

    @Override
    public void updategeomm3rk(double timepres, double dtsec) {
    }

    @Override
    public void finfinish() {
    }

    public static void main(String[] args) {
        String dir = "C:\\Users\\Public\\wees\\data\\tests\\aquifer\\";
        M3rk m = new M3rk(0.001);
        FtoolGrid2DregularGATemp ftool = new FtoolGrid2DregularGATemp(m);
        double temperature = 65.0;
        double starttime = 0.0;
        AquiferProperties.instantiateProperties(2);
        Property pmodel = PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE);
        pmodel.setDefaultvalue(temperature);
        Property pinitial = PropertyFactory.getProperty(AquiferProperties.IINITIALTEMPERATURE);
        pinitial.setDefaultvalue(temperature);
        GAPropertiesTemp gp = new GAPropertiesTemp(pmodel, pinitial);
        ModelComponentContainer mcc = new ModelComponentContainer();
        mcc.add(gp);
        Grid2Dregular g = new Grid2Dregular(mcc, starttime, 0.0, 0.0, 200, 200, 25.0, 25.0, 100.0);
        PropertyFactory.updateGeometry(g);
        WellPerforation wp1 = new WellPerforation(1500.0, 2500.0, 0.044444444444444446, 30.0, 10.0, 0.08960000000000001, g);
        WellPerforation wp2 = new WellPerforation(3500.0, 2500.0, -0.044444444444444446, -1.0, 10.0, 0.08960000000000001, g);
        g.addWellPerforation(wp1);
        g.addWellPerforation(wp2);
        g.getWpContainer().initializeWellBC(gp, 1);
        g.calculateVelfromWP(0);
        g.outputVel(0, String.valueOf(dir) + "velx", 0);
        g.outputVel(1, String.valueOf(dir) + "vely", 0);
        g.initializeBC();
        g.setUseVelocities(true);
        m.addftool(ftool);
        Step s = new Step();
        int IVELMODE = 0;
        int it = 0;
        while (it <= 50) {
            s.update(g, g.timepres, it, it, ftool.id);
            g.calculateVelfromWP(IVELMODE);
            m.dostepForward(s, g);
            System.out.println("TEMP at time : " + it);
            g.output(0, it == 0, String.valueOf(dir) + "temp" + it, 0);
            it += 5;
        }
    }
}

