/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.model.model2d;

import tno.geoenergy.fdintegration.model.CellBC;
import tno.geoenergy.fdintegration.model.ModelBC;
import tno.geoenergy.fdintegration.model.ModelComponentContainer;
import tno.geoenergy.fdintegration.model.ModelGrid;
import tno.geoenergy.fdintegration.model.model2d.Grid2Dregular;
import tno.geoenergy.logging.Logger;
import tno.geoenergy.properties.Property;

public class Grid2D
extends ModelGrid {
    protected double[][][] values = null;
    protected double[][] velx = null;
    protected double[][] vely = null;
    protected double[][] viscoratio = null;
    protected boolean useVelocities = false;
    private static Logger logger = Logger.getLogger(Grid2Dregular.class.getName());

    public Grid2D(ModelComponentContainer gp, double starttime, double orx, double ory, int nx, int ny) {
        super(gp, starttime);
        if (nx * ny > 2000000) {
            logger.error("nx*ny > 2000000");
        } else {
            this.orx = orx;
            this.ory = ory;
            this.nx = nx;
            this.ny = ny;
            this.values = new double[gp.getNcomponents()][nx][ny];
        }
        this.maxnodes = gp.getNcomponents() * nx * ny;
    }

    public double[][][] getValues() {
        return this.values;
    }

    public double[][] getVelx() {
        return this.velx;
    }

    public void setVelx(double[][] velx) {
        this.velx = velx;
    }

    public double[][] getVely() {
        return this.vely;
    }

    public void setVely(double[][] vely) {
        this.vely = vely;
    }

    public boolean isUseVelocities() {
        return this.useVelocities;
    }

    public void setUseVelocities(boolean useVelocities) {
        this.useVelocities = useVelocities;
    }

    protected void initializeValues(int component, double value) {
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                Grid2D.geotherm[this.getM3rkIndex((int)component, (int)i, (int)j)] = value;
                Grid2D.inigeotherm[this.getM3rkIndex((int)component, (int)i, (int)j)] = value;
                ++j;
            }
            ++i;
        }
    }

    protected void initializeValues(int component, Property p) {
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                Grid2D.geotherm[this.getM3rkIndex((int)component, (int)i, (int)j)] = p.getValue(i, j, 0);
                Grid2D.inigeotherm[this.getM3rkIndex((int)component, (int)i, (int)j)] = p.getValue(i, j, 0);
                ++j;
            }
            ++i;
        }
    }

    public double[][] getValues(int component, double[][] v) {
        if (v == null) {
            v = new double[this.getNx()][this.getNy()];
        }
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                v[i][j] = geotherm[this.getM3rkIndex(component, i, j)];
                ++j;
            }
            ++i;
        }
        return v;
    }

    public void initializeBCValues(int component, CellBC[][] cellBC) {
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                ModelBC mbc;
                CellBC cbc = cellBC[i][j];
                if (cbc != null && cbc.getTypes()[0] != null) {
                    mbc = cbc.getTypes()[0];
                    System.out.println("applying boundary WEll CELL VALUE " + mbc.getValue());
                    Grid2D.geotherm[this.getM3rkIndex((int)component, (int)i, (int)j)] = mbc.getValue();
                    Grid2D.inigeotherm[this.getM3rkIndex((int)component, (int)i, (int)j)] = mbc.getValue();
                }
                if (cbc != null && cbc.getTypes()[8] != null) {
                    mbc = cbc.getTypes()[8];
                    System.out.println("applying boundary WEll pressure " + mbc.getValue());
                    System.out.println("applying boundary CELL pressure (taking half or updated value) " + mbc.getPresfromQValue(this));
                    Grid2D.geotherm[this.getM3rkIndex((int)component, (int)i, (int)j)] = mbc.getPresfromQValue(this);
                    Grid2D.inigeotherm[this.getM3rkIndex((int)component, (int)i, (int)j)] = mbc.getPresfromQValue(this);
                }
                ++j;
            }
            ++i;
        }
    }

    public int getM3rkIndex(int component, int i, int j) {
        return component * this.nx * this.ny + i * this.ny + j + 1;
    }
}

