/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.model.model2d;

import tno.geoenergy.data.Faults;
import tno.geoenergy.data.Grid;
import tno.geoenergy.data.SmartGrid;
import tno.geoenergy.data.VTKgrid;
import tno.geoenergy.data.VTKgridWriter;
import tno.geoenergy.fdintegration.model.CellBC;
import tno.geoenergy.fdintegration.model.ModelBC;
import tno.geoenergy.fdintegration.model.ModelComponent;
import tno.geoenergy.fdintegration.model.ModelComponentContainer;
import tno.geoenergy.fdintegration.model.WellPerforation;
import tno.geoenergy.fdintegration.model.model2d.Grid2D;
import tno.geoenergy.logging.Logger;
import tno.geoenergy.properties.AquiferProperties;
import tno.geoenergy.properties.PropertyFactory;

public class Grid2Dregular
extends Grid2D {
    public static final int SURFER = 0;
    public static final int ARCINFO = 1;
    public static final int ZYCOR = 2;
    public static final int GMT = 3;
    public static final int CSV = 4;
    public static final String[] GRIDEXTENSION = new String[]{".grd", ".asc", ".dat", ".txt", ".csv"};
    public static final String[] GRIDDATAFORMAT = new String[]{"SURFER", "ARC", "ZYCOR", "GMT", "CSV"};
    protected int[][] faults = null;
    private double faultPermeability = 10000.0;
    private double faultThickness = 1.0;
    private static Logger logger = Logger.getLogger(Grid2Dregular.class.getName());

    public void setFaultPermeability(double faultPermeability) {
        this.faultPermeability = faultPermeability;
    }

    public double getFaultPermeability() {
        return this.faultPermeability;
    }

    public double getFaultThickness() {
        return this.faultThickness;
    }

    public void setFaultThickness(double faultThickness) {
        this.faultThickness = faultThickness;
    }

    public Grid2Dregular(ModelComponentContainer gp, double starttime, double orx, double ory, int nx, int ny, double dx, double dy, double dz) {
        super(gp, starttime, orx, ory, nx, ny);
        this.faults = new int[nx][ny];
        this.initFaultsmin1();
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.nz = 1;
        this.initializeValuesConstant();
    }

    public void initializeValuesConstant() {
        int i = 0;
        while (i < this.getGpContainer().size()) {
            this.initializeValues(i, this.getGpContainer().getModelComponent(i).getDefaultvalue());
            ++i;
        }
    }

    public void initializeValues() {
        int i = 0;
        while (i < this.getGpContainer().size()) {
            this.initializeValues(i, this.getGpContainer().getModelComponent(i).getInitialvalues());
            ++i;
        }
    }

    public void initializeFault(double x1, double y1, double x2, double y2, int id) {
        int ix1 = this.getIcell(x1);
        int iy1 = this.getJcell(y1);
        int ix2 = this.getIcell(x2);
        int iy2 = this.getJcell(y2);
        int dx = ix2 - ix1;
        int dy = iy2 - iy1;
        if (Math.abs(dx) > Math.abs(dy)) {
            if (dx < 0) {
                int t = ix1;
                ix1 = ix2;
                ix2 = t;
                t = iy1;
                iy1 = iy2;
                iy2 = t;
            }
            int yinc = 1;
            if (iy2 <= iy1) {
                yinc = -1;
            }
            Faults.bresX(ix1, iy1, ix2, iy2, yinc, id, this.faults);
        } else {
            if (dy < 0) {
                int t = ix1;
                ix1 = ix2;
                ix2 = t;
                t = iy1;
                iy1 = iy2;
                iy2 = t;
            }
            int xinc = 1;
            if (ix2 <= ix1) {
                xinc = -1;
            }
            Faults.bresY(ix1, iy1, ix2, iy2, xinc, id, this.faults);
        }
    }

    public void initializeBC() {
        int i = 0;
        while (i < this.getGpContainer().size()) {
            CellBC[][] cellBC = this.getBC(this.getGpContainer().getModelComponent(i));
            this.initializeBCValues(i, cellBC);
            ++i;
        }
    }

    private void calculateVelAnalytical(double[][][] vel) {
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                boolean celliswell = false;
                int iw = 0;
                while (iw < this.getWpContainer().size()) {
                    WellPerforation wp = this.getWpContainer().getWellPerforation(iw);
                    if (i == wp.getIcell() && j == wp.getJcell()) {
                        celliswell = true;
                    } else {
                        double xx = this.getX(i);
                        double yy = this.getY(j);
                        double[] val = wp.getStreamlineVelocity(xx, yy);
                        double[] dArray = vel[0][i];
                        int n = j;
                        dArray[n] = dArray[n] + val[0];
                        double[] dArray2 = vel[1][i];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + val[1];
                    }
                    ++iw;
                }
                if (celliswell) {
                    double[] dArray = vel[0][i];
                    int n = j;
                    dArray[n] = dArray[n] + 0.0;
                    double[] dArray3 = vel[1][i];
                    int n3 = j;
                    dArray3[n3] = dArray3[n3] + 0.0;
                }
                ++j;
            }
            ++i;
        }
    }

    public void calculateVelfromWP(int mode) {
        int nx = this.getNx();
        int ny = this.getNy();
        double[][][] vel = new double[2][nx][ny];
        if (mode == 0) {
            this.calculateVelAnalytical(vel);
        }
        this.velx = vel[0];
        this.vely = vel[1];
    }

    public SmartGrid getGridValues(boolean initial, int component) {
        SmartGrid grid = new SmartGrid();
        grid.values = new float[this.nx][this.ny];
        grid.originx = (float)this.orx;
        grid.originy = (float)this.ory;
        grid.dx = (float)this.dx;
        grid.dy = (float)this.dy;
        grid.nx = this.nx;
        grid.ny = this.ny;
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                grid.values[i][j] = initial ? (float)inigeotherm[this.getM3rkIndex(component, i, j)] : (float)geotherm[this.getM3rkIndex(component, i, j)];
                ++j;
            }
            ++i;
        }
        grid.m_Grid.originx = grid.originx;
        grid.m_Grid.originy = grid.originy;
        grid.m_Grid.dx = grid.dx;
        grid.m_Grid.dy = grid.dy;
        grid.m_Grid.nx = grid.nx;
        grid.m_Grid.ny = grid.ny;
        grid.m_Grid.values = grid.values;
        grid.m_Grid.unknown = -999.25f;
        return grid;
    }

    public int getIcell(double x) {
        int i = (int)((x - this.orx) / this.dx + 0.5);
        return i;
    }

    public int getJcell(double y) {
        int i = (int)((y - this.ory) / this.dy + 0.5);
        return i;
    }

    public double getX(int i) {
        return this.orx + (double)i * this.dx;
    }

    public double getY(int j) {
        return this.ory + (double)j * this.dy;
    }

    public CellBC[][] getBC(ModelComponent mc) {
        CellBC[][] r = new CellBC[this.nx][this.ny];
        int i = 0;
        while (i < mc.getBcContainer().size()) {
            ModelBC mbc = mc.getBcContainer().getModelBoundaryCondition(i);
            mbc.convert2CellBC(r);
            ++i;
        }
        return r;
    }

    public void outputWells(int ncomp, boolean initial, double time, double[][] viscosity, double salinity, double[][] totalpressure) {
        this.getWpContainer().setOutputTime(time);
        int component = 0;
        while (component < ncomp) {
            SmartGrid grid = this.getGridValues(initial, component);
            this.getWpContainer().setOutput(component, grid, viscosity, salinity, totalpressure);
            ++component;
        }
    }

    public void output(int component, boolean initial, String fname, int format) {
        SmartGrid grid = this.getGridValues(initial, component);
        grid.m_Grid.setFileName(String.valueOf(fname) + GRIDEXTENSION[format]);
        grid.m_Grid.setDataFormat(GRIDDATAFORMAT[format]);
        try {
            grid.m_Grid.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void outputVel(int xy, String fname, int format) {
        int i;
        SmartGrid grid = this.getGridValues(true, 0);
        grid.m_Grid.setFileName(String.valueOf(fname) + GRIDEXTENSION[format]);
        grid.m_Grid.setDataFormat(GRIDDATAFORMAT[format]);
        if (xy == 0) {
            i = 0;
            while (i < this.nx) {
                int j = 0;
                while (j < this.ny) {
                    grid.m_Grid.values[i][j] = (float)this.getVelx()[i][j];
                    ++j;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.nx) {
                int j = 0;
                while (j < this.ny) {
                    grid.m_Grid.values[i][j] = (float)this.getVely()[i][j];
                    ++j;
                }
                ++i;
            }
        }
        try {
            grid.m_Grid.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void outputFaults(String fname, int format) {
        SmartGrid grid = this.getGridValues(true, 0);
        grid.m_Grid.setFileName(String.valueOf(fname) + GRIDEXTENSION[format]);
        grid.m_Grid.setDataFormat(GRIDDATAFORMAT[format]);
        int nx = this.getNx();
        int ny = this.getNy();
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                grid.m_Grid.values[i][j] = 0.0f;
                if (this.faults[i][j] >= 0) {
                    grid.m_Grid.values[i][j] = 1.0f;
                }
                ++j;
            }
            ++i;
        }
        try {
            grid.m_Grid.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void outputVTKformat(String fileName) {
        double[][] porosity = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IPOROSITY));
        double[][] h = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ITHICKNESS));
        double[][] ng = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ING));
        double[][] topdepth = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IAQUIFERDEPTH));
        double[][] initialtemperature = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IINITIALTEMPERATURE));
        double[][] modeltemperature = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE));
        double[][] modeltotalpressure = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_TOTALPRES));
        double[][] modelpressure = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELPRESSURE));
        double[][] conduc = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_T_CONDUC));
        double[][] reftemp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE));
        double[][] density = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IDENSITY));
        VTKgrid vtkg = new VTKgrid(topdepth, this.dx, this.dy, this.orx, this.ory, h, fileName);
        vtkg.addProperty(modeltemperature, AquiferProperties.DEFAULTUNKNOWN, PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE).getName());
        vtkg.addProperty(modelpressure, AquiferProperties.DEFAULTUNKNOWN, PropertyFactory.getProperty(AquiferProperties.IMODELPRESSURE).getName());
        vtkg.addProperty(conduc, AquiferProperties.DEFAULTUNKNOWN, PropertyFactory.getProperty(AquiferProperties.ICALC_T_CONDUC).getName());
        vtkg.addProperty(density, AquiferProperties.DEFAULTUNKNOWN, PropertyFactory.getProperty(AquiferProperties.IDENSITY).getName());
        VTKgridWriter.writeVTK(vtkg);
    }

    public void outputPres(String fname, int timeyrs, int format) {
        SmartGrid grid = this.getGridValues(true, 0);
        grid.m_Grid.setFileName(String.valueOf(fname) + GRIDEXTENSION[format]);
        grid.m_Grid.setDataFormat(GRIDDATAFORMAT[format]);
        int nx = this.getNx();
        int ny = this.getNy();
        WellPerforation wp1 = this.getWpContainer().getWellPerforation(0);
        wp1.setMindist(1.0E30);
        double perm = PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYI).getDefaultvalue();
        double viscosity = PropertyFactory.getProperty(AquiferProperties.IVISCOSITY).getDefaultvalue();
        double porosity = PropertyFactory.getProperty(AquiferProperties.IPOROSITY).getDefaultvalue();
        double kh = perm * 100000.0 / (1.0132502738308866E15 * viscosity);
        double ch = PropertyFactory.getProperty(AquiferProperties.ISTORAGECAPACITY).getDefaultvalue() * 100000.0 * porosity;
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                grid.m_Grid.values[i][j] = 0.0f;
                int iw = 0;
                while (iw < this.getWpContainer().size()) {
                    WellPerforation wp = this.getWpContainer().getWellPerforation(iw);
                    if (i == wp.getIcell() && j == wp.getJcell()) {
                        float[] fArray = grid.m_Grid.values[i];
                        int n = j;
                        fArray[n] = (float)((double)fArray[n] + wp.getPwell());
                    } else {
                        double xx = this.getX(i);
                        double yy = this.getY(j);
                        double pp = wp.getPressure(xx, yy, kh, ch, timeyrs);
                        float[] fArray = grid.m_Grid.values[i];
                        int n = j;
                        fArray[n] = fArray[n] + (float)pp;
                    }
                    ++iw;
                }
                ++j;
            }
            ++i;
        }
        System.out.println(wp1.getMindist());
        try {
            grid.m_Grid.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void outputWells2File(String dirname) {
        this.getWpContainer().outputWells2File(dirname);
    }

    public void initFaultsmin1() {
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                this.faults[i][j] = -1;
                ++j;
            }
            ++i;
        }
    }

    public int[][] getFaultCells() {
        if (this.faults == null) {
            this.faults = new int[this.nx][this.ny];
            this.initFaultsmin1();
        }
        return this.faults;
    }

    public void setGridlevel() {
        double[][] topdepth = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IAQUIFERDEPTH));
        double[][] h = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ITHICKNESS));
        float[][] zlevel = new float[this.getNx()][this.getNy()];
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                zlevel[i][j] = (float)(topdepth[i][j] + 0.5 * h[i][j]);
                ++j;
            }
            ++i;
        }
        Grid.setZlevel(zlevel);
    }
}

