/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.model.model3d;

import java.util.Random;
import tno.geoenergy.TnoWaterProperties;
import tno.geoenergy.data.Voxet;
import tno.geoenergy.data.VoxetWriter;
import tno.geoenergy.fdintegration.integration.M3rk;
import tno.geoenergy.fdintegration.integration.Step;
import tno.geoenergy.fdintegration.model.CellBC;
import tno.geoenergy.fdintegration.model.GAPropertiesPres;
import tno.geoenergy.fdintegration.model.GAPropertiesTemp;
import tno.geoenergy.fdintegration.model.ModelComponentContainer;
import tno.geoenergy.fdintegration.model.ModelGrid;
import tno.geoenergy.fdintegration.model.ModelRealisation;
import tno.geoenergy.fdintegration.model.WellPerforation;
import tno.geoenergy.fdintegration.model.model2d.FtoolGrid2DregularGAPres;
import tno.geoenergy.fdintegration.model.model2d.Grid2Dregular;
import tno.geoenergy.fdintegration.model.model3d.FtoolGrid3DregularGATemp;
import tno.geoenergy.fdintegration.model.model3d.Grid3Dregular;
import tno.geoenergy.pcg.PCG3DBand;
import tno.geoenergy.pcg.PCG3DBandEclipse;
import tno.geoenergy.properties.AquiferProperties;
import tno.geoenergy.properties.Property;
import tno.geoenergy.properties.PropertyFactory;

public class FtoolGrid3DregularGAPres
extends FtoolGrid3DregularGATemp {
    static final double RATIOPERMXY = 1.0;
    static final double RATIOPERMX = Math.sqrt(1.0);
    static final double RATIOPERMY = Math.sqrt(1.0);
    static final double REFDENSITY = 1000.0;
    boolean useWPpressure = false;
    double[][][] ranFactors = null;
    double[][][] pres = null;
    CellBC[][][] cellBC = null;
    GAPropertiesPres gpp;
    double c_pres = 1.0E-9;
    double[][][] overc_pres = null;
    double[][][] permx = null;
    double[][][] permy = null;
    double[][][] permz = null;
    double[][][] massbal = null;
    double[][][] actnum = null;
    double[][][] ng = null;
    double[][][] hconductancei = null;
    double[][][] hconductancej = null;
    double[][][] hconductancek = null;
    double[][][] connectxmin = null;
    double[][][] connectxplus = null;
    double[][][] connectymin = null;
    double[][][] connectyplus = null;
    double[][][] connectzmin = null;
    double[][][] connectzplus = null;
    double[][][] actnumflow = null;
    double[][][] connectxmin_temp = null;
    double[][][] connectxplus_temp = null;
    double[][][] connectymin_temp = null;
    double[][][] connectyplus_temp = null;
    double[][][] connectzmin_temp = null;
    double[][][] connectzplus_temp = null;
    double[][][] porosity = null;
    double[][][] h = null;
    double[][] topdepth = null;
    double[][][] reftemp = null;
    double[][][] temp = null;
    public double[][][] viscosity = null;
    public double[][][] density = null;
    public double[][][] densityPseudoSourcei = null;
    public double[][][] densityPseudoSourcej = null;
    public double[][][] densityPseudoSourcek = null;
    public double refDensity;
    public double[][][] rightHandSide;
    public double[][][] depth;
    public double[][][] initialtemp = null;
    public double[][][] totalpres = null;
    double[][][] prespcg = null;
    static double[][][] modelpres = null;
    public double salinity;
    boolean update_viscosity = true;
    private int calcmode;
    private int icomponent = 1;
    private final double LMULTFD = 1.0;
    private final double LMULTPCG = 1.0;
    boolean firstpassafterprepf = false;
    boolean usepcg = true;
    public static double[][][] finvelx = null;
    public static double[][][] finvely = null;
    public static double[][][] finvelz = null;

    public FtoolGrid3DregularGAPres(M3rk m3rk) {
        super(m3rk);
        this.id = "grid3dregular_pres";
        this.m3rk = m3rk;
    }

    private void scaleOvercpres() {
        double LMULT = 1.0;
        if (this.usepcg) {
            LMULT = 1.0;
        }
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    if (i == 0 || i == this.NX - 1) {
                        double[] dArray = this.overc_pres[i][j];
                        int n = k;
                        dArray[n] = dArray[n] * LMULT;
                    }
                    if (j == 0 || j == this.NY - 1) {
                        double[] dArray = this.overc_pres[i][j];
                        int n = k;
                        dArray[n] = dArray[n] * LMULT;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public double[][][] getRanFactors() {
        int k;
        int j;
        if (this.ranFactors == null) {
            this.ranFactors = new double[this.NX][this.NY][this.NZ];
        }
        Random ran = new Random();
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    this.ranFactors[i][j][k] = 1.0;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i < this.NX - 1) {
            j = 1;
            while (j < this.NY - 1) {
                k = 0;
                while (k < this.NZ) {
                    this.ranFactors[i][j][k] = Math.pow(10.0, ran.nextDouble() * 3.0 - 2.0);
                    if (this.ranFactors[i][j][k] > 1.0) {
                        this.ranFactors[i][j][k] = 1.0;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return this.ranFactors;
    }

    private double[][][] getRanFactors(double d, int ii, int nX, int jj, int nY, int kk, int nZ) {
        if (this.ranFactors == null) {
            this.ranFactors = new double[this.NX][this.NY][this.NZ];
        }
        int i = ii;
        while (i < nX) {
            int j = jj;
            while (j < nY) {
                int k = kk;
                while (k < nZ) {
                    this.ranFactors[i][j][k] = d;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return this.ranFactors;
    }

    @Override
    public void prepf() {
        int k;
        int j;
        super.prepf();
        this.firstpassafterprepf = true;
        this.gpp = (GAPropertiesPres)this.m3rk.getGeom().getGpContainer().getModelComponent(this.icomponent);
        this.g = (Grid3Dregular)this.m3rk.getGeom();
        this.pres = this.g.getValues()[this.icomponent];
        this.cellBC = this.g.getBC(this.gpp);
        double switch_use_pcg = PropertyFactory.getProperty(AquiferProperties.ISWITCH_STEADYSTATE).getDefaultvalue();
        this.usepcg = switch_use_pcg > 0.0;
        double c_pres = PropertyFactory.getProperty(AquiferProperties.ISTORAGECAPACITY).getDefaultvalue();
        this.overc_pres = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_P_OVERC), this.overc_pres);
        this.porosity = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IPOROSITY), this.porosity);
        this.h = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ITHICKNESS), this.h);
        this.ng = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ING), this.ng);
        this.ranFactors = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_RANFACTORS), this.ranFactors);
        this.actnum = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IACTNUM), this.actnum);
        this.actnumflow = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IACTNUMFLOW), this.actnumflow);
        this.connectxmin = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTXMIN), this.connectxmin);
        this.connectxplus = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTXPLUS), this.connectxplus);
        this.connectymin = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTYMIN), this.connectymin);
        this.connectyplus = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTYPLUS), this.connectyplus);
        this.connectzmin = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTZMIN), this.connectzmin);
        this.connectzplus = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTZPLUS), this.connectzplus);
        this.connectxmin_temp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTXMINTEMP), this.connectxmin_temp);
        this.connectxplus_temp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTXPLUSTEMP), this.connectxplus_temp);
        this.connectymin_temp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTYMINTEMP), this.connectymin_temp);
        this.connectyplus_temp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTYPLUSTEMP), this.connectyplus_temp);
        this.connectzmin_temp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTZMINTEMP), this.connectzmin_temp);
        this.connectzplus_temp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTZPLUSTEMP), this.connectzplus_temp);
        this.totalpres = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_TOTALPRES), this.totalpres);
        this.topdepth = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IAQUIFERDEPTH));
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                if (i == 0) {
                    this.topdepth[i][j] = this.topdepth[i + 1][j];
                }
                if (i == this.NX - 1) {
                    this.topdepth[i][j] = this.topdepth[i - 1][j];
                }
                if (j == 0) {
                    this.topdepth[i][j] = this.topdepth[i][j + 1];
                }
                if (j == this.NY - 1) {
                    this.topdepth[i][j] = this.topdepth[i][j - 1];
                }
                ++j;
            }
            ++i;
        }
        this.salinity = PropertyFactory.getProperty(AquiferProperties.IWATERSALINITY).getDefaultvalue();
        this.initialtemp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IINITIALTEMPERATURE), this.initialtemp);
        this.reftemp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE), this.reftemp);
        this.viscosity = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IVISCOSITY), this.viscosity);
        this.density = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IDENSITY), this.density);
        this.refDensity = PropertyFactory.getProperty(AquiferProperties.IREFDENSITY).getDefaultvalue();
        this.rightHandSide = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IRHS), this.rightHandSide);
        this.densityPseudoSourcei = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IDENSITYPSEUDOSOURCEI), this.densityPseudoSourcei);
        this.densityPseudoSourcej = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IDENSITYPSEUDOSOURCEJ), this.densityPseudoSourcej);
        this.densityPseudoSourcek = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IDENSITYPSEUDOSOURCEK), this.densityPseudoSourcek);
        this.hconductancei = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_P_CONDUCTANCEI), this.hconductancei);
        this.hconductancej = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_P_CONDUCTANCEJ), this.hconductancej);
        this.hconductancek = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_P_CONDUCTANCEK), this.hconductancek);
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    this.overc_pres[i][j][k] = 1.0 / (c_pres * this.porosity[i][j][k] * 100000.0 * this.h[i][j][k] * this.g.getDx() * this.g.getDy());
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.scaleOvercpres();
        this.permx = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYI), this.permx);
        this.permy = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYJ), this.permy);
        this.permz = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYK), this.permz);
        this.massbal = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IOUTPUTMASSBAL), this.massbal);
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    this.densityPseudoSourcei[i][j][k] = 0.0;
                    this.densityPseudoSourcej[i][j][k] = 0.0;
                    this.densityPseudoSourcek[i][j][k] = 0.0;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (this.g.isUseVelocities()) {
            this.velx = this.g.getVelx();
            this.vely = this.g.getVely();
            this.velz = this.g.getVelz();
        }
        this.setDepth();
        this.setRefDensity();
    }

    private double getConducXY(int i, int j, int k, double[][][] perm) {
        return this.ranFactors[i][j][k] * perm[i][j][k] * this.ng[i][j][k] * 100000.0 / (1.0132502738308866E15 * this.viscosity[i][j][k]);
    }

    private double getConducZ(int i, int j, int k, double[][][] perm) {
        return this.ranFactors[i][j][k] * perm[i][j][k] * 100000.0 / (1.0132502738308866E15 * this.viscosity[i][j][k]);
    }

    public double[][][] updateConducViscosityRegular(double[] fy) {
        this.ranFactors = this.getRanFactors(1.0, 0, this.NX, 0, this.NY, 0, this.NZ);
        boolean updateviscosity = PropertyFactory.getProperty(AquiferProperties.ISWITCH_PTS_VISCOSITY).getDefaultvalue() == 1.0;
        boolean updateDensity = PropertyFactory.getProperty(AquiferProperties.ISWITCH_PTS_DENSITY).getDefaultvalue() == 1.0;
        this.getPres(fy);
        this.getTemp(fy);
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                double depth = this.topdepth[i][j] - 0.5 * this.h[i][j][0];
                int k = 0;
                while (k < this.NZ) {
                    int ncount = this.g.getM3rkIndex(this.icomponent, i, j, k);
                    this.totalpres[i][j][k] = (depth += this.h[i][j][k]) * 0.1 + fy[ncount];
                    if (updateviscosity) {
                        double visc;
                        this.viscosity[i][j][k] = visc = TnoWaterProperties.Viscosity(this.totalpres[i][j][k] * 100000.0, this.reftemp[i][j][k], this.salinity * 1.0E-6);
                    }
                    if (updateDensity) {
                        double dens;
                        this.density[i][j][k] = dens = TnoWaterProperties.Density(this.totalpres[i][j][k] * 100000.0, this.temp[i][j][k], this.salinity * 1.0E-6);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        double LMULT = 1.0;
        if (this.usepcg) {
            LMULT = 1.0;
        }
        int i2 = 0;
        while (i2 < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    double c2;
                    double kh2;
                    double dl2;
                    double dl1;
                    double kh1;
                    double conduc;
                    boolean ok = this.checkConnect(i2, j, k, i2 + 1, j, k);
                    if (ok) {
                        conduc = this.getConducXY(i2, j, k, this.permx);
                        kh1 = this.h[i2][j][k] * conduc;
                        dl1 = this.g.getDx();
                        if (i2 == 0 || i2 == this.NX - 1) {
                            dl1 *= LMULT;
                        }
                        dl2 = this.g.getDx();
                        if (i2 < this.NX - 1) {
                            conduc = this.getConducXY(i2 + 1, j, k, this.permx);
                            kh2 = this.h[i2 + 1][j][k] * conduc;
                            if (i2 == this.NX - 2) {
                                dl2 *= LMULT;
                            }
                        } else {
                            kh2 = kh1;
                        }
                        this.hconductancei[i2][j][k] = c2 = 2.0 * this.g.getDy() * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                    } else {
                        this.hconductancei[i2][j][k] = 0.0;
                    }
                    ok = this.checkConnect(i2, j, k, i2, j + 1, k);
                    if (ok) {
                        conduc = this.getConducXY(i2, j, k, this.permy);
                        kh1 = this.h[i2][j][k] * conduc;
                        dl1 = this.g.getDy();
                        if (j == 0 || j == this.NY - 1) {
                            dl1 *= LMULT;
                        }
                        dl2 = this.g.getDy();
                        if (j < this.NY - 1) {
                            conduc = this.getConducXY(i2, j + 1, k, this.permy);
                            kh2 = this.h[i2][j + 1][k] * conduc;
                            if (j == this.NY - 2) {
                                dl2 *= LMULT;
                            }
                        } else {
                            kh2 = kh1;
                        }
                        this.hconductancej[i2][j][k] = c2 = 2.0 * this.g.getDx() * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                    } else {
                        this.hconductancej[i2][j][k] = 0.0;
                    }
                    ok = this.checkConnect(i2, j, k, i2, j, k + 1);
                    if (ok) {
                        kh1 = this.g.getDx() * this.getConducZ(i2, j, k, this.permz);
                        dl1 = this.h[i2][j][k];
                        if (k < this.NZ - 1) {
                            kh2 = this.g.getDx() * this.getConducZ(i2, j, k + 1, this.permz);
                            dl2 = this.h[i2][j][k + 1];
                        } else {
                            kh2 = kh1;
                            dl2 = dl1;
                        }
                        this.hconductancek[i2][j][k] = c2 = 2.0 * this.g.getDy() * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                    } else {
                        this.hconductancek[i2][j][k] = 0.0;
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        if (this.usepcg) {
            this.prespcg = this.pcgpres();
        }
        return this.prespcg;
    }

    public double[][][] updateConducViscosity(double[] fy) {
        boolean isEclipseGridInput;
        boolean bl = isEclipseGridInput = PropertyFactory.getProperty(AquiferProperties.IMASKGEOM).getDefaultvalue() == 1.0;
        if (isEclipseGridInput) {
            return this.updateConducViscosityEclipse(fy);
        }
        return this.updateConducViscosityRegular(fy);
    }

    public double[][][] updateConducViscosityEclipse(double[] fy) {
        this.ranFactors = this.getRanFactors(1.0, 0, this.NX, 0, this.NY, 0, this.NZ);
        boolean updateviscosity = PropertyFactory.getProperty(AquiferProperties.ISWITCH_PTS_VISCOSITY).getDefaultvalue() == 1.0;
        boolean updateDensity = PropertyFactory.getProperty(AquiferProperties.ISWITCH_PTS_DENSITY).getDefaultvalue() == 1.0;
        this.getPres(fy);
        this.getTemp(fy);
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                double depth = this.topdepth[i][j] - 0.5 * this.h[i][j][0];
                int k = 0;
                while (k < this.NZ) {
                    int ncount = this.g.getM3rkIndex(this.icomponent, i, j, k);
                    this.totalpres[i][j][k] = (depth += this.h[i][j][k]) * 0.1 + fy[ncount];
                    if (updateviscosity) {
                        double visc;
                        this.viscosity[i][j][k] = visc = TnoWaterProperties.Viscosity(this.totalpres[i][j][k] * 100000.0, this.reftemp[i][j][k], this.salinity * 1.0E-6);
                    }
                    if (updateDensity) {
                        double dens;
                        this.density[i][j][k] = dens = TnoWaterProperties.Density(this.totalpres[i][j][k] * 100000.0, this.temp[i][j][k], this.salinity * 1.0E-6);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        double LMULT = 1.0;
        if (this.usepcg) {
            LMULT = 1.0;
        }
        int i2 = 0;
        while (i2 < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    int kPlusOne;
                    int jPlusOne;
                    double c2;
                    double kh2;
                    double dl2;
                    double dl1;
                    double kh1;
                    double conduc;
                    int iPlusOne;
                    this.hconductancei[i2][j][k] = 0.0;
                    this.hconductancej[i2][j][k] = 0.0;
                    this.hconductancek[i2][j][k] = 0.0;
                    if (k == 20) {
                        boolean bl = true;
                    }
                    if ((iPlusOne = (int)this.connectxplus[i2][j][k]) > 0) {
                        conduc = this.getConducXY(i2, j, k, this.permx);
                        kh1 = this.h[i2][j][k] * conduc;
                        dl1 = this.g.getDx();
                        if (i2 == 0 || i2 == this.NX - 1) {
                            dl1 *= LMULT;
                        }
                        dl2 = this.g.getDx();
                        if (i2 < this.NX - 1) {
                            conduc = this.getConducXY(iPlusOne, j, k, this.permx);
                            kh2 = this.h[iPlusOne][j][k] * conduc;
                            if (i2 == this.NX - 2) {
                                dl2 *= LMULT;
                            }
                        } else {
                            kh2 = kh1;
                        }
                        this.hconductancei[i2][j][k] = c2 = 2.0 * this.g.getDy() * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                    }
                    if ((jPlusOne = (int)this.connectyplus[i2][j][k]) > 0) {
                        conduc = this.getConducXY(i2, j, k, this.permy);
                        kh1 = this.h[i2][j][k] * conduc;
                        dl1 = this.g.getDy();
                        if (j == 0 || j == this.NY - 1) {
                            dl1 *= LMULT;
                        }
                        dl2 = this.g.getDy();
                        if (j < this.NY - 1) {
                            conduc = this.getConducXY(i2, jPlusOne, k, this.permy);
                            kh2 = this.h[i2][jPlusOne][k] * conduc;
                            if (j == this.NY - 2) {
                                dl2 *= LMULT;
                            }
                        } else {
                            kh2 = kh1;
                        }
                        this.hconductancej[i2][j][k] = c2 = 2.0 * this.g.getDx() * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                    }
                    if ((kPlusOne = (int)this.connectzplus[i2][j][k]) > 0) {
                        kh1 = this.g.getDx() * this.getConducZ(i2, j, k, this.permz);
                        dl1 = this.h[i2][j][k];
                        if (k < this.NZ - 1) {
                            kh2 = this.g.getDx() * this.getConducZ(i2, j, kPlusOne, this.permz);
                            dl2 = this.h[i2][j][kPlusOne];
                        } else {
                            kh2 = kh1;
                            dl2 = dl1;
                        }
                        this.hconductancek[i2][j][k] = c2 = 2.0 * this.g.getDy() * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        if (this.usepcg) {
            this.prespcg = this.pcgpres();
        }
        return this.prespcg;
    }

    private boolean checkConnect(int i, int j, int k, int i2, int j2, int k2) {
        if (i2 > this.NX - 1 || j2 > this.NY - 1) {
            return this.actnum[i][j][k] > 0.0;
        }
        if (k2 > this.NZ - 1) {
            return false;
        }
        return this.actnum[i][j][k] > 0.0 && this.actnum[i2][j2][k2] > 0.0;
    }

    private void getPres(double[] fy) {
        if (this.prespcg == null) {
            this.prespcg = new double[this.NX][this.NY][this.NZ];
        }
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.prespcg[i][j][k] = fy[this.g.getM3rkIndex(this.icomponent, i, j, k)];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void getTemp(double[] fy) {
        double reftemp = 65.0;
        double sumdt = 0.0;
        if (this.temp == null) {
            this.temp = new double[this.NX][this.NY][this.NZ];
        }
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.temp[i][j][k] = fy[this.g.getM3rkIndex(0, i, j, k)];
                    sumdt += this.temp[i][j][k] - reftemp;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        System.out.println("XXXX---------- SUMDT -------XXXX" + sumdt / (double)(this.NX * this.NY * this.NZ));
    }

    private void setRefDensity() {
        this.refDensity = 1000.0;
    }

    private void setDepth() {
        double d = 0.0;
        if (this.depth == null) {
            this.depth = new double[this.NX][this.NY][this.NZ];
        }
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                d = this.topdepth[i][j] - 0.5 * this.h[i][j][0];
                int k = 0;
                while (k < this.NZ) {
                    this.depth[i][j][k] = d += this.h[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private double[][][] pcgpres() {
        boolean USECONSTANTPRES;
        PCG3DBand pcg;
        boolean isEclipseGridInput = PropertyFactory.getProperty(AquiferProperties.IMASKGEOM).getDefaultvalue() == 1.0;
        double UNKNOWN = 1.2345E38;
        if (isEclipseGridInput) {
            pcg = new PCG3DBandEclipse();
            PCG3DBand.DIAGSCALE = 1.0;
            PCG3DBand.DIRICHMULT = 1.0;
            PCG3DBand pcge = pcg;
            ((PCG3DBandEclipse)pcge).initGeometryProp(this.g.getNx(), this.g.getNy(), this.g.getNz(), this.g.getDx(), this.g.getDy(), this.g.getOrx(), this.g.getOry(), this.hconductancei, this.hconductancej, this.hconductancek, UNKNOWN, this.refDensity, this.topdepth, this.h, this.actnum, this.overc_pres, this.density, this.densityPseudoSourcei, this.densityPseudoSourcej, this.densityPseudoSourcek, this.rightHandSide, this.connectxmin, this.connectxplus, this.connectymin, this.connectyplus, this.connectzmin, this.connectzplus, this.actnumflow, this.connectxmin_temp, this.connectxplus_temp, this.connectymin_temp, this.connectyplus_temp, this.connectzmin_temp, this.connectzplus_temp, this.actnumtemp);
        } else {
            pcg = new PCG3DBand();
            PCG3DBand.DIAGSCALE = 1.0;
            PCG3DBand.DIRICHMULT = 1.0;
            pcg.initGeometryProp(this.g.getNx(), this.g.getNy(), this.g.getNz(), this.g.getDx(), this.g.getDy(), this.g.getOrx(), this.g.getOry(), this.hconductancei, this.hconductancej, this.hconductancek, UNKNOWN, this.refDensity, this.topdepth, this.h, this.actnum, this.overc_pres, this.density, this.densityPseudoSourcei, this.densityPseudoSourcej, this.densityPseudoSourcek, this.rightHandSide);
        }
        boolean bl = USECONSTANTPRES = PropertyFactory.getProperty(AquiferProperties.ISWITCH_NOFLOWBC).getDefaultvalue() == 0.0;
        if (USECONSTANTPRES) {
            pcg.initializeValPressure(1.0);
        } else {
            pcg.initializeValPressure2(1.0);
        }
        pcg.setDefaultvalue(0.0);
        boolean checkinactive = this.g.getWpContainer().checkInactive();
        if (!checkinactive) {
            this.calcmode = PropertyFactory.getProperty(AquiferProperties.ISWITCH_PRESSURE_CALC).getDefaultvalue() == 0.0 ? 2 : 1;
            this.g.getWpContainer().setDischargeMode(this.calcmode);
        }
        this.gpp.getBcContainer().clear();
        this.g.getWpContainer().initializeWellBC(this.gpp, this.NZ);
        pcg.initBCPressure(this.gpp.getBcContainer());
        pcg.initializeDirichlet(null, USECONSTANTPRES);
        pcg.initializeDefaultValue();
        pcg.setDefaultvalue(0.0);
        pcg.setupstartvalue(this.prespcg);
        pcg.doPCG(1000, 1);
        System.out.println("ready");
        this.prespcg = pcg.getValues(false, this.prespcg);
        pcg.getCalculatedWellData(this.gpp.getBcContainer(), this.g.getWpContainer(), this.prespcg);
        return this.prespcg;
    }

    private void updatevel(double[] fy) {
        boolean isEclipseGridInput;
        boolean bl = isEclipseGridInput = PropertyFactory.getProperty(AquiferProperties.IMASKGEOM).getDefaultvalue() == 1.0;
        if (isEclipseGridInput) {
            this.updatevelEclipse(fy);
        } else {
            this.updatevelRegular(fy);
        }
    }

    private void updatevelRegular(double[] fy) {
        this.velx = this.g.getVelx();
        this.vely = this.g.getVely();
        this.velz = this.g.getVelz();
        double velzsum = 0.0;
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    boolean ok;
                    this.velx[i][j][k] = 0.0;
                    this.vely[i][j][k] = 0.0;
                    this.velz[i][j][k] = 0.0;
                    this.massbal[i][j][k] = 0.0;
                    boolean bl = ok = this.actnum[i][j][k] > 0.0;
                    if (ok) {
                        double tzf;
                        double tyf;
                        double txf;
                        double t;
                        if (!this.usepcg) {
                            t = fy[this.g.getM3rkIndex(this.icomponent, i, j, k)];
                            txf = i < this.NX - 1 ? fy[this.g.getM3rkIndex(this.icomponent, i + 1, j, k)] : t;
                            tyf = j < this.NY - 1 ? fy[this.g.getM3rkIndex(this.icomponent, i, j + 1, k)] : t;
                            tzf = t;
                            if (k != this.NZ - 1) {
                                tzf = fy[this.g.getM3rkIndex(this.icomponent, i, j, k + 1)];
                            }
                        } else {
                            txf = tyf = (t = this.prespcg[i][j][k]);
                            double txb = t;
                            double tyb = t;
                            double tzb = t;
                            tzf = t;
                            if (i < this.NX - 1) {
                                txf = this.prespcg[i + 1][j][k];
                                double[] dArray = this.massbal[i][j];
                                int n = k;
                                dArray[n] = dArray[n] + this.hconductancei[i][j][k] * (txf - this.densityPseudoSourcei[i][j][k] - t);
                            }
                            if (j < this.NY - 1) {
                                tyf = this.prespcg[i][j + 1][k];
                                double[] dArray = this.massbal[i][j];
                                int n = k;
                                dArray[n] = dArray[n] + this.hconductancej[i][j][k] * (tyf - this.densityPseudoSourcej[i][j][k] - t);
                            }
                            if (k < this.NZ - 1) {
                                tzf = this.prespcg[i][j][k + 1];
                                double[] dArray = this.massbal[i][j];
                                int n = k;
                                dArray[n] = dArray[n] + this.hconductancek[i][j][k] * (tzf - this.densityPseudoSourcek[i][j][k] - t);
                            }
                            if (i > 0) {
                                txb = this.prespcg[i - 1][j][k];
                                double[] dArray = this.massbal[i][j];
                                int n = k;
                                dArray[n] = dArray[n] + this.hconductancei[i - 1][j][k] * (txb + this.densityPseudoSourcei[i - 1][j][k] - t);
                            }
                            if (j > 0) {
                                tyb = this.prespcg[i][j - 1][k];
                                double[] dArray = this.massbal[i][j];
                                int n = k;
                                dArray[n] = dArray[n] + this.hconductancej[i][j - 1][k] * (tyb + this.densityPseudoSourcej[i][j - 1][k] - t);
                            }
                            if (k > 0) {
                                tzb = this.prespcg[i][j][k - 1];
                                double[] dArray = this.massbal[i][j];
                                int n = k;
                                dArray[n] = dArray[n] + this.hconductancek[i][j][k - 1] * (tzb + this.densityPseudoSourcek[i][j][k - 1] - t);
                            }
                            double[] dArray = this.massbal[i][j];
                            int n = k;
                            dArray[n] = dArray[n] * 3600.0;
                        }
                        ok = true;
                        this.velx[i][j][k] = 0.0;
                        if (this.actnum[i][j][k] > 0.0 && ok) {
                            this.velx[i][j][k] = -(this.hconductancei[i][j][k] * (txf - this.densityPseudoSourcei[i][j][k] - t)) / (this.DY * this.porosity[i][j][k] * this.ng[i][j][k]);
                        }
                        this.vely[i][j][k] = 0.0;
                        if (this.actnum[i][j][k] > 0.0 && ok) {
                            this.vely[i][j][k] = -(this.hconductancej[i][j][k] * (tyf - this.densityPseudoSourcej[i][j][k] - t)) / (this.DX * this.porosity[i][j][k] * this.ng[i][j][k]);
                        }
                        this.velz[i][j][k] = 0.0;
                        if (k < this.NZ - 1 && this.actnum[i][j][k] > 0.0) {
                            this.velz[i][j][k] = -(this.hconductancek[i][j][k] * (tzf - this.densityPseudoSourcek[i][j][k] - t)) / (this.DX * this.porosity[i][j][k] * this.ng[i][j][k]);
                        }
                        velzsum += this.velz[i][j][k];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.g.setVelx(this.velx);
        this.g.setVely(this.vely);
        this.g.setVelz(this.velz);
        System.out.println("-------------------- VELZ SUM -------------" + velzsum);
    }

    private void updatevelEclipse(double[] fy) {
        this.velx = this.g.getVelx();
        this.vely = this.g.getVely();
        this.velz = this.g.getVelz();
        double velzsum = 0.0;
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    boolean ok;
                    this.velx[i][j][k] = 0.0;
                    this.vely[i][j][k] = 0.0;
                    this.velz[i][j][k] = 0.0;
                    this.massbal[i][j][k] = 0.0;
                    boolean bl = ok = this.actnumflow[i][j][k] > 0.0;
                    if (ok) {
                        int kPlusOne;
                        double tzf;
                        double tyf;
                        int jPlusOne;
                        double txf;
                        int iPlusOne;
                        double t;
                        if (!this.usepcg) {
                            t = fy[this.g.getM3rkIndex(this.icomponent, i, j, k)];
                            if (i < this.NX - 1) {
                                iPlusOne = (int)this.connectxplus[i][j][k];
                                txf = fy[this.g.getM3rkIndex(this.icomponent, iPlusOne, j, k)];
                            } else {
                                txf = t;
                            }
                            if (j < this.NY - 1) {
                                jPlusOne = (int)this.connectyplus[i][j][k];
                                tyf = fy[this.g.getM3rkIndex(this.icomponent, i, jPlusOne, k)];
                            } else {
                                tyf = t;
                            }
                            tzf = t;
                            if (k != this.NZ - 1) {
                                kPlusOne = (int)this.connectzplus[i][j][k];
                                tzf = fy[this.g.getM3rkIndex(this.icomponent, i, j, kPlusOne)];
                            }
                        } else {
                            int kMinOne;
                            int jMinOne;
                            int iMinOne;
                            txf = tyf = (t = this.prespcg[i][j][k]);
                            double txb = t;
                            double tyb = t;
                            double tzb = t;
                            tzf = t;
                            if (i < this.NX - 1 && (iPlusOne = (int)this.connectxplus[i][j][k]) > 0) {
                                txf = this.prespcg[iPlusOne][j][k];
                                double[] dArray = this.massbal[i][j];
                                int n = k;
                                dArray[n] = dArray[n] + this.hconductancei[i][j][k] * (txf - this.densityPseudoSourcei[i][j][k] - t);
                            }
                            if (j < this.NY - 1 && (jPlusOne = (int)this.connectyplus[i][j][k]) > 0) {
                                tyf = this.prespcg[i][jPlusOne][k];
                                double[] dArray = this.massbal[i][j];
                                int n = k;
                                dArray[n] = dArray[n] + this.hconductancej[i][j][k] * (tyf - this.densityPseudoSourcej[i][j][k] - t);
                            }
                            if (k < this.NZ - 1 && (kPlusOne = (int)this.connectzplus[i][j][k]) > 0) {
                                tzf = this.prespcg[i][j][kPlusOne];
                                double[] dArray = this.massbal[i][j];
                                int n = k;
                                dArray[n] = dArray[n] + this.hconductancek[i][j][k] * (tzf - this.densityPseudoSourcek[i][j][k] - t);
                            }
                            if (i > 0 && (iMinOne = (int)this.connectxmin[i][j][k]) >= 0) {
                                txb = this.prespcg[iMinOne][j][k];
                                double[] dArray = this.massbal[i][j];
                                int n = k;
                                dArray[n] = dArray[n] + this.hconductancei[iMinOne][j][k] * (txb + this.densityPseudoSourcei[iMinOne][j][k] - t);
                            }
                            if (j > 0 && (jMinOne = (int)this.connectymin[i][j][k]) >= 0) {
                                tyb = this.prespcg[i][jMinOne][k];
                                double[] dArray = this.massbal[i][j];
                                int n = k;
                                dArray[n] = dArray[n] + this.hconductancej[i][jMinOne][k] * (tyb + this.densityPseudoSourcej[i][jMinOne][k] - t);
                            }
                            if (k > 0 && (kMinOne = (int)this.connectzmin[i][j][k]) >= 0) {
                                tzb = this.prespcg[i][j][kMinOne];
                                double[] dArray = this.massbal[i][j];
                                int n = k;
                                dArray[n] = dArray[n] + this.hconductancek[i][j][kMinOne] * (tzb + this.densityPseudoSourcek[i][j][kMinOne] - t);
                            }
                            double[] dArray = this.massbal[i][j];
                            int n = k;
                            dArray[n] = dArray[n] * 3600.0;
                        }
                        ok = true;
                        this.velx[i][j][k] = 0.0;
                        if (this.actnumflow[i][j][k] > 0.0 && ok) {
                            this.velx[i][j][k] = -(this.hconductancei[i][j][k] * (txf - this.densityPseudoSourcei[i][j][k] - t)) / (this.DY * this.porosity[i][j][k] * this.ng[i][j][k]);
                        }
                        this.vely[i][j][k] = 0.0;
                        if (this.actnumflow[i][j][k] > 0.0 && ok) {
                            this.vely[i][j][k] = -(this.hconductancej[i][j][k] * (tyf - this.densityPseudoSourcej[i][j][k] - t)) / (this.DX * this.porosity[i][j][k] * this.ng[i][j][k]);
                        }
                        this.velz[i][j][k] = 0.0;
                        if (k < this.NZ - 1 && this.actnumflow[i][j][k] > 0.0) {
                            this.velz[i][j][k] = -(this.hconductancek[i][j][k] * (tzf - this.densityPseudoSourcek[i][j][k] - t)) / (this.DX * this.porosity[i][j][k] * this.ng[i][j][k]);
                        }
                        velzsum += this.velz[i][j][k];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.g.setVelx(this.velx);
        this.g.setVely(this.vely);
        this.g.setVelz(this.velz);
        System.out.println("-------------------- VELZ SUM -------------" + velzsum);
    }

    @Override
    public void f(double[] fy) {
        int ncount;
        int k;
        int j;
        int i;
        if (this.firstpassafterprepf) {
            super.updateModelledTemperature(fy);
            this.prespcg = this.updateConducViscosity(fy);
            this.firstpassafterprepf = false;
        }
        this.updatevel(fy);
        super.f(fy);
        int i2 = 0;
        while (i2 < this.NX) {
            int j2 = 0;
            while (j2 < this.NY) {
                int k2 = 0;
                while (k2 < this.NZ) {
                    this.pres[i2][j2][k2] = 0.0;
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
        double rxf = 1.0;
        double rxb = 1.0;
        double ryf = 1.0;
        double ryb = 1.0;
        CellBC cbc = null;
        if (!this.usepcg) {
            i = 0;
            while (i < this.NX) {
                j = 0;
                while (j < this.NY) {
                    k = 0;
                    while (k < this.NZ) {
                        cbc = this.cellBC[i][j][k];
                        ncount = this.g.getM3rkIndex(this.icomponent, i, j, k);
                        double t = fy[ncount];
                        double txf = this.gpp.getDefaultvalue();
                        double txb = this.gpp.getDefaultvalue();
                        double tyf = this.gpp.getDefaultvalue();
                        double tyb = this.gpp.getDefaultvalue();
                        int ib = Math.max(0, i - 1);
                        int jb = Math.max(0, j - 1);
                        if (i != 0) {
                            txb = fy[this.g.getM3rkIndex(this.icomponent, i - 1, j, k)];
                        }
                        if (j != 0) {
                            tyb = fy[this.g.getM3rkIndex(this.icomponent, i, j - 1, k)];
                        }
                        if (i != this.NX - 1) {
                            txf = fy[this.g.getM3rkIndex(this.icomponent, i + 1, j, k)];
                        }
                        if (j != this.NY - 1) {
                            tyf = fy[this.g.getM3rkIndex(this.icomponent, i, j + 1, k)];
                        }
                        if (cbc != null) {
                            if (cbc.getTypes()[0] != null) {
                                this.pres[i][j][k] = 0.0;
                            } else {
                                if (cbc.getTypes()[1] != null) {
                                    txb = t + cbc.getTypes()[1].getValue() * this.DX / (RATIOPERMX * this.getConducXY(i, j, k, this.permx) * rxb);
                                }
                                if (cbc.getTypes()[3] != null) {
                                    tyb = t + cbc.getTypes()[3].getValue() * this.DY / (RATIOPERMY * this.getConducXY(i, j, k, this.permy) * ryb);
                                }
                                if (cbc.getTypes()[2] != null) {
                                    txf = t + cbc.getTypes()[2].getValue() * this.DX / (RATIOPERMX * this.getConducXY(i, j, k, this.permx) * rxf);
                                }
                                if (cbc.getTypes()[4] != null) {
                                    tyf = t + cbc.getTypes()[4].getValue() * this.DY / (RATIOPERMY * this.getConducXY(i, j, k, this.permy) * ryf);
                                }
                                this.pres[i][j][k] = this.overc_pres[i][j][k] * (this.hconductancei[i][j][k] * (txf - t) - this.hconductancei[ib][j][k] * (t - txb) + this.hconductancej[i][j][k] * (tyf - t) - this.hconductancej[i][jb][k] * (t - tyb));
                                if (cbc.getTypes()[7] != null) {
                                    double q = cbc.getTypes()[7].getValue();
                                    double[] dArray = this.pres[i][j];
                                    int n = k;
                                    dArray[n] = dArray[n] + this.overc_pres[i][j][k] * (q *= this.h[i][j][k] * this.g.getDx() * this.g.getDy());
                                }
                                if (cbc.getTypes()[8] != null) {
                                    this.pres[i][j][k] = 0.0;
                                }
                            }
                        } else {
                            this.pres[i][j][k] = this.overc_pres[i][j][k] * (this.hconductancei[i][j][k] * (txf - t) - this.hconductancei[ib][j][k] * (t - txb) + this.hconductancej[i][j][k] * (tyf - t) - this.hconductancej[i][jb][k] * (t - tyb));
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    ncount = this.g.getM3rkIndex(this.icomponent, i, j, k);
                    M3rk.ty[ncount] = 0.0;
                    fy[ncount] = 0.0;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        double maxdt = 0.0;
        int i3 = 0;
        while (i3 < this.NX) {
            int j3 = 0;
            while (j3 < this.NY) {
                int k3 = 0;
                while (k3 < this.NZ) {
                    if (Math.abs(this.pres[i3][j3][k3]) > maxdt) {
                        maxdt = Math.abs(this.pres[i3][j3][k3]);
                    }
                    ncount = this.g.getM3rkIndex(this.icomponent, i3, j3, k3);
                    fy[ncount] = this.pres[i3][j3][k3];
                    M3rk.ty[ncount] = fy[ncount];
                    ++k3;
                }
                ++j3;
            }
            ++i3;
        }
        if (M3rk.info[4] % 100 == 0) {
            System.out.println(" f(   PRESSURE)  + time " + this.m3rk.x / this.m3rk.fys + "  " + fy.length + "  " + this.m3rk.getGeom().maxnodes + "   max DTdt : " + maxdt);
            if (Double.isNaN(this.m3rk.x)) {
                System.out.println("shoould not reach this");
            }
        }
    }

    @Override
    public void updategeom(double timepres, double dtsec) {
    }

    @Override
    public void updategeomm3rk(double timepres, double dtsec) {
    }

    @Override
    public void finfinish() {
        if (this.usepcg) {
            int k;
            int j;
            modelpres = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELPRESSURE), modelpres);
            if (finvelx == null) {
                finvelx = new double[this.NX][this.NY][this.NZ];
            }
            if (finvely == null) {
                finvely = new double[this.NX][this.NY][this.NZ];
            }
            if (finvelz == null) {
                finvelz = new double[this.NX][this.NY][this.NZ];
            }
            int i = 0;
            while (i < this.NX) {
                j = 0;
                while (j < this.NY) {
                    k = 0;
                    while (k < this.NZ) {
                        int ncount = this.g.getM3rkIndex(this.icomponent, i, j, k);
                        this.m3rk.getGeom();
                        ModelRealisation.geotherm[ncount] = this.prespcg[i][j][k];
                        FtoolGrid3DregularGAPres.modelpres[i][j][k] = this.prespcg[i][j][k];
                        this.g.setProductionTemperatureFromPressure(this.prespcg, this.hconductancei, this.hconductancej, this.actnum, this.gpp.getBcContainer());
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            i = this.NX - 1;
            while (i >= 0) {
                j = this.NY - 1;
                while (j >= 0) {
                    k = this.NZ - 1;
                    while (k >= 0) {
                        if (i < this.NX - 1) {
                            FtoolGrid3DregularGAPres.finvelx[i + 1][j][k] = 0.5 * (this.velx[i + 1][j][k] + this.velx[i][j][k]) / this.h[i][j][k];
                        }
                        if (j < this.NY - 1) {
                            FtoolGrid3DregularGAPres.finvely[i][j + 1][k] = 0.5 * (this.vely[i][j + 1][k] + this.vely[i][j][k]) / this.h[i][j][k];
                        }
                        if (k < this.NZ - 1) {
                            FtoolGrid3DregularGAPres.finvelz[i][j][k + 1] = 0.5 * (this.velz[i][j][k + 1] + this.velz[i][j][k]) / this.DY;
                        }
                        --k;
                    }
                    --j;
                }
                --i;
            }
            int k2 = this.NZ - 1;
            while (k2 >= 0) {
                FtoolGrid3DregularGAPres.finvelx[0][0][k2] = finvelx[1][0][k2];
                FtoolGrid3DregularGAPres.finvely[0][0][k2] = finvely[0][1][k2];
                --k2;
            }
            i = this.NX - 1;
            while (i >= 0) {
                j = this.NY - 1;
                while (j >= 0) {
                    FtoolGrid3DregularGAPres.finvelz[i][j][0] = this.NZ == 1 ? 0.0 : finvelz[i][j][1];
                    --j;
                }
                --i;
            }
            i = this.NX - 1;
            while (i >= 0) {
                j = this.NY - 1;
                while (j >= 0) {
                    k = this.NZ - 1;
                    while (k >= 0) {
                        this.velx[i][j][k] = finvelx[i][j][k];
                        this.vely[i][j][k] = finvely[i][j][k];
                        this.velz[i][j][k] = finvelz[i][j][k];
                        --k;
                    }
                    --j;
                }
                --i;
            }
        }
    }

    public static void outputProp(String dir, ModelGrid g, int iformat) {
        PropertyFactory.write(AquiferProperties.IAQUIFERDEPTH, dir, "topdepth", g, iformat);
        PropertyFactory.write(AquiferProperties.IACTNUM, dir, "actnum", g, iformat);
        PropertyFactory.write(AquiferProperties.ITHICKNESS, dir, "thickness", g, iformat);
        PropertyFactory.write(AquiferProperties.IPOROSITY, dir, "porosity", g, iformat);
        PropertyFactory.write(AquiferProperties.ING, dir, "ng", g, iformat);
        PropertyFactory.write(AquiferProperties.IINITIALTEMPERATURE, dir, "temp_init", g, iformat);
        PropertyFactory.write(AquiferProperties.ICALC_RANFACTORS, dir, "ranfactors", g, iformat);
        PropertyFactory.write(AquiferProperties.IPERMEABILITYI, dir, "permx", g, iformat);
        PropertyFactory.write(AquiferProperties.IPERMEABILITYJ, dir, "permx", g, iformat);
        PropertyFactory.write(AquiferProperties.IPERMEABILITYK, dir, "permz", g, iformat);
    }

    public static void calculate2D() {
        M3rk m = new M3rk(0.001);
        FtoolGrid2DregularGAPres ftool = new FtoolGrid2DregularGAPres(m);
        String dir = "C:\\Users\\Public\\wees\\data\\tests\\aquifer\\";
        double temperature = 65.0;
        double starttime = 0.0;
        int IMODELGEOM = 2;
        AquiferProperties.instantiateProperties(IMODELGEOM);
        Property pmodel = PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE);
        pmodel.setDefaultvalue(temperature);
        Property pinitial = PropertyFactory.getProperty(AquiferProperties.IINITIALTEMPERATURE);
        pinitial.setDefaultvalue(temperature);
        GAPropertiesTemp gp = new GAPropertiesTemp(pmodel, pinitial);
        pmodel = PropertyFactory.getProperty(AquiferProperties.IMODELPRESSURE);
        pmodel.setDefaultvalue(0.0);
        pinitial = PropertyFactory.getProperty(AquiferProperties.IINITIALPRESSURE);
        pinitial.setDefaultvalue(0.0);
        GAPropertiesPres gpp = new GAPropertiesPres(pmodel, pinitial);
        ModelComponentContainer mcc = new ModelComponentContainer();
        mcc.add(gp);
        mcc.add(gpp);
        double thickness = PropertyFactory.getProperty(AquiferProperties.ITHICKNESS).getDefaultvalue();
        boolean nlayers = true;
        double layerthickness = thickness / (double)nlayers;
        Grid2Dregular g = new Grid2Dregular(mcc, starttime, 0.0, 0.0, 100, 100, 50.0, 50.0, 1.0);
        PropertyFactory.getProperty(AquiferProperties.ITHICKNESS).setDefaultvalue(layerthickness);
        PropertyFactory.updateGeometry(g);
        g.initializeValues();
        WellPerforation wp1 = new WellPerforation(1500.0, 2500.0, 0.044444444444444446, 30.0, 60.0, 0.08960000000000001, g);
        WellPerforation wp2 = new WellPerforation(3000.0, 2500.0, -0.044444444444444446, -1.0, -40.0, 0.08960000000000001, g);
        g.addWellPerforation(wp1);
        g.addWellPerforation(wp2);
        g.getWpContainer().initializeWellBC(gp, g.getNz());
        g.calculateVelfromWP(1);
        g.initializeBC();
        g.setUseVelocities(true);
        m.addftool(ftool);
        Step s = new Step();
        int it = 0;
        while (it <= 200) {
            s.update(g, g.timepres, it, it, ftool.id);
            m.dostepForward(s, g);
            g.output(0, it == 0, String.valueOf(dir) + "temp" + it, 0);
            g.output(1, it == 0, String.valueOf(dir) + "pres" + it, 0);
            g.outputWells(mcc.size(), it == 0, it, ftool.viscosity, ftool.salinity, ftool.totalpres);
            it += 5;
        }
        g.outputWells2File(dir);
        FtoolGrid3DregularGAPres.outputProp(dir, g, 0);
    }

    public static void calculate3D() {
        M3rk m = new M3rk(0.001);
        FtoolGrid3DregularGAPres ftool = new FtoolGrid3DregularGAPres(m);
        String dir = "C:\\Users\\Public\\wees\\data\\tests\\aquifer\\";
        double temperature = 65.0;
        double starttime = 0.0;
        int IMODELGEOM = 3;
        AquiferProperties.instantiateProperties(IMODELGEOM);
        Property pmodel = PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE);
        pmodel.setDefaultvalue(temperature);
        Property pinitial = PropertyFactory.getProperty(AquiferProperties.IINITIALTEMPERATURE);
        pinitial.setDefaultvalue(temperature);
        GAPropertiesTemp gp = new GAPropertiesTemp(pmodel, pinitial);
        pmodel = PropertyFactory.getProperty(AquiferProperties.IMODELPRESSURE);
        pmodel.setDefaultvalue(0.0);
        pinitial = PropertyFactory.getProperty(AquiferProperties.IINITIALPRESSURE);
        pinitial.setDefaultvalue(0.0);
        GAPropertiesPres gpp = new GAPropertiesPres(pmodel, pinitial);
        ModelComponentContainer mcc = new ModelComponentContainer();
        mcc.add(gp);
        mcc.add(gpp);
        double thickness = PropertyFactory.getProperty(AquiferProperties.ITHICKNESS).getDefaultvalue();
        int nlayers = 10;
        double layerthickness = 5.0 * thickness / (double)nlayers;
        Grid3Dregular g = new Grid3Dregular(mcc, starttime, 0.0, 0.0, 0.0, 100, 100, nlayers, 50.0, 50.0, layerthickness);
        PropertyFactory.getProperty(AquiferProperties.ITHICKNESS).setDefaultvalue(layerthickness);
        PropertyFactory.updateGeometry(g);
        g.initializeValues();
        WellPerforation wp1 = new WellPerforation(1500.0, 2500.0, 0.044444444444444446, 30.0, 60.0, 0.08960000000000001, g);
        wp1.setKstart(4);
        wp1.setKend(6);
        WellPerforation wp2 = new WellPerforation(3000.0, 2500.0, -0.044444444444444446, -1.0, -40.0, 0.08960000000000001, g);
        wp2.setKstart(4);
        wp2.setKend(6);
        g.addWellPerforation(wp1);
        g.addWellPerforation(wp2);
        g.getWpContainer().initializeWellBC(gp, g.getNz());
        g.getWpContainer().initializeWellBC(gpp, g.getNz());
        g.calculateVelfromWP(1);
        g.initializeBC();
        g.setUseVelocities(true);
        m.addftool(ftool);
        Step s = new Step();
        double[][][] val = null;
        int it = 0;
        while (it <= 50) {
            s.update(g, g.timepres, it, it, ftool.id);
            m.dostepForward(s, g);
            Voxet v = PropertyFactory.getVoxet(dir, "temp" + it, g, g.getVoxetValues(false, 0, val));
            VoxetWriter.write(v);
            v = PropertyFactory.getVoxet(dir, "pres" + it, g, g.getVoxetValues(false, ftool.icomponent, val));
            VoxetWriter.write(v);
            v = PropertyFactory.getVoxet(dir, "velx", g, g.getVelx());
            VoxetWriter.write(v);
            v = PropertyFactory.getVoxet(dir, "vely", g, g.getVely());
            VoxetWriter.write(v);
            v = PropertyFactory.getVoxet(dir, "velz", g, g.getVelz());
            VoxetWriter.write(v);
            g.outputWellsTempPres(mcc.size(), it == 0, it, gpp.getBcContainer(), ftool.viscosity, ftool.salinity, ftool.totalpres);
            it += 5;
        }
        g.outputWells2File(dir);
        FtoolGrid3DregularGAPres.outputProp(dir, g, 0);
    }

    public static void main(String[] args) {
        FtoolGrid3DregularGAPres.calculate3D();
    }
}

