/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.model.model3d;

import tno.geoenergy.TnoWaterProperties;
import tno.geoenergy.fdintegration.integration.Ftool;
import tno.geoenergy.fdintegration.integration.M3rk;
import tno.geoenergy.fdintegration.integration.Step;
import tno.geoenergy.fdintegration.model.CellBC;
import tno.geoenergy.fdintegration.model.GAPropertiesTemp;
import tno.geoenergy.fdintegration.model.ModelComponentContainer;
import tno.geoenergy.fdintegration.model.WellPerforation;
import tno.geoenergy.fdintegration.model.model3d.Grid3Dregular;
import tno.geoenergy.properties.AquiferProperties;
import tno.geoenergy.properties.Property;
import tno.geoenergy.properties.PropertyFactory;

public class FtoolGrid3DregularGATemp
extends Ftool {
    public static double INFINITE_MINTIME = 50000.0;
    private GAPropertiesTemp gp = null;
    Grid3Dregular g = null;
    int NX = 0;
    int NY = 0;
    int NZ = 0;
    double DX = 0.0;
    double DY = 0.0;
    double DZ = 0.0;
    double DX2 = 0.0;
    double DY2 = 0.0;
    double DZ2 = 0.0;
    double OVERDX = 0.0;
    double OVERDX2 = 0.0;
    double OVERDY = 0.0;
    double OVERDY2 = 0.0;
    private final double LMULTFD = 1.0;
    private double[][][] temp = null;
    double[][][] velx = null;
    double[][][] vely = null;
    double[][][] velz = null;
    private CellBC[][][] cellBC = null;
    private double[][][] initialtemperature = null;
    private double[][][] conduc = null;
    private double[][][] conductancei = null;
    private double[][][] conductancej = null;
    private double[][][] conductancek = null;
    double[][][] porosity;
    double[][][] c;
    double[][][] overc;
    double[][][] ratiowaterrhocp;
    double[][][] h;
    double[][][] ng;
    double[][] topdepth;
    double[][][] reftemp = null;
    double[][][] diftemp = null;
    double[][][] connectxmin_temp = null;
    double[][][] connectxplus_temp = null;
    double[][][] connectymin_temp = null;
    double[][][] connectyplus_temp = null;
    double[][][] connectzmin_temp = null;
    double[][][] connectzplus_temp = null;
    double[][][] actnumtemp = null;
    private int icomponent = 0;
    boolean firstpassafterprepf = false;
    double basetime = 0.0;
    boolean fixtemptopbottom = false;
    boolean includewall = false;
    double rockdiffusivity;
    double rockconductivity;

    public FtoolGrid3DregularGATemp(M3rk m3rk) {
        super(m3rk);
        this.id = "grid3dregular_temp";
        this.m3rk = m3rk;
    }

    private void scaleOverc() {
        double LMULT = 1.0;
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    if (k == 0) {
                        double[] dArray = this.overc[i][j];
                        int n = k;
                        dArray[n] = dArray[n] * LMULT;
                    }
                    if (k == this.NZ - 1) {
                        double[] dArray = this.overc[i][j];
                        int n = k;
                        dArray[n] = dArray[n] * LMULT;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void prepf() {
        this.gp = (GAPropertiesTemp)this.m3rk.getGeom().getGpContainer().getModelComponent(this.icomponent);
        this.g = (Grid3Dregular)this.m3rk.getGeom();
        this.temp = this.g.getValues()[0];
        this.cellBC = this.g.getBC(this.gp);
        this.NY = this.g.getNy();
        this.NX = this.g.getNx();
        this.NZ = this.g.getNz();
        this.DY = this.g.getDy();
        this.DX = this.g.getDx();
        this.DX2 = this.DX * this.DX;
        this.DY2 = this.DY * this.DY;
        this.OVERDX = 1.0 / this.DX;
        this.OVERDX2 = 1.0 / this.DX2;
        this.OVERDY = 1.0 / this.DY;
        this.OVERDY2 = 1.0 / this.DY2;
        this.c = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_T_C), this.c);
        this.overc = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_T_OVERC), this.overc);
        this.ratiowaterrhocp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_T_RATIORHOCP), this.ratiowaterrhocp);
        this.porosity = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IPOROSITY), this.porosity);
        this.h = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ITHICKNESS), this.h);
        this.ng = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ING), this.ng);
        this.topdepth = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IAQUIFERDEPTH), this.topdepth);
        this.initialtemperature = PropertyFactory.getValues(this.gp.getInitialvalues(), this.initialtemperature);
        double rhorock = PropertyFactory.getProperty(AquiferProperties.IROCKDENSITY).getDefaultvalue();
        double crock = PropertyFactory.getProperty(AquiferProperties.IROCKHEATCAPACITY).getDefaultvalue();
        double rhocprock = rhorock * crock;
        double salinity = PropertyFactory.getProperty(AquiferProperties.IWATERSALINITY).getDefaultvalue();
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                double depth = this.topdepth[i][j] - 0.5 * this.h[i][j][0];
                int k = 0;
                while (k < this.NZ) {
                    double pres = (depth += this.h[i][j][k]) * 0.1;
                    double rhowater = TnoWaterProperties.Density(pres * 100000.0, this.temp[i][j][k], salinity * 1.0E-6);
                    double cwater = TnoWaterProperties.HeatCapacity(pres * 100000.0, this.temp[i][j][k], salinity * 1.0E-6);
                    this.c[i][j][k] = this.porosity[i][j][k] * rhowater * cwater + (1.0 - this.porosity[i][j][k]) * rhocprock;
                    this.overc[i][j][k] = 1.0 / (this.c[i][j][k] * this.h[i][j][k] * this.g.getDx() * this.g.getDy());
                    this.ratiowaterrhocp[i][j][k] = rhowater * cwater / this.c[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.scaleOverc();
        this.conduc = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_T_CONDUC), this.conduc);
        this.conductancei = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_T_CONDUCTANCEI), this.conductancei);
        this.conductancej = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_T_CONDUCTANCEJ), this.conductancej);
        this.conductancek = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_T_CONDUCTANCEK), this.conductancek);
        this.actnumtemp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IACTNUMTEMP), this.actnumtemp);
        this.connectxmin_temp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTXMINTEMP), this.connectxmin_temp);
        this.connectxplus_temp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTXPLUSTEMP), this.connectxplus_temp);
        this.connectymin_temp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTYMINTEMP), this.connectymin_temp);
        this.connectyplus_temp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTYPLUSTEMP), this.connectyplus_temp);
        this.connectzmin_temp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTZMINTEMP), this.connectzmin_temp);
        this.connectzplus_temp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICONNECTZPLUSTEMP), this.connectzplus_temp);
        double rockconduc = PropertyFactory.getProperty(AquiferProperties.IROCKCONDUCTIVITY).getDefaultvalue();
        double waterconduc = PropertyFactory.getProperty(AquiferProperties.IWATERCONDUCTIVITY).getDefaultvalue();
        this.rockconductivity = 0.0;
        int i2 = 0;
        while (i2 < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.conduc[i2][j][k] = TnoWaterProperties.getMixedLithologyConductivity(waterconduc, rockconduc, this.porosity[i2][j][k]);
                    this.rockconductivity += this.conduc[i2][j][k];
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        this.rockconductivity /= (double)(this.NX * this.NY * this.NZ);
        this.basetime = this.g.timepres * 3.15576E7;
        this.includewall = Math.abs(PropertyFactory.getProperty(AquiferProperties.ISWITCH_INCLUDEWALL).getDefaultvalue() - 1.0) < 0.001;
        this.fixtemptopbottom = Math.abs(PropertyFactory.getProperty(AquiferProperties.ISWITCH_FIXTEMPTOPBOTTOM).getDefaultvalue() - 1.0) < 0.001;
        this.rockdiffusivity = this.rockconductivity / rhocprock;
        int i3 = 0;
        while (i3 < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    double c2;
                    double kh1 = this.h[i3][j][k] * this.conduc[i3][j][k];
                    double dl1 = this.g.getDx();
                    double kh2 = i3 < this.NX - 1 ? this.h[i3 + 1][j][k] * this.conduc[i3 + 1][j][k] : kh1;
                    double dl2 = this.g.getDx();
                    this.conductancei[i3][j][k] = c2 = 2.0 * this.g.getDy() * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                    kh1 = this.h[i3][j][k] * this.conduc[i3][j][k];
                    dl1 = this.g.getDy();
                    kh2 = j < this.NY - 1 ? this.h[i3][j + 1][k] * this.conduc[i3][j + 1][k] : kh1;
                    dl2 = this.g.getDy();
                    this.conductancej[i3][j][k] = c2 = 2.0 * this.g.getDx() * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                    kh1 = this.g.getDx() * this.conduc[i3][j][k];
                    dl1 = this.h[i3][j][k];
                    if (k == 0 || k == this.NZ - 1) {
                        dl1 *= 1.0;
                    }
                    if (k < this.NZ - 1) {
                        kh2 = this.g.getDx() * this.conduc[i3][j][k + 1];
                        dl2 = this.h[i3][j][k + 1];
                        if (k == this.NZ - 2) {
                            dl2 *= 1.0;
                        }
                    } else {
                        kh2 = kh1;
                        dl2 = dl1;
                    }
                    this.conductancek[i3][j][k] = c2 = 2.0 * this.g.getDy() * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        if (this.g.isUseVelocities()) {
            this.velx = this.g.getVelx();
            this.vely = this.g.getVely();
            this.velz = this.g.getVelz();
        }
        System.out.println("ratiowaterrhocp " + this.ratiowaterrhocp);
        this.firstpassafterprepf = true;
    }

    protected void updateModelledTemperature(double[] fy) {
        this.reftemp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE), this.reftemp);
        this.diftemp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELDIFTEMPERATURE), this.reftemp);
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    double t;
                    this.reftemp[i][j][k] = t = fy[this.g.getM3rkIndex(this.icomponent, i, j, k)];
                    this.diftemp[i][j][k] = this.reftemp[i][j][k] - this.initialtemperature[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void f(double[] fy) {
        boolean isEclipseGridInput;
        boolean bl = isEclipseGridInput = PropertyFactory.getProperty(AquiferProperties.IMASKGEOM).getDefaultvalue() == 1.0;
        if (isEclipseGridInput) {
            this.fEclipse(fy);
        } else {
            this.fRegular(fy);
        }
    }

    public void fRegular(double[] fy) {
        int ncount;
        int k;
        int j;
        double inf_time = Math.max(this.basetime + this.m3rk.x, INFINITE_MINTIME);
        double length_infinite = Math.pow(this.rockdiffusivity * inf_time / Math.PI, 0.5);
        if (this.firstpassafterprepf) {
            this.updateModelledTemperature(fy);
            this.firstpassafterprepf = false;
        }
        int i = 0;
        while (i < this.NX) {
            int j2 = 0;
            while (j2 < this.NY) {
                int k2 = 0;
                while (k2 < this.NZ) {
                    this.temp[i][j2][k2] = 0.0;
                    ++k2;
                }
                ++j2;
            }
            ++i;
        }
        if (this.g.isUseVelocities()) {
            this.velx = this.g.getVelx();
            this.vely = this.g.getVely();
            this.velz = this.g.getVelz();
        }
        int iklow = 0;
        int ikhigh = this.NZ;
        if (this.fixtemptopbottom && this.NZ != 1) {
            ++iklow;
            --ikhigh;
        }
        boolean fixtempsides = !this.fixtemptopbottom;
        int iilow = 0;
        int iihigh = this.NX;
        int ijlow = 0;
        int ijhigh = this.NY;
        if (fixtempsides) {
            ++iilow;
            --iihigh;
            ++ijlow;
            --ijhigh;
        }
        int i2 = iilow;
        while (i2 < iihigh) {
            j = ijlow;
            while (j < ijhigh) {
                k = iklow;
                while (k < ikhigh) {
                    double t;
                    CellBC cbc = this.cellBC[i2][j][k];
                    ncount = this.g.getM3rkIndex(this.icomponent, i2, j, k);
                    double txf = t = fy[ncount];
                    double txb = t;
                    double tyf = t;
                    double tyb = t;
                    double tzf = t;
                    double tzb = t;
                    if (i2 != this.NX - 1) {
                        txf = fy[this.g.getM3rkIndex(this.icomponent, i2 + 1, j, k)];
                    }
                    if (i2 != 0) {
                        txb = fy[this.g.getM3rkIndex(this.icomponent, i2 - 1, j, k)];
                    }
                    if (i2 == 0) {
                        txb = txf;
                    }
                    if (i2 == this.NX - 1) {
                        txf = txb;
                    }
                    if (j != this.NY - 1) {
                        tyf = fy[this.g.getM3rkIndex(this.icomponent, i2, j + 1, k)];
                    }
                    if (j != 0) {
                        tyb = fy[this.g.getM3rkIndex(this.icomponent, i2, j - 1, k)];
                    }
                    if (j == 0) {
                        tyb = tyf;
                    }
                    if (j == this.NY - 1) {
                        tyf = tyb;
                    }
                    if (k != this.NZ - 1) {
                        tzf = fy[this.g.getM3rkIndex(this.icomponent, i2, j, k + 1)];
                    }
                    if (k != 0) {
                        tzb = fy[this.g.getM3rkIndex(this.icomponent, i2, j, k - 1)];
                    }
                    if (k == 0) {
                        tzb = tzf;
                    }
                    if (k == this.NZ - 1) {
                        tzf = tzb;
                    }
                    if (fixtempsides) {
                        if (i2 == this.NX - 2) {
                            txf = this.initialtemperature[i2 + 1][j][k];
                        }
                        if (i2 == 1) {
                            txb = this.initialtemperature[i2 - 1][j][k];
                        }
                        if (j == this.NY - 2) {
                            tyf = this.initialtemperature[i2][j + 1][k];
                        }
                        if (j == 1) {
                            tyb = this.initialtemperature[i2][j - 1][k];
                        }
                    }
                    if (cbc != null && cbc.getTypes()[0] != null) {
                        this.temp[i2][j][k] = 0.0;
                    } else {
                        int imin = Math.max(0, i2 - 1);
                        int jmin = Math.max(0, j - 1);
                        this.temp[i2][j][k] = this.overc[i2][j][k] * (this.conductancei[i2][j][k] * (txf - t) - this.conductancei[imin][j][k] * (t - txb) + this.conductancej[i2][j][k] * (tyf - t) - this.conductancej[i2][jmin][k] * (t - tyb));
                        if (!this.fixtemptopbottom) {
                            if (k != 0) {
                                double[] dArray = this.temp[i2][j];
                                int n = k;
                                dArray[n] = dArray[n] - this.overc[i2][j][k] * (this.conductancek[i2][j][k - 1] * (t - tzb));
                            }
                            if (k != this.NZ - 1) {
                                double[] dArray = this.temp[i2][j];
                                int n = k;
                                dArray[n] = dArray[n] + this.overc[i2][j][k] * (this.conductancek[i2][j][k] * (tzf - t));
                            }
                        } else if (k != 0 && k != this.NZ - 1) {
                            double[] dArray = this.temp[i2][j];
                            int n = k;
                            dArray[n] = dArray[n] - this.overc[i2][j][k] * (this.conductancek[i2][j][k - 1] * (t - tzb));
                            double[] dArray2 = this.temp[i2][j];
                            int n2 = k;
                            dArray2[n2] = dArray2[n2] + this.overc[i2][j][k] * (this.conductancek[i2][j][k] * (tzf - t));
                        }
                        if (this.g.isUseVelocities()) {
                            double hh;
                            double facx = 0.5;
                            double facy = 0.5;
                            double facz = 0.5;
                            if (Math.abs(this.velx[i2][j][k]) > 1.0E-15) {
                                if (i2 > 0 && this.velx[i2 - 1][j][k] / this.velx[i2][j][k] < 0.0) {
                                    facx = 1.0;
                                }
                            } else {
                                facx = 1.0;
                            }
                            if (Math.abs(this.vely[i2][j][k]) > 1.0E-15) {
                                if (i2 > 0 && this.vely[i2 - 1][j][k] / this.vely[i2][j][k] < 0.0) {
                                    facy = 1.0;
                                }
                            } else {
                                facy = 1.0;
                            }
                            if (Math.abs(this.velz[i2][j][k]) > 1.0E-15) {
                                if (k >= 1 && this.velz[i2][j][k - 1] / this.velz[i2][j][k] < 0.0) {
                                    facz = 1.0;
                                }
                            } else {
                                facz = 1.0;
                            }
                            if (i2 > 0) {
                                if (this.velx[i2 - 1][j][k] > 0.0) {
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] + -facx * (t - txb) * this.velx[i2 - 1][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDX / this.h[i2][j][k];
                                } else {
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] + -facx * (txf - t) * this.velx[i2 - 1][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDX / this.h[i2][j][k];
                                }
                            }
                            if (j > 0) {
                                if (this.vely[i2][j - 1][k] > 0.0) {
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] + -facy * (t - tyb) * this.vely[i2][j - 1][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDY / this.h[i2][j][k];
                                } else {
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] + -facy * (tyf - t) * this.vely[i2][j - 1][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDY / this.h[i2][j][k];
                                }
                            }
                            if (k > 0) {
                                hh = 0.5 * (this.h[i2][j][k] + this.h[i2][j][k - 1]);
                                if (this.velz[i2][j][k - 1] > 0.0) {
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] + -facz * (t - tzb) * this.velz[i2][j][k - 1] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] / (this.DY * hh);
                                } else {
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] + -facz * (tzf - t) * this.velz[i2][j][k - 1] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] / (this.DY * hh);
                                }
                            }
                            if (this.velx[i2][j][k] > 0.0) {
                                double[] dArray = this.temp[i2][j];
                                int n = k;
                                dArray[n] = dArray[n] + -facx * (t - txb) * this.velx[i2][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDX / this.h[i2][j][k];
                            } else {
                                double[] dArray = this.temp[i2][j];
                                int n = k;
                                dArray[n] = dArray[n] + -facx * (txf - t) * this.velx[i2][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDX / this.h[i2][j][k];
                            }
                            if (this.vely[i2][j][k] > 0.0) {
                                double[] dArray = this.temp[i2][j];
                                int n = k;
                                dArray[n] = dArray[n] + -facy * (t - tyb) * this.vely[i2][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDY / this.h[i2][j][k];
                            } else {
                                double[] dArray = this.temp[i2][j];
                                int n = k;
                                dArray[n] = dArray[n] + -facy * (tyf - t) * this.vely[i2][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDY / this.h[i2][j][k];
                            }
                            if (k < this.NZ - 1) {
                                hh = 0.5 * (this.h[i2][j][k] + this.h[i2][j][k + 1]);
                                if (this.velz[i2][j][k] > 0.0) {
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] + -facz * (t - tzb) * this.velz[i2][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] / (this.DY * hh);
                                } else {
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] + -facz * (tzf - t) * this.velz[i2][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] / (this.DY * hh);
                                }
                            }
                            if (!this.fixtemptopbottom && this.includewall && (k == 0 || k == this.NZ - 1)) {
                                ncount = this.g.getM3rkIndex(this.icomponent, i2, j, k);
                                double initialtemperature = Grid3Dregular.inigeotherm[ncount];
                                double q = 0.5 * this.rockconductivity * (initialtemperature - t) / length_infinite;
                                double[] dArray = this.temp[i2][j];
                                int n = k;
                                dArray[n] = dArray[n] + (q *= this.overc[i2][j][k] * this.DX * this.DY);
                            }
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    ncount = this.g.getM3rkIndex(this.icomponent, i2, j, k);
                    M3rk.ty[ncount] = 0.0;
                    fy[ncount] = 0.0;
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        double maxdt = 0.0;
        int i3 = 0;
        while (i3 < this.NX) {
            int j3 = 0;
            while (j3 < this.NY) {
                int k3 = 0;
                while (k3 < this.NZ) {
                    if (Math.abs(this.temp[i3][j3][k3]) > maxdt) {
                        maxdt = Math.abs(this.temp[i3][j3][k3]);
                    }
                    ncount = this.g.getM3rkIndex(this.icomponent, i3, j3, k3);
                    fy[ncount] = this.temp[i3][j3][k3];
                    M3rk.ty[ncount] = fy[ncount];
                    ++k3;
                }
                ++j3;
            }
            ++i3;
        }
        if (M3rk.info[4] % 100 == 0) {
            System.out.println(" f(TEMPERATURE)  + time " + this.m3rk.x / this.m3rk.fys + "  " + fy.length + "  " + this.m3rk.getGeom().maxnodes + "   max DTdt : " + maxdt + "[" + this.m3rk.n + "]");
            if (Double.isNaN(this.m3rk.x)) {
                System.out.println("shoould not reach this");
            }
        }
    }

    public void fEclipse(double[] fy) {
        int ncount;
        int k;
        int j;
        double inf_time = Math.max(this.basetime + this.m3rk.x, INFINITE_MINTIME);
        double length_infinite = Math.pow(this.rockdiffusivity * inf_time / Math.PI, 0.5);
        if (this.firstpassafterprepf) {
            this.updateModelledTemperature(fy);
            this.firstpassafterprepf = false;
        }
        int i = 0;
        while (i < this.NX) {
            int j2 = 0;
            while (j2 < this.NY) {
                int k2 = 0;
                while (k2 < this.NZ) {
                    this.temp[i][j2][k2] = 0.0;
                    ++k2;
                }
                ++j2;
            }
            ++i;
        }
        if (this.g.isUseVelocities()) {
            this.velx = this.g.getVelx();
            this.vely = this.g.getVely();
            this.velz = this.g.getVelz();
        }
        int iklow = 0;
        int ikhigh = this.NZ;
        if (this.fixtemptopbottom && this.NZ != 1) {
            ++iklow;
            --ikhigh;
        }
        boolean fixtempsides = !this.fixtemptopbottom;
        int iilow = 0;
        int iihigh = this.NX;
        int ijlow = 0;
        int ijhigh = this.NY;
        if (fixtempsides) {
            ++iilow;
            --iihigh;
            ++ijlow;
            --ijhigh;
        }
        int i2 = iilow;
        while (i2 < iihigh) {
            j = ijlow;
            while (j < ijhigh) {
                k = iklow;
                while (k < ikhigh) {
                    if (this.actnumtemp[i2][j][k] > 0.0) {
                        double tzb;
                        double tzf;
                        CellBC cbc = this.cellBC[i2][j][k];
                        ncount = this.g.getM3rkIndex(this.icomponent, i2, j, k);
                        double t = fy[ncount];
                        int xplus = (int)this.connectxplus_temp[i2][j][k];
                        int xmin = (int)this.connectxmin_temp[i2][j][k];
                        int yplus = (int)this.connectyplus_temp[i2][j][k];
                        int ymin = (int)this.connectymin_temp[i2][j][k];
                        int zplus = (int)this.connectzplus_temp[i2][j][k];
                        int zmin = (int)this.connectzmin_temp[i2][j][k];
                        double txf = xplus > 0 ? fy[this.g.getM3rkIndex(this.icomponent, xplus, j, k)] : t;
                        double txb = xmin >= 0 ? fy[this.g.getM3rkIndex(this.icomponent, xmin, j, k)] : t;
                        double tyf = yplus > 0 ? fy[this.g.getM3rkIndex(this.icomponent, i2, yplus, k)] : t;
                        double tyb = ymin >= 0 ? fy[this.g.getM3rkIndex(this.icomponent, i2, ymin, k)] : t;
                        if (k != this.NZ - 1 && this.connectzplus_temp[i2][j][k] > 0.0) {
                            zplus = (int)this.connectzplus_temp[i2][j][k];
                            tzf = fy[this.g.getM3rkIndex(this.icomponent, i2, j, zplus)];
                        } else {
                            tzf = t;
                        }
                        if (k != 0 && this.connectzmin_temp[i2][j][k] >= 0.0) {
                            zmin = (int)this.connectzmin_temp[i2][j][k];
                            tzb = fy[this.g.getM3rkIndex(this.icomponent, i2, j, zmin)];
                        } else {
                            tzb = t;
                        }
                        if (fixtempsides) {
                            if (i2 == this.NX - 2 || this.connectxplus_temp[i2][j][k] < 0.0) {
                                txf = this.initialtemperature[i2 + 1][j][k];
                            }
                            if (i2 == 1 || this.connectxmin_temp[i2][j][k] < 0.0) {
                                txb = this.initialtemperature[i2 - 1][j][k];
                            }
                            if (j == this.NY - 2 || this.connectyplus_temp[i2][j][k] < 0.0) {
                                tyf = this.initialtemperature[i2][j + 1][k];
                            }
                            if (j == 1 || this.connectymin_temp[i2][j][k] < 0.0) {
                                tyb = this.initialtemperature[i2][j - 1][k];
                            }
                        }
                        if (cbc != null && cbc.getTypes()[0] != null) {
                            this.temp[i2][j][k] = 0.0;
                        } else {
                            int imin = Math.max(0, xmin);
                            int jmin = Math.max(0, ymin);
                            this.temp[i2][j][k] = this.overc[i2][j][k] * (this.conductancei[i2][j][k] * (txf - t) - this.conductancei[imin][j][k] * (t - txb) + this.conductancej[i2][j][k] * (tyf - t) - this.conductancej[i2][jmin][k] * (t - tyb));
                            if (!this.fixtemptopbottom) {
                                zmin = (int)this.connectzmin_temp[i2][j][k];
                                if (zmin >= 0 && k != 0) {
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] - this.overc[i2][j][k] * (this.conductancek[i2][j][zmin] * (t - tzb));
                                }
                                if (k != this.NZ - 1) {
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] + this.overc[i2][j][k] * (this.conductancek[i2][j][k] * (tzf - t));
                                }
                            } else if (k != 0 && k != this.NZ - 1) {
                                zmin = (int)this.connectzmin_temp[i2][j][k];
                                if (zmin >= 0) {
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] - this.overc[i2][j][k] * (this.conductancek[i2][j][zmin] * (t - tzb));
                                }
                                double[] dArray = this.temp[i2][j];
                                int n = k;
                                dArray[n] = dArray[n] + this.overc[i2][j][k] * (this.conductancek[i2][j][k] * (tzf - t));
                            }
                            if (this.g.isUseVelocities()) {
                                double hh;
                                double facx = 0.5;
                                double facy = 0.5;
                                double facz = 0.5;
                                if (Math.abs(this.velx[i2][j][k]) > 1.0E-15) {
                                    if (i2 > 0 && this.velx[i2 - 1][j][k] / this.velx[i2][j][k] < 0.0) {
                                        facx = 1.0;
                                    }
                                } else {
                                    facx = 1.0;
                                }
                                if (Math.abs(this.vely[i2][j][k]) > 1.0E-15) {
                                    if (i2 > 0 && this.vely[i2 - 1][j][k] / this.vely[i2][j][k] < 0.0) {
                                        facy = 1.0;
                                    }
                                } else {
                                    facy = 1.0;
                                }
                                if (Math.abs(this.velz[i2][j][k]) > 1.0E-15) {
                                    if (k >= 1 && this.velz[i2][j][k - 1] / this.velz[i2][j][k] < 0.0) {
                                        facz = 1.0;
                                    }
                                } else {
                                    facz = 1.0;
                                }
                                if (i2 > 0) {
                                    if (this.velx[i2 - 1][j][k] > 0.0) {
                                        double[] dArray = this.temp[i2][j];
                                        int n = k;
                                        dArray[n] = dArray[n] + -facx * (t - txb) * this.velx[i2 - 1][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDX / this.h[i2][j][k];
                                    } else {
                                        double[] dArray = this.temp[i2][j];
                                        int n = k;
                                        dArray[n] = dArray[n] + -facx * (txf - t) * this.velx[i2 - 1][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDX / this.h[i2][j][k];
                                    }
                                }
                                if (j > 0) {
                                    if (this.vely[i2][j - 1][k] > 0.0) {
                                        double[] dArray = this.temp[i2][j];
                                        int n = k;
                                        dArray[n] = dArray[n] + -facy * (t - tyb) * this.vely[i2][j - 1][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDY / this.h[i2][j][k];
                                    } else {
                                        double[] dArray = this.temp[i2][j];
                                        int n = k;
                                        dArray[n] = dArray[n] + -facy * (tyf - t) * this.vely[i2][j - 1][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDY / this.h[i2][j][k];
                                    }
                                }
                                if (k > 0 && zmin >= 0) {
                                    hh = 0.5 * (this.h[i2][j][k] + this.h[i2][j][zmin]);
                                    if (this.velz[i2][j][zmin] > 0.0) {
                                        double[] dArray = this.temp[i2][j];
                                        int n = k;
                                        dArray[n] = dArray[n] + -facz * (t - tzb) * this.velz[i2][j][zmin] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] / (this.DY * hh);
                                    } else {
                                        double[] dArray = this.temp[i2][j];
                                        int n = k;
                                        dArray[n] = dArray[n] + -facz * (tzf - t) * this.velz[i2][j][zmin] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] / (this.DY * hh);
                                    }
                                }
                                if (this.velx[i2][j][k] > 0.0) {
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] + -facx * (t - txb) * this.velx[i2][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDX / this.h[i2][j][k];
                                } else {
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] + -facx * (txf - t) * this.velx[i2][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDX / this.h[i2][j][k];
                                }
                                if (this.vely[i2][j][k] > 0.0) {
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] + -facy * (t - tyb) * this.vely[i2][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDY / this.h[i2][j][k];
                                } else {
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] + -facy * (tyf - t) * this.vely[i2][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] * this.OVERDY / this.h[i2][j][k];
                                }
                                if (k < this.NZ - 1 && zplus > 0) {
                                    hh = 0.5 * (this.h[i2][j][k] + this.h[i2][j][zplus]);
                                    if (this.velz[i2][j][k] > 0.0) {
                                        double[] dArray = this.temp[i2][j];
                                        int n = k;
                                        dArray[n] = dArray[n] + -facz * (t - tzb) * this.velz[i2][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] / (this.DY * hh);
                                    } else {
                                        double[] dArray = this.temp[i2][j];
                                        int n = k;
                                        dArray[n] = dArray[n] + -facz * (tzf - t) * this.velz[i2][j][k] * this.porosity[i2][j][k] * this.ng[i2][j][k] * this.ratiowaterrhocp[i2][j][k] / (this.DY * hh);
                                    }
                                }
                                if (!this.fixtemptopbottom && this.includewall && (k == 0 || k == this.NZ - 1)) {
                                    ncount = this.g.getM3rkIndex(this.icomponent, i2, j, k);
                                    double initialtemperature = Grid3Dregular.inigeotherm[ncount];
                                    double q = 0.5 * this.rockconductivity * (initialtemperature - t) / length_infinite;
                                    double[] dArray = this.temp[i2][j];
                                    int n = k;
                                    dArray[n] = dArray[n] + (q *= this.overc[i2][j][k] * this.DX * this.DY);
                                }
                            }
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    ncount = this.g.getM3rkIndex(this.icomponent, i2, j, k);
                    M3rk.ty[ncount] = 0.0;
                    fy[ncount] = 0.0;
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        double maxdt = 0.0;
        int i3 = 0;
        while (i3 < this.NX) {
            int j3 = 0;
            while (j3 < this.NY) {
                int k3 = 0;
                while (k3 < this.NZ) {
                    if (Math.abs(this.temp[i3][j3][k3]) > maxdt) {
                        maxdt = Math.abs(this.temp[i3][j3][k3]);
                    }
                    ncount = this.g.getM3rkIndex(this.icomponent, i3, j3, k3);
                    fy[ncount] = this.temp[i3][j3][k3];
                    M3rk.ty[ncount] = fy[ncount];
                    ++k3;
                }
                ++j3;
            }
            ++i3;
        }
        if (M3rk.info[4] % 100 == 0) {
            System.out.println(" f(TEMPERATURE)  + time " + this.m3rk.x / this.m3rk.fys + "  " + fy.length + "  " + this.m3rk.getGeom().maxnodes + "   max DTdt : " + maxdt + "[" + this.m3rk.n + "]");
            if (Double.isNaN(this.m3rk.x)) {
                System.out.println("shoould not reach this");
            }
        }
    }

    @Override
    public void updategeom(double timepres, double dtsec) {
    }

    @Override
    public void updategeomm3rk(double timepres, double dtsec) {
    }

    @Override
    public void finfinish() {
    }

    public static void main(String[] args) {
        String dir = "C:\\Users\\Public\\wees\\data\\tests\\aquifer\\";
        M3rk m = new M3rk(0.001);
        FtoolGrid3DregularGATemp ftool = new FtoolGrid3DregularGATemp(m);
        double temperature = 65.0;
        double starttime = 0.0;
        AquiferProperties.instantiateProperties(3);
        Property pmodel = PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE);
        pmodel.setDefaultvalue(temperature);
        Property pinitial = PropertyFactory.getProperty(AquiferProperties.IINITIALTEMPERATURE);
        pinitial.setDefaultvalue(temperature);
        GAPropertiesTemp gp = new GAPropertiesTemp(pmodel, pinitial);
        ModelComponentContainer mcc = new ModelComponentContainer();
        mcc.add(gp);
        int nlayers = 10;
        double layerthickness = 10.0;
        Grid3Dregular g = new Grid3Dregular(mcc, starttime, 0.0, 0.0, 0.0, 100, 100, 10, 50.0, 50.0, nlayers);
        PropertyFactory.getProperty(AquiferProperties.ITHICKNESS).setDefaultvalue(layerthickness);
        PropertyFactory.updateGeometry(g);
        WellPerforation wp1 = new WellPerforation(1500.0, 2500.0, 0.044444444444444446, 30.0, 10.0, 0.08960000000000001, g);
        WellPerforation wp2 = new WellPerforation(3500.0, 2500.0, -0.044444444444444446, -1.0, 10.0, 0.08960000000000001, g);
        g.addWellPerforation(wp1);
        g.addWellPerforation(wp2);
        g.getWpContainer().initializeWellBC(gp, g.getNz());
        g.calculateVelfromWP(0);
        int koutput = 0;
        g.outputVel(0, String.valueOf(dir) + "velx", 0, koutput);
        g.outputVel(1, String.valueOf(dir) + "vely", 0, koutput);
        g.outputVel(2, String.valueOf(dir) + "velz", 0, koutput);
        g.initializeBC();
        g.setUseVelocities(true);
        m.addftool(ftool);
        Step s = new Step();
        int IVELMODE = 0;
        int jwells = 50;
        int it = 0;
        while (it <= 50) {
            s.update(g, g.timepres, it, it, ftool.id);
            g.calculateVelfromWP(IVELMODE);
            m.dostepForward(s, g);
            System.out.println("TEMP at time : " + it);
            g.output(0, it == 0, String.valueOf(dir) + "temp" + it, 0, koutput);
            g.outputJsection(0, it == 0, String.valueOf(dir) + "temp" + it + "_j" + jwells, 0, jwells);
            it += 5;
        }
    }
}

