/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.model.model3d;

import tno.geoenergy.fdintegration.model.CellBC;
import tno.geoenergy.fdintegration.model.ModelBC;
import tno.geoenergy.fdintegration.model.ModelComponentContainer;
import tno.geoenergy.fdintegration.model.ModelGrid;
import tno.geoenergy.logging.Logger;
import tno.geoenergy.properties.Property;

public class Grid3D
extends ModelGrid {
    protected double[][][][] values = null;
    protected double[][][] velx = null;
    protected double[][][] vely = null;
    protected double[][][] velz = null;
    protected boolean useVelocities = false;
    private static Logger logger = Logger.getLogger(Grid3D.class.getName());

    public Grid3D(ModelComponentContainer gp, double starttime, double orx, double ory, double orz, int nx, int ny, int nz) {
        super(gp, starttime);
        if (nx * ny * nz > 2000000) {
            logger.error("nx*ny > 2000000");
        } else {
            this.orx = orx;
            this.ory = ory;
            this.orz = orz;
            this.nx = nx;
            this.ny = ny;
            this.nz = nz;
            this.values = new double[gp.getNcomponents()][nx][ny][nz];
        }
        this.maxnodes = gp.getNcomponents() * nx * ny * nz;
    }

    public double[][][][] getValues() {
        return this.values;
    }

    public double[][][] getVelz() {
        return this.velz;
    }

    public void setVelz(double[][][] velz) {
        this.velz = velz;
    }

    public double[][][] getVelx() {
        return this.velx;
    }

    public void setVelx(double[][][] velx) {
        this.velx = velx;
    }

    public double[][][] getVely() {
        return this.vely;
    }

    public void setVely(double[][][] vely) {
        this.vely = vely;
    }

    public boolean isUseVelocities() {
        return this.useVelocities;
    }

    public void setUseVelocities(boolean useVelocities) {
        this.useVelocities = useVelocities;
    }

    protected void initializeValues(int component, double value) {
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                int k = 0;
                while (k < this.getNz()) {
                    Grid3D.geotherm[this.getM3rkIndex((int)component, (int)i, (int)j, (int)k)] = value;
                    Grid3D.inigeotherm[this.getM3rkIndex((int)component, (int)i, (int)j, (int)k)] = value;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void initializeValues(int component, Property p) {
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                int k = 0;
                while (k < this.getNz()) {
                    int n = this.getM3rkIndex(component, i, j, k);
                    Grid3D.geotherm[n] = p.getValue(i, j, k);
                    Grid3D.inigeotherm[n] = p.getValue(i, j, k);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void initializeBCValues(int component, CellBC[][][] cellBC) {
        int i = 0;
        while (i < this.getNx()) {
            int j = 0;
            while (j < this.getNy()) {
                int k = 0;
                while (k < this.getNz()) {
                    ModelBC mbc;
                    CellBC cbc = cellBC[i][j][k];
                    if (cbc != null && cbc.getTypes()[0] != null) {
                        mbc = cbc.getTypes()[0];
                        Grid3D.geotherm[this.getM3rkIndex((int)component, (int)i, (int)j, (int)k)] = mbc.getValue();
                        Grid3D.inigeotherm[this.getM3rkIndex((int)component, (int)i, (int)j, (int)k)] = mbc.getValue();
                    }
                    if (cbc != null && cbc.getTypes()[8] != null) {
                        mbc = cbc.getTypes()[8];
                        Grid3D.geotherm[this.getM3rkIndex((int)component, (int)i, (int)j, (int)k)] = mbc.getValue() / 2.0;
                        Grid3D.inigeotherm[this.getM3rkIndex((int)component, (int)i, (int)j, (int)k)] = mbc.getValue() / 2.0;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public int getM3rkIndex(int component, int i, int j, int k) {
        return component * this.nx * this.ny * this.nz + k * this.nx * this.ny + i * this.ny + j + 1;
    }
}

