/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.fdintegration.model.model3d;

import tno.geoenergy.data.Faults;
import tno.geoenergy.data.SmartGrid;
import tno.geoenergy.data.VTKgrid;
import tno.geoenergy.data.VTKgridWriter;
import tno.geoenergy.fdintegration.model.CellBC;
import tno.geoenergy.fdintegration.model.ModelBC;
import tno.geoenergy.fdintegration.model.ModelBCContainer;
import tno.geoenergy.fdintegration.model.ModelComponent;
import tno.geoenergy.fdintegration.model.ModelComponentContainer;
import tno.geoenergy.fdintegration.model.WellPerforation;
import tno.geoenergy.fdintegration.model.model3d.Grid3D;
import tno.geoenergy.logging.Logger;
import tno.geoenergy.properties.AquiferProperties;
import tno.geoenergy.properties.PropertyFactory;

public class Grid3Dregular
extends Grid3D {
    public static final int SURFER = 0;
    public static final int ARCINFO = 1;
    public static final int ZYCOR = 2;
    public static final String[] GRIDEXTENSION = new String[]{".grd", ".asc", ".dat"};
    public static final String[] GRIDDATAFORMAT = new String[]{"SURFER", "ARC", "ZYCOR"};
    protected int[][] faults;
    private static Logger logger = Logger.getLogger(Grid3Dregular.class.getName());
    static double[][][] s_porosity = null;
    static double[][][] s_h = null;
    static double[][][] s_ng = null;
    static double[][] s_topdepth = null;
    static double[][][] s_initialtemperature = null;
    static double[][][] s_modeltemperature = null;
    static double[][][] s_modeldiftemperature = null;
    static double[][][] s_modeltotalpressure = null;
    static double[][][] s_modelpressure = null;
    static double[][][] s_conduc = null;
    static double[][][] s_reftemp = null;
    static double[][][] s_density = null;
    static double[][][] s_refdensity = null;

    public Grid3Dregular(ModelComponentContainer gp, double starttime, double orx, double ory, double orz, int nx, int ny, int nz, double dx, double dy, double dz) {
        super(gp, starttime, orx, ory, orz, nx, ny, nz);
        this.faults = new int[nx][ny];
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.initializeValuesConstant();
    }

    public void initializeValuesConstant() {
        int i = 0;
        while (i < this.getGpContainer().size()) {
            this.initializeValues(i, this.getGpContainer().getModelComponent(i).getDefaultvalue());
            ++i;
        }
    }

    public void initializeValues() {
        int i = 0;
        while (i < this.getGpContainer().size()) {
            this.initializeValues(i, this.getGpContainer().getModelComponent(i).getInitialvalues());
            ++i;
        }
    }

    public void initializeFault(double x1, double y1, double x2, double y2, int id) {
        int ix1 = this.getIcell(x1);
        int iy1 = this.getJcell(y1);
        int ix2 = this.getIcell(x2);
        int iy2 = this.getJcell(y2);
        int dx = ix2 - ix1;
        int dy = iy2 - iy1;
        if (Math.abs(dx) > Math.abs(dy)) {
            if (dx < 0) {
                int t = ix1;
                ix1 = ix2;
                ix2 = t;
                t = iy1;
                iy1 = iy2;
                iy2 = t;
            }
            int yinc = 1;
            if (iy2 <= iy1) {
                yinc = -1;
            }
            Faults.bresX(ix1, iy1, ix2, iy2, yinc, id, this.faults);
        } else {
            if (dy < 0) {
                int t = ix1;
                ix1 = ix2;
                ix2 = t;
                t = iy1;
                iy1 = iy2;
                iy2 = t;
            }
            int xinc = 1;
            if (ix2 <= ix1) {
                xinc = -1;
            }
            Faults.bresY(ix1, iy1, ix2, iy2, xinc, id, this.faults);
        }
    }

    public void initializeBC() {
        int i = 0;
        while (i < this.getGpContainer().size()) {
            CellBC[][][] cellBC = this.getBC(this.getGpContainer().getModelComponent(i));
            this.initializeBCValues(i, cellBC);
            ++i;
        }
    }

    private void calculateVelAnalytical(double[][][][] vel) {
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                int k = 0;
                while (k < this.nz) {
                    boolean celliswell = false;
                    int iw = 0;
                    while (iw < this.getWpContainer().size()) {
                        WellPerforation wp = this.getWpContainer().getWellPerforation(iw);
                        if (i == wp.getIcell() && j == wp.getJcell()) {
                            celliswell = true;
                        } else {
                            double xx = this.getX(i);
                            double yy = this.getY(j);
                            double[] val = wp.getStreamlineVelocity(xx, yy);
                            double[] dArray = vel[0][i][j];
                            int n = k;
                            dArray[n] = dArray[n] + val[0];
                            double[] dArray2 = vel[1][i][j];
                            int n2 = k;
                            dArray2[n2] = dArray2[n2] + val[1];
                        }
                        ++iw;
                    }
                    if (celliswell) {
                        double[] dArray = vel[0][i][j];
                        int n = k;
                        dArray[n] = dArray[n] + 0.0;
                        double[] dArray3 = vel[1][i][j];
                        int n3 = k;
                        dArray3[n3] = dArray3[n3] + 0.0;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void calculateVelfromWP(int mode) {
        int nx = this.getNx();
        int ny = this.getNy();
        int nz = this.getNz();
        double[][][][] vel = new double[3][nx][ny][nz];
        if (mode == 0) {
            this.calculateVelAnalytical(vel);
        }
        this.velx = vel[0];
        this.vely = vel[1];
        this.velz = vel[2];
    }

    public double[][][] getVoxetValues(boolean initial, int component, double[][][] values) {
        if (values == null) {
            values = new double[this.nx][this.ny][this.nz];
        }
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                int k = 0;
                while (k < this.nz) {
                    values[i][j][k] = initial ? (double)((float)inigeotherm[this.getM3rkIndex(component, i, j, k)]) : (double)((float)geotherm[this.getM3rkIndex(component, i, j, k)]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return values;
    }

    public SmartGrid getGridValues(boolean initial, int component, int k) {
        SmartGrid grid = new SmartGrid();
        grid.values = new float[this.nx][this.ny];
        grid.originx = (float)this.orx;
        grid.originy = (float)this.ory;
        grid.dx = (float)this.dx;
        grid.dy = (float)this.dy;
        grid.nx = this.nx;
        grid.ny = this.ny;
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                grid.values[i][j] = initial ? (float)inigeotherm[this.getM3rkIndex(component, i, j, k)] : (float)geotherm[this.getM3rkIndex(component, i, j, k)];
                ++j;
            }
            ++i;
        }
        grid.m_Grid.originx = grid.originx;
        grid.m_Grid.originy = grid.originy;
        grid.m_Grid.dx = grid.dx;
        grid.m_Grid.dy = grid.dy;
        grid.m_Grid.nx = grid.nx;
        grid.m_Grid.ny = grid.ny;
        grid.m_Grid.values = grid.values;
        grid.m_Grid.unknown = -999.25f;
        return grid;
    }

    public SmartGrid getJGridValues(boolean initial, int component, int jsection) {
        SmartGrid grid = new SmartGrid();
        grid.values = new float[this.nx][this.nz];
        grid.originx = (float)this.orx;
        grid.originy = (float)this.orz;
        grid.dx = (float)this.dx;
        grid.dy = 1.0f;
        grid.nx = this.nx;
        grid.ny = this.nz;
        int i = 0;
        while (i < grid.nx) {
            int j = 0;
            while (j < grid.ny) {
                grid.values[i][j] = initial ? (float)inigeotherm[this.getM3rkIndex(component, i, jsection, j)] : (float)geotherm[this.getM3rkIndex(component, i, jsection, j)];
                ++j;
            }
            ++i;
        }
        grid.m_Grid.originx = grid.originx;
        grid.m_Grid.originy = grid.originy;
        grid.m_Grid.dx = grid.dx;
        grid.m_Grid.dy = grid.dy;
        grid.m_Grid.nx = grid.nx;
        grid.m_Grid.ny = grid.ny;
        grid.m_Grid.values = grid.values;
        grid.m_Grid.unknown = -999.25f;
        return grid;
    }

    public int getIcell(double x) {
        int i = (int)((x - this.orx) / this.dx + 0.5);
        return i;
    }

    public int getJcell(double y) {
        int i = (int)((y - this.ory) / this.dy + 0.5);
        return i;
    }

    public double getX(int i) {
        return this.orx + (double)i * this.dx;
    }

    public double getY(int j) {
        return this.ory + (double)j * this.dy;
    }

    public CellBC[][][] getBC(ModelComponent mc) {
        CellBC[][][] r = new CellBC[this.nx][this.ny][this.nz];
        int i = 0;
        while (i < mc.getBcContainer().size()) {
            ModelBC mbc = mc.getBcContainer().getModelBoundaryCondition(i);
            mbc.convert3CellBC(r);
            ++i;
        }
        return r;
    }

    public void outputWellsTempPres(int ncomp, boolean initial, double time, ModelBCContainer bcContainer, double[][][] viscosity, double salinity, double[][][] totalpressure) {
        this.getWpContainer().setOutputTime(time);
        double[] qsum = new double[this.getWpContainer().size()];
        double[] tsum = new double[this.getWpContainer().size()];
        int component = 0;
        while (component < ncomp) {
            int i = 0;
            while (i < bcContainer.size()) {
                ModelBC bc = bcContainer.getModelBoundaryCondition(i);
                int iwell = bc.getWellid();
                int ii = bc.getIlow();
                int jj = bc.getJlow();
                int kk = bc.getKlow();
                double val = geotherm[this.getM3rkIndex(component, ii, jj, kk)];
                if (component == 1) {
                    this.getWpContainer().setOutput(component, iwell, val, viscosity, salinity, totalpressure);
                } else {
                    WellPerforation wp = this.getWpContainer().getWellPerforation(iwell);
                    double q = Math.abs(bc.getQ_calculated());
                    int n = iwell;
                    qsum[n] = qsum[n] + q;
                    int n2 = iwell;
                    tsum[n2] = tsum[n2] + q * geotherm[this.getM3rkIndex(0, ii, jj, kk)];
                }
                ++i;
            }
            if (component == 0) {
                int iwell = 0;
                while (iwell < this.getWpContainer().size()) {
                    double temperature = tsum[iwell] / qsum[iwell];
                    this.getWpContainer().setOutput(component, iwell, temperature, viscosity, salinity, totalpressure);
                    ++iwell;
                }
            }
            ++component;
        }
    }

    public void output(int component, boolean initial, String fname, int format, int k) {
        SmartGrid grid = this.getGridValues(initial, component, k);
        grid.m_Grid.setFileName(String.valueOf(fname) + GRIDEXTENSION[format]);
        grid.m_Grid.setDataFormat(GRIDDATAFORMAT[format]);
        try {
            grid.m_Grid.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void outputJsection(int component, boolean initial, String fname, int format, int j) {
        SmartGrid grid = this.getJGridValues(initial, component, j);
        grid.m_Grid.setFileName(String.valueOf(fname) + GRIDEXTENSION[format]);
        grid.m_Grid.setDataFormat(GRIDDATAFORMAT[format]);
        try {
            grid.m_Grid.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void outputVel(int xyz, String fname, int format, int k) {
        int i;
        SmartGrid grid = this.getGridValues(true, 0, k);
        grid.m_Grid.setFileName(String.valueOf(fname) + GRIDEXTENSION[format]);
        grid.m_Grid.setDataFormat(GRIDDATAFORMAT[format]);
        if (xyz == 0) {
            i = 0;
            while (i < this.nx) {
                int j = 0;
                while (j < this.ny) {
                    grid.m_Grid.values[i][j] = (float)this.getVelx()[i][j][k];
                    ++j;
                }
                ++i;
            }
        } else if (xyz == 1) {
            i = 0;
            while (i < this.nx) {
                int j = 0;
                while (j < this.ny) {
                    grid.m_Grid.values[i][j] = (float)this.getVely()[i][j][k];
                    ++j;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.nx) {
                int j = 0;
                while (j < this.ny) {
                    grid.m_Grid.values[i][j] = (float)this.getVelz()[i][j][k];
                    ++j;
                }
                ++i;
            }
        }
        try {
            grid.m_Grid.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void outputFaults(String fname, int format) {
        SmartGrid grid = this.getGridValues(true, 0, 0);
        grid.m_Grid.setFileName(String.valueOf(fname) + GRIDEXTENSION[format]);
        grid.m_Grid.setDataFormat(GRIDDATAFORMAT[format]);
        int nx = this.getNx();
        int ny = this.getNy();
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                grid.m_Grid.values[i][j] = 0.0f;
                if (this.faults[i][j] >= 0) {
                    grid.m_Grid.values[i][j] = 1.0f;
                }
                ++j;
            }
            ++i;
        }
        try {
            grid.m_Grid.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void outputPres(String fname, int timeyrs, int format, int k) {
        SmartGrid grid = this.getGridValues(true, 0, k);
        grid.m_Grid.setFileName(String.valueOf(fname) + GRIDEXTENSION[format]);
        grid.m_Grid.setDataFormat(GRIDDATAFORMAT[format]);
        int nx = this.getNx();
        int ny = this.getNy();
        WellPerforation wp1 = this.getWpContainer().getWellPerforation(0);
        wp1.setMindist(1.0E30);
        double perm = PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYI).getDefaultvalue();
        double viscosity = PropertyFactory.getProperty(AquiferProperties.IVISCOSITY).getDefaultvalue();
        double porosity = PropertyFactory.getProperty(AquiferProperties.IPOROSITY).getDefaultvalue();
        double kh = perm * 100000.0 / (1.0132502738308866E15 * viscosity);
        double ch = PropertyFactory.getProperty(AquiferProperties.ISTORAGECAPACITY).getDefaultvalue() * 100000.0 * porosity;
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                grid.m_Grid.values[i][j] = 0.0f;
                int iw = 0;
                while (iw < this.getWpContainer().size()) {
                    WellPerforation wp = this.getWpContainer().getWellPerforation(iw);
                    if (i == wp.getIcell() && j == wp.getJcell()) {
                        float[] fArray = grid.m_Grid.values[i];
                        int n = j;
                        fArray[n] = (float)((double)fArray[n] + wp.getPwell());
                    } else {
                        double xx = this.getX(i);
                        double yy = this.getY(j);
                        double pp = wp.getPressure(xx, yy, kh, ch, timeyrs);
                        float[] fArray = grid.m_Grid.values[i];
                        int n = j;
                        fArray[n] = fArray[n] + (float)pp;
                    }
                    ++iw;
                }
                ++j;
            }
            ++i;
        }
        System.out.println(wp1.getMindist());
        try {
            grid.m_Grid.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void outputWells2File(String dirname) {
        this.getWpContainer().outputWells2File(dirname);
    }

    public int[][] getFaultCells() {
        return this.faults;
    }

    public void setProductionTemperatureFromPressure(double[][][] prespcg, double[][][] conductancei, double[][][] conductancej, double[][][] actnum, ModelBCContainer bcContainer) {
        int i = 0;
        while (i < bcContainer.size()) {
            ModelBC bc = bcContainer.getModelBoundaryCondition(i);
            int ii = bc.getIlow();
            int jj = bc.getJlow();
            int kk = bc.getKlow();
            double sumq = 0.0;
            double sumt = 0.0;
            WellPerforation wp = this.getWpContainer().getWellPerforation(bc.getWellid());
            double qcell = bc.getValue();
            if (qcell < 0.0 && actnum[ii][jj][kk] > 0.0) {
                double q;
                double p1;
                double p = geotherm[this.getM3rkIndex(1, ii, jj, kk)];
                if (ii > 0 && (p1 = geotherm[this.getM3rkIndex(1, ii - 1, jj, kk)]) - p > 0.0) {
                    q = (p1 - p) * conductancei[ii - 1][jj][kk];
                    sumq += q;
                    sumt += q * geotherm[this.getM3rkIndex(0, ii - 1, jj, kk)];
                }
                if (ii < this.nx - 1 && (p1 = geotherm[this.getM3rkIndex(1, ii + 1, jj, kk)]) - p > 0.0) {
                    q = (p1 - p) * conductancei[ii][jj][kk];
                    sumq += q;
                    sumt += q * geotherm[this.getM3rkIndex(0, ii + 1, jj, kk)];
                }
                if (jj < this.ny - 1 && (p1 = geotherm[this.getM3rkIndex(1, ii, jj + 1, kk)]) - p > 0.0) {
                    q = (p1 - p) * conductancej[ii][jj][kk];
                    sumq += q;
                    sumt += q * geotherm[this.getM3rkIndex(0, ii, jj + 1, kk)];
                }
                if (jj > 0 && (p1 = geotherm[this.getM3rkIndex(1, ii, jj - 1, kk)]) - p > 0.0) {
                    q = (p1 - p) * conductancej[ii][jj - 1][kk];
                    sumq += q;
                    sumt += q * geotherm[this.getM3rkIndex(0, ii, jj - 1, kk)];
                }
                if (sumq > 1.0E-20) {
                    Grid3Dregular.geotherm[this.getM3rkIndex((int)0, (int)ii, (int)jj, (int)kk)] = sumt / sumq;
                }
            }
            ++i;
        }
    }

    public void outputVTKformat(String fileName) {
        boolean icomp = false;
        s_porosity = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IPOROSITY), s_porosity);
        s_h = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ITHICKNESS), s_h);
        s_ng = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ING), s_ng);
        s_topdepth = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IAQUIFERDEPTH));
        s_initialtemperature = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IINITIALTEMPERATURE), s_initialtemperature);
        s_modeltemperature = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE), s_modeltemperature);
        s_modeldiftemperature = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELDIFTEMPERATURE), s_modeldiftemperature);
        s_modeltotalpressure = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_TOTALPRES), s_modeltotalpressure);
        s_modelpressure = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELPRESSURE), s_modelpressure);
        s_conduc = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ICALC_T_CONDUC), s_conduc);
        s_reftemp = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE), s_reftemp);
        s_density = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IDENSITY), s_density);
        s_refdensity = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IREFDENSITY), s_refdensity);
        VTKgrid vtkg = new VTKgrid(s_topdepth, this.dx, this.dy, this.orx, this.ory, s_h, fileName);
        vtkg.addProperty(s_modeltemperature, AquiferProperties.DEFAULTUNKNOWN, PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE).getName());
        vtkg.addProperty(s_modeldiftemperature, AquiferProperties.DEFAULTUNKNOWN, PropertyFactory.getProperty(AquiferProperties.IMODELDIFTEMPERATURE).getName());
        vtkg.addProperty(s_modelpressure, AquiferProperties.DEFAULTUNKNOWN, PropertyFactory.getProperty(AquiferProperties.IMODELPRESSURE).getName());
        vtkg.addProperty(s_conduc, AquiferProperties.DEFAULTUNKNOWN, PropertyFactory.getProperty(AquiferProperties.ICALC_T_CONDUC).getName());
        vtkg.addProperty(s_density, AquiferProperties.DEFAULTUNKNOWN, PropertyFactory.getProperty(AquiferProperties.IDENSITY).getName());
        vtkg.addProperty(s_refdensity, AquiferProperties.DEFAULTUNKNOWN, PropertyFactory.getProperty(AquiferProperties.IREFDENSITY).getName());
        VTKgridWriter.writeVTK(vtkg);
    }
}

