/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer;

import java.awt.Frame;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import tno.geoenergy.geothermalaquifer.AquiferProject;
import tno.geoenergy.geothermalaquifer.gui.AquiferDialog;
import tno.geoenergy.geothermalaquifer.gui.ProgressDialog;
import tno.geoenergy.logging.Logger;

public class AQUIFERMAIN
extends Thread {
    private static Logger logger = Logger.getLogger(AQUIFERMAIN.class.getName());
    public static AquiferDialog m = null;
    private static AquiferProject aquiferProject = null;
    private static String curdir = null;
    private static int guimode;
    private static Map<String, Integer> GUIMODES;

    static {
        GUIMODES = new HashMap<String, Integer>();
        GUIMODES.put("3DMode", AquiferDialog.GUIMODE2D3D);
    }

    public static void read(File file, Frame frame) {
        aquiferProject = new AquiferProject(file, frame);
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (argv.length > 0) {
            try {
                guimode = GUIMODES.get(argv[0]);
            }
            catch (Exception e) {
                guimode = AquiferDialog.GUIMODE2D;
            }
        } else {
            guimode = AquiferDialog.GUIMODE2D;
        }
        AQUIFERMAIN app = new AQUIFERMAIN();
        app.start();
    }

    @Override
    public void run() {
        try {
            logger.info("Starting Aquifer");
            m = new AquiferDialog(AQUIFERMAIN.getProductName(), guimode);
            m.setSize(900, 750);
            m.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static AquiferProject getProject() {
        return aquiferProject;
    }

    public static void setProject(AquiferProject p) {
        aquiferProject = p;
    }

    public static AquiferDialog getDialog() {
        return m;
    }

    public static String getVersionName() {
        return "1.0";
    }

    public static String getIconName() {
        return "/tno/geoenergy/icons/TNO_icon.png";
    }

    public static String getIconSloganName() {
        return "/tno/geoenergy/icons/TNOinnovationforlife_small.png";
    }

    public static String getApplicationName() {
        return "DoubletCalc 2D";
    }

    public static String getProductName() {
        return String.valueOf(AQUIFERMAIN.getApplicationName()) + " " + AQUIFERMAIN.getVersionName();
    }

    public static String getCopyright() {
        return "(c)TNO 2015. All Rights Reserved";
    }

    public static String getAuthor() {
        return " Maarten Pluymaekers \n Jan-Diederik van Wees \n Hans Veldkamp \n thermogis@tno.nl";
    }

    public static String getAboutText() {
        return "DoubletCalc 2D is a software tool that is being developed by TNO. It enables to calculate the temperature and pressure development around two or more geothermal wells in two dimensions over time. The software aims at bridging the gap between simple 1D prediction tools like TNO's DoubletCalc v1.43 (DC1D, Mijnlieff et al. 2014), and sophisticated 2D and 3D reservoir simulators like Eclipse.";
    }

    public static void calculate(String curdir, ProgressDialog pd) {
        AQUIFERMAIN.getProject().calculate(curdir, pd);
        AQUIFERMAIN.updateGUIResults();
    }

    public static void setCurrentDir(String dirname) {
        curdir = dirname;
    }

    public static String getCurrentDir() {
        return curdir;
    }

    public static void updateGUIFromProject() {
        AQUIFERMAIN.getDialog().updateGUIFromProject(AQUIFERMAIN.getProject());
    }

    public static void updateProjectFromGUI() {
        AQUIFERMAIN.getDialog().updateProjectFromGUI(AQUIFERMAIN.getProject());
    }

    public static void updateGUIResults() {
        AQUIFERMAIN.getDialog().updateGUIResults(AQUIFERMAIN.getProject());
    }
}

