/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.vecmath.Vector3d;
import okada.DC3D0;
import okada.DCCON0;
import tno.geoenergy.data.Grid;
import tno.geoenergy.properties.AquiferProperties;
import tno.geoenergy.properties.PropertyFactory;
import wrapper.ObservationPoint;
import wrapper.ObservationPointData;
import wrapper.PointSource;
import wrapper.SourceFactory;
import wrapper.StressSource;

public class AquiferCalculateSubsidence {
    public static double E = PropertyFactory.getProperty(AquiferProperties.IROCKYOUNGSMODULUS).getDefaultvalue();
    public static double v = PropertyFactory.getProperty(AquiferProperties.IROCKPOISSONSRATIO).getDefaultvalue();
    public static double cm = PropertyFactory.getProperty(AquiferProperties.IROCKCOMPACTION).getDefaultvalue();
    public static double ct = PropertyFactory.getProperty(AquiferProperties.IROCKTHERMALCOMPACTION).getDefaultvalue();
    public static double[][] pres = null;
    public static double[][] tmodel = null;
    public static double[][] tinitial = null;
    public static double[][] topdepth = null;
    public static double[][] h = null;
    public static double[][] subsidence = null;
    public static ObservationPointData opd = new ObservationPointData();

    public static void calculate2D(double orx, double ory, double dx, double dy, int LOD, String filename) {
        PointSource.setStressParameters(E, v);
        int igeom = PropertyFactory.getITYPEGEOM();
        if (igeom == 2) {
            pres = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELPRESSURE));
            tmodel = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE));
            tinitial = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IINITIALTEMPERATURE));
            topdepth = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IAQUIFERDEPTH));
            h = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ITHICKNESS));
            subsidence = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ISUBSIDENCE));
            int nx = pres.length;
            int ny = pres[0].length;
            double dx2 = dx;
            dx2 = (double)LOD * dx;
            int lod = LOD;
            double dy2 = dy * (double)lod;
            int nx2 = (nx - 1) / lod + 1;
            int ny2 = (ny - 1) / lod + 1;
            Grid gsubs = DC3D0.getGrid(orx, ory, dx2, dy2, nx2, ny2, "test");
            SourceFactory.getStressSourceData().clear();
            opd.clear();
            boolean fillopd = opd.size() == 0;
            fillopd = true;
            PrintStream pos = null;
            try {
                int j;
                pos = new PrintStream(new BufferedOutputStream(new FileOutputStream(filename)));
                int icount = 0;
                int i = 0;
                while (i < nx2) {
                    j = 0;
                    while (j < ny2) {
                        int ihmin = (int)Math.ceil((double)(i * lod) - 0.5 * (double)lod);
                        int ihmax = ihmin + lod;
                        int jhmin = (int)Math.ceil((double)(j * lod) - 0.5 * (double)lod);
                        int jhmax = jhmin + lod;
                        int iarea = 0;
                        double area = 0.0;
                        double top = 0.0;
                        double hh = 0.0;
                        double unistrain = 0.0;
                        int ih = ihmin;
                        while (ih < ihmax) {
                            int jh = jhmin;
                            while (jh < jhmax) {
                                if (ih >= 0 && ih < nx && jh >= 0 && jh < ny) {
                                    ++iarea;
                                    area += dx * dy;
                                    hh += h[ih][jh];
                                    top += topdepth[ih][jh];
                                    double dt = tmodel[ih][jh] - tinitial[ih][jh];
                                    unistrain += cm * pres[ih][jh] + ct * dt;
                                }
                                ++jh;
                            }
                            ++ih;
                        }
                        if (iarea > 0) {
                            unistrain /= (double)iarea;
                            Vector3d x = new Vector3d(orx + (double)i * dx2, ory + (double)j * dy2, -((top /= (double)iarea) + 0.5 * (hh /= (double)iarea)));
                            Vector3d u = new Vector3d(0.0, 0.0, 0.0);
                            double arearoot = Math.sqrt(area);
                            if (Math.abs(unistrain) > 1.0E-5) {
                                SourceFactory.createSource(StressSource.SOURCE_POINT, x, 0.0, 0.0, arearoot, arearoot, hh, u, unistrain * (2.0 + DCCON0.LAMBDA / DCCON0.MYU), true);
                                pos.println(String.valueOf(x.x) + " " + x.y + " " + x.z + " " + area * hh * unistrain);
                            }
                        }
                        if (fillopd) {
                            Vector3d o = new Vector3d(orx + (double)i * dx2, ory + (double)j * dy2, 0.0);
                            ObservationPoint op = new ObservationPoint(o);
                            opd.add(op);
                        }
                        ++icount;
                        ++j;
                    }
                    ++i;
                }
                SourceFactory.getStressSourceData().calculateAll(opd);
                icount = 0;
                i = 0;
                while (i < nx2) {
                    j = 0;
                    while (j < ny2) {
                        gsubs.values[i][j] = (float)(1000.0 * AquiferCalculateSubsidence.opd.get((int)icount).outputs[ObservationPoint.IU].z);
                        ++icount;
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < nx) {
                    j = 0;
                    while (j < ny) {
                        AquiferCalculateSubsidence.subsidence[i][j] = gsubs.getValueAtxy((float)(orx + (double)i * dx), (float)(ory + (double)j * dy));
                        ++j;
                    }
                    ++i;
                }
                pos.close();
            }
            catch (Exception e) {
                System.err.println("Exception\n  " + e);
            }
        }
    }

    public static void calculate2DOLD(double orx, double ory, double dx, double dy) {
        PointSource.setStressParameters(E, v);
        int igeom = PropertyFactory.getITYPEGEOM();
        if (igeom == 2) {
            int j;
            pres = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELPRESSURE));
            tmodel = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE));
            tinitial = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IINITIALTEMPERATURE));
            topdepth = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IAQUIFERDEPTH));
            h = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ITHICKNESS));
            subsidence = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ISUBSIDENCE));
            int nx = pres.length;
            int ny = pres[0].length;
            double dx2 = dx;
            while (dx2 < 100.0) {
                dx2 += dx;
            }
            int lod = (int)(dx2 / dx);
            double dy2 = dy * (double)lod;
            int nx2 = nx * lod;
            int ny2 = ny * lod;
            Grid gsubs = DC3D0.getGrid(orx, ory, dx2, dy2, nx2, ny2, "test");
            SourceFactory.getStressSourceData().clear();
            opd.clear();
            boolean fillopd = opd.size() == 0;
            fillopd = true;
            int icount = 0;
            int i = 0;
            while (i < nx) {
                j = 0;
                while (j < ny) {
                    Vector3d x = new Vector3d((double)i * dx, (double)j * dy, -(topdepth[i][j] + 0.5 * h[i][j]));
                    Vector3d o = new Vector3d((double)i * dx, (double)j * dy, 0.0);
                    double dt = tmodel[i][j] - tinitial[i][j];
                    if (Math.abs(dt) > 10.0) {
                        dt -= 1.0E-4;
                    }
                    if (Math.abs(pres[i][j]) > 1.0) {
                        double p = pres[i][j];
                        double[] dArray = pres[i];
                        int n = j;
                        dArray[n] = dArray[n] * 1.0;
                    }
                    double unistrain = cm * pres[i][j] + ct * dt;
                    Vector3d u = new Vector3d(0.0, 0.0, 0.0);
                    if (Math.abs(unistrain) > 1.0E-5) {
                        SourceFactory.createSource(StressSource.SOURCE_POINT, x, 0.0, 0.0, dx, dy, h[i][j], u, unistrain * (2.0 + DCCON0.LAMBDA / DCCON0.MYU), true);
                    }
                    if (fillopd) {
                        ObservationPoint op = new ObservationPoint(o);
                        opd.add(op);
                    }
                    ++icount;
                    ++j;
                }
                ++i;
            }
            opd.clearOutput();
            SourceFactory.getStressSourceData().calculateAll(opd);
            icount = 0;
            i = 0;
            while (i < nx) {
                j = 0;
                while (j < ny) {
                    AquiferCalculateSubsidence.subsidence[i][j] = 1000.0 * AquiferCalculateSubsidence.opd.get((int)icount).outputs[ObservationPoint.IU].z;
                    ++icount;
                    ++j;
                }
                ++i;
            }
        }
    }

    public static void main(String[] args) {
    }
}

