/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import tno.geoenergy.data.EclipseGrid;
import tno.geoenergy.data.SmartGrid;
import tno.geoenergy.data.SmartVoxet;
import tno.geoenergy.data.Voxet;
import tno.geoenergy.data.VoxetWriter;
import tno.geoenergy.fdintegration.integration.M3rk;
import tno.geoenergy.fdintegration.integration.Step;
import tno.geoenergy.fdintegration.model.GAPropertiesPres;
import tno.geoenergy.fdintegration.model.GAPropertiesTemp;
import tno.geoenergy.fdintegration.model.ModelComponentContainer;
import tno.geoenergy.fdintegration.model.ModelGrid;
import tno.geoenergy.fdintegration.model.WellPerforation;
import tno.geoenergy.fdintegration.model.WellPerforationContainer;
import tno.geoenergy.fdintegration.model.model2d.FtoolGrid2DregularGAPres;
import tno.geoenergy.fdintegration.model.model2d.Grid2Dregular;
import tno.geoenergy.fdintegration.model.model3d.FtoolGrid3DregularGAPres;
import tno.geoenergy.fdintegration.model.model3d.Grid3Dregular;
import tno.geoenergy.geothermalaquifer.AquiferCalculateSubsidence;
import tno.geoenergy.geothermalaquifer.ConvectionTest;
import tno.geoenergy.geothermalaquifer.OutputReference;
import tno.geoenergy.geothermalaquifer.OutputReferenceContainer;
import tno.geoenergy.geothermalaquifer.gui.ProgressDialog;
import tno.geoenergy.properties.AquiferProperties;
import tno.geoenergy.properties.Grid2DProperty;
import tno.geoenergy.properties.Grid3DProperty;
import tno.geoenergy.properties.Property;
import tno.geoenergy.properties.PropertyFactory;
import tno.geoenergy.properties.WellProperty;

public class AquiferProject {
    public static final double THICKTRESHOLD = 1.0;
    public static final double PERMTRESHOLDMIN = 0.0;
    public static final double PERMTHRESHOLD = 0.0;
    protected static final int LODSUBSIDENCECALC = 4;
    boolean usefaults = false;
    int nfaults = 0;
    public static final int NFAULTSMAX = 100;
    double[] faultsx1 = new double[100];
    double[] faultsy1 = new double[100];
    double[] faultsx2 = new double[100];
    double[] faultsy2 = new double[100];
    Property nx;
    Property ny;
    Property nz;
    Property minx;
    Property miny;
    Property minz;
    Property maxx;
    Property maxy;
    Property maxz;
    Property geometry_mask;
    Property aquifer_temp;
    Property aquifer_thickness;
    Property aquifer_porosity;
    Property aquifer_ntg;
    Property aquifer_c;
    Property aquifer_ch;
    Property aquifer_perm_x_mdarcy;
    Property aquifer_perm_y_mdarcy;
    Property aquifer_perm_z_mdarcy;
    Property aquifer_viscoinjection;
    Property aquifer_depth;
    Property aquifer_salinity;
    Property aquifer_actnum;
    Property aquifer_actnumflow;
    Property aquifer_actnumtemp;
    Property aquifer_connectxmin;
    Property aquifer_connectymin;
    Property aquifer_connectzmin;
    Property aquifer_connectxplus;
    Property aquifer_connectyplus;
    Property aquifer_connectzplus;
    Property aquifer_connectxmin_temp;
    Property aquifer_connectymin_temp;
    Property aquifer_connectzmin_temp;
    Property aquifer_connectxplus_temp;
    Property aquifer_connectyplus_temp;
    Property aquifer_connectzplus_temp;
    Property rock_c;
    Property rock_ch;
    Property rock_rho;
    Property rock_E;
    Property rock_v;
    Property rock_cm;
    Property rock_ct;
    Property well_x;
    Property well_y;
    Property welldiameter;
    Property wellskin;
    Property welltemp;
    Property wellpressure;
    Property wellvolrate;
    Property timeproductionend;
    Property timeend;
    Property timestep;
    Property timesteppostprod;
    Property viscositymode;
    Property pressuremode;
    Property includewall;
    Property includegravity;
    Property includesubsidence;
    Property includefixtemptopbottom;
    Property outputfilemode;
    Property vtkmode;
    Property debugmode;
    Property noflowbc;
    Frame frame;
    WellPerforationContainer wellresults;
    OutputReferenceContainer gridresults;

    public AquiferProject(int igeom) {
        this.initiateAquiferProperties(igeom);
        this.gridresults = new OutputReferenceContainer();
        this.setDefaultWellProperties();
    }

    public AquiferProject(File file, Frame frame) {
        this.frame = frame;
        try {
            this.readxml(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(frame, "cannot read projectfile \n" + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(frame, "cannot parse projectfile \n" + e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(frame, "cannot parse projectfile \n" + e.getMessage());
        }
        this.gridresults = new OutputReferenceContainer();
    }

    public void readxml(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(xmlFile);
        Element root = doc.getDocumentElement();
        int igeom = Integer.parseInt(root.getAttribute("type_id"));
        this.initiateAquiferProperties(igeom);
        NodeList nList = root.getChildNodes();
        int i = 0;
        while (i < nList.getLength()) {
            Node nNode = nList.item(i);
            if (nNode.getNodeType() == 1) {
                PropertyFactory.setPropertyResultTag(nNode.getNodeName(), nNode.getTextContent());
            }
            ++i;
        }
    }

    public void setDefaultWellProperties() {
        PropertyFactory.setITYPEVECTOR(2);
        double[] d = new double[]{1750.0, 3250.0};
        ((WellProperty)this.well_x).setValues(d);
        ((WellProperty)this.well_x).setDefaultValues(d);
        double[] d2 = new double[]{2500.0, 2500.0};
        ((WellProperty)this.well_y).setValues(d2);
        ((WellProperty)this.well_y).setDefaultValues(d2);
        double[] t = new double[]{30.0, -1.0};
        ((WellProperty)this.welltemp).setValues(t);
        ((WellProperty)this.welltemp).setDefaultValues(t);
        double[] p = new double[]{30.0, -30.0};
        ((WellProperty)this.wellpressure).setValues(p);
        ((WellProperty)this.wellpressure).setDefaultValues(p);
        double[] v = new double[]{160.0, -160.0};
        ((WellProperty)this.wellvolrate).setValues(v);
        ((WellProperty)this.wellvolrate).setDefaultValues(v);
    }

    public void saveProject(String filename, Frame frame) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("project");
            doc.appendChild(rootElement);
            Attr attr = doc.createAttribute("type_id");
            attr.setValue(Integer.toString(PropertyFactory.getITYPEGEOM()));
            rootElement.setAttributeNode(attr);
            Property p = null;
            int i = 0;
            while (i < PropertyFactory.getALLPROPERTIES().size()) {
                p = PropertyFactory.getProperty(i);
                if (p.hasSaveTag()) {
                    Element node = doc.createElement(p.getTag());
                    node.appendChild(doc.createTextNode(PropertyFactory.getPropertyResultTag(p)));
                    rootElement.appendChild(node);
                }
                ++i;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(filename));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(frame, "file cannot be written\n" + filename);
        }
    }

    public void initiateAquiferProperties(int igeom) {
        AquiferProperties.instantiateProperties(igeom);
        this.nx = PropertyFactory.getProperty(AquiferProperties.INX);
        this.minx = PropertyFactory.getProperty(AquiferProperties.IMINX);
        this.maxx = PropertyFactory.getProperty(AquiferProperties.IMAXX);
        this.ny = PropertyFactory.getProperty(AquiferProperties.INY);
        this.miny = PropertyFactory.getProperty(AquiferProperties.IMINY);
        this.maxy = PropertyFactory.getProperty(AquiferProperties.IMAXY);
        this.nz = PropertyFactory.getProperty(AquiferProperties.INZ);
        this.minz = PropertyFactory.getProperty(AquiferProperties.IMINZ);
        this.maxz = PropertyFactory.getProperty(AquiferProperties.IMAXZ);
        this.geometry_mask = PropertyFactory.getProperty(AquiferProperties.IMASKGEOM);
        this.aquifer_temp = PropertyFactory.getProperty(AquiferProperties.IINITIALTEMPERATURE);
        this.aquifer_thickness = PropertyFactory.getProperty(AquiferProperties.ITHICKNESS);
        this.aquifer_porosity = PropertyFactory.getProperty(AquiferProperties.IPOROSITY);
        this.aquifer_ntg = PropertyFactory.getProperty(AquiferProperties.ING);
        this.aquifer_ch = PropertyFactory.getProperty(AquiferProperties.ISTORAGECAPACITY);
        this.aquifer_perm_x_mdarcy = PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYI);
        this.aquifer_perm_y_mdarcy = PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYJ);
        this.aquifer_perm_z_mdarcy = PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYK);
        this.aquifer_viscoinjection = PropertyFactory.getProperty(AquiferProperties.IVISCOSITY);
        this.aquifer_depth = PropertyFactory.getProperty(AquiferProperties.IAQUIFERDEPTH);
        this.aquifer_salinity = PropertyFactory.getProperty(AquiferProperties.IWATERSALINITY);
        this.aquifer_actnum = PropertyFactory.getProperty(AquiferProperties.IACTNUM);
        this.aquifer_c = PropertyFactory.getProperty(AquiferProperties.IWATERCONDUCTIVITY);
        this.aquifer_actnumflow = PropertyFactory.getProperty(AquiferProperties.IACTNUMFLOW);
        this.aquifer_connectxmin = PropertyFactory.getProperty(AquiferProperties.ICONNECTXMIN);
        this.aquifer_connectymin = PropertyFactory.getProperty(AquiferProperties.ICONNECTYMIN);
        this.aquifer_connectzmin = PropertyFactory.getProperty(AquiferProperties.ICONNECTZMIN);
        this.aquifer_connectxplus = PropertyFactory.getProperty(AquiferProperties.ICONNECTXPLUS);
        this.aquifer_connectyplus = PropertyFactory.getProperty(AquiferProperties.ICONNECTYPLUS);
        this.aquifer_connectzplus = PropertyFactory.getProperty(AquiferProperties.ICONNECTZPLUS);
        this.aquifer_actnumtemp = PropertyFactory.getProperty(AquiferProperties.IACTNUMTEMP);
        this.aquifer_connectxmin_temp = PropertyFactory.getProperty(AquiferProperties.ICONNECTXMINTEMP);
        this.aquifer_connectymin_temp = PropertyFactory.getProperty(AquiferProperties.ICONNECTYMINTEMP);
        this.aquifer_connectzmin_temp = PropertyFactory.getProperty(AquiferProperties.ICONNECTZMINTEMP);
        this.aquifer_connectxplus_temp = PropertyFactory.getProperty(AquiferProperties.ICONNECTXPLUSTEMP);
        this.aquifer_connectyplus_temp = PropertyFactory.getProperty(AquiferProperties.ICONNECTYPLUSTEMP);
        this.aquifer_connectzplus_temp = PropertyFactory.getProperty(AquiferProperties.ICONNECTZPLUSTEMP);
        this.rock_c = PropertyFactory.getProperty(AquiferProperties.IROCKCONDUCTIVITY);
        this.rock_ch = PropertyFactory.getProperty(AquiferProperties.IROCKHEATCAPACITY);
        this.rock_rho = PropertyFactory.getProperty(AquiferProperties.IROCKDENSITY);
        this.rock_E = PropertyFactory.getProperty(AquiferProperties.IROCKYOUNGSMODULUS);
        this.rock_v = PropertyFactory.getProperty(AquiferProperties.IROCKPOISSONSRATIO);
        this.rock_cm = PropertyFactory.getProperty(AquiferProperties.IROCKCOMPACTION);
        this.rock_ct = PropertyFactory.getProperty(AquiferProperties.IROCKTHERMALCOMPACTION);
        this.timeend = PropertyFactory.getProperty(AquiferProperties.ILIFETIMECALC);
        this.timeproductionend = PropertyFactory.getProperty(AquiferProperties.ILIFETIMEPROD);
        this.timestep = PropertyFactory.getProperty(AquiferProperties.ITIMESTEP);
        this.timesteppostprod = PropertyFactory.getProperty(AquiferProperties.ITIMESTEP_POSTPROD);
        this.viscositymode = PropertyFactory.getProperty(AquiferProperties.ISWITCH_PTS_VISCOSITY);
        this.pressuremode = PropertyFactory.getProperty(AquiferProperties.ISWITCH_PRESSURE_CALC);
        this.includewall = PropertyFactory.getProperty(AquiferProperties.ISWITCH_INCLUDEWALL);
        this.includefixtemptopbottom = PropertyFactory.getProperty(AquiferProperties.ISWITCH_FIXTEMPTOPBOTTOM);
        this.includegravity = PropertyFactory.getProperty(AquiferProperties.ISWITCH_PTS_DENSITY);
        this.includesubsidence = PropertyFactory.getProperty(AquiferProperties.ISWITCH_PTS_SUBSIDENCE);
        this.noflowbc = PropertyFactory.getProperty(AquiferProperties.ISWITCH_NOFLOWBC);
        this.outputfilemode = PropertyFactory.getProperty(AquiferProperties.IFILEFORMAT);
        this.vtkmode = PropertyFactory.getProperty(AquiferProperties.IFILEFORMATVTK);
        this.debugmode = PropertyFactory.getProperty(AquiferProperties.IDEBUG_OUTPUT);
        this.well_x = PropertyFactory.getProperty(AquiferProperties.IWELLX);
        this.well_y = PropertyFactory.getProperty(AquiferProperties.IWELLY);
        this.welldiameter = PropertyFactory.getProperty(AquiferProperties.IWELLDIAMETER);
        this.wellskin = PropertyFactory.getProperty(AquiferProperties.IWELLSKIN);
        this.welltemp = PropertyFactory.getProperty(AquiferProperties.IWELLTEMP);
        this.wellpressure = PropertyFactory.getProperty(AquiferProperties.IWELLPRES);
        this.wellvolrate = PropertyFactory.getProperty(AquiferProperties.IWELLFLOWRATE);
    }

    public void outputProp(String dir, ModelGrid g, int iformat) {
        this.writeOutput(AquiferProperties.IAQUIFERDEPTH, dir, OutputReference.topdepth, g, iformat);
        this.writeOutput(AquiferProperties.IACTNUM, dir, OutputReference.actnum, g, iformat);
        this.writeOutput(AquiferProperties.ITHICKNESS, dir, OutputReference.thickness, g, iformat);
        this.writeOutput(AquiferProperties.IPOROSITY, dir, OutputReference.poro, g, iformat);
        this.writeOutput(AquiferProperties.ING, dir, OutputReference.ntg, g, iformat);
        this.writeOutput(AquiferProperties.IINITIALTEMPERATURE, dir, OutputReference.temperatureinitial, g, iformat);
        this.writeOutput(AquiferProperties.IPERMEABILITYI, dir, OutputReference.permx, g, iformat);
        this.writeOutput(AquiferProperties.IPERMEABILITYJ, dir, OutputReference.permy, g, iformat);
        this.writeOutput(AquiferProperties.IPERMEABILITYK, dir, OutputReference.permz, g, iformat);
    }

    private void writeOutput(int iprop, String dir, String name, int timestep, ModelGrid g, int iformat) {
        String fullname = String.valueOf(name) + timestep;
        OutputReference ref = new OutputReference(iprop, dir, name, timestep, iformat);
        PropertyFactory.write(iprop, dir, fullname, g, iformat);
        this.gridresults.add(ref);
    }

    private void writeOutput(int iprop, String dir, String name, ModelGrid g, int iformat) {
        OutputReference ref = new OutputReference(iprop, dir, name, iformat);
        PropertyFactory.write(iprop, dir, name, g, iformat);
        this.gridresults.add(ref);
    }

    public void updateInput() {
        Object mask;
        if (this.geometry_mask instanceof Grid2DProperty && ((Grid2DProperty)this.geometry_mask).isUsegrid()) {
            mask = ((Grid2DProperty)this.geometry_mask).getInput();
            this.geometry_mask.setDefaultvalue(0.0);
            this.minx.setDefaultValue((double)((SmartGrid)mask).originx - 0.5 * (double)((SmartGrid)mask).dx);
            this.miny.setDefaultValue((double)((SmartGrid)mask).originy - 0.5 * (double)((SmartGrid)mask).dy);
            this.maxx.setDefaultValue((double)(((SmartGrid)mask).originx + ((SmartGrid)mask).dx * (float)((SmartGrid)mask).nx) - 0.5 * (double)((SmartGrid)mask).dx);
            this.maxy.setDefaultValue((double)(((SmartGrid)mask).originy + ((SmartGrid)mask).dy * (float)((SmartGrid)mask).ny) - 0.5 * (double)((SmartGrid)mask).dy);
            this.nx.setDefaultValue(((SmartGrid)mask).nx);
            this.ny.setDefaultValue(((SmartGrid)mask).ny);
        }
        if (this.geometry_mask instanceof Grid3DProperty && ((Grid3DProperty)this.geometry_mask).isUsegrid()) {
            this.geometry_mask.setDefaultvalue(1.0);
            mask = ((Grid3DProperty)this.geometry_mask).getInput();
            this.minx.setDefaultValue(((SmartVoxet)mask).getOriginx() - 0.5 * ((SmartVoxet)mask).getDx());
            this.miny.setDefaultValue(((SmartVoxet)mask).getOriginy() - 0.5 * ((SmartVoxet)mask).getDy());
            this.minz.setDefaultValue(((SmartVoxet)mask).getOriginz() - 0.5 * ((SmartVoxet)mask).getDz());
            this.maxx.setDefaultValue(((SmartVoxet)mask).getOriginx() + ((SmartVoxet)mask).getDx() * (double)((SmartVoxet)mask).getNx() - 0.5 * ((SmartVoxet)mask).getDx());
            this.maxy.setDefaultValue(((SmartVoxet)mask).getOriginy() + ((SmartVoxet)mask).getDy() * (double)((SmartVoxet)mask).getNy() - 0.5 * ((SmartVoxet)mask).getDy());
            this.maxz.setDefaultValue(((SmartVoxet)mask).getOriginz() + ((SmartVoxet)mask).getDz() * (double)((SmartVoxet)mask).getNz() - 0.5 * ((SmartVoxet)mask).getDz());
            this.nx.setDefaultValue(((SmartVoxet)mask).getNx());
            this.ny.setDefaultValue(((SmartVoxet)mask).getNy());
            this.nz.setDefaultValue(((SmartVoxet)mask).getNz());
            if (((SmartVoxet)mask).isGeometry_only()) {
                ((Grid3DProperty)this.aquifer_actnum).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.ACTNUM, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_actnum).setUsegrid(true);
                System.out.println("actnum set");
                ((Grid3DProperty)this.aquifer_thickness).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.THICKNESS, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_thickness).setUsegrid(true);
                ((Grid3DProperty)this.aquifer_actnumflow).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.ACTNUMFLOW, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_actnumflow).setUsegrid(true);
                ((Grid3DProperty)this.aquifer_actnumtemp).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.ACTNUMTEMP, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_actnumtemp).setUsegrid(true);
                ((Grid3DProperty)this.aquifer_connectxmin).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.CONNECTXMIN, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_connectxmin).setUsegrid(true);
                ((Grid3DProperty)this.aquifer_connectymin).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.CONNECTYMIN, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_connectymin).setUsegrid(true);
                ((Grid3DProperty)this.aquifer_connectzmin).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.CONNECTZMIN, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_connectzmin).setUsegrid(true);
                ((Grid3DProperty)this.aquifer_connectxplus).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.CONNECTXPLUS, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_connectxplus).setUsegrid(true);
                ((Grid3DProperty)this.aquifer_connectyplus).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.CONNECTYPLUS, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_connectyplus).setUsegrid(true);
                ((Grid3DProperty)this.aquifer_connectzplus).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.CONNECTZPLUS, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_connectzplus).setUsegrid(true);
                ((Grid3DProperty)this.aquifer_connectxmin_temp).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.CONNECTXMINTEMP, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_connectxmin_temp).setUsegrid(true);
                ((Grid3DProperty)this.aquifer_connectymin_temp).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.CONNECTYMINTEMP, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_connectymin_temp).setUsegrid(true);
                ((Grid3DProperty)this.aquifer_connectzmin_temp).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.CONNECTZMINTEMP, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_connectzmin_temp).setUsegrid(true);
                ((Grid3DProperty)this.aquifer_connectxplus_temp).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.CONNECTXPLUSTEMP, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_connectxplus_temp).setUsegrid(true);
                ((Grid3DProperty)this.aquifer_connectyplus_temp).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.CONNECTYPLUSTEMP, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_connectyplus_temp).setUsegrid(true);
                ((Grid3DProperty)this.aquifer_connectzplus_temp).setInput(new SmartVoxet(String.valueOf(((SmartVoxet)mask).getPath()) + "*" + EclipseGrid.CONNECTZPLUSTEMP, ((SmartVoxet)mask).getName()));
                ((Grid3DProperty)this.aquifer_connectzplus_temp).setUsegrid(true);
            }
        }
    }

    public void calculate(String curdir, ProgressDialog pd) {
        int igeom = PropertyFactory.getITYPEGEOM();
        PropertyFactory.printAllProperties();
        if (this.checkInput()) {
            this.gridresults.clear();
            if (igeom == 2) {
                this.calculate2D(curdir, pd);
            }
            if (igeom == 3) {
                this.calculate3D(curdir, pd);
            }
        }
    }

    public boolean checkInput() {
        boolean b = true;
        int i = 0;
        while (i < PropertyFactory.getITYPEVECTOR()) {
            double x = ((WellProperty)this.well_x).getValues()[i];
            double y = ((WellProperty)this.well_y).getValues()[i];
            if (this.minx.getDefaultvalue() > x || this.maxx.getDefaultvalue() < x || this.miny.getDefaultvalue() > y || this.maxy.getDefaultvalue() < y) {
                b = false;
            }
            ++i;
        }
        if (!b) {
            JOptionPane.showMessageDialog(this.frame, "Input well coordinates\nnot within Region Of Interest");
        }
        this.updateInput();
        if (this.pressuremode.getDefaultvalue() == 0.0 && ((WellProperty)this.wellvolrate).getSumValue() != 0.0) {
            JOptionPane.showMessageDialog(this.frame, "Input well flow rate\nnot in equilibrium");
            b = false;
        }
        return b;
    }

    public void calculate3D(String dir, ProgressDialog pd) {
        int fileformat = (int)PropertyFactory.getProperty(AquiferProperties.IFILEFORMAT).getDefaultvalue();
        double starttime = 0.0;
        boolean convectiontest = false;
        M3rk m = new M3rk(0.001);
        FtoolGrid3DregularGAPres ftool = new FtoolGrid3DregularGAPres(m);
        m.addftool(ftool);
        double temperature = this.aquifer_temp.getDefaultvalue();
        Property pmodel = PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE);
        pmodel.setDefaultvalue(temperature);
        Property pinitial = PropertyFactory.getProperty(AquiferProperties.IINITIALTEMPERATURE);
        pinitial.setDefaultvalue(temperature);
        GAPropertiesTemp gp = new GAPropertiesTemp(pmodel, pinitial);
        pmodel = PropertyFactory.getProperty(AquiferProperties.IMODELPRESSURE);
        pmodel.setDefaultvalue(0.0);
        pinitial = PropertyFactory.getProperty(AquiferProperties.IINITIALPRESSURE);
        pinitial.setDefaultvalue(0.0);
        GAPropertiesPres gpp = new GAPropertiesPres(pmodel, pinitial);
        ModelComponentContainer mcc = new ModelComponentContainer();
        mcc.add(gp);
        mcc.add(gpp);
        double dx = (this.maxx.getDefaultvalue() - this.minx.getDefaultvalue()) / (1.0 * this.nx.getDefaultvalue());
        double dy = (this.maxy.getDefaultvalue() - this.miny.getDefaultvalue()) / (1.0 * this.ny.getDefaultvalue());
        double dz = (this.maxz.getDefaultvalue() - this.minz.getDefaultvalue()) / (1.0 * this.nz.getDefaultvalue());
        double Ox = this.minx.getDefaultvalue() + 0.5 * dx;
        double Oy = this.miny.getDefaultvalue() + 0.5 * dy;
        double Oz = this.minz.getDefaultvalue() + 0.5 * dz;
        Grid3Dregular g = new Grid3Dregular(mcc, starttime, Ox, Oy, Oz, (int)this.nx.getDefaultvalue(), (int)this.ny.getDefaultvalue(), (int)this.nz.getDefaultvalue(), dx, dy, dz);
        PropertyFactory.updateGeometry(g);
        g.initializeValues();
        if (convectiontest) {
            ConvectionTest.modifyGridActnum(g, m);
            ConvectionTest.modifyGridTemperature(g, m);
        }
        int i = 0;
        while (i < PropertyFactory.getITYPEVECTOR()) {
            WellPerforation wp = new WellPerforation(((WellProperty)this.well_x).getValues()[i], ((WellProperty)this.well_y).getValues()[i], ((WellProperty)this.wellvolrate).getValues()[i] / 3600.0, ((WellProperty)this.welltemp).getValues()[i], ((WellProperty)this.wellpressure).getValues()[i], 0.5 * ((WellProperty)this.welldiameter).getValues()[i] * 2.54 * 0.01, g);
            g.addWellPerforation(wp);
            ++i;
        }
        g.getWpContainer().initializeWellBC(gp, g.getNz());
        g.getWpContainer().initializeWellBC(gpp, g.getNz());
        g.calculateVelfromWP(1);
        g.initializeBC();
        g.setUseVelocities(true);
        Step s = new Step();
        int interval = 1;
        int outputstep = (int)this.timestep.getDefaultvalue();
        int localtimestart = 0;
        int it = 0;
        while ((double)it <= this.timeend.getDefaultvalue()) {
            pd.setProgress((int)((double)it / this.timeend.getDefaultvalue() * 99.0 + 1.0));
            pd.setNote("simulation run (year " + it + ")");
            s.update(g, g.timepres, it, it, ftool.id);
            m.dostepForward(s, g);
            g.outputWellsTempPres(mcc.size(), it == 0, it, gpp.getBcContainer(), ftool.viscosity, ftool.salinity, ftool.totalpres);
            if ((it - localtimestart) % outputstep == 0) {
                this.writeOutput(AquiferProperties.IMODELTEMPERATURE, String.valueOf(dir) + "/", OutputReference.temperatureprefix, it, g, fileformat);
                this.writeOutput(AquiferProperties.IMODELPRESSURE, String.valueOf(dir) + "/", OutputReference.presureprefix, it, g, fileformat);
                if (PropertyFactory.getProperty(AquiferProperties.IDEBUG_OUTPUT).getDefaultvalue() == 1.0) {
                    Voxet v = PropertyFactory.getVoxet(dir, String.valueOf(OutputReference.velocityxprefix) + it, g, g.getVelx());
                    VoxetWriter.write(v);
                    v = PropertyFactory.getVoxet(dir, String.valueOf(OutputReference.velocityyprefix) + it, g, g.getVely());
                    VoxetWriter.write(v);
                    v = PropertyFactory.getVoxet(dir, String.valueOf(OutputReference.velocityzprefix) + it, g, g.getVelz());
                    VoxetWriter.write(v);
                    this.writeOutput(AquiferProperties.IMODELDIFTEMPERATURE, dir, String.valueOf(OutputReference.temperatureprefix) + "dif", it, g, fileformat);
                    this.writeOutput(AquiferProperties.IOUTPUTMASSBAL, dir, OutputReference.massbalprefix, it, g, fileformat);
                    this.writeOutput(AquiferProperties.IDENSITY, dir, OutputReference.densprefix, it, g, fileformat);
                    this.writeOutput(AquiferProperties.IDENSITYPSEUDOSOURCEK, dir, OutputReference.difdensprefixk, it, g, fileformat);
                    this.writeOutput(AquiferProperties.IDENSITYPSEUDOSOURCEI, dir, OutputReference.difdensprefixi, it, g, fileformat);
                    this.writeOutput(AquiferProperties.IDENSITYPSEUDOSOURCEJ, dir, OutputReference.difdensprefixj, it, g, fileformat);
                    this.writeOutput(AquiferProperties.IRHS, dir, OutputReference.righthandsideprefix, it, g, fileformat);
                }
                if (PropertyFactory.getProperty(AquiferProperties.IFILEFORMATVTK).getDefaultvalue() == 1.0) {
                    g.outputVTKformat(String.valueOf(dir) + "/" + "vtkgrid" + it);
                }
            }
            if ((double)it >= this.timeproductionend.getDefaultvalue()) {
                if (convectiontest) {
                    g.setUseVelocities(ConvectionTest.INCLUDEVELOCITIES);
                } else {
                    g.setUseVelocities(false);
                }
                outputstep = interval = (int)this.timesteppostprod.getDefaultvalue();
                localtimestart = (int)this.timeproductionend.getDefaultvalue();
                gp.getBcContainer().clear();
                gpp.getBcContainer().clear();
                g.getWpContainer().setDischargeMode(3);
            }
            it += interval;
        }
        if (PropertyFactory.getProperty(AquiferProperties.IDEBUG_OUTPUT).getDefaultvalue() == 1.0) {
            this.outputProp(dir, g, fileformat);
        }
        g.outputWells2File(dir);
        this.wellresults = g.getWpContainer();
    }

    public void calculate2D(String dir, ProgressDialog pd) {
        int i;
        int fileformat = (int)PropertyFactory.getProperty(AquiferProperties.IFILEFORMAT).getDefaultvalue();
        double starttime = 0.0;
        M3rk m = new M3rk(1.0E-4);
        FtoolGrid2DregularGAPres ftool = new FtoolGrid2DregularGAPres(m);
        m.addftool(ftool);
        Property tmodel = PropertyFactory.getProperty(AquiferProperties.IMODELTEMPERATURE);
        Property tinitial = PropertyFactory.getProperty(AquiferProperties.IINITIALTEMPERATURE);
        GAPropertiesTemp gp = new GAPropertiesTemp(tmodel, this.aquifer_temp);
        Property pmodel = PropertyFactory.getProperty(AquiferProperties.IMODELPRESSURE);
        pmodel.setDefaultvalue(0.0);
        Property pinitial = PropertyFactory.getProperty(AquiferProperties.IINITIALPRESSURE);
        pinitial.setDefaultvalue(0.0);
        GAPropertiesPres gpp = new GAPropertiesPres(pmodel, pinitial);
        ModelComponentContainer mcc = new ModelComponentContainer();
        mcc.add(gp);
        mcc.add(gpp);
        double dx = (this.maxx.getDefaultvalue() - this.minx.getDefaultvalue()) / (1.0 * this.nx.getDefaultvalue());
        double dy = (this.maxy.getDefaultvalue() - this.miny.getDefaultvalue()) / (1.0 * this.ny.getDefaultvalue());
        double Ox = this.minx.getDefaultvalue() + 0.5 * dx;
        double Oy = this.miny.getDefaultvalue() + 0.5 * dy;
        Grid2Dregular g = new Grid2Dregular(mcc, starttime, Ox, Oy, (int)this.nx.getDefaultvalue(), (int)this.ny.getDefaultvalue(), dx, dy, this.aquifer_thickness.getDefaultvalue());
        PropertyFactory.updateGeometry(g);
        g.initializeValues();
        g.setGridlevel();
        if (this.usefaults) {
            i = 0;
            while (i < this.nfaults) {
                g.initializeFault(this.faultsx1[i], this.faultsy1[i], this.faultsx2[i], this.faultsy2[i], i);
                ++i;
            }
            g.getFlContainer().initializeFaults(g);
            g.outputFaults(String.valueOf(dir) + "/faults", 1);
        }
        i = 0;
        while (i < PropertyFactory.getITYPEVECTOR()) {
            WellPerforation wp = new WellPerforation(((WellProperty)this.well_x).getValues()[i], ((WellProperty)this.well_y).getValues()[i], ((WellProperty)this.wellvolrate).getValues()[i] / 3600.0, ((WellProperty)this.welltemp).getValues()[i], ((WellProperty)this.wellpressure).getValues()[i], 0.5 * ((WellProperty)this.welldiameter).getValues()[i] * 2.54 * 0.01, ((WellProperty)this.wellskin).getValues()[i], g);
            g.addWellPerforation(wp);
            ++i;
        }
        g.getWpContainer().initializeWellBC(gp, g.getNz());
        g.getWpContainer().initializeWellBC(gpp, g.getNz());
        g.calculateVelfromWP(1);
        g.initializeBC();
        g.setUseVelocities(true);
        Step s = new Step();
        int interval = 1;
        int outputstep = (int)this.timestep.getDefaultvalue();
        int localtimestart = 0;
        int it = 0;
        while ((double)it <= this.timeend.getDefaultvalue()) {
            boolean updatesubs;
            pd.setProgress((int)((double)it / this.timeend.getDefaultvalue() * 99.0 + 1.0));
            pd.setNote("simulation run (year " + it + ")");
            s.update(g, g.timepres, it, it, ftool.id);
            m.dostepForward(s, g);
            g.outputWells(mcc.size(), it == 0, it, ftool.viscosity, ftool.salinity, ftool.totalpres);
            if ((it - localtimestart) % outputstep == 0) {
                this.writeOutput(AquiferProperties.IMODELTEMPERATURE, String.valueOf(dir) + "/", OutputReference.temperatureprefix, it, g, fileformat);
                this.writeOutput(AquiferProperties.IMODELPRESSURE, String.valueOf(dir) + "/", OutputReference.presureprefix, it, g, fileformat);
                if (PropertyFactory.getProperty(AquiferProperties.IDEBUG_OUTPUT).getDefaultvalue() == 1.0) {
                    g.outputVel(0, String.valueOf(dir) + "/" + OutputReference.velocityxprefix + it, fileformat);
                    g.outputVel(1, String.valueOf(dir) + "/" + OutputReference.velocityyprefix + it, fileformat);
                    this.writeOutput(AquiferProperties.IVISCOSITY, String.valueOf(dir) + "/", OutputReference.viscosityprefix, it, g, fileformat);
                }
                if (PropertyFactory.getProperty(AquiferProperties.IFILEFORMATVTK).getDefaultvalue() == 1.0) {
                    g.outputVTKformat(String.valueOf(dir) + "/" + "vtkgrid" + it);
                }
            }
            if ((double)it >= this.timeproductionend.getDefaultvalue()) {
                g.setUseVelocities(false);
                outputstep = interval = (int)this.timesteppostprod.getDefaultvalue();
                localtimestart = (int)this.timeproductionend.getDefaultvalue();
                gp.getBcContainer().clear();
                gpp.getBcContainer().clear();
                g.getWpContainer().setDischargeMode(3);
            }
            boolean bl = updatesubs = PropertyFactory.getProperty(AquiferProperties.ISWITCH_PTS_SUBSIDENCE).getDefaultvalue() == 1.0;
            if (updatesubs) {
                AquiferCalculateSubsidence.calculate2D(g.getOrx(), g.getOry(), g.getDx(), g.getDy(), 4, String.valueOf(dir) + "/" + OutputReference.subsidenceprefix + it + "_aesubs_compactionssources.txt");
                this.writeOutput(AquiferProperties.ISUBSIDENCE, String.valueOf(dir) + "/", OutputReference.subsidenceprefix, it, g, fileformat);
            }
            it += interval;
        }
        if (PropertyFactory.getProperty(AquiferProperties.IDEBUG_OUTPUT).getDefaultvalue() == 1.0) {
            this.outputProp(dir, g, fileformat);
        }
        g.outputWells2File(dir);
        this.wellresults = g.getWpContainer();
    }

    public Property getAquifer_porosity() {
        return this.aquifer_porosity;
    }

    public Property getAquifer_temp() {
        return this.aquifer_temp;
    }

    public Property getAquifer_thickness() {
        return this.aquifer_thickness;
    }

    public Property getMaxx() {
        return this.maxx;
    }

    public Property getMaxy() {
        return this.maxy;
    }

    public Property getMinx() {
        return this.minx;
    }

    public Property getMiny() {
        return this.miny;
    }

    public Property getMinz() {
        return this.minz;
    }

    public Property getMaxz() {
        return this.maxz;
    }

    public Property getNx() {
        return this.nx;
    }

    public Property getNy() {
        return this.ny;
    }

    public Property getNz() {
        return this.nz;
    }

    public Property getTimeend() {
        return this.timeend;
    }

    public Property getTimestep() {
        return this.timestep;
    }

    public Property getWell_pressure() {
        return this.wellpressure;
    }

    public Property getWell_temp() {
        return this.welltemp;
    }

    public Property getWell_volrate() {
        return this.wellvolrate;
    }

    public Property getWell_x() {
        return this.well_x;
    }

    public Property getWell_y() {
        return this.well_y;
    }

    public Property getWelldiameter() {
        return this.welldiameter;
    }

    public Property getWellskin() {
        return this.wellskin;
    }

    public Property getTimeproductionend() {
        return this.timeproductionend;
    }

    public float[] getWellsX() {
        float[] x = new float[PropertyFactory.getITYPEVECTOR()];
        int i = 0;
        while (i < PropertyFactory.getITYPEVECTOR()) {
            x[i] = (float)((WellProperty)this.well_x).getValues()[i];
            ++i;
        }
        return x;
    }

    public float[] getWellsY() {
        float[] y = new float[PropertyFactory.getITYPEVECTOR()];
        int i = 0;
        while (i < PropertyFactory.getITYPEVECTOR()) {
            y[i] = (float)((WellProperty)this.well_y).getValues()[i];
            ++i;
        }
        return y;
    }

    public String[] getWellsStrings() {
        String[] names = new String[PropertyFactory.getITYPEVECTOR()];
        int i = 0;
        while (i < PropertyFactory.getITYPEVECTOR()) {
            double rate = this.pressuremode.getDefaultvalue() == 1.0 ? ((WellProperty)this.wellpressure).getValues()[i] : ((WellProperty)this.wellvolrate).getValues()[i];
            names[i] = rate < 0.0 ? "Well " + i + " [producer]" : "Well " + i + " [injector]";
            ++i;
        }
        return names;
    }

    public Property getAquifer_ch() {
        return this.aquifer_ch;
    }

    public Property getAquifer_c() {
        return this.aquifer_c;
    }

    public Property getAquifer_perm_x_mdarcy() {
        return this.aquifer_perm_x_mdarcy;
    }

    public Property getAquifer_perm_y_mdarcy() {
        return this.aquifer_perm_y_mdarcy;
    }

    public Property getAquifer_perm_z_mdarcy() {
        return this.aquifer_perm_z_mdarcy;
    }

    public Property getAquifer_viscoinjection() {
        return this.aquifer_viscoinjection;
    }

    public Property getAquifer_salinity() {
        return this.aquifer_salinity;
    }

    public Property getAquifer_depth() {
        return this.aquifer_depth;
    }

    public Property getAquifer_ntg() {
        return this.aquifer_ntg;
    }

    public Property getAquifer_actnum() {
        return this.aquifer_actnum;
    }

    public Property getViscosityMode() {
        return this.viscositymode;
    }

    public Property getPressureMode() {
        return this.pressuremode;
    }

    public WellPerforationContainer getWellresults() {
        return this.wellresults;
    }

    public OutputReferenceContainer getGridresults() {
        return this.gridresults;
    }

    public Property getGeometryMask() {
        return this.geometry_mask;
    }

    public Property getIncludewall() {
        return this.includewall;
    }

    public Property getTimestepPostProd() {
        return this.timesteppostprod;
    }

    public Property getRock_c() {
        return this.rock_c;
    }

    public Property getRock_ch() {
        return this.rock_ch;
    }

    public Property getRock_rho() {
        return this.rock_rho;
    }

    public Property getRock_E() {
        return this.rock_E;
    }

    public Property getRock_v() {
        return this.rock_v;
    }

    public Property getRock_cm() {
        return this.rock_cm;
    }

    public Property getRock_ct() {
        return this.rock_ct;
    }

    public Property getOutputfilemode() {
        return this.outputfilemode;
    }

    public Property getVtkmode() {
        return this.vtkmode;
    }

    public Property getDebugmode() {
        return this.debugmode;
    }

    public Property getNoFlowBC() {
        return this.noflowbc;
    }

    public Property getIncludefixtemptopbottom() {
        return this.includefixtemptopbottom;
    }

    public Property getIncludesubsidence() {
        return this.includesubsidence;
    }

    public Property getIncludegravity() {
        return this.includegravity;
    }
}

