/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer;

import tno.geoenergy.data.Voxet;
import tno.geoenergy.data.VoxetReader;
import tno.geoenergy.fdintegration.integration.M3rk;
import tno.geoenergy.fdintegration.model.GAPropertiesTemp;
import tno.geoenergy.fdintegration.model.model3d.Grid3Dregular;
import tno.geoenergy.properties.AquiferProperties;
import tno.geoenergy.properties.PropertyFactory;

public class ConvectionTest {
    public static boolean INCLUDEVELOCITIES = true;
    private static int NZTOP = 45;
    private static int NZRES = 5;
    private static int NZMARGIN = 500;
    private static GAPropertiesTemp gp = null;
    private static double TEMPSURF = 10.0;
    private static double TEMPGRAD = 31.0;

    public static void modifyGridTemperature(Grid3Dregular g, M3rk m3rk) {
        int j;
        double[][][] h = null;
        double[][][] initialtemperature = null;
        int nx = g.getNx();
        int ny = g.getNy();
        int nz = g.getNz();
        int component = 0;
        h = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.ITHICKNESS), h);
        initialtemperature = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IINITIALTEMPERATURE), initialtemperature);
        int n = 0;
        double temptop = 0.0;
        double tempbase = 0.0;
        int i = 0;
        while (i < nx) {
            j = 0;
            while (j < ny) {
                double z = 0.0;
                int k = 0;
                while (k < nz) {
                    z = k == 0 ? (z += 0.5 * h[i][j][k]) : (z += h[i][j][k]);
                    double temperature = TEMPSURF + z * TEMPGRAD * 0.001;
                    n = g.getM3rkIndex(component, i, j, k);
                    if (k == NZTOP - NZMARGIN) {
                        temptop = temperature;
                    }
                    if (k == NZTOP + NZRES + NZMARGIN) {
                        tempbase = temperature;
                    }
                    Grid3Dregular.getGeotherm()[n] = temperature;
                    Grid3Dregular.getInigeotherm()[n] = temperature;
                    initialtemperature[i][j][k] = temperature;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nx) {
            j = 0;
            while (j < ny) {
                int k = 0;
                while (k < nz) {
                    n = g.getM3rkIndex(component, i, j, k);
                    if (k < NZTOP - NZMARGIN) {
                        Grid3Dregular.getGeotherm()[n] = temptop;
                        Grid3Dregular.getInigeotherm()[n] = temptop;
                        initialtemperature[i][j][k] = temptop;
                    }
                    if (k > NZTOP + NZRES + NZMARGIN) {
                        Grid3Dregular.getGeotherm()[n] = tempbase;
                        Grid3Dregular.getInigeotherm()[n] = tempbase;
                        initialtemperature[i][j][k] = tempbase;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void modifyGridActnum(Grid3Dregular g, M3rk m3rk) {
        Object h = null;
        Object initialtemperature = null;
        int nx = g.getNx();
        int ny = g.getNy();
        int nz = g.getNz();
        boolean component = false;
        boolean n = false;
        double[][][] actnum = null;
        actnum = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IACTNUM), actnum);
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                int k = 0;
                while (k < nz) {
                    if (k < NZTOP || k > NZTOP + NZRES) {
                        actnum[i][j][k] = 0.0;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void modifyGridPermWall(Grid3Dregular g, M3rk m3rk) {
        double[][][] kv = null;
        Object initialtemperature = null;
        int nx = g.getNx();
        int ny = g.getNy();
        int nz = g.getNz();
        boolean component = false;
        boolean n = false;
        kv = PropertyFactory.getValues(PropertyFactory.getProperty(AquiferProperties.IPERMEABILITYK), kv);
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                int k = 0;
                while (k < nz) {
                    if (k >= NZTOP && k <= NZTOP + NZRES && (i == nx / 4 || i == 3 * nx / 4)) {
                        double[] dArray = kv[i][j];
                        int n2 = k;
                        dArray[n2] = dArray[n2] * 100.0;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private static double[][] getPilarSlice(Voxet prop, Voxet thick, double x, double y) {
        int i = prop.getI(x);
        int j = prop.getJ(y);
        double ztemp = 0.0;
        float[][][] allpropval = prop.getValues();
        float[][][] allthickval = thick.getValues();
        float[] propval = new float[prop.getNz()];
        int k = 0;
        while (k < prop.getNz()) {
            propval[k] = allpropval[k][j][i];
            ++k;
        }
        float[] thickval = new float[thick.getNz()];
        k = 0;
        while (k < thick.getNz()) {
            thickval[k] = allthickval[k][j][i];
            ++k;
        }
        double[][] res = new double[prop.getNz()][2];
        int p = 0;
        while (p < propval.length) {
            res[p][0] = propval[p];
            res[p][1] = ztemp += (double)thickval[p];
            ++p;
        }
        return res;
    }

    public static void PilarValues() {
        String SEP = " \t ";
        String base = "C:\\Users\\lipseylc\\AppData\\Local\\My Local Documents\\projectruns\\";
        double x = 3900.0;
        double y = 2500.0;
        int z = 39;
        Voxet thick = VoxetReader.read(String.valueOf(base) + "thickness" + ".vo");
        Voxet temp = VoxetReader.read(String.valueOf(base) + "temp_init" + ".vo");
        Voxet temp1 = VoxetReader.read(String.valueOf(base) + "temp10005" + ".vo");
        Voxet temp2 = VoxetReader.read(String.valueOf(base) + "temp19005" + ".vo");
        double[][] res = ConvectionTest.getPilarSlice(temp, thick, x, y);
        double[][] res1 = ConvectionTest.getPilarSlice(temp1, thick, x, y);
        double[][] res2 = ConvectionTest.getPilarSlice(temp2, thick, x, y);
        System.out.println("x, y, z, temp_init, temp10005, temp19005");
        int i = 0;
        while (i < res.length) {
            System.out.println(String.valueOf(x) + SEP + y + SEP + res[i][1] + SEP + res[i][0] + SEP + res1[i][0] + SEP + res2[i][0]);
            ++i;
        }
        System.out.println();
        System.out.println("time, temperature");
        int v = 5;
        while (v < 5005) {
            Voxet vox = VoxetReader.read(String.valueOf(base) + "temp" + v + ".vo");
            int i2 = vox.getI(x);
            int j = vox.getJ(y);
            int k = z;
            float val = vox.getValues()[k][j][i2];
            System.out.println(String.valueOf(v) + SEP + val);
            v += 1000;
        }
    }

    public static void main(String[] args) {
        ConvectionTest.PilarValues();
    }
}

