/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer;

import tno.geoenergy.properties.Property;
import tno.geoenergy.properties.PropertyFactory;

public class OutputReference {
    public static String presureprefix = "pres";
    public static String temperatureprefix = "temp";
    public static String viscosityprefix = "visc";
    public static String subsidenceprefix = "subs";
    public static String velocityxprefix = "velx";
    public static String velocityyprefix = "vely";
    public static String velocityzprefix = "velz";
    public static String massbalprefix = "massbal";
    public static String refdensprefix = "refdens";
    public static String difdensprefixk = "difdensk";
    public static String difdensprefixi = "difdensi";
    public static String difdensprefixj = "difdensj";
    public static String densprefix = "dens";
    public static String righthandsideprefix = "rhs";
    public static String topdepth = "topdepth";
    public static String actnum = "actnum";
    public static String thickness = "thickness";
    public static String poro = "porosity";
    public static String ntg = "ng";
    public static String temperatureinitial = "temp_init";
    public static String ranfactors = "ranfactors";
    public static String permx = "permx";
    public static String permy = "permy";
    public static String permz = "permz";
    String pname;
    String basename;
    String units;
    int timestep = -1;
    String filename;
    float min;
    float max;
    String[] EXT = new String[]{".grd", ".asc", ".dat", ".txt", ".csv"};

    public OutputReference(Property p, String basedir, String name, int iformat) {
        this.init(p, basedir, name, iformat);
    }

    public OutputReference(int iprop, String basedir, String name, int iformat) {
        Property p = PropertyFactory.getProperty(iprop);
        this.init(p, basedir, name, iformat);
    }

    public OutputReference(Property p, String basedir, String name, int tstep, int iformat) {
        this.init(p, basedir, name, iformat);
        this.timestep = tstep;
        this.filename = String.valueOf(basedir) + name + tstep + this.EXT[iformat];
    }

    public OutputReference(int iprop, String basedir, String name, int tstep, int iformat) {
        Property p = PropertyFactory.getProperty(iprop);
        this.init(p, basedir, name, iformat);
        this.timestep = tstep;
        this.filename = String.valueOf(basedir) + name + tstep + this.EXT[iformat];
    }

    private void init(Property p, String basedir, String name, int iformat) {
        this.pname = p.getName();
        this.units = p.getUnits();
        this.basename = name;
        if (!basedir.endsWith("\\")) {
            basedir = String.valueOf(basedir) + "\\";
        }
        this.filename = String.valueOf(basedir) + name + this.EXT[iformat];
    }

    public String getName() {
        return this.basename;
    }

    public String getFileName() {
        return this.filename;
    }

    public String getUnits() {
        return this.units;
    }

    public boolean isTimeStepped() {
        return this.timestep > -1;
    }
}

