/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JLabel;
import tno.geoenergy.geothermalaquifer.OutputReference;

public class OutputReferenceContainer
extends HashMap<String, ArrayList<OutputReference>> {
    public void add(OutputReference ref) {
        if (this.containsKey(ref.getName())) {
            ((ArrayList)this.get(ref.getName())).add(ref);
        } else {
            ArrayList<OutputReference> reftypelist = new ArrayList<OutputReference>();
            reftypelist.add(ref);
            this.put(ref.getName(), reftypelist);
        }
    }

    public List<Integer> getTimeSteps(String key) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (OutputReference ref : (ArrayList)this.get(key)) {
            res.add(ref.timestep);
        }
        Collections.sort(res);
        return res;
    }

    public Hashtable<Integer, JLabel> getTimeStepLabels(String key) {
        Hashtable<Integer, JLabel> res = new Hashtable<Integer, JLabel>();
        List<Integer> steps = this.getTimeSteps(key);
        int i = 0;
        while (i < steps.size()) {
            res.put(new Integer(i), new JLabel(steps.get(i).toString()));
            ++i;
        }
        return res;
    }

    public OutputReference getMap(String key, int timestep) {
        if (this.containsKey(key)) {
            ArrayList reflist = (ArrayList)this.get(key);
            for (OutputReference ref : reflist) {
                if (!ref.isTimeStepped()) {
                    return ref;
                }
                if (ref.timestep != timestep) continue;
                return ref;
            }
        }
        return null;
    }
}

