/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import tno.geoenergy.geothermalaquifer.AQUIFERMAIN;
import tno.geoenergy.geothermalaquifer.AquiferProject;
import tno.geoenergy.geothermalaquifer.gui.AboutDialog;
import tno.geoenergy.geothermalaquifer.gui.InputPanelAdvanced;
import tno.geoenergy.geothermalaquifer.gui.InputPanelAquifer;
import tno.geoenergy.geothermalaquifer.gui.InputPanelWells;
import tno.geoenergy.geothermalaquifer.gui.OutputPanelGrid;
import tno.geoenergy.geothermalaquifer.gui.OutputPanelWells;
import tno.geoenergy.geothermalaquifer.gui.ProgressDialog;
import tno.geoenergy.geothermalaquifer.gui.gridview.RawGridViewControl;
import tno.geoenergy.logging.Logger;
import tno.geoenergy.properties.PropertyFactory;

public class AquiferDialog
extends JFrame
implements ActionListener {
    public static int GUIMODE2D = 0;
    public static int GUIMODE2D3D = 1;
    public static Preferences prefs;
    public static String lastOutputDir;
    private static Logger logger;
    JButton new2DProject;
    JButton new3DProject;
    JButton loadProject;
    JButton saveproject;
    JButton calculate;
    JButton viewGrid;
    JButton help;
    JFileChooser fc;
    String filename;
    JTabbedPane tabPane;
    JPanel menuBar;
    InputPanelAquifer inputAquiferTab;
    InputPanelAdvanced inputAdvancedTab;
    public InputPanelWells inputWellsTab;
    OutputPanelWells outputWellsTab;
    OutputPanelGrid outputGridTab;

    static {
        logger = Logger.getLogger(AquiferDialog.class.getName());
    }

    public void setupTabPanels() {
        this.tabPane = new JTabbedPane();
        this.inputAquiferTab = new InputPanelAquifer(this);
        this.tabPane.addTab("Input Aquifer", this.inputAquiferTab);
        this.tabPane.setComponentAt(0, this.inputAquiferTab);
        this.inputAdvancedTab = new InputPanelAdvanced(this);
        this.tabPane.addTab("Advanced Settings", this.inputAdvancedTab);
        this.tabPane.setComponentAt(1, this.inputAdvancedTab);
        this.inputWellsTab = new InputPanelWells(this);
        this.tabPane.addTab("Input Wells", this.inputWellsTab);
        this.tabPane.setComponentAt(2, this.inputWellsTab);
        this.outputWellsTab = new OutputPanelWells(this);
        this.tabPane.addTab("Well Results", this.outputWellsTab);
        this.tabPane.setComponentAt(3, this.outputWellsTab);
        this.outputGridTab = new OutputPanelGrid(this);
        this.tabPane.addTab("Grid Results", this.outputGridTab);
        this.tabPane.setComponentAt(4, this.outputGridTab);
        this.tabPane.setVisible(false);
        this.getContentPane().add((Component)this.tabPane, "Center");
    }

    public void setupMenuBar(int guiMode) {
        this.menuBar = new JPanel();
        this.menuBar.setLayout(new GridLayout(1, 5, 20, 20));
        this.new2DProject = new JButton("New 2D Project");
        this.new2DProject.addActionListener(this);
        this.new3DProject = new JButton("New 3D Project");
        this.new3DProject.addActionListener(this);
        this.loadProject = new JButton("Load Project");
        this.loadProject.addActionListener(this);
        this.saveproject = new JButton("Save project");
        this.saveproject.addActionListener(this);
        this.saveproject.setEnabled(false);
        this.calculate = new JButton("Calculate");
        this.calculate.addActionListener(this);
        this.calculate.setEnabled(false);
        this.viewGrid = new JButton("View Grid");
        this.viewGrid.addActionListener(this);
        this.help = new JButton("About");
        this.help.addActionListener(this);
        this.menuBar.add(this.new2DProject);
        if (guiMode == GUIMODE2D3D) {
            this.menuBar.add(this.new3DProject);
        }
        this.menuBar.add(this.loadProject);
        this.menuBar.add(this.saveproject);
        this.menuBar.add(this.calculate);
        this.menuBar.add(this.viewGrid);
        this.menuBar.add(this.help);
        this.getContentPane().add((Component)this.menuBar, "North");
    }

    public AquiferDialog(String t, int guiMode) {
        super(t);
        this.setDefaultCloseOperation(3);
        prefs = Preferences.userNodeForPackage(this.getClass());
        lastOutputDir = prefs.get("LAST_OUTPUT_DIR", ".");
        URL iconURL = this.getClass().getResource(AQUIFERMAIN.getIconName());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(iconURL));
        this.setupMenuBar(guiMode);
        this.setupTabPanels();
    }

    public void About() {
        AboutDialog dlg = new AboutDialog();
        dlg.setVisible(true);
    }

    public void loadFile() {
        this.fc = new JFileChooser(lastOutputDir);
        FileNameExtensionFilter prjf = new FileNameExtensionFilter("projects (*.xml)", "xml");
        this.fc.addChoosableFileFilter(prjf);
        this.fc.setFileFilter(prjf);
        int returnVal = this.fc.showOpenDialog(this);
        if (returnVal == 0) {
            this.filename = this.fc.getSelectedFile().getPath();
            prefs.put("LAST_OUTPUT_DIR", this.fc.getSelectedFile().getParent());
            try {
                File file = new File(this.filename);
                if (file.exists()) {
                    AQUIFERMAIN.read(file, this);
                    AQUIFERMAIN.setCurrentDir(file.getParent());
                    AQUIFERMAIN.updateGUIFromProject();
                    this.tabPane.setVisible(true);
                    this.saveproject.setEnabled(true);
                    this.calculate.setEnabled(true);
                    this.setTitle(String.valueOf(AQUIFERMAIN.getProductName()) + " : " + PropertyFactory.getITYPEGEOM() + "D project | " + this.filename);
                } else {
                    JOptionPane.showMessageDialog(this, "file does not exist\n" + this.filename);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveFile() {
        this.fc = new JFileChooser(lastOutputDir);
        FileNameExtensionFilter prjf = new FileNameExtensionFilter("projects (*.xml)", "xml");
        this.fc.addChoosableFileFilter(prjf);
        this.fc.setFileFilter(prjf);
        int returnVal = this.fc.showSaveDialog(this);
        if (returnVal == 0) {
            this.filename = this.fc.getSelectedFile().getPath();
            if (!this.filename.endsWith(".xml")) {
                this.filename = String.valueOf(this.filename) + ".xml";
            }
            prefs.put("LAST_OUTPUT_DIR", this.fc.getSelectedFile().getParent());
            try {
                AQUIFERMAIN.updateProjectFromGUI();
                AQUIFERMAIN.getProject().saveProject(this.filename, this);
                AQUIFERMAIN.setCurrentDir(this.fc.getSelectedFile().getParent());
                this.setTitle(String.valueOf(AQUIFERMAIN.getProductName()) + " : " + PropertyFactory.getITYPEGEOM() + "D project | " + this.filename);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, String.valueOf(e.getMessage()) + "\n" + this.filename);
            }
        }
    }

    private void calculate() {
        Object error = null;
        final ProgressDialog progressDialog = new ProgressDialog((Frame)this, "Running Simulation");
        String file = AQUIFERMAIN.getCurrentDir();
        if (file == null) {
            JOptionPane.showMessageDialog(this, "SAVE PROJECT BEFORE RUN");
        } else {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    String curdir = AQUIFERMAIN.getCurrentDir();
                    AQUIFERMAIN.updateProjectFromGUI();
                    AQUIFERMAIN.calculate(curdir, progressDialog);
                    AQUIFERMAIN.updateGUIFromProject();
                }
            };
            progressDialog.setTask(task);
            progressDialog.setShowCancelButton(false);
            progressDialog.setVisible(true);
            error = progressDialog.getResult();
            if (error != null) {
                logger.info("Error while running samples: 0");
                String title = "Error while running simulation!";
                JOptionPane.showMessageDialog(this, error, title, 0);
            }
        }
    }

    public void makeRawGridView() {
        this.fc = new JFileChooser(lastOutputDir);
        FileNameExtensionFilter file3d = new FileNameExtensionFilter("3D voxets (*.vo)", "vo");
        FileNameExtensionFilter file2d = new FileNameExtensionFilter("2D grids (*.grd, *.asc)", "grd", "asc");
        FileNameExtensionFilter file23d = new FileNameExtensionFilter("2D grids & 3D voxets", "vo", "grd", "asc");
        this.fc.addChoosableFileFilter(file3d);
        this.fc.addChoosableFileFilter(file2d);
        this.fc.addChoosableFileFilter(file23d);
        int returnVal = this.fc.showOpenDialog(this);
        if (returnVal == 0) {
            this.filename = this.fc.getSelectedFile().getPath();
            prefs.put("LAST_OUTPUT_DIR", this.fc.getSelectedFile().getParent());
            AquiferDialog.makeRawGridView(this.filename, this);
        }
    }

    public void setWorkingDirectory() {
        this.fc = new JFileChooser(lastOutputDir);
        this.fc.setFileSelectionMode(1);
        int returnVal = this.fc.showDialog(this, "Select working directory");
        if (returnVal == 0) {
            AQUIFERMAIN.setCurrentDir(this.fc.getSelectedFile().getPath());
            prefs.put("LAST_OUTPUT_DIR", this.fc.getSelectedFile().getPath());
        }
    }

    public static void makeRawGridView(String filename, Frame f) {
        try {
            File file = new File(filename);
            if (file.exists() || filename.contains("*")) {
                if (AQUIFERMAIN.getProject() == null) {
                    RawGridViewControl frame = new RawGridViewControl(filename, null, null, null, true);
                } else {
                    AQUIFERMAIN.updateProjectFromGUI();
                    float[] x = AQUIFERMAIN.getProject().getWellsX();
                    float[] y = AQUIFERMAIN.getProject().getWellsY();
                    String[] wells = AQUIFERMAIN.getProject().getWellsStrings();
                    RawGridViewControl rawGridViewControl = new RawGridViewControl(filename, AQUIFERMAIN.getProject().getWellsX(), AQUIFERMAIN.getProject().getWellsY(), AQUIFERMAIN.getProject().getWellsStrings(), true);
                }
            } else {
                JOptionPane.showMessageDialog(f, "file does not exist\n" + filename);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private void newFile(int igeom) {
        boolean ok = true;
        if (AQUIFERMAIN.getCurrentDir() == null) {
            this.setWorkingDirectory();
        }
        if (AQUIFERMAIN.getProject() != null) {
            int i = JOptionPane.showConfirmDialog(this, "Use current working directory and overwrite existing project?");
            boolean bl = ok = i == 0;
        }
        if (!ok) {
            this.setWorkingDirectory();
            ok = true;
        }
        if (ok) {
            System.out.println("project type " + igeom);
            AQUIFERMAIN.setProject(new AquiferProject(igeom));
            AQUIFERMAIN.updateGUIFromProject();
            this.tabPane.setVisible(true);
            this.saveproject.setEnabled(true);
            this.calculate.setEnabled(true);
            this.setTitle(String.valueOf(AQUIFERMAIN.getProductName()) + " : " + igeom + "D project | " + AQUIFERMAIN.getCurrentDir() + "*");
        }
    }

    public void updateProjectFromGUI(AquiferProject project) {
        this.inputAquiferTab.updateProjectFromGUI(project);
        this.inputAdvancedTab.updateProjectFromGUI(project);
        this.inputWellsTab.updateProjectFromGUI(project);
    }

    public void updateGUIFromProject(AquiferProject project) {
        this.inputAquiferTab.updateGUIFromProject(project);
        this.inputAdvancedTab.updateGUIFromProject(project);
        this.inputWellsTab.refresh();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.new2DProject) {
            this.newFile(2);
        } else if (evt.getSource() == this.new3DProject) {
            this.newFile(3);
        } else if (evt.getSource() == this.loadProject) {
            this.loadFile();
        } else if (evt.getSource() == this.saveproject) {
            this.saveFile();
        } else if (evt.getSource() == this.calculate) {
            this.calculate();
        } else if (evt.getSource() == this.viewGrid) {
            this.makeRawGridView();
        } else if (evt.getSource() == this.help) {
            this.About();
        }
    }

    public void updateGUIResults(AquiferProject project) {
        this.outputWellsTab.update();
        if (PropertyFactory.getITYPEGEOM() == 2) {
            this.outputGridTab.update();
        }
    }
}

