/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import tno.geoenergy.geothermalaquifer.AquiferProject;
import tno.geoenergy.geothermalaquifer.gui.GridBagAdder;
import tno.geoenergy.geothermalaquifer.gui.LayoutUtil;
import tno.geoenergy.geothermalaquifer.gui.PanelsUtil;
import tno.geoenergy.geothermalaquifer.gui.components.GuiPropertyButton;
import tno.geoenergy.geothermalaquifer.gui.components.GuiPropertyField;
import tno.geoenergy.geothermalaquifer.gui.components.GuiPropertyFieldButton;
import tno.geoenergy.logging.Logger;
import tno.geoenergy.properties.PropertyFactory;

public class InputPanelAquifer
extends JPanel {
    private static Logger logger = Logger.getLogger(InputPanelAquifer.class.getName());
    int fieldwith = 50;
    int filedheight = 20;
    boolean is3D = false;
    GuiPropertyField nx;
    GuiPropertyField minx;
    GuiPropertyField maxx;
    GuiPropertyField ny;
    GuiPropertyField miny;
    GuiPropertyField maxy;
    GuiPropertyField nz;
    GuiPropertyField minz;
    GuiPropertyField maxz;
    GuiPropertyButton geometry_mask;
    GuiPropertyFieldButton g_aquifer_temp;
    GuiPropertyFieldButton g_aquifer_thickness;
    GuiPropertyFieldButton g_aquifer_porosity;
    GuiPropertyFieldButton g_aquifer_ntg;
    GuiPropertyFieldButton g_aquifer_actnum;
    GuiPropertyFieldButton g_aquifer_perm_x_mdarcy;
    GuiPropertyFieldButton g_aquifer_perm_y_mdarcy;
    GuiPropertyFieldButton g_aquifer_perm_z_mdarcy;
    GuiPropertyFieldButton g_aquifer_depth;
    GuiPropertyField g_aquifer_salinity;
    GuiPropertyField g_timeproductionend;
    GuiPropertyField g_timeend;
    GuiPropertyField g_timestep;
    GuiPropertyField g_timesteppostprod;
    Frame parent;

    public InputPanelAquifer(Frame parent) {
        this.parent = parent;
        this.initialize();
    }

    private void initialize() {
        GuiPropertyField[] roi3d;
        GuiPropertyField[] roi;
        this.geometry_mask = new GuiPropertyButton(this.parent);
        this.g_aquifer_temp = new GuiPropertyFieldButton(this.parent, this.geometry_mask);
        this.g_aquifer_thickness = new GuiPropertyFieldButton(this.parent, this.geometry_mask);
        this.g_aquifer_porosity = new GuiPropertyFieldButton(this.parent, this.geometry_mask);
        this.g_aquifer_ntg = new GuiPropertyFieldButton(this.parent, this.geometry_mask);
        this.g_aquifer_actnum = new GuiPropertyFieldButton(this.parent, this.geometry_mask);
        this.g_aquifer_depth = new GuiPropertyFieldButton(this.parent, this.geometry_mask, 2);
        this.g_aquifer_perm_x_mdarcy = new GuiPropertyFieldButton(this.parent, this.geometry_mask);
        this.g_aquifer_perm_y_mdarcy = new GuiPropertyFieldButton(this.parent, this.geometry_mask);
        this.g_aquifer_perm_z_mdarcy = new GuiPropertyFieldButton(this.parent, this.geometry_mask);
        this.g_aquifer_salinity = new GuiPropertyField(this.parent);
        this.g_timeproductionend = new GuiPropertyField(this.parent);
        this.g_timeend = new GuiPropertyField(this.parent);
        this.g_timestep = new GuiPropertyField(this.parent);
        this.g_timesteppostprod = new GuiPropertyField(this.parent);
        this.nx = new GuiPropertyField(this.parent);
        this.minx = new GuiPropertyField(this.parent);
        this.maxx = new GuiPropertyField(this.parent);
        this.ny = new GuiPropertyField(this.parent);
        this.miny = new GuiPropertyField(this.parent);
        this.maxy = new GuiPropertyField(this.parent);
        this.nz = new GuiPropertyField(this.parent);
        this.minz = new GuiPropertyField(this.parent);
        this.maxz = new GuiPropertyField(this.parent);
        GuiPropertyField[] guiPropertyFieldArray = roi = new GuiPropertyField[]{this.nx, this.minx, this.maxx, this.ny, this.miny, this.maxy};
        int n = roi.length;
        int n2 = 0;
        while (n2 < n) {
            GuiPropertyField g = guiPropertyFieldArray[n2];
            this.geometry_mask.coupleGuiProperty(g, true);
            ++n2;
        }
        GuiPropertyField[] guiPropertyFieldArray2 = roi3d = new GuiPropertyField[]{this.nz, this.minz, this.maxz};
        int n3 = roi3d.length;
        n = 0;
        while (n < n3) {
            GuiPropertyField g = guiPropertyFieldArray2[n];
            this.geometry_mask.coupleGuiProperty(g, true, 3);
            ++n;
        }
        JPanel west = new JPanel(new BorderLayout());
        JPanel west1 = new JPanel(new GridBagLayout());
        west.add((Component)west1, "Center");
        Border paneEdge = BorderFactory.createEtchedBorder(0);
        west1.setBorder(paneEdge);
        JLabel label = new JLabel("");
        label.setPreferredSize(new Dimension(30, this.filedheight));
        GridBagAdder.add(west1, LayoutUtil.createNorthWestPanel(label), 0, 0, 1, 1, 1, 1, 1, 10);
        int irow = 0;
        PanelsUtil.add2GridBagRowLine(west1, "REGION OF INTEREST ", 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.minx, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.maxx, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.miny, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.maxy, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.minz, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.maxz, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.geometry_mask, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.nx, 5, irow - 7);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.ny, 5, irow - 6);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.nz, 5, irow - 5);
        PanelsUtil.add2GridBagRowLine(west1, "", 1, irow++);
        PanelsUtil.add2GridBagRowLine(west1, "AQUIFER PROPERTIES ", 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.g_aquifer_temp, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.g_aquifer_depth, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.g_aquifer_thickness, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.g_aquifer_porosity, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.g_aquifer_ntg, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.g_aquifer_actnum, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.g_aquifer_perm_x_mdarcy, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.g_aquifer_perm_y_mdarcy, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.g_aquifer_perm_z_mdarcy, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.g_aquifer_salinity, 1, irow++);
        PanelsUtil.add2GridBagRowLine(west1, "", 1, irow++);
        PanelsUtil.add2GridBagRowLine(west1, "CALCULATION SETTINGS ", 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.g_timeproductionend, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.g_timeend, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.g_timestep, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(west1, this.g_timesteppostprod, 1, irow++);
        this.add(west);
    }

    public void updateProjectFromGUI(AquiferProject project) {
        try {
            PropertyFactory.setGuiProperty(project.getNx(), this.nx);
            PropertyFactory.setGuiProperty(project.getMinx(), this.minx);
            PropertyFactory.setGuiProperty(project.getMaxx(), this.maxx);
            PropertyFactory.setGuiProperty(project.getNy(), this.ny);
            PropertyFactory.setGuiProperty(project.getMiny(), this.miny);
            PropertyFactory.setGuiProperty(project.getMaxy(), this.maxy);
            PropertyFactory.setGuiProperty(project.getNz(), this.nz);
            PropertyFactory.setGuiProperty(project.getMinz(), this.minz);
            PropertyFactory.setGuiProperty(project.getMaxz(), this.maxz);
            PropertyFactory.setGuiProperty(project.getGeometryMask(), this.geometry_mask);
            PropertyFactory.setGuiProperty(project.getAquifer_temp(), this.g_aquifer_temp);
            PropertyFactory.setGuiProperty(project.getAquifer_depth(), this.g_aquifer_depth);
            PropertyFactory.setGuiProperty(project.getAquifer_thickness(), this.g_aquifer_thickness);
            PropertyFactory.setGuiProperty(project.getAquifer_porosity(), this.g_aquifer_porosity);
            PropertyFactory.setGuiProperty(project.getAquifer_ntg(), this.g_aquifer_ntg);
            PropertyFactory.setGuiProperty(project.getAquifer_actnum(), this.g_aquifer_actnum);
            PropertyFactory.setGuiProperty(project.getAquifer_perm_x_mdarcy(), this.g_aquifer_perm_x_mdarcy);
            PropertyFactory.setGuiProperty(project.getAquifer_perm_y_mdarcy(), this.g_aquifer_perm_y_mdarcy);
            PropertyFactory.setGuiProperty(project.getAquifer_perm_z_mdarcy(), this.g_aquifer_perm_z_mdarcy);
            PropertyFactory.setGuiProperty(project.getAquifer_salinity(), this.g_aquifer_salinity);
            PropertyFactory.setGuiProperty(project.getTimeproductionend(), this.g_timeproductionend);
            PropertyFactory.setGuiProperty(project.getTimeend(), this.g_timeend);
            PropertyFactory.setGuiProperty(project.getTimestep(), this.g_timestep);
            PropertyFactory.setGuiProperty(project.getTimestepPostProd(), this.g_timesteppostprod);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateGUIFromProject(AquiferProject project) {
        this.nx.updateValuesFromProperty(project.getNx());
        this.minx.updateValuesFromProperty(project.getMinx());
        this.maxx.updateValuesFromProperty(project.getMaxx());
        this.ny.updateValuesFromProperty(project.getNy());
        this.miny.updateValuesFromProperty(project.getMiny());
        this.maxy.updateValuesFromProperty(project.getMaxy());
        this.nz.updateValuesFromProperty(project.getNz());
        this.minz.updateValuesFromProperty(project.getMinz());
        this.maxz.updateValuesFromProperty(project.getMaxz());
        this.geometry_mask.updateValuesFromProperty(project.getGeometryMask());
        this.g_aquifer_temp.updateValuesFromProperty(project.getAquifer_temp());
        this.g_aquifer_depth.updateValuesFromProperty(project.getAquifer_depth());
        this.g_aquifer_thickness.updateValuesFromProperty(project.getAquifer_thickness());
        this.g_aquifer_porosity.updateValuesFromProperty(project.getAquifer_porosity());
        this.g_aquifer_ntg.updateValuesFromProperty(project.getAquifer_ntg());
        this.g_aquifer_actnum.updateValuesFromProperty(project.getAquifer_actnum());
        this.g_aquifer_perm_x_mdarcy.updateValuesFromProperty(project.getAquifer_perm_x_mdarcy());
        this.g_aquifer_perm_y_mdarcy.updateValuesFromProperty(project.getAquifer_perm_y_mdarcy());
        this.g_aquifer_perm_z_mdarcy.updateValuesFromProperty(project.getAquifer_perm_z_mdarcy());
        this.g_aquifer_salinity.updateValuesFromProperty(project.getAquifer_salinity());
        this.g_timeproductionend.updateValuesFromProperty(project.getTimeproductionend());
        this.g_timeend.updateValuesFromProperty(project.getTimeend());
        this.g_timestep.updateValuesFromProperty(project.getTimestep());
        this.g_timesteppostprod.updateValuesFromProperty(project.getTimestepPostProd());
        if (PropertyFactory.getITYPEGEOM() == 2) {
            this.nz.isVisible(false);
            this.minz.isVisible(false);
            this.maxz.isVisible(false);
            this.g_aquifer_perm_z_mdarcy.isVisible(false);
        }
        if (PropertyFactory.getITYPEGEOM() == 3) {
            this.nz.isVisible(true);
            this.minz.isVisible(true);
            this.maxz.isVisible(true);
            this.g_aquifer_perm_z_mdarcy.isVisible(true);
        }
        this.repaint();
    }
}

