/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import tno.geoenergy.geothermalaquifer.AQUIFERMAIN;
import tno.geoenergy.geothermalaquifer.AquiferProject;
import tno.geoenergy.geothermalaquifer.gui.PanelsUtil;
import tno.geoenergy.geothermalaquifer.gui.components.GuiPropertyCombo;
import tno.geoenergy.geothermalaquifer.gui.components.GuiWellPropertyField;
import tno.geoenergy.logging.Logger;
import tno.geoenergy.properties.PropertyFactory;

public class InputPanelWells
extends JPanel {
    JPanel west3;
    JPanel west;
    private static Logger logger = Logger.getLogger(InputPanelWells.class.getName());
    GuiWellPropertyField g_wellinj_x;
    GuiWellPropertyField g_wellinj_y;
    GuiWellPropertyField g_welldiameter;
    GuiWellPropertyField g_wellskin;
    GuiWellPropertyField g_welltemp;
    GuiWellPropertyField g_wellpres;
    GuiWellPropertyField g_wellvolrate;
    GuiPropertyCombo g_prescalc;
    GuiPropertyCombo g_presequilibrium;
    Frame parent;

    public InputPanelWells(Frame parent) {
        this.parent = parent;
        this.initialize();
    }

    private void initialize() {
        this.g_wellinj_x = new GuiWellPropertyField(this.parent);
        this.g_wellinj_y = new GuiWellPropertyField(this.parent);
        this.g_welldiameter = new GuiWellPropertyField(this.parent);
        this.g_wellskin = new GuiWellPropertyField(this.parent);
        this.g_welltemp = new GuiWellPropertyField(this.parent);
        this.g_wellpres = new GuiWellPropertyField(this.parent);
        this.g_wellvolrate = new GuiWellPropertyField(this.parent);
        this.g_prescalc = new GuiPropertyCombo(this.parent);
        this.g_presequilibrium = new GuiPropertyCombo(this.parent);
        this.g_prescalc.coupleGuiProperty(this.g_wellvolrate, true);
        this.g_prescalc.coupleGuiProperty(this.g_wellpres, false);
        this.g_prescalc.coupleGuiProperty(this.g_presequilibrium, false);
        this.west = new JPanel(new BorderLayout());
        this.west3 = new JPanel(new GridBagLayout());
        this.west.add((Component)this.west3, "Center");
        Border paneEdge = BorderFactory.createEtchedBorder(0);
        this.west3.setBorder(paneEdge);
        int irow = 0;
        PanelsUtil.add2GridBagHeaderWellRow(this.west3, this.parent, 1, irow++);
        PanelsUtil.add2GridBagHeaderWellNameRow(this.west3, this.g_wellvolrate, 1, irow++);
        PanelsUtil.add2GridBagWellRow(this.west3, this.g_wellinj_x, 1, irow++);
        PanelsUtil.add2GridBagWellRow(this.west3, this.g_wellinj_y, 1, irow++);
        PanelsUtil.add2GridBagWellRow(this.west3, this.g_welldiameter, 1, irow++);
        PanelsUtil.add2GridBagWellRow(this.west3, this.g_wellskin, 1, irow++);
        PanelsUtil.add2GridBagWellRow(this.west3, this.g_wellpres, 1, irow++);
        PanelsUtil.add2GridBagWellRow(this.west3, this.g_welltemp, 1, irow++);
        PanelsUtil.add2GridBagWellRow(this.west3, this.g_wellvolrate, 1, irow++);
        PanelsUtil.add2GridBagRowGuiProperty(this.west3, this.g_prescalc, 1, irow++);
        this.add(this.west);
    }

    public void updateProjectFromGUI(AquiferProject project) {
        try {
            PropertyFactory.setGuiProperty(project.getWell_x(), this.g_wellinj_x);
            PropertyFactory.setGuiProperty(project.getWell_y(), this.g_wellinj_y);
            PropertyFactory.setGuiProperty(project.getWelldiameter(), this.g_welldiameter);
            PropertyFactory.setGuiProperty(project.getWellskin(), this.g_wellskin);
            PropertyFactory.setGuiProperty(project.getWell_temp(), this.g_welltemp);
            PropertyFactory.setGuiProperty(project.getWell_pressure(), this.g_wellpres);
            PropertyFactory.setGuiProperty(project.getWell_volrate(), this.g_wellvolrate);
            PropertyFactory.setGuiProperty(project.getPressureMode(), this.g_prescalc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateGUIFromProject(AquiferProject project) {
        this.g_wellinj_x.updateValuesFromProperty(project.getWell_x());
        this.g_wellinj_y.updateValuesFromProperty(project.getWell_y());
        this.g_welldiameter.updateValuesFromProperty(project.getWelldiameter());
        this.g_wellskin.updateValuesFromProperty(project.getWellskin());
        this.g_welltemp.updateValuesFromProperty(project.getWell_temp());
        this.g_wellpres.updateValuesFromProperty(project.getWell_pressure());
        this.g_wellvolrate.updateValuesFromProperty(project.getWell_volrate());
        this.g_prescalc.updateValuesFromProperty(project.getPressureMode());
        if (PropertyFactory.getITYPEGEOM() == 2) {
            this.g_prescalc.isEnabled(true);
        }
        PropertyFactory.getITYPEGEOM();
        this.repaint();
    }

    public void refresh() {
        this.west.remove(this.west3);
        this.initialize();
        this.updateGUIFromProject(AQUIFERMAIN.getProject());
        this.updateUI();
    }
}

