/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.table.DefaultTableModel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.NumberCellRenderer;
import tno.geoenergy.fdintegration.model.WellPerforationContainer;
import tno.geoenergy.geothermalaquifer.AQUIFERMAIN;

public class OutputChart
implements ChartProgressListener {
    JFreeChart chart;
    DefaultTableModel tableModel;
    private XYSeriesCollection[] datasets;
    private XYSeries[] series;
    private int dataindex;

    public OutputChart(JPanel parent, String name, String xLabel, String yLabel) {
        this.chart = ChartFactory.createXYLineChart(name, xLabel, yLabel, null, PlotOrientation.VERTICAL, true, true, false);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder());
        ChartPanel panel = new ChartPanel(this.chart);
        panel.setPreferredSize(new Dimension(500, 210));
        panel.setBorder(border);
        JPanel content = new JPanel(new BorderLayout());
        content.add(panel);
        JPanel dashboard = new JPanel(new BorderLayout());
        dashboard.setPreferredSize(new Dimension(300, 120));
        dashboard.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
        Object[] header = new String[]{"Series name", "Year", name};
        this.tableModel = new DefaultTableModel(header, 2);
        JTable table = new JTable(this.tableModel);
        NumberCellRenderer renderer = new NumberCellRenderer();
        table.getColumnModel().getColumn(2).setCellRenderer(renderer);
        dashboard.add(new JScrollPane(table));
        content.add((Component)dashboard, "East");
        parent.add(content);
    }

    public void updateChart() {
        WellPerforationContainer welldata = AQUIFERMAIN.getProject().getWellresults();
        this.tableModel.setRowCount(welldata.size());
        this.datasets = new XYSeriesCollection[welldata.size()];
        this.series = new XYSeries[welldata.size()];
        XYPlot plot = (XYPlot)this.chart.getPlot();
        XYDataset[] datasets = new XYDataset[welldata.size()];
        int i = 0;
        while (i < welldata.size()) {
            double[][] data = welldata.getWellPerforation(i).outputWell2Chart();
            String wellname = welldata.getWellPerforation(i).getNiceWellname(i);
            datasets[i] = this.createDataset(i, wellname, data[this.dataindex], data[0]);
            if (i == 0) {
                plot.setDataset(datasets[i]);
            } else {
                plot.setDataset(i, datasets[i]);
                plot.setRenderer(i, new XYLineAndShapeRenderer(true, true));
            }
            this.tableModel.setValueAt(plot.getDataset(i).getSeriesKey(0), i, 0);
            ++i;
        }
        NumberAxis numberaxis = (NumberAxis)plot.getRangeAxis();
        numberaxis.setAutoRangeIncludesZero(false);
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setDomainCrosshairVisible(true);
        plot.setDomainCrosshairLockedOnData(false);
        this.chart.addProgressListener(this);
    }

    private XYDataset createDataset(int index, String name, double[] data, double[] interval) {
        this.series[index] = new XYSeries((Comparable)((Object)name));
        int i = 0;
        while (i < data.length) {
            this.series[index].add(interval[i], data[i]);
            ++i;
        }
        this.datasets[index] = new XYSeriesCollection();
        this.datasets[index].addSeries(this.series[index]);
        return this.datasets[index];
    }

    @Override
    public void chartProgress(ChartProgressEvent event) {
        if (event.getType() != 2) {
            return;
        }
        JFreeChart c = event.getChart();
        if (c != null) {
            XYPlot plot = (XYPlot)c.getPlot();
            double xx = plot.getDomainCrosshairValue();
            int millis = (int)xx;
            int count = plot.getDatasetCount();
            int i = 0;
            while (i < count) {
                int itemIndex = this.series[i].getX(millis).intValue();
                if (itemIndex >= 0) {
                    XYDataItem item = this.series[i].getDataItem(itemIndex);
                    double x = item.getXValue();
                    double y = item.getYValue();
                    this.tableModel.setValueAt(x, i, 1);
                    this.tableModel.setValueAt(y, i, 2);
                }
                ++i;
            }
        }
    }

    public void setDataindex(int dataindex) {
        this.dataindex = dataindex;
    }
}

