/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer.gui;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tno.geoenergy.data.Grid;
import tno.geoenergy.geothermalaquifer.AQUIFERMAIN;
import tno.geoenergy.geothermalaquifer.OutputReference;
import tno.geoenergy.geothermalaquifer.OutputReferenceContainer;
import tno.geoenergy.geothermalaquifer.gui.gridview.GraphLegend;
import tno.geoenergy.geothermalaquifer.gui.gridview.GridGraph;

public class OutputPanelGrid
extends JPanel
implements ActionListener,
ChangeListener {
    Frame parent;
    GridGraph GridPane;
    Grid inputGrid;
    JLabel positionLabel;
    JPanel controllPanel;
    GraphLegend legend;
    DefaultComboBoxModel cmodel;
    JComboBox maptype;
    JSlider timestepper;
    private JTable DataTable;
    Object[][] tabledata;
    String[] tablecolumnNames;
    float[][] data;
    int numberOfColumns;
    int numberOfLines;
    float[] x;
    float[] y;
    float[] ix;
    float[] iy;
    String[] wellNames;
    float xor;
    float yor;
    float dx;
    float dy;
    float datamin;
    float datamax;
    float undef;
    float xhit = 0.0f;
    float yhit = 0.0f;
    float val = 0.0f;
    float xshift = 0.0f;
    float yshift = 0.0f;
    String Ilabel = "I";
    String Jlabel = "J";
    int timemax = 30;
    int timestep = 1;
    JLabel leg;
    OutputReferenceContainer gridresults;
    String[] mapprefix = new String[]{""};

    public OutputPanelGrid(Frame parent) {
        this.parent = parent;
        this.datamax = -1.0E35f;
        this.datamin = 1.0E38f;
        this.GridPane = new GridGraph();
        this.legend = new GraphLegend();
        this.legend.setGraph(this.GridPane);
        this.leg = new JLabel("legend text");
        this.legend.add(this.leg);
        this.controllPanel = new JPanel();
        this.controllPanel.add(new JLabel("map type"));
        this.cmodel = new DefaultComboBoxModel<String>(this.mapprefix);
        this.maptype = new JComboBox(this.cmodel);
        this.timestepper = new JSlider(0, this.timemax, this.timestep);
        this.timestepper.setMajorTickSpacing(this.timestep);
        this.timestepper.setSnapToTicks(true);
        this.timestepper.setPaintTicks(true);
        this.timestepper.setPaintLabels(true);
        this.controllPanel.add(this.maptype);
        this.controllPanel.add(new JLabel("timestep"));
        this.controllPanel.add(this.timestepper);
        this.positionLabel = new JLabel("[" + this.xhit + " : " + this.yhit + "]");
        this.setLayout(new BorderLayout());
        this.add("Center", this.GridPane);
        this.add("South", this.positionLabel);
        this.add("North", this.controllPanel);
        this.add("East", this.legend);
        this.maptype.addActionListener(this);
        this.timestepper.addChangeListener(this);
        this.GridPane.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (OutputPanelGrid.this.GridPane.isCellCentered()) {
                    OutputPanelGrid.this.xshift = OutputPanelGrid.this.dx / 2.0f;
                    OutputPanelGrid.this.yshift = OutputPanelGrid.this.dy / 2.0f;
                } else {
                    OutputPanelGrid.this.xshift = 0.0f;
                    OutputPanelGrid.this.yshift = 0.0f;
                }
                Point2D.Float pnt = OutputPanelGrid.this.GridPane.getXYvalue(e);
                OutputPanelGrid.this.xhit = pnt.x * OutputPanelGrid.this.dx + OutputPanelGrid.this.xor - OutputPanelGrid.this.xshift;
                OutputPanelGrid.this.yhit = ((float)OutputPanelGrid.this.numberOfLines - pnt.y) * OutputPanelGrid.this.dy + OutputPanelGrid.this.yor - OutputPanelGrid.this.yshift;
                if (OutputPanelGrid.this.inputGrid != null) {
                    OutputPanelGrid.this.val = OutputPanelGrid.this.inputGrid.getValueAtxy(OutputPanelGrid.this.xhit, OutputPanelGrid.this.yhit);
                }
                int row = (int)pnt.y + 1;
                int col = (int)pnt.x + 1;
                if (col < 1) {
                    col = 1;
                }
                if (col > OutputPanelGrid.this.numberOfColumns) {
                    col = OutputPanelGrid.this.numberOfColumns;
                }
                if (row < 1) {
                    row = 1;
                }
                if (row > OutputPanelGrid.this.numberOfLines) {
                    row = OutputPanelGrid.this.numberOfLines;
                }
                OutputPanelGrid.this.positionLabel.setText("[" + OutputPanelGrid.this.xhit + " : " + OutputPanelGrid.this.yhit + " : " + OutputPanelGrid.this.val + "]  " + OutputPanelGrid.this.Ilabel + col + " " + OutputPanelGrid.this.Jlabel + (OutputPanelGrid.this.numberOfLines - row + 1));
            }
        });
    }

    public void loadData(String gridname) {
        Grid g = new Grid(gridname);
        this.init(g, gridname, null, null, null, this.Ilabel, this.Jlabel);
        this.x = AQUIFERMAIN.getProject().getWellsX();
        this.y = AQUIFERMAIN.getProject().getWellsY();
        this.wellNames = AQUIFERMAIN.getProject().getWellsStrings();
        this.GridPane.setProjectName("test");
        this.GridPane.setScaling(this.datamin, this.datamax, false, this.undef);
        this.GridPane.setData(this.data, this.numberOfColumns, this.numberOfLines, true);
        this.GridPane.setscale(this.inputGrid.originx, this.inputGrid.originy, this.inputGrid.dx, this.inputGrid.dy);
        String polygon = String.valueOf(AQUIFERMAIN.getCurrentDir()) + "\\polygon.txt";
        Vector<Float> vx = new Vector<Float>();
        Vector<Float> vy = new Vector<Float>();
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(polygon));){
                String line = br.readLine();
                while (line != null) {
                    String[] vals = line.split(",");
                    vx.add(Float.valueOf(Float.parseFloat(vals[0])));
                    vy.add(Float.valueOf(Float.parseFloat(vals[1])));
                    line = br.readLine();
                }
                if (vx.size() > 0) {
                    float[] ixv = new float[vx.size()];
                    float[] iyv = new float[vy.size()];
                    int i = 0;
                    while (i < vx.size()) {
                        ixv[i] = ((Float)vx.get(i)).floatValue();
                        iyv[i] = ((Float)vy.get(i)).floatValue();
                        ++i;
                    }
                    this.GridPane.setPol(ixv, iyv, "");
                }
                br.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.x != null) {
            this.GridPane.setWells(this.x, this.y, this.wellNames);
        }
    }

    public void init(Grid g, String gridname, float[] xwell, float[] ywell, String[] namewell, String Ilabel, String Jlabel) {
        this.x = xwell;
        this.y = ywell;
        this.wellNames = namewell;
        this.Ilabel = Ilabel;
        this.Jlabel = Jlabel;
        this.inputGrid = g;
        this.xor = this.inputGrid.originx;
        this.yor = this.inputGrid.originy;
        this.dx = this.inputGrid.dx;
        this.dy = this.inputGrid.dy;
        this.numberOfColumns = this.inputGrid.nx;
        this.numberOfLines = this.inputGrid.ny;
        this.tabledata = new Object[this.numberOfLines][this.numberOfColumns + 1];
        this.data = new float[this.numberOfColumns][this.numberOfLines];
        this.tablecolumnNames = new String[this.numberOfColumns + 1];
        this.fillData();
    }

    public void fillData() {
        int iyy;
        int ixx = 0;
        while (ixx < this.numberOfColumns) {
            iyy = 0;
            while (iyy < this.numberOfLines) {
                if (this.inputGrid.defined(this.inputGrid.values[ixx][iyy])) {
                    this.data[ixx][this.numberOfLines - iyy - 1] = this.inputGrid.values[ixx][iyy];
                    if (this.DataTable != null) {
                        this.DataTable.setValueAt(Float.toString(this.data[ixx][this.numberOfLines - iyy - 1]), this.numberOfLines - iyy - 1, ixx + 1);
                    }
                } else {
                    this.data[ixx][this.numberOfLines - iyy - 1] = this.inputGrid.values[ixx][iyy];
                    if (this.DataTable != null) {
                        this.DataTable.setValueAt(Float.toString(this.data[ixx][this.numberOfLines - iyy - 1]), this.numberOfLines - iyy - 1, ixx + 1);
                    }
                }
                ++iyy;
            }
            ++ixx;
        }
        this.undef = this.inputGrid.unknown;
        ixx = 0;
        while (ixx < this.numberOfColumns) {
            this.tablecolumnNames[ixx + 1] = Integer.toString(ixx + 1);
            iyy = 0;
            while (iyy < this.numberOfLines) {
                this.tabledata[iyy][ixx + 1] = Float.toString(this.data[ixx][iyy]);
                if (this.inputGrid.defined(ixx, iyy)) {
                    this.datamax = this.datamax < this.inputGrid.values[ixx][iyy] ? this.inputGrid.values[ixx][iyy] : this.datamax;
                    this.datamin = this.datamin > this.inputGrid.values[ixx][iyy] ? this.inputGrid.values[ixx][iyy] : this.datamin;
                }
                ++iyy;
            }
            ++ixx;
        }
        this.tablecolumnNames[0] = Integer.toString(0);
    }

    public void update() {
        this.gridresults = AQUIFERMAIN.getProject().getGridresults();
        this.mapprefix = this.gridresults.keySet().toArray(new String[this.gridresults.size()]);
        Arrays.sort(this.mapprefix);
        this.cmodel.removeAllElements();
        String[] stringArray = this.mapprefix;
        int n = this.mapprefix.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.cmodel.addElement(s);
            ++n2;
        }
        this.loadMap();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.maptype) {
            this.datamax = -1.0E35f;
            this.datamin = 1.0E38f;
        }
        this.loadMap();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting()) {
            this.loadMap();
        }
    }

    public void loadMap() {
        String mapkey;
        if (this.maptype.getSelectedItem() != null) {
            mapkey = this.maptype.getSelectedItem().toString();
            List<Integer> steps = this.gridresults.getTimeSteps(mapkey);
            if (steps.size() > 0) {
                this.timemax = steps.size() - 1;
                this.timestepper.setLabelTable(this.gridresults.getTimeStepLabels(mapkey));
            } else {
                this.timemax = 0;
            }
        }
        this.timestepper.setMaximum(this.timemax);
        this.timestepper.setMajorTickSpacing(this.timestep);
        if (this.maptype.getSelectedItem() != null) {
            mapkey = this.maptype.getSelectedItem().toString();
            JLabel label = (JLabel)this.timestepper.getLabelTable().get(this.timestepper.getValue());
            OutputReference map = this.gridresults.getMap(mapkey, Integer.parseInt(label.getText()));
            this.leg.setText(map.getUnits());
            this.loadData(map.getFileName());
            this.repaint();
        }
    }
}

