/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import tno.geoenergy.geothermalaquifer.gui.ProgressListener;

public class ProgressDialog
extends JDialog
implements ProgressListener {
    private JProgressBar progressBar;
    private JLabel noteLabel;
    private JButton cancelButton;
    private JLabel iconLabel;
    private boolean showCancelButton = true;
    private boolean canceled = false;
    private Runnable task;
    private Object result;
    public static final Icon INFO_ICON = UIManager.getIcon("OptionPane.informationIcon");
    public static final Icon ERROR_ICON = UIManager.getIcon("OptionPane.errorIcon");
    public static final Icon WARNING_ICON = UIManager.getIcon("OptionPane.warningIcon");
    public static final Icon QUESTION_ICON = UIManager.getIcon("OptionPane.questionIcon");

    public ProgressDialog(Dialog owner, String title) {
        super(owner, title, true);
        this.initComponents();
        this.initLayout(title);
    }

    public ProgressDialog(Frame owner, String title) {
        super(owner, title, true);
        this.initComponents();
        this.initLayout(title);
    }

    private void cancel() {
        this.canceled = true;
        this.cancelButton.setEnabled(false);
        System.out.println("hit cancel");
    }

    public Object getResult() {
        return this.result;
    }

    @Override
    public void incrementProgress() {
        int value = this.progressBar.getValue();
        this.progressBar.setValue(++value);
    }

    private void initComponents() {
        this.progressBar = new JProgressBar();
        this.cancelButton = new JButton("Cancel");
        this.iconLabel = new JLabel(INFO_ICON);
        this.noteLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressDialog.this.cancel();
            }

            @Override
            public boolean isEnabled() {
                return true;
            }
        };
        this.cancelButton.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        this.cancelButton.registerKeyboardAction(cancelAction, KeyStroke.getKeyStroke(27, 0), 2);
        this.cancelButton.addActionListener(cancelAction);
    }

    private void initLayout(String title) {
        Container pane = this.getContentPane();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(0, 0, 0, 0);
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridheight = 2;
        pane.add((Component)this.iconLabel, gc);
        gc.fill = 2;
        gc.weighty = 0.0;
        gc.gridx = 1;
        gc.gridheight = 1;
        pane.add((Component)this.noteLabel, gc);
        pane.add((Component)this.progressBar, gc);
        gc.gridx = 0;
        gc.gridy = -1;
        gc.gridwidth = 2;
        gc.fill = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.anchor = 10;
        if (!title.equals("Saving Project")) {
            pane.add((Component)this.cancelButton, gc);
        }
        if (pane instanceof JComponent) {
            JComponent comp = (JComponent)pane;
            comp.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        }
        this.setSize(new Dimension(250, 125));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    public static final void main(String[] args) {
        final JFrame frame = new JFrame("Demo of ProgressDialog");
        ProgressDialog dialog = new ProgressDialog((Frame)frame, "Making progress??");
        String buttonText = "Do heavy duty complicated task!";
        final JButton buttonCount = new JButton("Do heavy duty complicated task!");
        final Runnable countTask = new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.setMaximum(100);
                int i = 0;
                while (i < 10) {
                    if (ProgressDialog.this.isCanceled()) {
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    int j = 0;
                    while (j < 10) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        int count = i * 10 + j;
                        if (count > 26) {
                            ProgressDialog.this.setResult("What comes after " + count + "?");
                            return;
                        }
                        ProgressDialog.this.setNote("Counted to " + count);
                        ProgressDialog.this.setProgress(count);
                        ++j;
                    }
                    ++i;
                }
            }
        };
        final JProgressBar liveBar = new JProgressBar();
        Runnable liveDemoTask = new Runnable(){

            @Override
            public void run() {
                int i = 0;
                int max = 100;
                boolean up = true;
                liveBar.setMaximum(max);
                while (true) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (i > max) {
                        up = false;
                    }
                    if (i < 0) {
                        up = true;
                    }
                    i = up ? ++i : --i;
                    liveBar.setValue(i);
                }
            }
        };
        Thread live = new Thread(liveDemoTask);
        live.start();
        ActionListener countAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressDialog.this.setTask(countTask);
                Point location = frame.getLocation();
                location.x += 100;
                location.y += 100;
                ProgressDialog.this.setLocation(location);
                buttonCount.setEnabled(false);
                buttonCount.setText("doing it...");
                ProgressDialog.this.setVisible(true);
                buttonCount.setText("Do heavy duty complicated task!");
                buttonCount.setEnabled(true);
                Object error = ProgressDialog.this.getResult();
                if (error != null) {
                    String title = "Error while doing task!";
                    JOptionPane.showMessageDialog(frame, error, title, 0);
                }
            }
        };
        buttonCount.addActionListener(countAction);
        JTextArea message = new JTextArea();
        message.setText("  Watch how the frame still gets updated while we are doing our heavy duty task!   ");
        frame.getContentPane().setLayout(new GridLayout(0, 1));
        frame.getContentPane().add(message);
        frame.getContentPane().add(buttonCount);
        frame.getContentPane().add(liveBar);
        frame.pack();
        frame.setVisible(true);
    }

    public void setIcon(Icon icon) {
        this.iconLabel.setIcon(icon);
    }

    @Override
    public void setMaximum(int max) {
        this.progressBar.setMaximum(max);
    }

    @Override
    public void setNote(String message) {
        this.noteLabel.setText(message);
    }

    @Override
    public void setProgress(int progress) {
        this.progressBar.setValue(progress);
    }

    @Override
    public void setResult(Object result) {
        this.result = result;
    }

    public void setShowCancelButton(boolean show) {
        this.showCancelButton = show;
    }

    public void setTask(Runnable task) {
        this.task = task;
    }

    @Override
    public void setVisible(boolean b) {
        if (b && this.task != null) {
            this.canceled = false;
            this.cancelButton.setEnabled(true);
            this.cancelButton.setVisible(this.showCancelButton);
            this.iconLabel.setVisible(this.iconLabel.getIcon() != null);
            this.result = null;
            this.setProgress(0);
            final TaskRunner r = new TaskRunner();
            Runnable post = new Runnable(){

                @Override
                public void run() {
                    Thread t = new Thread(r);
                    t.start();
                }
            };
            SwingUtilities.invokeLater(post);
        }
        super.setVisible(b);
    }

    private class TaskRunner
    implements Runnable {
        private TaskRunner() {
        }

        @Override
        public void run() {
            try {
                ProgressDialog.this.task.run();
            }
            finally {
                ProgressDialog.this.setVisible(false);
            }
        }
    }
}

