/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer.gui.components;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import tno.geoenergy.geothermalaquifer.AQUIFERMAIN;
import tno.geoenergy.geothermalaquifer.gui.AquiferDialog;
import tno.geoenergy.geothermalaquifer.gui.components.GuiProperty;
import tno.geoenergy.properties.Grid3DProperty;
import tno.geoenergy.properties.Property;
import tno.geoenergy.properties.PropertyFactory;

public class GuiPropertyButton
extends GuiProperty
implements ActionListener {
    public static int ALLGEOM = -1;
    public JButton show = new JButton("view");
    public JButton grid = new JButton();
    public JButton usegrid = new JButton();
    public Label pname = new Label("");
    Vector<GuiProperty> coupledgp = new Vector();
    Vector<Boolean> inverse = new Vector();
    Vector<Integer> geomtype = new Vector();
    Vector<String> eclipseproperties;
    Frame parent;

    public GuiPropertyButton(Frame parent) {
        this.parent = parent;
        this.show.addActionListener(this);
        this.grid.addActionListener(this);
        this.usegrid.addActionListener(this);
        this.grid.setText(this.filename);
        this.updateUseGrid();
    }

    @Override
    public void isEnabled(Boolean b) {
        super.isEnabled(b);
        this.grid.setEnabled(b);
        this.usegrid.setEnabled(b);
        this.show.setEnabled(b);
        if (b.booleanValue()) {
            this.updateUseGrid();
        }
    }

    public void coupleGuiProperty(GuiProperty gp, Boolean inv) {
        this.coupledgp.add(gp);
        this.inverse.add(inv);
        this.geomtype.add(-1);
        this.updateCoupled();
    }

    public void coupleGuiProperty(GuiProperty gp, Boolean inv, int geom) {
        this.coupledgp.add(gp);
        this.inverse.add(inv);
        this.geomtype.add(geom);
        this.updateCoupled();
    }

    public void updateCoupled() {
        int i = 0;
        while (i < this.coupledgp.size()) {
            if (this.geomtype.get(i) == ALLGEOM || this.geomtype.get(i) == PropertyFactory.getITYPEGEOM()) {
                if (this.inverse.get(i).booleanValue()) {
                    this.coupledgp.get(i).isEnabled(!this.grid.isEnabled());
                } else {
                    this.coupledgp.get(i).isEnabled(this.grid.isEnabled());
                }
            }
            ++i;
        }
    }

    private void updateUseGrid() {
        this.grid.setEnabled(this.useGrid);
        this.show.setEnabled(this.useGrid);
        if (this.useGrid.booleanValue()) {
            this.usegrid.setText("use values");
            this.grid.setBackground(Color.YELLOW);
        } else {
            if (PropertyFactory.getITYPEGEOM() == 2) {
                this.usegrid.setText("use grid");
            }
            if (PropertyFactory.getITYPEGEOM() == 3) {
                this.usegrid.setText("use voxet");
            }
            this.grid.setBackground(Color.LIGHT_GRAY);
        }
        if (!this.coupledgp.isEmpty()) {
            this.updateCoupled();
        }
    }

    @Override
    public void updateValuesFromProperty(Property p) {
        super.updateValuesFromProperty(p);
        this.pname.setText(this.name);
        File f = new File(this.filename);
        this.grid.setText(f.getName());
        this.updateUseGrid();
        if (p instanceof Grid3DProperty) {
            try {
                if (((Grid3DProperty)p).getInput().isGeometry_only()) {
                    this.eclipseproperties = ((Grid3DProperty)p).getInput().getVoxetProperyNames();
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public Vector<String> getEclipseProperties() {
        return this.eclipseproperties;
    }

    public String getFileName() {
        int returnVal;
        JFileChooser fc = new JFileChooser(AquiferDialog.lastOutputDir);
        FileNameExtensionFilter file3d = new FileNameExtensionFilter("3D voxets (*.vo)", "vo");
        FileNameExtensionFilter file3dEcl = new FileNameExtensionFilter("Eclipse (*.GRDECL)", "GRDECL");
        FileNameExtensionFilter file2d = new FileNameExtensionFilter("2D grids (*.grd, *.asc, *.dat)", "grd", "asc", "dat");
        if (PropertyFactory.getITYPEGEOM() == 2) {
            fc.addChoosableFileFilter(file2d);
        }
        if (PropertyFactory.getITYPEGEOM() == 3) {
            fc.addChoosableFileFilter(file3dEcl);
        }
        if ((returnVal = fc.showOpenDialog(this.parent)) == 0) {
            this.filename = fc.getSelectedFile().getPath();
            AquiferDialog.prefs.put("LAST_OUTPUT_DIR", fc.getSelectedFile().getParent());
            try {
                File file = new File(this.filename);
                if (file.exists()) {
                    return this.filename;
                }
                JOptionPane.showMessageDialog(this.parent, "file does not exist\n" + this.filename);
                return "none";
            }
            catch (Exception e) {
                return "none";
            }
        }
        return this.filename;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.usegrid) {
            this.useGrid = this.useGrid == false;
            this.updateUseGrid();
        }
        if (e.getSource() == this.show) {
            AquiferDialog.makeRawGridView(this.filename, this.parent);
        }
        if (e.getSource() == this.grid) {
            this.filename = this.getFileName();
            File f = new File(this.filename);
            this.grid.setText(f.getName());
            this.updateUseGrid();
            AQUIFERMAIN.updateProjectFromGUI();
            AQUIFERMAIN.getProject().updateInput();
            AQUIFERMAIN.updateGUIFromProject();
        }
    }
}

