/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer.gui.components;

import java.awt.Frame;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import tno.geoenergy.geothermalaquifer.gui.components.GuiProperty;
import tno.geoenergy.properties.Property;

public class GuiPropertyCombo
extends GuiProperty
implements ActionListener {
    String[] switchoptions = new String[]{"no", "yes"};
    DefaultComboBoxModel cmodel = new DefaultComboBoxModel<String>(this.switchoptions);
    public JComboBox switchcalc = new JComboBox(this.cmodel);
    Vector<GuiProperty> coupledgp = new Vector();
    Vector<Boolean> inverse = new Vector();
    public Label pname = new Label("");

    public GuiPropertyCombo(Frame parent) {
        this.switchcalc.addActionListener(this);
    }

    @Override
    public void updateValuesFromProperty(Property p) {
        super.updateValuesFromProperty(p);
        this.switchcalc.setSelectedIndex((int)Double.parseDouble(this.value));
        this.pname.setText(this.name);
    }

    public void setSwitchoptions(String[] options) {
        this.cmodel.removeAllElements();
        int i = 0;
        while (i < options.length) {
            this.cmodel.addElement(options[i]);
            ++i;
        }
    }

    public void coupleGuiProperty(GuiProperty gp, Boolean inv) {
        this.coupledgp.add(gp);
        this.inverse.add(inv);
        this.updateCoupled();
    }

    public void updateCoupled() {
        int i = 0;
        while (i < this.coupledgp.size()) {
            if (this.inverse.get(i).booleanValue()) {
                this.coupledgp.get(i).isEnabled(this.switchcalc.getSelectedIndex() == 0);
            } else {
                this.coupledgp.get(i).isEnabled(this.switchcalc.getSelectedIndex() == 1);
            }
            ++i;
        }
    }

    @Override
    public void isEnabled(Boolean b) {
        this.switchcalc.setEnabled(b);
    }

    @Override
    public void isVisible(Boolean b) {
        this.pname.setVisible(b);
        this.switchcalc.setVisible(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.switchcalc) {
            this.value = "" + this.switchcalc.getSelectedIndex();
            if (!this.coupledgp.isEmpty()) {
                this.updateCoupled();
            }
        }
    }
}

