/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer.gui.components;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import tno.geoenergy.data.EclipseGrid;
import tno.geoenergy.geothermalaquifer.gui.AquiferDialog;
import tno.geoenergy.geothermalaquifer.gui.components.GuiProperty;
import tno.geoenergy.geothermalaquifer.gui.components.GuiPropertyButton;
import tno.geoenergy.geothermalaquifer.gui.components.GuiPropertyField;
import tno.geoenergy.properties.Property;
import tno.geoenergy.properties.PropertyFactory;

public class GuiPropertyFieldButton
extends GuiPropertyField
implements ActionListener {
    private int geometry_override = -1;
    String[] options = new String[0];
    public JButton show = new JButton("view");
    public JButton grid = new JButton();
    public JButton usegrid = new JButton();
    Frame parent;

    public GuiPropertyFieldButton(Frame parent) {
        super(parent);
        this.parent = parent;
        this.show.addActionListener(this);
        this.grid.addActionListener(this);
        this.usegrid.addActionListener(this);
        this.grid.setText(this.toNiceName(this.filename));
        this.updateUseGrid();
    }

    public GuiPropertyFieldButton(Frame parent, GuiProperty cgp, int geom) {
        super(parent);
        this.parent = parent;
        this.geometry_override = geom;
        this.coupled = (GuiPropertyButton)cgp;
        this.show.addActionListener(this);
        this.grid.addActionListener(this);
        this.usegrid.addActionListener(this);
        this.updateUseGrid();
    }

    public GuiPropertyFieldButton(Frame parent, GuiProperty cgp) {
        super(parent);
        this.parent = parent;
        this.coupled = (GuiPropertyButton)cgp;
        this.show.addActionListener(this);
        this.grid.addActionListener(this);
        this.usegrid.addActionListener(this);
        this.updateUseGrid();
    }

    @Override
    public void isEnabled(Boolean b) {
        super.isEnabled(b);
        this.grid.setEnabled(b);
        this.usegrid.setEnabled(b);
        this.show.setEnabled(b);
        if (b.booleanValue()) {
            this.updateUseGrid();
        }
    }

    @Override
    public void isVisible(Boolean b) {
        super.isVisible(b);
        this.grid.setVisible(b);
        this.usegrid.setVisible(b);
        this.show.setVisible(b);
    }

    private void updateUseGrid() {
        this.grid.setEnabled(this.useGrid);
        this.textValue.setEnabled(this.useGrid == false);
        this.show.setEnabled(this.useGrid);
        if (this.useGrid.booleanValue()) {
            this.usegrid.setText("use value");
            this.grid.setBackground(Color.YELLOW);
            this.textValue.setBackground(Color.LIGHT_GRAY);
        } else {
            if (PropertyFactory.getITYPEGEOM() == 2 || this.geometry_override == 2) {
                this.usegrid.setText("use grid");
            } else if (PropertyFactory.getITYPEGEOM() == 3) {
                this.usegrid.setText("use voxet");
            }
            this.grid.setBackground(Color.LIGHT_GRAY);
            this.textValue.setBackground(Color.YELLOW);
        }
    }

    @Override
    public void updateValuesFromProperty(Property p) {
        super.updateValuesFromProperty(p);
        try {
            this.grid.setText(this.toNiceName(this.filename));
        }
        catch (Exception e) {
            System.out.println("no file for " + this.name);
        }
        try {
            if (((GuiPropertyButton)this.coupled).getEclipseProperties().size() > 0) {
                this.options = ((GuiPropertyButton)this.coupled).getEclipseProperties().toArray(new String[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateUseGrid();
    }

    public String getFileName() {
        JFileChooser fc = new JFileChooser(AquiferDialog.lastOutputDir);
        FileNameExtensionFilter file3d = new FileNameExtensionFilter("3D voxets (*.vo)", "vo");
        FileNameExtensionFilter file2d = new FileNameExtensionFilter("2D grids (*.grd, *.asc, *.dat)", "grd", "asc", "dat");
        if (PropertyFactory.getITYPEGEOM() == 2 || this.geometry_override == 2) {
            fc.addChoosableFileFilter(file2d);
        } else if (PropertyFactory.getITYPEGEOM() == 3) {
            fc.addChoosableFileFilter(file3d);
        }
        int returnVal = fc.showOpenDialog(this.parent);
        if (returnVal == 0) {
            this.filename = fc.getSelectedFile().getPath();
            AquiferDialog.prefs.put("LAST_OUTPUT_DIR", fc.getSelectedFile().getParent());
            try {
                File file = new File(this.filename);
                if (file.exists()) {
                    return this.filename;
                }
                JOptionPane.showMessageDialog(this.parent, "file does not exist\n" + this.filename);
                return "none";
            }
            catch (Exception e) {
                return "none";
            }
        }
        return this.filename;
    }

    public String getSelector() {
        String s = (String)JOptionPane.showInputDialog(this.parent, "Available properties:", "Select Eclipse property", -1, null, this.options, null);
        if (s != null && s.length() > 0) {
            return "*" + s;
        }
        return "none";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.usegrid) {
            this.useGrid = this.useGrid == false;
            this.updateUseGrid();
        }
        if (e.getSource() == this.show) {
            AquiferDialog.makeRawGridView(this.filename, this.parent);
        }
        if (e.getSource() == this.grid) {
            String res;
            this.filename = this.coupled != null && this.options.length > 0 ? (this.geometry_override == 2 ? String.valueOf(this.coupled.filename) + "*" + EclipseGrid.TOPGRID : ((res = this.getSelector()) != "none" ? String.valueOf(this.coupled.filename) + res : res)) : this.getFileName();
            this.grid.setText(this.toNiceName(this.filename));
            this.updateUseGrid();
        }
    }

    private String toNiceName(String name) {
        if (name.contains("*")) {
            File f = new File(name);
            return "*" + f.getName().split("\\*")[1];
        }
        File f = new File(name);
        return f.getName();
    }
}

