/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer.gui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.util.Vector;
import javax.swing.JTextField;
import tno.geoenergy.geothermalaquifer.gui.PanelsUtil;
import tno.geoenergy.geothermalaquifer.gui.components.GuiWellProperty;
import tno.geoenergy.properties.Property;
import tno.geoenergy.properties.PropertyFactory;
import tno.geoenergy.properties.WellProperty;

public class GuiWellPropertyField
extends GuiWellProperty {
    public Vector<JTextField> columndata = new Vector();
    public Label pname = new Label("");
    public Label punits = new Label("");

    public GuiWellPropertyField(Frame parent) {
        this.initialize();
        this.pname.setText(this.name);
        this.punits.setText(this.units);
    }

    public void initialize() {
        this.columndata.clear();
        int i = 0;
        while (i < PropertyFactory.getITYPEVECTOR()) {
            JTextField textValue = new JTextField("");
            textValue.setHorizontalAlignment(4);
            textValue.setBackground(Color.YELLOW);
            textValue.setPreferredSize(new Dimension(PanelsUtil.fieldwidth, PanelsUtil.fieldheight));
            this.columndata.add(textValue);
            ++i;
        }
    }

    @Override
    public void updateValuesFromProperty(Property p) {
        super.updateValuesFromProperty((WellProperty)p);
        int i = 0;
        while (i < this.value.length) {
            this.columndata.get(i).setText(this.value[i]);
            ++i;
        }
        this.pname.setText(this.name);
        this.punits.setText(this.units);
    }

    @Override
    public void updatePropertyFromGui() {
        int i = 0;
        while (i < this.value.length) {
            this.value[i] = this.columndata.get(i).getText();
            ++i;
        }
    }

    @Override
    public void isEnabled(Boolean b) {
        int i = 0;
        while (i < this.columndata.size()) {
            this.columndata.get(i).setEnabled(b);
            if (b.booleanValue()) {
                this.columndata.get(i).setBackground(Color.YELLOW);
            } else {
                this.columndata.get(i).setBackground(Color.LIGHT_GRAY);
            }
            ++i;
        }
    }
}

