/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer.gui.gridview;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;
import tno.geoenergy.geothermalaquifer.gui.gridview.GridGraph;

public class GraphLegend
extends JPanel
implements Printable {
    GridGraph graph = null;
    int xindent = 35;
    int yindent = 25;
    double xor = 0.0;
    double yor = 0.0;
    byte[] Pixels;
    int columns;
    int rows;
    private Image LegImage;

    public void setGraph(GridGraph graph) {
        this.graph = graph;
        this.drawLegend();
    }

    public void drawLegend() {
        this.columns = 1;
        this.rows = 255;
        this.Pixels = new byte[this.rows * this.columns];
        int index = 0;
        int i = 0;
        while (i < this.columns) {
            int j = 0;
            while (j < this.rows) {
                index = i + j * this.columns;
                float sample = this.rows - j;
                this.Pixels[index] = sample >= 0.0f ? (byte)sample : (byte)0;
                this.Pixels[index] = sample <= 255.0f ? (int)((int)sample) : -1;
                ++j;
            }
            ++i;
        }
        this.LegImage = this.createImage(new MemoryImageSource(this.columns, this.rows, (ColorModel)this.graph.SeisColorModel, this.Pixels, 0, this.columns));
    }

    public void drawContent2D(Graphics2D g) {
        Rectangle rect = g.getClipBounds();
        int hgt = 1;
        int wdt = 1;
        int min_width = 88;
        rect.setSize(hgt, min_width);
        if (this.graph.isPrinting) {
            wdt = rect.width;
            hgt = rect.height;
        } else {
            hgt = (int)this.getSize(null).getHeight();
            wdt = (int)this.getSize(null).getWidth();
        }
        Font MyFont = new Font("SansSerif", 0, 10);
        g.setFont(MyFont);
        this.yor = this.yindent;
        this.xor = this.xindent;
        if (this.graph.DataAvailable) {
            int xp1;
            int yp;
            int xp;
            g.drawImage(this.LegImage, this.xindent, this.yindent, wdt - 2 * this.xindent, hgt - 2 * this.yindent, this);
            g.setColor(new Color(0x7F7F7F));
            int j = 0;
            while (j < this.graph.nTicksZ) {
                xp = wdt - this.xindent + 5;
                yp = (int)(this.yor + ((double)(hgt - this.yindent) - this.yor) / (double)(this.graph.nTicksZ - 1) * (double)j);
                xp1 = (int)this.xor;
                String mstr = String.format("%.1f", this.graph.ZTickMax - this.graph.ZTickDist * (double)j);
                g.drawLine(xp, yp, xp1, yp);
                g.drawString(mstr, xp + 5, yp);
                ++j;
            }
            yp = (int)this.yor;
            xp = (int)this.xor;
            int yp1 = hgt - this.yindent;
            xp1 = wdt - this.xindent;
            g.drawLine(xp, yp, xp1, yp);
            g.drawLine(xp1, yp, xp1, yp1);
            g.drawLine(xp1, yp1, xp, yp1);
            g.drawLine(xp, yp1, xp, yp);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawContent2D(g2);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        return 0;
    }
}

