/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer.gui.gridview;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import tno.geoenergy.geothermalaquifer.gui.gridview.ScaleObject;
import tno.geoenergy.graphics.ColorPalette;

public class GridGraph
extends JPanel
implements Printable {
    byte[] red;
    byte[] green;
    byte[] blue;
    Color[] palette;
    float[][] tracebuf;
    float[] m_x = null;
    float[] m_y = null;
    float[] pol_x = null;
    float[] pol_y = null;
    String[] m_wellNames = null;
    private String pollabel = null;
    int numColors = 256;
    boolean DataAvailable = false;
    int NTR;
    int NSM;
    float zmin = 0.0f;
    float zmax = 1.0f;
    float undef;
    int xindent = 35;
    int yindent = 15;
    double xor = 0.0;
    double yor = 0.0;
    double scale1;
    double scale2;
    double scale3;
    double XTickMax;
    double XTickMin;
    double YTickMax;
    double YTickMin;
    double XTickDist;
    double YTickDist;
    double ZTickMax;
    double ZTickMin;
    double ZTickDist;
    int nTicksX;
    int nTicksY;
    int nTicksZ;
    boolean DisplaySingleTrace = true;
    int CurrentRecord = 0;
    float m_xorg = 0.0f;
    float m_yorg = 0.0f;
    float m_dx = 1.0f;
    float m_dy = 1.0f;
    private Image SeisImage;
    private byte[] SeisPixels;
    IndexColorModel SeisColorModel;
    String projectName = null;
    boolean isPrinting = false;
    boolean isCellCentered = false;
    int m_icolumn = -1;
    int m_jlineRow = -1;
    private boolean logscale = false;

    public boolean isCellCentered() {
        return this.isCellCentered;
    }

    public void setCellCentered(boolean isCellCentered) {
        this.isCellCentered = isCellCentered;
    }

    public boolean isLogscale() {
        return this.logscale;
    }

    public void setLogscale(boolean logscale) {
        this.logscale = logscale;
    }

    public GridGraph() {
        this.setBackground(Color.white);
        ColorPalette cp = new ColorPalette(ColorPalette.COLORS);
        cp.setMinz(0.0f);
        cp.setMaxz(256.0f);
        cp.setStepz(1.0f);
        this.red = new byte[256];
        this.green = new byte[256];
        this.blue = new byte[256];
        cp.stretchScale();
        this.palette = new Color[this.numColors];
        Color c = null;
        int i = 0;
        while (i < this.numColors) {
            c = cp.getColor(i, false);
            int clr = c.getRGB();
            this.palette[i] = c;
            this.red[i] = (byte)c.getRed();
            this.green[i] = (byte)c.getGreen();
            this.blue[i] = (byte)c.getBlue();
            ++i;
        }
        this.SeisColorModel = new IndexColorModel(8, 256, this.red, this.green, this.blue, 0);
    }

    public void setProjectName(String name) {
        this.projectName = name;
    }

    public void setScaling(float min, float max, boolean logscale, float undef) {
        this.logscale = logscale;
        this.zmin = min;
        this.zmax = max;
        this.undef = undef;
        if (logscale) {
            this.zmax = (float)Math.log10(this.zmax);
            this.zmin = (float)Math.log10(this.zmin);
            System.out.println("zmax + zmin " + this.zmax + this.zmin);
        }
        if (this.zmax == this.zmin) {
            this.zmax = this.zmin + 1.0f;
        }
        if (this.DataAvailable) {
            this.initGrid();
            this.initSeisImage();
        }
    }

    public void setData(float[][] data, int ntraces, int nsamples) {
        this.tracebuf = data;
        this.NTR = ntraces;
        this.NSM = nsamples;
        this.SeisPixels = new byte[this.NTR * this.NSM];
        this.DataAvailable = true;
        this.initGrid();
        this.initSeisImage();
    }

    public void setData(float[][] data, int ntraces, int nsamples, boolean cellCentered) {
        this.isCellCentered = cellCentered;
        this.tracebuf = data;
        this.NTR = ntraces;
        this.NSM = nsamples;
        this.SeisPixels = new byte[this.NTR * this.NSM];
        this.DataAvailable = true;
        this.initGrid();
        this.initSeisImage();
    }

    public void setscale(float xorg, float yorg, float dx, float dy) {
        if (this.isCellCentered) {
            this.m_xorg = xorg - dx / 2.0f;
            this.m_yorg = yorg - dy / 2.0f;
        } else {
            this.m_xorg = xorg;
            this.m_yorg = yorg;
        }
        this.m_dx = dx;
        this.m_dy = dy;
    }

    public void setWells(float[] x, float[] y, String[] wellNames) {
        this.m_x = x;
        this.m_y = y;
        this.m_wellNames = wellNames;
    }

    private void initGrid() {
        ScaleObject grd1 = new ScaleObject(0.0, this.NTR, true);
        ScaleObject grd2 = new ScaleObject(0.0, this.NSM, true);
        ScaleObject grd3 = new ScaleObject(this.zmin, this.zmax, true);
        this.XTickMin = grd1.GridMin;
        this.XTickMax = grd1.GridMax;
        this.XTickDist = grd1.GridInt;
        this.nTicksX = grd1.nGrids;
        this.YTickMin = grd2.GridMin;
        this.YTickMax = grd2.GridMax;
        this.YTickDist = grd2.GridInt;
        this.nTicksY = grd2.nGrids;
        this.ZTickMin = grd3.GridMin;
        this.ZTickMax = grd3.GridMax;
        this.ZTickDist = grd3.GridInt;
        this.nTicksZ = grd3.nGrids;
    }

    private void initSeisImage() {
        float scale = 254.0f / (this.zmax - this.zmin);
        int index = 0;
        int i = 0;
        while (i < this.NTR) {
            int j = 0;
            while (j < this.NSM) {
                index = i + j * this.NTR;
                float sample = this.tracebuf[i][j] == this.undef ? 0.0f : (this.logscale ? (float)(Math.log10(this.tracebuf[i][j]) - (double)this.zmin) * scale + 1.0f : (this.tracebuf[i][j] - this.zmin) * scale + 1.0f);
                this.SeisPixels[index] = sample >= 0.0f ? (byte)sample : (byte)0;
                this.SeisPixels[index] = sample <= 255.0f ? (int)((int)sample) : -1;
                ++j;
            }
            ++i;
        }
        this.SeisImage = this.createImage(new MemoryImageSource(this.NTR, this.NSM, (ColorModel)this.SeisColorModel, this.SeisPixels, 0, this.NTR));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawContent2D(g2);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        this.isPrinting = true;
        Graphics2D g2 = (Graphics2D)g;
        int fontHeight = g2.getFontMetrics().getHeight();
        int fontDesent = g2.getFontMetrics().getDescent();
        double pageHeight = pf.getImageableHeight() - (double)fontHeight;
        double pageWidth = pf.getImageableWidth();
        int totalNumPages = 1;
        if (pi >= totalNumPages) {
            this.isPrinting = false;
            return 1;
        }
        RepaintManager currentManager = RepaintManager.currentManager(this);
        currentManager.setDoubleBufferingEnabled(false);
        g2.translate(pf.getImageableX(), pf.getImageableY());
        g2.drawString(" survey: " + this.projectName + " domain: Grid", 0, (int)(pageHeight + (double)fontHeight - (double)fontDesent));
        g2.setClip(0, 0, (int)pageWidth, (int)pageHeight);
        this.drawContent2D(g2);
        currentManager.setDoubleBufferingEnabled(true);
        this.isPrinting = false;
        return 0;
    }

    public void drawContent2D(Graphics2D g) {
        int xp1;
        int yp1;
        int yp;
        int xp;
        Rectangle rect = g.getClipBounds();
        int hgt = 1;
        int wdt = 1;
        if (this.isPrinting) {
            wdt = rect.width;
            hgt = rect.height;
        } else {
            hgt = (int)this.getSize(null).getHeight();
            wdt = (int)this.getSize(null).getWidth();
        }
        this.scale1 = (float)(wdt - 2 * this.xindent) / (float)this.NTR;
        this.scale2 = (float)(hgt - 2 * this.yindent) / (float)this.NSM;
        this.scale3 = (float)this.numColors / (this.zmax - this.zmin);
        Font MyFont = new Font("SansSerif", 0, 10);
        g.setFont(MyFont);
        this.yor = this.yindent;
        this.xor = this.xindent;
        if (this.DataAvailable) {
            String mstr;
            g.drawImage(this.SeisImage, this.xindent, this.yindent, wdt - 2 * this.xindent, hgt - 2 * this.yindent, this);
            g.setColor(new Color(0x7F7F7F));
            int j = 0;
            while (j < this.nTicksX - 1) {
                xp = (int)(this.xor + this.scale1 * ((double)j * this.XTickDist));
                yp = (int)this.yor;
                yp1 = hgt - this.yindent;
                mstr = Integer.toString((int)((double)this.m_xorg + (double)this.m_dx * (this.XTickMin + this.XTickDist * (double)j)));
                g.drawLine(xp, yp, xp, yp1);
                g.drawString(mstr, xp, this.yindent - 5);
                ++j;
            }
            j = 1;
            while (j < this.nTicksY - 1) {
                yp = (int)(this.yor + this.scale2 * ((double)j * this.YTickDist));
                xp = (int)this.xor;
                xp1 = wdt - this.xindent;
                mstr = Integer.toString((int)((double)this.m_yorg + (double)this.m_dy * ((double)this.NSM - (this.YTickMin + this.YTickDist * (double)j))));
                g.drawLine(xp, yp, xp1, yp);
                g.drawString(mstr, xp - this.xindent + 5, yp);
                g.drawString(mstr, xp1 - 10, yp);
                ++j;
            }
            yp = (int)this.yor;
            xp = (int)this.xor;
            yp1 = hgt - this.yindent;
            xp1 = wdt - this.xindent;
            g.drawLine(xp, yp, xp1, yp);
            g.drawLine(xp1, yp, xp1, yp1);
            g.drawLine(xp1, yp1, xp, yp1);
            g.drawLine(xp, yp1, xp, yp);
        }
        if (this.m_x != null) {
            Color c = g.getColor();
            g.setColor(new Color(255, 255, 255));
            int iwell = 0;
            while (iwell < this.m_x.length) {
                xp = (int)(this.xor + this.scale1 * (double)((this.m_x[iwell] - this.m_xorg) / this.m_dx));
                yp = (int)(this.yor + this.scale2 * (double)(this.m_dy * (float)this.NSM - (this.m_y[iwell] - this.m_yorg)) / (double)this.m_dy);
                g.drawLine(xp - 5, yp, xp + 5, yp);
                g.drawLine(xp, yp - 5, xp, yp + 5);
                g.drawString(this.m_wellNames[iwell], xp + 2, yp - 2);
                ++iwell;
            }
            g.setColor(c);
        }
        if (this.m_jlineRow > 0) {
            g.setColor(new Color(0, 250, 250));
            xp = (int)this.xor;
            xp1 = wdt - this.xindent;
            yp1 = yp = (int)(this.yor + this.scale2 * (double)(this.m_dy * (float)this.NSM - ((float)this.m_jlineRow * this.m_dy - this.m_dy / 2.0f)) / (double)this.m_dy);
            g.drawLine(xp, yp, xp1, yp1);
        }
        if (this.m_icolumn > 0) {
            g.setColor(new Color(0, 250, 250));
            yp = (int)this.yor;
            yp1 = hgt - this.yindent;
            xp1 = xp = (int)(this.xor + this.scale1 * (double)(((float)this.m_icolumn * this.m_dx - this.m_dx / 2.0f) / this.m_dx));
            g.drawLine(xp, yp, xp1, yp1);
        }
        if (this.pol_x != null) {
            Color c = g.getColor();
            g.setColor(new Color(0, 0, 0));
            int iwell = 0;
            while (iwell < this.pol_x.length) {
                xp = (int)(this.xor + this.scale1 * (double)(this.pol_x[iwell] - this.m_xorg) / (double)this.m_dx);
                yp = (int)(this.yor + this.scale2 * (double)(this.m_dy * (float)this.NSM - (this.pol_y[iwell] - this.m_yorg)) / (double)this.m_dy);
                int inext = (iwell + 1) % this.pol_x.length;
                xp1 = (int)(this.xor + this.scale1 * (double)(this.pol_x[inext] - this.m_xorg) / (double)this.m_dx);
                yp1 = (int)(this.yor + this.scale2 * (double)(this.m_dy * (float)this.NSM - (this.pol_y[inext] - this.m_yorg)) / (double)this.m_dy);
                g.drawLine(xp, yp, xp1, yp1);
                if (iwell == 0) {
                    g.drawString(this.pollabel, xp + 2, yp - 2);
                }
                ++iwell;
            }
            g.setColor(c);
        }
    }

    public Point2D.Float getXYvalue(MouseEvent e) {
        e.consume();
        int xp = e.getX();
        int yp = e.getY();
        float XVal = (float)(((double)xp - this.xor) / this.scale1);
        float YVal = (float)(((double)yp - this.yor) / this.scale2);
        Point2D.Float pnt = new Point2D.Float(XVal, YVal);
        return pnt;
    }

    public void setPol(float[] x, float[] y, String label) {
        this.pol_x = x;
        this.pol_y = y;
        this.pollabel = label;
    }

    public int getM_icolumn() {
        return this.m_icolumn;
    }

    public void setM_icolumn(int mIcolumn) {
        this.m_icolumn = mIcolumn;
    }

    public int getM_jlineRow() {
        return this.m_jlineRow;
    }

    public void setM_jlineRow(int mJlineRow, boolean inverse) {
        this.m_jlineRow = mJlineRow;
        if (inverse) {
            this.m_jlineRow = this.NSM - this.m_jlineRow + 1;
        }
    }
}

