/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer.gui.gridview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import tno.geoenergy.data.Grid;
import tno.geoenergy.data.SmartGrid;
import tno.geoenergy.geothermalaquifer.gui.gridview.GridGraph;
import tno.geoenergy.geothermalaquifer.gui.gridview.RawGridViewControl;

public class RawGridView
extends JFrame {
    Component GridPanel;
    GridGraph GridPane;
    RawGridView thisRVG;
    boolean inverseJ;
    private JTable DataTable;
    DefaultTableModel DataTableModel;
    Object[][] tabledata;
    int lc = 0;
    int lr = 0;
    String[] tablecolumnNames;
    float[][] data;
    int numberOfColumns;
    int numberOfLines;
    Grid inputGrid;
    Grid outputGrid;
    float[] x;
    float[] y;
    float[] ix;
    float[] iy;
    String[] wellNames;
    float xor;
    float yor;
    float dx;
    float dy;
    float datamin;
    float datamax;
    float undef;
    String USC;
    float xhit = 0.0f;
    float yhit = 0.0f;
    float val = 0.0f;
    float xshift = 0.0f;
    float yshift = 0.0f;
    RawGridViewControl viewControl = null;
    boolean isCellcentered = false;
    JLabel positionLabel;
    String Ilabel = "I";
    String Jlabel = "J";

    public GridGraph getGridPane() {
        return this.GridPane;
    }

    public RawGridView(String gridname, float[] xwell, float[] ywell, String[] namewell, RawGridViewControl viewControl, boolean inverseJ, String Ilabel, String JLabel2, boolean isCellCentered) {
        super("Grid Viewer");
        this.inverseJ = inverseJ;
        this.viewControl = viewControl;
        this.isCellcentered = isCellCentered;
        this.makeViewMenu();
        Grid g = new SmartGrid(gridname, "").getAsGrid();
        this.init(g, gridname, xwell, ywell, namewell, Ilabel, this.Jlabel);
    }

    public RawGridView(Grid g, String gridname, float[] xwell, float[] ywell, String[] namewell, RawGridViewControl viewControl, boolean inverseJ, String Ilabel, String Jlabel, boolean isCellCentered) {
        super("Grid Viewer");
        this.inverseJ = inverseJ;
        this.viewControl = viewControl;
        this.isCellcentered = isCellCentered;
        this.makeViewMenu();
        this.init(g, gridname, xwell, ywell, namewell, Ilabel, Jlabel);
    }

    public void updateGrid(Grid g, String gridname) {
        System.out.println("updating the grid " + gridname);
        this.inputGrid = g;
        this.fillData();
        this.packTable(this.DataTable, 2);
        this.GridPane.setData(this.data, this.numberOfColumns, this.numberOfLines, this.isCellcentered);
    }

    public void init(Grid g, String gridname, float[] xwell, float[] ywell, String[] namewell, String Ilabel, String Jlabel) {
        this.thisRVG = this;
        this.x = xwell;
        this.y = ywell;
        this.wellNames = namewell;
        this.Ilabel = Ilabel;
        this.Jlabel = Jlabel;
        this.inputGrid = g;
        this.xor = this.inputGrid.originx;
        this.yor = this.inputGrid.originy;
        this.dx = this.inputGrid.dx;
        this.dy = this.inputGrid.dy;
        this.numberOfColumns = this.inputGrid.nx;
        this.numberOfLines = this.inputGrid.ny;
        this.tabledata = new Object[this.numberOfLines][this.numberOfColumns + 1];
        this.data = new float[this.numberOfColumns][this.numberOfLines];
        this.tablecolumnNames = new String[this.numberOfColumns + 1];
        this.fillData();
        this.GridPanel = this.makeGridViewPanel(gridname);
        this.getContentPane().add(this.GridPanel, "Center");
    }

    public void fillData() {
        int iyy;
        int iyy2;
        int ixx = 0;
        while (ixx < this.numberOfColumns) {
            iyy2 = 0;
            while (iyy2 < this.numberOfLines) {
                if (this.inputGrid.defined(this.inputGrid.values[ixx][iyy2])) {
                    this.data[ixx][this.numberOfLines - iyy2 - 1] = this.inputGrid.values[ixx][iyy2];
                    if (this.DataTable != null) {
                        this.DataTable.setValueAt(Float.toString(this.data[ixx][this.numberOfLines - iyy2 - 1]), this.numberOfLines - iyy2 - 1, ixx + 1);
                    }
                } else {
                    this.data[ixx][this.numberOfLines - iyy2 - 1] = this.inputGrid.values[ixx][iyy2];
                    if (this.DataTable != null) {
                        this.DataTable.setValueAt(Float.toString(this.data[ixx][this.numberOfLines - iyy2 - 1]), this.numberOfLines - iyy2 - 1, ixx + 1);
                    }
                }
                ++iyy2;
            }
            ++ixx;
        }
        this.datamax = -1.0E35f;
        this.datamin = 1.0E38f;
        this.undef = this.inputGrid.unknown;
        ixx = 0;
        while (ixx < this.numberOfColumns) {
            this.tablecolumnNames[ixx + 1] = Integer.toString(ixx + 1);
            iyy2 = 0;
            while (iyy2 < this.numberOfLines) {
                this.tabledata[iyy2][ixx + 1] = Float.toString(this.data[ixx][iyy2]);
                if (this.inputGrid.defined(ixx, iyy2)) {
                    this.datamax = this.datamax < this.inputGrid.values[ixx][iyy2] ? this.inputGrid.values[ixx][iyy2] : this.datamax;
                    this.datamin = this.datamin > this.inputGrid.values[ixx][iyy2] ? this.inputGrid.values[ixx][iyy2] : this.datamin;
                }
                ++iyy2;
            }
            ++ixx;
        }
        this.tablecolumnNames[0] = Integer.toString(0);
        if (!this.inverseJ) {
            iyy = 0;
            while (iyy < this.numberOfLines) {
                this.tabledata[iyy][0] = Integer.toString(this.numberOfLines - iyy);
                ++iyy;
            }
        } else {
            iyy = 0;
            while (iyy < this.numberOfLines) {
                this.tabledata[iyy][0] = Integer.toString(iyy + 1);
                ++iyy;
            }
        }
    }

    protected Component makeGridViewPanel(String Name) {
        JLabel fillerEdit1 = new JLabel("Interpreted Grid View of " + Name);
        fillerEdit1.setHorizontalAlignment(0);
        this.DataTableModel = new DefaultTableModel(this.tabledata, this.tablecolumnNames);
        this.DataTable = new JTable(this.DataTableModel);
        this.packTable(this.DataTable, 2);
        this.DataTable.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    int rr = RawGridView.this.DataTable.getSelectedRow() - 1;
                    int cc = RawGridView.this.DataTable.getSelectedColumn();
                    if (cc > 1) {
                        try {
                            RawGridView.this.lc = cc;
                            RawGridView.this.lr = rr;
                            RawGridView.this.data[cc - 1][rr] = Float.parseFloat((String)RawGridView.this.DataTable.getValueAt(rr, cc));
                            RawGridView.this.GridPane.setData(RawGridView.this.data, RawGridView.this.numberOfColumns, RawGridView.this.numberOfLines, RawGridView.this.isCellcentered);
                        }
                        catch (NumberFormatException er) {
                            RawGridView.this.DataTable.setValueAt(Float.toString(RawGridView.this.data[cc - 1][rr]), rr, cc);
                        }
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        JScrollPane tableScroll = new JScrollPane(this.DataTable);
        JPanel edit1 = new JPanel();
        edit1.setLayout(new BorderLayout());
        edit1.add("North", fillerEdit1);
        edit1.add("Center", tableScroll);
        this.GridPane = new GridGraph();
        this.GridPane.setProjectName(this.USC);
        this.GridPane.setScaling(this.datamin, this.datamax, false, this.undef);
        this.GridPane.setData(this.data, this.numberOfColumns, this.numberOfLines, this.isCellcentered);
        this.GridPane.setscale(this.inputGrid.originx, this.inputGrid.originy, this.inputGrid.dx, this.inputGrid.dy);
        if (this.x != null) {
            this.GridPane.setWells(this.x, this.y, this.wellNames);
        }
        if (this.GridPane.isCellCentered()) {
            this.xshift = this.dx / 2.0f;
            this.yshift = this.dy / 2.0f;
        } else {
            this.xshift = 0.0f;
            this.yshift = 0.0f;
        }
        this.GridPane.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point2D.Float pnt = RawGridView.this.GridPane.getXYvalue(e);
                RawGridView.this.xhit = pnt.x * RawGridView.this.dx + RawGridView.this.xor - RawGridView.this.xshift;
                RawGridView.this.yhit = ((float)RawGridView.this.numberOfLines - pnt.y) * RawGridView.this.dy + RawGridView.this.yor - RawGridView.this.yshift;
                RawGridView.this.val = RawGridView.this.inverseJ ? RawGridView.this.inputGrid.getValueAtxy(RawGridView.this.xhit, RawGridView.this.yhit) : RawGridView.this.inputGrid.getValueAtxy(RawGridView.this.xhit, RawGridView.this.yhit);
                int row = (int)pnt.y + 1;
                int col = (int)pnt.x + 1;
                if (col < 1) {
                    col = 1;
                }
                if (col > RawGridView.this.numberOfColumns) {
                    col = RawGridView.this.numberOfColumns;
                }
                if (row < 1) {
                    row = 1;
                }
                if (row > RawGridView.this.numberOfLines) {
                    row = RawGridView.this.numberOfLines;
                }
                if (RawGridView.this.inverseJ) {
                    RawGridView.this.positionLabel.setText("[" + RawGridView.this.xhit + " : " + RawGridView.this.yhit + " : " + RawGridView.this.val + "]  " + RawGridView.this.Ilabel + col + " " + RawGridView.this.Jlabel + row);
                } else {
                    RawGridView.this.positionLabel.setText("[" + RawGridView.this.xhit + " : " + RawGridView.this.yhit + " : " + RawGridView.this.val + "]  " + RawGridView.this.Ilabel + col + " " + RawGridView.this.Jlabel + (RawGridView.this.numberOfLines - row + 1));
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Point2D.Float pnt = RawGridView.this.GridPane.getXYvalue(e);
                RawGridView.this.xhit = pnt.x * RawGridView.this.dx + RawGridView.this.xor - RawGridView.this.xshift;
                RawGridView.this.yhit = ((float)RawGridView.this.numberOfLines - pnt.y) * RawGridView.this.dy + RawGridView.this.yor - RawGridView.this.yshift;
                RawGridView.this.val = RawGridView.this.inputGrid.getValueAtxy(RawGridView.this.xhit, RawGridView.this.yhit);
                int row = (int)pnt.y + 1;
                int col = (int)pnt.x + 1;
                if (col < 1) {
                    col = 1;
                }
                if (col > RawGridView.this.numberOfColumns) {
                    col = RawGridView.this.numberOfColumns;
                }
                if (row < 1) {
                    row = 1;
                }
                if (row > RawGridView.this.numberOfLines) {
                    row = RawGridView.this.numberOfLines;
                }
                RawGridView.this.DataTable.changeSelection(row - 1, col - 1, false, false);
                if (RawGridView.this.inverseJ) {
                    RawGridView.this.positionLabel.setText("[" + RawGridView.this.xhit + " : " + RawGridView.this.yhit + " : " + RawGridView.this.val + "]  " + RawGridView.this.Ilabel + col + " " + RawGridView.this.Jlabel + row);
                } else {
                    RawGridView.this.positionLabel.setText("[" + RawGridView.this.xhit + " : " + RawGridView.this.yhit + " : " + RawGridView.this.val + "]  " + RawGridView.this.Ilabel + col + " " + RawGridView.this.Jlabel + (RawGridView.this.numberOfLines - row + 1));
                }
            }
        });
        this.GridPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int col;
                int row;
                Point2D.Float pnt;
                if ((e.getModifiers() & 0x10) == 16) {
                    pnt = RawGridView.this.GridPane.getXYvalue(e);
                    RawGridView.this.xhit = pnt.x * RawGridView.this.dx + RawGridView.this.xor - RawGridView.this.xshift;
                    RawGridView.this.yhit = ((float)RawGridView.this.numberOfLines - pnt.y) * RawGridView.this.dy + RawGridView.this.yor - RawGridView.this.yshift;
                    if (RawGridView.this.inverseJ) {
                        RawGridView.this.val = RawGridView.this.inputGrid.getValueAtxy(RawGridView.this.xhit, RawGridView.this.yhit);
                        System.out.println(" mouse released xhit + yhit + value " + RawGridView.this.xhit + " " + RawGridView.this.yhit + " " + RawGridView.this.val);
                    } else {
                        RawGridView.this.val = RawGridView.this.inputGrid.getValueAtxy(RawGridView.this.xhit, RawGridView.this.yhit);
                    }
                    row = (int)pnt.y + 1;
                    col = (int)pnt.x + 1;
                    if (col < 1) {
                        col = 1;
                    }
                    if (col > RawGridView.this.numberOfColumns) {
                        col = RawGridView.this.numberOfColumns;
                    }
                    if (row < 1) {
                        row = 1;
                    }
                    if (row > RawGridView.this.numberOfLines) {
                        row = RawGridView.this.numberOfLines;
                    }
                    RawGridView.this.DataTable.changeSelection(row - 1, col - 1, false, false);
                    int rowselect = row;
                    rowselect = RawGridView.this.inverseJ ? row : RawGridView.this.numberOfLines - row + 1;
                    RawGridView.this.positionLabel.setText("[" + RawGridView.this.xhit + " : " + RawGridView.this.yhit + " : " + RawGridView.this.val + "]  " + RawGridView.this.Ilabel + col + " " + RawGridView.this.Jlabel + rowselect);
                    if (RawGridView.this.viewControl != null) {
                        RawGridView.this.thisRVG.getGridPane().setM_icolumn(col);
                        RawGridView.this.thisRVG.getGridPane().setM_jlineRow(rowselect, RawGridView.this.inverseJ);
                        RawGridView.this.thisRVG.getGridPane().repaint();
                        System.out.println("col " + col + " row " + rowselect);
                        if (RawGridView.this.inverseJ) {
                            RawGridView.this.viewControl.modifyView(RawGridView.this.thisRVG, col, row);
                        } else {
                            RawGridView.this.viewControl.modifyView(RawGridView.this.thisRVG, col, rowselect);
                        }
                    }
                }
                if ((e.getModifiers() & 4) == 4 && RawGridView.this.x != null) {
                    pnt = RawGridView.this.GridPane.getXYvalue(e);
                    RawGridView.this.xhit = pnt.x * RawGridView.this.dx + RawGridView.this.xor - RawGridView.this.xshift;
                    RawGridView.this.yhit = ((float)RawGridView.this.numberOfLines - pnt.y) * RawGridView.this.dy + RawGridView.this.yor - RawGridView.this.yshift;
                    RawGridView.this.val = RawGridView.this.inverseJ ? RawGridView.this.inputGrid.getValueAtxy(RawGridView.this.xhit, RawGridView.this.yhit) : RawGridView.this.inputGrid.getValueAtxy(RawGridView.this.xhit, RawGridView.this.yhit);
                    row = (int)pnt.y + 1;
                    col = (int)pnt.x + 1;
                    if (col < 1) {
                        col = 1;
                    }
                    if (col > RawGridView.this.numberOfColumns) {
                        col = RawGridView.this.numberOfColumns;
                    }
                    if (row < 1) {
                        row = 1;
                    }
                    if (row > RawGridView.this.numberOfLines) {
                        row = RawGridView.this.numberOfLines;
                    }
                    boolean hit = false;
                    float dist = (RawGridView.this.xhit - RawGridView.this.x[0]) * (RawGridView.this.xhit - RawGridView.this.x[0]) + (RawGridView.this.yhit - RawGridView.this.y[0]) * (RawGridView.this.yhit - RawGridView.this.y[0]);
                    if (RawGridView.this.inverseJ) {
                        RawGridView.this.positionLabel.setText("[" + RawGridView.this.xhit + " : " + RawGridView.this.yhit + " : " + RawGridView.this.val + "]  " + RawGridView.this.Ilabel + col + " " + RawGridView.this.Jlabel + row);
                    } else {
                        RawGridView.this.positionLabel.setText("[" + RawGridView.this.xhit + " : " + RawGridView.this.yhit + " : " + RawGridView.this.val + "]  " + RawGridView.this.Ilabel + col + " " + RawGridView.this.Jlabel + (RawGridView.this.numberOfLines - row + 1));
                    }
                }
            }
        });
        this.positionLabel = new JLabel("[" + this.xhit + " : " + this.yhit + "]");
        JPanel edit2 = new JPanel();
        edit2.setLayout(new BorderLayout());
        edit2.add("South", this.positionLabel);
        edit2.add("Center", this.GridPane);
        JSplitPane dataPane = new JSplitPane(0);
        dataPane.setTopComponent(edit1);
        dataPane.setBottomComponent(edit2);
        dataPane.setDividerLocation(100);
        return dataPane;
    }

    private void makeViewMenu() {
        this.setDefaultCloseOperation(2);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("GraphView Menu");
        menu.setMnemonic(84);
        menu.getAccessibleContext().setAccessibleDescription("The only menu in this program that has menu items");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("toggle color scaling", 67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        menuItem.getAccessibleContext().setAccessibleDescription("toggles the scaling from normal to log values");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RawGridView.this.switchColorScale();
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Close", 67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        menuItem.getAccessibleContext().setAccessibleDescription("This Closes the Grid");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RawGridView.this.CloseFileAction();
            }
        });
        menu.add(menuItem);
    }

    public void switchColorScale() {
        this.GridPane.setScaling(this.datamin, this.datamax, !this.GridPane.isLogscale(), this.undef);
        if (this.viewControl != null && this.viewControl.v != null) {
            this.viewControl.rvgI.getGridPane().setScaling(this.viewControl.v.getMin(), this.viewControl.v.getMax(), this.GridPane.isLogscale(), this.undef);
            this.viewControl.rvgI.repaint();
            this.viewControl.rvgJ.getGridPane().setScaling(this.viewControl.v.getMin(), this.viewControl.v.getMax(), this.GridPane.isLogscale(), this.undef);
            this.viewControl.rvgJ.repaint();
            this.viewControl.rvgK.getGridPane().setScaling(this.viewControl.v.getMin(), this.viewControl.v.getMax(), this.GridPane.isLogscale(), this.undef);
            this.viewControl.rvgK.repaint();
        }
    }

    @Override
    public void dispose() {
        if (this.viewControl != null && this.viewControl.v != null && this.viewControl.isCloseOthers()) {
            this.viewControl.setCloseOthers(false);
            if (this != this.viewControl.rvgI) {
                this.viewControl.rvgI.CloseFileAction();
            }
            if (this != this.viewControl.rvgJ) {
                this.viewControl.rvgJ.CloseFileAction();
            }
            if (this != this.viewControl.rvgK) {
                this.viewControl.rvgK.CloseFileAction();
            }
        }
        super.dispose();
        this.setVisible(false);
        this.inputGrid = null;
        this.outputGrid = null;
        this.data = null;
        this.DataTable = null;
        this.DataTableModel = null;
        this.tabledata = null;
    }

    public void CloseFileAction() {
        this.dispose();
    }

    private void packTable(JTable table, int margin) {
        table.setAutoResizeMode(0);
        int i = 0;
        while (i < table.getColumnCount()) {
            TableColumn col = table.getColumnModel().getColumn(i);
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            int width = comp.getPreferredSize().width;
            int r = 0;
            while (r < table.getRowCount()) {
                renderer = table.getCellRenderer(r, i);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, i), false, false, r, i);
                width = Math.max(width, comp.getPreferredSize().width);
                ++r;
            }
            col.setPreferredWidth(width += margin * 2);
            ++i;
        }
    }
}

