/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer.gui.gridview;

import javax.swing.JFrame;
import tno.geoenergy.data.EclipseGrid;
import tno.geoenergy.data.Grid;
import tno.geoenergy.data.SmartVoxet;
import tno.geoenergy.data.Voxet;
import tno.geoenergy.geothermalaquifer.gui.gridview.RawGridView;
import tno.geoenergy.properties.PropertyFactory;

public class RawGridViewControl
extends JFrame {
    Voxet v = null;
    RawGridView rvgK = null;
    Grid gK = null;
    int kindex = -1;
    RawGridView rvgI = null;
    int iindex = -1;
    Grid gI = null;
    RawGridView rvgJ = null;
    int jindex = -1;
    Grid gJ = null;
    static final int I2D = 1;
    static final int I3D = 2;
    boolean invI = true;
    boolean invJ = true;
    boolean invK = false;
    int mode = 1;
    int imax = 0;
    int jmax = 0;
    int kmax = 0;
    boolean closeOthers = true;

    public boolean isCloseOthers() {
        return this.closeOthers;
    }

    public void setCloseOthers(boolean closeOthers) {
        this.closeOthers = closeOthers;
    }

    public RawGridViewControl(String gridname, float[] xwell, float[] ywell, String[] namewell, boolean isCellCentered) {
        int isize = 550;
        int icascade = 550;
        if (gridname.endsWith(".vo") || gridname.contains("*") && !gridname.endsWith(EclipseGrid.TOPGRID)) {
            this.mode = 2;
            this.v = new SmartVoxet(gridname, "").getVoxet();
            System.out.println("voxet read succesful");
            this.kindex = 0;
            double dx = this.v.getDx();
            double dy = this.v.getDy();
            double orx = this.v.getOriginx();
            double ory = this.v.getOriginy();
            this.imax = this.v.getNx();
            this.jmax = this.v.getNy();
            this.kmax = this.v.getNz();
            this.gK = PropertyFactory.getGrid(String.valueOf(this.v.getPropName()) + "_K" + this.kindex, orx, ory, dx, dy, this.v.getUnknown(), this.v.getValuesK(this.kindex, null, this.invK));
            this.gK.values = this.v.getValuesK(this.kindex, this.gK.values, this.invK);
            this.rvgK = new RawGridView(this.gK, String.valueOf(gridname) + "_K", xwell, ywell, namewell, this, this.invK, "I", "J", isCellCentered);
            this.rvgK.setSize(isize, isize);
            this.rvgK.setLocation(0, 100);
            this.rvgK.getGridPane().setScaling(this.v.getMin(), this.v.getMax(), false, this.v.getUnknown());
            this.rvgK.setVisible(true);
            this.jindex = 0;
            dx = this.v.getDx();
            dy = this.v.getDz();
            orx = this.v.getOriginx();
            ory = -(this.v.getOriginz() + this.v.getDz() * (float)(this.v.getNz() - 1));
            System.out.println(" ory " + ory);
            this.gJ = PropertyFactory.getGrid(String.valueOf(this.v.getPropName()) + "_J" + this.jindex, orx, ory, dx, dy, this.v.getUnknown(), this.v.getValuesJ(this.jindex, null, this.invJ));
            this.gJ.values = this.v.getValuesJ(this.jindex, this.gJ.values, this.invJ);
            this.rvgJ = new RawGridView(this.gJ, String.valueOf(gridname) + "_J", xwell, ywell, namewell, this, this.invJ, "I", "K", isCellCentered);
            this.rvgJ.setSize(isize, isize);
            this.rvgJ.setLocation(1 * icascade, 100);
            this.rvgJ.getGridPane().setScaling(this.v.getMin(), this.v.getMax(), false, this.v.getUnknown());
            this.rvgJ.setVisible(true);
            this.iindex = 0;
            dx = this.v.getDy();
            dy = this.v.getDz();
            orx = this.v.getOriginy();
            ory = -(this.v.getOriginz() + this.v.getDz() * (float)(this.v.getNz() - 1));
            this.gI = PropertyFactory.getGrid(String.valueOf(this.v.getPropName()) + "_I" + this.iindex, orx, ory, dx, dy, this.v.getUnknown(), this.v.getValuesI(this.iindex, null, this.invI));
            this.gI.values = this.v.getValuesI(this.kindex, this.gI.values, this.invI);
            this.rvgI = new RawGridView(this.gI, String.valueOf(gridname) + "_I", xwell, ywell, namewell, this, this.invI, "J", "K", isCellCentered);
            this.rvgI.setSize(isize, isize);
            this.rvgI.setLocation(2 * icascade, 100);
            this.rvgI.getGridPane().setScaling(this.v.getMin(), this.v.getMax(), false, this.v.getUnknown());
            this.rvgI.setVisible(true);
            this.setSize(740, 200);
            this.setLocation(0, 200);
            this.setVisible(false);
        } else {
            this.mode = 1;
            this.rvgK = new RawGridView(gridname, xwell, ywell, namewell, this, false, "I", "J", isCellCentered);
            this.rvgK.setSize(740, 740);
            this.rvgK.setLocation(250, 200);
            this.rvgK.setVisible(true);
            this.setVisible(false);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.rvgK != null) {
            this.rvgK.dispose();
        }
        if (this.rvgI != null) {
            this.rvgI.dispose();
        }
        if (this.rvgJ != null) {
            this.rvgJ.dispose();
        }
    }

    public static void main(String[] argv) {
    }

    public void modifyView(RawGridView rvg, int col, int row) {
        if (rvg == this.rvgK) {
            this.iindex = Math.min(col, this.imax);
            this.jindex = Math.min(row, this.jmax);
            if (this.v != null) {
                this.gJ.values = this.v.getValuesJ(this.jindex - 1, this.gJ.values, this.invJ);
                this.rvgJ.updateGrid(this.gJ, String.valueOf(this.v.getPropName()) + "_J" + this.jindex);
                this.rvgJ.getGridPane().setM_icolumn(this.iindex);
                this.rvgJ.getGridPane().setM_jlineRow(this.kindex, this.invJ);
                this.gI.values = this.v.getValuesI(this.iindex - 1, this.gI.values, this.invI);
                this.rvgI.updateGrid(this.gI, String.valueOf(this.v.getPropName()) + "_I" + this.iindex);
                this.rvgI.getGridPane().setM_icolumn(this.jindex);
                this.rvgI.getGridPane().setM_jlineRow(this.kindex, this.invI);
                this.rvgI.repaint();
                this.rvgJ.repaint();
            }
        } else if (rvg == this.rvgI) {
            this.jindex = Math.min(col, this.jmax);
            this.kindex = Math.min(row, this.kmax);
            if (this.v != null) {
                this.gJ.values = this.v.getValuesJ(this.jindex - 1, this.gJ.values, this.invJ);
                this.rvgJ.updateGrid(this.gJ, String.valueOf(this.v.getPropName()) + "_J" + this.jindex);
                this.rvgJ.getGridPane().setM_icolumn(this.iindex);
                this.rvgJ.getGridPane().setM_jlineRow(this.kindex, this.invJ);
                System.out.println("RVGJ updateing for k = " + this.kindex);
                this.gK.values = this.v.getValuesK(this.kindex - 1, this.gK.values, this.invK);
                this.rvgK.updateGrid(this.gK, String.valueOf(this.v.getPropName()) + "_K" + this.kindex);
                this.rvgK.getGridPane().setM_icolumn(this.iindex);
                this.rvgK.getGridPane().setM_jlineRow(this.jindex, this.invK);
                this.rvgJ.repaint();
                this.rvgK.repaint();
            }
        } else if (rvg == this.rvgJ) {
            this.iindex = Math.min(col, this.imax);
            this.kindex = Math.min(row, this.kmax);
            if (this.v != null) {
                this.gI.values = this.v.getValuesI(this.iindex - 1, this.gI.values, this.invJ);
                this.rvgI.updateGrid(this.gI, String.valueOf(this.v.getPropName()) + "_I" + this.iindex);
                this.rvgI.getGridPane().setM_icolumn(this.jindex);
                this.rvgI.getGridPane().setM_jlineRow(this.kindex, this.invJ);
                System.out.println("RVGJ updateing for k = " + this.kindex);
                this.gK.values = this.v.getValuesK(this.kindex - 1, this.gK.values, this.invK);
                this.rvgK.updateGrid(this.gK, String.valueOf(this.v.getPropName()) + "_K" + this.kindex);
                this.rvgK.getGridPane().setM_icolumn(this.iindex);
                this.rvgK.getGridPane().setM_jlineRow(this.jindex, this.invK);
                this.rvgI.repaint();
                this.rvgK.repaint();
            }
        }
    }
}

