/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.geothermalaquifer.gui.gridview;

public class ScaleObject {
    public double Max;
    public double Min;
    public double GridInt;
    public double GridMin;
    public double GridMax;
    public int nGrids;

    public ScaleObject(double MinVal, double MaxVal, boolean isDecimal) {
        this.Max = MaxVal;
        this.Min = MinVal;
        if (this.Max == this.Min) {
            this.Max *= 1.1;
            this.Min *= 0.9;
        }
        this.GridInt = (float)Math.pow(10.0, Math.floor(Math.log(this.Max - this.Min) / Math.log(10.0)));
        this.nGrids = (int)((this.Max - this.Min) / this.GridInt);
        if (isDecimal) {
            if (this.nGrids < 2) {
                this.nGrids *= 5;
                this.GridInt /= 5.0;
            }
            if (this.nGrids < 5) {
                this.nGrids *= 2;
                this.GridInt /= 2.0;
            }
        } else {
            if (this.nGrids < 3) {
                this.nGrids *= 3;
                this.GridInt /= 3.0;
            }
            if (this.nGrids < 5) {
                this.nGrids *= 2;
                this.GridInt /= 2.0;
            }
        }
        int MinIndex = (int)Math.floor(this.Min / this.GridInt);
        int MaxIndex = (int)Math.ceil(this.Max / this.GridInt);
        this.GridMin = (float)(this.GridInt * (double)MinIndex);
        this.GridMax = (float)(this.GridInt * (double)MaxIndex);
        this.nGrids = 1 + MaxIndex - MinIndex;
    }
}

