/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.graphics;

import java.awt.Color;
import java.util.Vector;

public class ColorPalette {
    public static final float OVER255 = 0.003921569f;
    float minz = 0.0f;
    float maxz = 100.0f;
    float stepz = 10.0f;
    public static final Color[] COLORS = new Color[]{new Color(4, 12, 172, 255), new Color(72, 152, 240, 255), new Color(40, 124, 0, 255), new Color(152, 228, 108, 255), new Color(220, 228, 108, 255), new Color(232, 192, 56, 255), new Color(216, 116, 8, 255), new Color(255, 50, 50, 255)};
    protected Vector c = new Vector();
    protected Vector z = new Vector();
    protected Color colorOutside = new Color(50, 50, 50, 255);
    protected String fileName = "";

    public ColorPalette() {
    }

    public ColorPalette(Color[] colors) {
        int i = 0;
        while (i < colors.length) {
            this.add(colors[i], new Float(i));
            ++i;
        }
    }

    public boolean add(Color valc, Float valz) {
        if (this.c.add(valc)) {
            return this.z.add(valz);
        }
        return false;
    }

    public Color getColor(int i) {
        return (Color)this.c.get(i);
    }

    public Float getZ(int i) {
        return (Float)this.z.get(i);
    }

    public Color setColor(int i, Color val) {
        return this.c.set(i, val);
    }

    public Float setZ(int i, Float val) {
        return this.z.set(i, val);
    }

    public Color remove(int i) {
        this.z.remove(i);
        return (Color)this.c.remove(i);
    }

    public void checkvals() {
        float TINY = 1.0E-10f;
        if (this.minz > this.maxz - TINY) {
            this.maxz = this.minz + TINY;
        }
        if (this.stepz <= (this.maxz - this.minz) / 100.0f) {
            this.stepz = (this.maxz - this.minz) / 100.0f;
        }
    }

    public void setZminmaxLinear(Float min, Float max) {
        this.z.clear();
        if (this.c.size() > 1) {
            int i = 0;
            while (i < this.c.size()) {
                this.z.add(new Float((float)i * 1.0f));
                ++i;
            }
            this.stretchMinMax(min, max);
        }
    }

    public void stretchScale() {
        this.stretchMinMax(new Float(this.minz), new Float(this.maxz));
        ColorPalette cp = new ColorPalette();
        int nsteps = Math.round((this.maxz - this.minz) / this.stepz);
        int i = 0;
        while (i <= nsteps) {
            float zz = this.minz + (float)i * this.stepz;
            Color col = this.getColor(zz, true);
            cp.add(col, new Float(zz));
            ++i;
        }
        this.z = cp.z;
        this.c = cp.c;
    }

    public void stretchMinMax(Float min, Float max) {
        if (this.z.size() >= 2 && max.floatValue() > min.floatValue()) {
            float zmin = this.getZ(0).floatValue();
            float zmax = this.getZ(this.size() - 1).floatValue();
            float scale = (max.floatValue() - min.floatValue()) / (zmax - zmin);
            float zprev = 0.0f;
            int i = 1;
            while (i < this.size()) {
                float dznew = this.getZ(i).floatValue() - this.getZ(i - 1).floatValue();
                if (i == 1) {
                    zprev = min.floatValue();
                } else {
                    this.setZ(i - 1, new Float(zprev));
                }
                zprev += dznew * scale;
                ++i;
            }
            this.setZ(0, min);
            this.setZ(this.size() - 1, max);
        }
    }

    public Color copyColor(Color col) {
        Color c = new Color(col.getRed(), col.getGreen(), col.getBlue(), col.getAlpha());
        return c;
    }

    public Color getColor(float z, boolean interpolate) {
        Color col = null;
        if (z < this.getZ(0).floatValue() || z > this.getZ(this.size() - 1).floatValue()) {
            col = this.copyColor(this.colorOutside);
        } else {
            int i = 0;
            while (z > this.getZ(i).floatValue() && i < this.size()) {
                ++i;
            }
            if (i == 0) {
                col = this.copyColor(this.getColor(0));
            } else {
                col = this.copyColor(this.getColor(i - 1));
                if (interpolate) {
                    Color colwork = this.copyColor(this.getColor(i));
                    float z1 = this.getZ(i - 1).floatValue();
                    float z2 = this.getZ(i).floatValue();
                    float inter = z2 - z1;
                    if ((double)inter > 1.0E-30) {
                        inter = (z - z1) / inter;
                        col = this.interpolate(col, colwork, inter);
                    }
                }
            }
        }
        return col;
    }

    public Color interpolate(Color c1, Color c2, float inter) {
        int r = Math.round((float)c1.getRed() * (1.0f - inter) + (float)c2.getRed() * inter);
        int g = Math.round((float)c1.getGreen() * (1.0f - inter) + (float)c2.getGreen() * inter);
        int b = Math.round((float)c1.getBlue() * (1.0f - inter) + (float)c2.getBlue() * inter);
        int a = Math.round((float)c1.getAlpha() * (1.0f - inter) + (float)c2.getAlpha() * inter);
        Color col = new Color(r, g, b, a);
        return col;
    }

    public ColorPalette(Vector colors) {
        if (colors != null) {
            int i = 0;
            while (i < colors.size()) {
                this.add((Color)colors.get(i));
                ++i;
            }
        }
    }

    public Vector getColors() {
        return this.c;
    }

    public void setColors(Vector colors) {
        this.c = (Vector)colors.clone();
    }

    public void addSameColors(int wantedsize, Color color) {
        int i = this.c.size();
        while (i < wantedsize) {
            this.add(color);
            ++i;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String f) {
        this.fileName = new String(f);
    }

    public boolean add(Color val) {
        return this.c.add(val);
    }

    public Color get(int i) {
        return (Color)this.c.get(i);
    }

    public Color set(int i, Color val) {
        return this.c.set(i, val);
    }

    public int size() {
        return this.c.size();
    }

    public float getMaxz() {
        return this.maxz;
    }

    public void setMaxz(float maxz) {
        this.maxz = maxz;
    }

    public float getMinz() {
        return this.minz;
    }

    public void setMinz(float minz) {
        this.minz = minz;
    }

    public float getStepz() {
        return this.stepz;
    }

    public void setStepz(float stepz) {
        this.stepz = stepz;
    }

    public Color[] getColorsArray() {
        int l = this.c.size();
        Color[] cols = new Color[l - 1];
        int i = 0;
        while (i < l - 1) {
            cols[i] = (Color)this.c.get(i);
            ++i;
        }
        return cols;
    }

    public String[] getLegendtexts() {
        int l = this.z.size();
        String[] ss = new String[l - 1];
        int i = 0;
        while (i < l - 1) {
            int z1 = (int)((Float)this.z.get(i)).floatValue();
            int z2 = (int)this.maxz;
            if (i < l - 1) {
                z2 = (int)((Float)this.z.get(i + 1)).floatValue();
            }
            ss[i] = "[" + z1 + ".." + z2 + "]";
            ++i;
        }
        return ss;
    }
}

