/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.logging;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import tno.geoenergy.logging.Level;
import tno.geoenergy.logging.M3rkLogger;

public class Logger {
    String fqcn = "logging.Logger";
    private static Map instances = new Hashtable();
    private Category cat = null;

    private Logger() {
    }

    private Logger(Category cat) {
        this.cat = cat;
    }

    public static Logger getLogger(String name) {
        Category c = Category.getInstance(name);
        Logger l = (Logger)instances.get(c);
        if (l != null) {
            return l;
        }
        l = new Logger(c);
        instances.put(c, l);
        URL confUrl = null;
        if (M3rkLogger.getLocal()) {
            try {
                confUrl = new URL("file", "", "log4j.cfg");
                File f = new File(confUrl.getFile());
                if (!f.exists()) {
                    confUrl = null;
                }
            }
            catch (MalformedURLException mfe) {
                System.out.println("Malformed url: " + mfe.toString());
            }
        } else {
            confUrl = Thread.currentThread().getContextClassLoader().getResource("./log4j.cfg");
        }
        try {
            if (confUrl != null) {
                PropertyConfigurator.configure(confUrl);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return l;
    }

    public void log(Level level, String message) {
        Priority p;
        Priority priority = level == Level.DEBUG ? Priority.DEBUG : (level == Level.INFO ? Priority.INFO : (level == Level.WARN ? Priority.WARN : (level == Level.ERROR ? Priority.ERROR : (p = level == Level.FATAL ? Priority.FATAL : null))));
        if (p == null) {
            p = Priority.DEBUG;
        }
        this.cat.log(this.fqcn, p, message, null);
    }

    public boolean isDebugEnabled() {
        return this.cat.isDebugEnabled();
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message);
    }

    public boolean isInfoEnabled() {
        return this.cat.isInfoEnabled();
    }

    public void info(String message) {
        this.log(Level.INFO, message);
    }

    public void warn(String message) {
        this.log(Level.WARN, message);
    }

    public void error(String message) {
        this.log(Level.ERROR, message);
    }

    public void fatal(String message) {
        this.log(Level.FATAL, message);
        System.exit(0);
    }
}

