/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.pcg;

import java.io.File;
import tno.geoenergy.data.InputXyzPropData;
import tno.geoenergy.data.SmartGrid;
import tno.geoenergy.data.Voxet;
import tno.geoenergy.data.VoxetReader;
import tno.geoenergy.data.VoxetWriter;
import tno.geoenergy.pcg.PCGbase;

public class PCG3D
extends PCGbase {
    public static final int SURFER = 0;
    public static final int ARCINFO = 1;
    public static final int ZYCOR = 2;
    public static final String[] GRIDEXTENSION = new String[]{".grd", ".asc", ".dat"};
    public static final String[] GRIDDATAFORMAT = new String[]{"SURFER", "ARC", "ZYCOR"};
    public int NX = 10;
    public int NY = 10;
    public int NZ = 10;
    protected boolean[][] active = null;
    protected int[][] indexYstart = null;
    public static final int IJ = 0;
    public static final int IMIN = 1;
    public static final int IPLUS = 2;
    public static final int JMIN = 3;
    public static final int JPLUS = 4;
    public static final int KMIN = 5;
    public static final int KPLUS = 6;
    private static final int DIRICHLET = 1;
    private static final int SOURCE = 2;
    public static final float UNKNOWN = -999.25f;
    double dx;
    double dy;
    double dz;
    double originx;
    double originy;
    double originz;
    double[][][] conductancei = null;
    double[][][] conductancej = null;
    double[][][] conductancek = null;
    double[][][] overcpdxdydz = null;
    int[][][] bccodes = null;
    double[][][] bcval = null;
    boolean[][][] okconnect = null;
    boolean[] infinite = new boolean[7];
    boolean[] heatflow = new boolean[7];
    double[] heatflowval = new double[7];
    double[] potentialval = new double[7];
    double[] lmult = new double[7];
    double LMULT = 1000.0;
    double defaultvalue = 1.0;
    double rhocpscale = 1.0;
    double adiag;

    public double getX(int i, int j) {
        return this.originx + (double)i * this.dx;
    }

    public double getY(int i, int j) {
        return this.originy + (double)j * this.dy;
    }

    public void initGeometryProp(Voxet kx, Voxet ky, Voxet kz, Voxet A, double rhocpscale, double rhocp, int nclipz) {
        rhocp = rhocpscale * rhocp;
        this.rhocpscale = rhocpscale;
        this.NX = kx.getNx();
        this.NY = kx.getNy();
        this.NZ = Math.min(kx.getNz(), nclipz);
        this.originx = kx.getOriginx();
        this.originy = kx.getOriginy();
        this.originz = kx.getOriginz();
        this.dx = kx.getDx();
        this.dy = kx.getDy();
        this.dz = kx.getDz();
        this.initializeArrays();
        this.nx = this.initializeIndex(kx);
        this.initializeOK(this.okconnect);
        this.initializeOvercpdxdydz(rhocp);
        this.initializeConductance(kx, ky, kz);
        String fbase = new File(kx.getFileName()).getParent();
        Voxet kxx = new Voxet(kx, String.valueOf(fbase) + "/kxx", "kxx");
        this.copyValuesToVoxet(kxx, this.conductancei);
        VoxetWriter.write(kxx);
        Voxet kyy = new Voxet(ky, String.valueOf(fbase) + "/kyy", "kyy");
        this.copyValuesToVoxet(kyy, this.conductancej);
        VoxetWriter.write(kyy);
        Voxet kzz = new Voxet(kz, String.valueOf(fbase) + "/kzz", "kzz");
        this.copyValuesToVoxet(kzz, this.conductancek);
        VoxetWriter.write(kzz);
        Voxet cp = new Voxet(kx, String.valueOf(fbase) + "/cp", "cp");
        this.copyValuesToVoxet(cp, this.overcpdxdydz);
        VoxetWriter.write(cp);
    }

    private void copyValuesToVoxet(Voxet kx, double[][][] v) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    kx.getValues()[k][j][i] = (float)v[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void initializeConductance(Voxet kx, Voxet ky, Voxet kz) {
        int k;
        int j;
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    this.conductancei[i][j][k] = kx.getUnknown();
                    this.conductancej[i][j][k] = ky.getUnknown();
                    this.conductancek[i][j][k] = kz.getUnknown();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                boolean[] ok = this.okconnect[i][j];
                if (ok[0]) {
                    k = 0;
                    while (k < this.NZ) {
                        if (ok[2]) {
                            this.conductancei[i][j][k] = this.dz * this.dy / this.dx * 1.0 / (0.5 * (double)(1.0f / kx.getValues()[k][j][i]) + 0.5 * (double)(1.0f / kx.getValues()[k][j][i + 1]));
                        }
                        if (ok[4]) {
                            this.conductancej[i][j][k] = this.dz * this.dx / this.dy * 1.0 / (0.5 * (double)(1.0f / ky.getValues()[k][j][i]) + 0.5 * (double)(1.0f / ky.getValues()[k][j + 1][i]));
                        }
                        if (k < this.NZ - 1) {
                            this.conductancek[i][j][k] = this.dx * this.dy / this.dz * 1.0 / (0.5 * (double)(1.0f / kz.getValues()[k][j][i]) + 0.5 * (double)(1.0f / kz.getValues()[k + 1][j][i]));
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void initializeValTemperatureLITH(double basetemp) {
        this.infinite[1] = false;
        this.infinite[2] = false;
        this.infinite[4] = false;
        this.infinite[3] = false;
        this.infinite[6] = false;
        this.infinite[5] = true;
        this.lmult[1] = 10000.0;
        this.lmult[2] = 10000.0;
        this.lmult[4] = 10000.0;
        this.lmult[3] = 10000.0;
        this.lmult[6] = 0.1;
        this.lmult[5] = 0.1;
        this.LMULT = 1.0;
        this.heatflow[1] = true;
        this.heatflow[2] = true;
        this.heatflow[4] = true;
        this.heatflow[3] = true;
        this.heatflow[6] = false;
        this.heatflow[5] = false;
        this.heatflowval[1] = 0.0;
        this.heatflowval[2] = 0.0;
        this.heatflowval[4] = 0.0;
        this.heatflowval[3] = 0.0;
        this.heatflowval[6] = 0.0;
        this.heatflowval[5] = 0.0;
        double dt = 0.0;
        this.potentialval[1] = 0.0;
        this.potentialval[2] = 0.0;
        this.potentialval[4] = 0.0;
        this.potentialval[3] = 0.0;
        this.potentialval[6] = basetemp + dt;
        this.potentialval[5] = 0.0;
    }

    public void initializeValTemperatureBCD() {
        this.infinite[1] = false;
        this.infinite[2] = false;
        this.infinite[4] = false;
        this.infinite[3] = false;
        this.infinite[6] = false;
        this.infinite[5] = true;
        this.lmult[1] = 10000.0;
        this.lmult[2] = 10000.0;
        this.lmult[4] = 10000.0;
        this.lmult[3] = 10000.0;
        this.lmult[6] = 10000.0;
        this.lmult[5] = 0.1;
        this.LMULT = 1.0;
        this.heatflow[1] = true;
        this.heatflow[2] = true;
        this.heatflow[4] = true;
        this.heatflow[3] = true;
        this.heatflow[6] = true;
        this.heatflow[5] = false;
        this.heatflowval[1] = 0.0;
        this.heatflowval[2] = 0.0;
        this.heatflowval[4] = 0.0;
        this.heatflowval[3] = 0.0;
        this.heatflowval[6] = 0.0;
        this.heatflowval[5] = 0.0;
        this.potentialval[1] = 0.0;
        this.potentialval[2] = 0.0;
        this.potentialval[4] = 0.0;
        this.potentialval[3] = 0.0;
        this.potentialval[6] = 0.0;
        this.potentialval[5] = 0.0;
    }

    private void initializeValPressure() {
        this.infinite[1] = true;
        this.infinite[2] = true;
        this.infinite[4] = true;
        this.infinite[3] = true;
        this.infinite[6] = false;
        this.infinite[5] = false;
        this.LMULT = 10000.0;
        this.lmult[1] = 10000.0;
        this.lmult[2] = 10000.0;
        this.lmult[4] = 10000.0;
        this.lmult[3] = 10000.0;
        this.lmult[6] = 10000.0;
        this.lmult[5] = 10000.0;
        this.heatflow[1] = false;
        this.heatflow[2] = false;
        this.heatflow[4] = false;
        this.heatflow[3] = false;
        this.heatflow[6] = true;
        this.heatflow[5] = true;
        this.heatflowval[1] = 0.0;
        this.heatflowval[2] = 0.0;
        this.heatflowval[4] = 0.0;
        this.heatflowval[3] = 0.0;
        this.heatflowval[6] = 0.0;
        this.heatflowval[5] = 0.0;
        this.potentialval[1] = 0.0;
        this.potentialval[2] = 0.0;
        this.potentialval[4] = 0.0;
        this.potentialval[3] = 0.0;
        this.potentialval[6] = 0.0;
        this.potentialval[5] = 0.0;
    }

    private void initializeArrays() {
        this.indexYstart = new int[this.NX][this.NY];
        this.conductancei = new double[this.NX][this.NY][this.NZ];
        this.conductancej = new double[this.NX][this.NY][this.NZ];
        this.conductancek = new double[this.NX][this.NY][this.NZ];
        this.overcpdxdydz = new double[this.NX][this.NY][this.NZ];
        this.bccodes = new int[this.NX][this.NY][this.NZ];
        this.bcval = new double[this.NX][this.NY][this.NZ];
        this.okconnect = new boolean[this.NX][this.NY][5];
    }

    private void initializeOvercpdxdydz(double rhocp) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.overcpdxdydz[i][j][k] = 1.0 / (rhocp * this.dx * this.dy * this.dz);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private int initializeIndex(Voxet kk) {
        this.active = new boolean[this.NX][this.NY];
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                if (kk.defined(kk.getValues()[0][j][i])) {
                    this.active[i][j] = true;
                }
                ++j;
            }
            ++i;
        }
        return this.initializeIndex(this.active);
    }

    private int initializeIndex(boolean[][] active) {
        int lastindex = 0;
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                if (active[i][j]) {
                    this.indexYstart[i][j] = lastindex;
                    lastindex += this.NZ;
                } else {
                    this.indexYstart[i][j] = -10000000;
                }
                ++j;
            }
            ++i;
        }
        return lastindex;
    }

    public int getIndex(int i, int j, int k) {
        return this.indexYstart[i][j] + k;
    }

    public int getI(double x) {
        int i = (int)((x - this.originx) / this.dx);
        if (i < 0 || i > this.NX - 1) {
            i = -1;
        }
        return i;
    }

    public int getJ(double y) {
        int i = (int)((y - this.originy) / this.dy);
        if (i < 0 || i > this.NY - 1) {
            i = -1;
        }
        return i;
    }

    public int getK(double z) {
        int i = (int)((z - this.originz) / this.dz);
        if (i < 0 || i > this.NZ - 1) {
            i = -1;
        }
        return i;
    }

    public void initializeDirichlet(InputXyzPropData bcd) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                boolean[] ok = this.okconnect[i][j];
                if (ok[0]) {
                    int k = 0;
                    while (k < this.NZ) {
                        int n = this.getIndex(i, j, k);
                        int ik = 1;
                        while (ik < 5) {
                            if (!(ok[ik] || this.heatflow[ik] || this.infinite[ik])) {
                                this.bccodes[i][j][k] = 1;
                                this.bcval[i][j][k] = this.potentialval[ik];
                            }
                            ++ik;
                        }
                        ik = -1;
                        if (k == 0) {
                            ik = 5;
                        } else if (k == this.NZ - 1) {
                            ik = 6;
                        }
                        if (ik > 0 && !this.heatflow[ik] && !this.infinite[ik]) {
                            this.bccodes[i][j][k] = 1;
                            this.bcval[i][j][k] = this.potentialval[ik];
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (bcd != null) {
            this.setBCfromdata(bcd);
        }
    }

    private void setBCfromdata(InputXyzPropData bcd) {
        try {
            double[] x = bcd.parseDouble(bcd.getColNames()[0], true);
            double[] y = bcd.parseDouble(bcd.getColNames()[1], true);
            double[] z = bcd.parseDouble(bcd.getColNames()[2], true);
            double[] p = bcd.parseDouble(bcd.getColNames()[3], true);
            int ii = 0;
            while (ii < x.length) {
                int i = this.getI(x[ii]);
                int j = this.getJ(y[ii]);
                int k = this.getK(z[ii]);
                if (i > -1 && j > -1 && k > -1) {
                    this.bccodes[i][j][k] = 1;
                    this.bcval[i][j][k] = p[ii];
                }
                ++ii;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initializeOK(boolean[][][] ok) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                this.getOK(ok[i][j], i, j);
                ++j;
            }
            ++i;
        }
    }

    private void getOK(boolean[] ok, int i, int j) {
        int n = this.getIndex(i, j, 0);
        boolean bl = ok[0] = n > 0;
        if (ok[0]) {
            n = i == 0 ? -100000000 : this.getIndex(i - 1, j, 0);
            ok[1] = n > -1;
            n = i == this.NX - 1 ? -100000000 : this.getIndex(i + 1, j, 0);
            ok[2] = n > 0;
            n = j == 0 ? -100000000 : this.getIndex(i, j - 1, 0);
            ok[3] = n > -1;
            n = j == this.NY - 1 ? -100000000 : this.getIndex(i, j + 1, 0);
            ok[4] = n > -1;
        }
    }

    @Override
    double getDefaultvalue() {
        return this.defaultvalue;
    }

    public void setDefaultvalue(double defaultvalue) {
        this.defaultvalue = defaultvalue;
    }

    @Override
    public void initialize_dirichlet() {
        boolean[] ok = null;
        if (this.b == null) {
            this.b = new double[this.nx];
        }
        int i = 0;
        while (i < this.nx) {
            this.b[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                ok = this.okconnect[i][j];
                if (ok[0]) {
                    int k = 0;
                    while (k < this.NZ) {
                        int n = this.getIndex(i, j, k);
                        int ik = 1;
                        while (ik < 5) {
                            if (!ok[ik] && this.infinite[ik]) {
                                if (ik < 3) {
                                    int n2 = n;
                                    this.b[n2] = this.b[n2] + -DIAGSCALE * this.overcpdxdydz[i][j][k] * this.conductancei[i][j][k] * this.lmult[ik] * this.getDefaultPotential(ik, i, j, k);
                                } else {
                                    int n3 = n;
                                    this.b[n3] = this.b[n3] + -DIAGSCALE * this.overcpdxdydz[i][j][k] * this.conductancej[i][j][k] * this.lmult[ik] * this.getDefaultPotential(ik, i, j, k);
                                }
                            }
                            ++ik;
                        }
                        boolean okKMIN = k > 0;
                        boolean okKPLUS = k < this.NZ - 1;
                        ik = -1;
                        if (okKMIN) {
                            ik = 5;
                        } else if (okKPLUS) {
                            ik = 6;
                        }
                        if (ik > 0 && this.infinite[ik]) {
                            int n4 = n;
                            this.b[n4] = this.b[n4] + -DIAGSCALE * this.overcpdxdydz[i][j][k] * this.conductancek[i][j][k] * this.lmult[ik] * this.getDefaultPotential(ik, i, j, k);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void AtimesV(double[] ax, double[] diag, double[] x) {
        boolean[] ok = null;
        int i = 0;
        while (i < this.nx) {
            ax[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                ok = this.okconnect[i][j];
                if (ok[0]) {
                    int k = 0;
                    while (k < this.NZ) {
                        boolean okKPLUS;
                        int n2;
                        int n = this.getIndex(i, j, k);
                        double t = x[n];
                        double dd = 0.0;
                        this.adiag = 0.0;
                        if (ok[2]) {
                            n2 = this.getIndex(i + 1, j, k);
                            double txf = x[n2];
                            dd += this.conductancei[i][j][k] * (txf - t);
                            this.adiag += this.conductancei[i][j][k];
                        } else {
                            dd = this.applyBCside(dd, i, j, k, 2, t);
                        }
                        if (ok[4]) {
                            n2 = this.getIndex(i, j + 1, k);
                            double tyf = x[n2];
                            dd += this.conductancej[i][j][k] * (tyf - t);
                            this.adiag += this.conductancej[i][j][k];
                        } else {
                            dd = this.applyBCside(dd, i, j, k, 4, t);
                        }
                        if (ok[1]) {
                            n2 = this.getIndex(i - 1, j, k);
                            double txb = x[n2];
                            dd += this.conductancei[i - 1][j][k] * (txb - t);
                            this.adiag += this.conductancei[i - 1][j][k];
                        } else {
                            dd = this.applyBCside(dd, i, j, k, 1, t);
                        }
                        if (ok[3]) {
                            n2 = this.getIndex(i, j - 1, k);
                            double tyb = x[n2];
                            dd += this.conductancej[i][j - 1][k] * (tyb - t);
                            this.adiag += this.conductancej[i][j - 1][k];
                        } else {
                            dd = this.applyBCside(dd, i, j, k, 3, t);
                        }
                        boolean okKMIN = k > 0;
                        boolean bl = okKPLUS = k < this.NZ - 1;
                        if (okKPLUS) {
                            n2 = this.getIndex(i, j, k + 1);
                            double tzf = x[n2];
                            dd += this.conductancek[i][j][k] * (tzf - t);
                            this.adiag += this.conductancek[i][j][k];
                        } else {
                            dd = this.applyBCside(dd, i, j, k, 6, t);
                        }
                        if (okKMIN) {
                            n2 = this.getIndex(i, j, k - 1);
                            double tzb = x[n2];
                            dd += this.conductancek[i][j][k - 1] * (tzb - t);
                            this.adiag += this.conductancek[i][j][k - 1];
                        } else {
                            dd = this.applyBCside(dd, i, j, k, 5, t);
                        }
                        double premult = 1.0;
                        if (this.bccodes[i][j][k] == 1) {
                            premult = 1.0 / DIRICHMULT;
                        }
                        this.adiag *= this.overcpdxdydz[i][j][k];
                        ax[n] = DIAGSCALE * (dd *= this.overcpdxdydz[i][j][k] * premult);
                        diag[n] = DIAGSCALE / this.adiag;
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private double applyBCside(double dd, int i, int j, int k, int BCSIDE, double t) {
        double mult = 1.0;
        if (this.infinite[BCSIDE]) {
            if (this.infinite[BCSIDE]) {
                mult = 1.0 / this.lmult[BCSIDE];
            }
            if (BCSIDE == 5 || BCSIDE == 6) {
                dd += this.conductancek[i][j][k] * mult * -t;
                this.adiag += this.conductancek[i][j][k] * mult;
            }
            if (BCSIDE == 1 || BCSIDE == 2) {
                dd += this.conductancei[i][j][k] * mult * -t;
                this.adiag += this.conductancei[i][j][k] * mult;
            }
            if (BCSIDE == 3 || BCSIDE == 4) {
                dd += this.conductancej[i][j][k] * mult * -t;
                this.adiag += this.conductancej[i][j][k] * mult;
            }
        }
        return dd;
    }

    private double getDefaultPotential(int BCSIDE, int i, int j, int k) {
        return this.potentialval[BCSIDE];
    }

    @Override
    public void initializeRHS(double[] b) {
        int k;
        int j;
        int n = 0;
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    n = this.getIndex(i, j, k);
                    if (n > -1) {
                        b[n] = 0.0;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.initialize_dirichlet();
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    if (this.bccodes[i][j][k] == 2) {
                        n = this.getIndex(i, j, k);
                        b[n] = -this.bcval[i][j][k] * DIAGSCALE * this.overcpdxdydz[i][j][k];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.NX) {
            int j2 = 0;
            while (j2 < this.NY) {
                int k2 = 0;
                while (k2 < this.NZ) {
                    if (this.active[i2][j2]) {
                        boolean ok;
                        boolean bl = ok = k2 == this.NZ - 1;
                        if (ok && this.heatflow[6]) {
                            int n2 = n = this.getIndex(i2, j2, k2);
                            b[n2] = b[n2] + -this.heatflowval[6] * (this.dx * this.dy) * DIAGSCALE * this.overcpdxdydz[i2][j2][k2];
                        }
                        boolean bl2 = ok = k2 == 0;
                        if (ok && this.heatflow[5]) {
                            int n3 = n = this.getIndex(i2, j2, k2);
                            b[n3] = b[n3] + -this.heatflowval[5] * (this.dx * this.dy) * DIAGSCALE * this.overcpdxdydz[i2][j2][k2];
                        }
                    }
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
    }

    public SmartGrid getGridValues(boolean[][] active, double[][] values) {
        SmartGrid grid = new SmartGrid();
        float unknown = -999.25f;
        grid.values = new float[this.NX][this.NY];
        grid.originx = (float)this.originx;
        grid.originy = (float)this.originy;
        grid.dx = (float)this.dx;
        grid.dy = (float)this.dy;
        grid.nx = this.NX;
        grid.ny = this.NY;
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                grid.values[i][j] = active[i][j] ? (float)values[i][j] : unknown;
                ++j;
            }
            ++i;
        }
        grid.m_Grid.originx = grid.originx;
        grid.m_Grid.originy = grid.originy;
        grid.m_Grid.dx = grid.dx;
        grid.m_Grid.dy = grid.dy;
        grid.m_Grid.nx = grid.nx;
        grid.m_Grid.ny = grid.ny;
        grid.m_Grid.values = grid.values;
        grid.m_Grid.unknown = unknown;
        return grid;
    }

    public void output(boolean[][] active, double[][] values, String fname, int format) {
        String ffname = fname;
        SmartGrid grid = this.getGridValues(active, values);
        grid.m_Grid.setFileName(String.valueOf(ffname) + GRIDEXTENSION[format]);
        grid.m_Grid.setDataFormat(GRIDDATAFORMAT[format]);
        try {
            grid.m_Grid.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void outputAsGrids(Voxet kk, boolean init) {
        String fbase = new File(kk.getFileName()).getParent();
        String stage = "init";
        if (!init) {
            stage = "run";
        }
        Voxet vtemp = null;
        vtemp = init ? new Voxet(kk, String.valueOf(fbase) + "/temp_init", "initial_temperature") : new Voxet(kk, String.valueOf(fbase) + "/temp_result", "calculated_temperature");
        vtemp.setNz(this.NZ);
        int k = 0;
        while (k < this.NZ) {
            double[][] values = this.getValues(k, init);
            int i = 0;
            while (i < this.NX) {
                int j = 0;
                while (j < this.NY) {
                    vtemp.getValues()[k][j][i] = (float)values[i][j];
                    ++j;
                }
                ++i;
            }
            this.output(this.active, values, String.valueOf(fbase) + "/potential_" + stage + "_" + (double)k * this.dz, 1);
            ++k;
        }
        VoxetWriter.write(vtemp);
    }

    private double[][] getValues(int k, boolean init) {
        double[][] v = new double[this.NX][this.NY];
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int n = this.getIndex(i, j, k);
                v[i][j] = n > -1 ? (init ? this.x0[n] : this.x[n]) : -999.25;
                ++j;
            }
            ++i;
        }
        return v;
    }

    public void initializeDefaultValue() {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    if (this.bccodes[i][j][k] == 1 && Math.abs(this.bcval[i][j][k]) > Math.abs(this.getDefaultvalue())) {
                        this.setDefaultvalue(this.bcval[i][j][k]);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 7) {
            if (Math.abs(this.potentialval[i]) > Math.abs(this.getDefaultvalue())) {
                this.setDefaultvalue(this.potentialval[i]);
            }
            ++i;
        }
    }

    @Override
    public void setupstartvalue() {
        int n;
        int k;
        int j;
        this.x0 = new double[this.nx];
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    n = this.getIndex(i, j, k);
                    if (n > -1) {
                        this.x0[n] = this.getDefaultvalue();
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    if (this.bccodes[i][j][k] == 1) {
                        n = this.getIndex(i, j, k);
                        this.x0[n] = this.bcval[i][j][k];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.NX) {
            int j2 = 0;
            while (j2 < this.NY) {
                int k2 = 0;
                while (k2 < this.NZ) {
                    boolean[] ok = this.okconnect[i2][j2];
                    if (ok[0]) {
                        if (this.infinite[5] && k2 == 0) {
                            n = this.getIndex(i2, j2, k2);
                            this.x0[n] = this.potentialval[5];
                        }
                        if (this.infinite[6] && k2 == this.NZ - 1) {
                            n = this.getIndex(i2, j2, k2);
                            this.x0[n] = this.potentialval[6];
                        }
                    }
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
    }

    private void initBCPressure() {
        double source = 10000.0;
        int k = 1;
        while (k < this.NZ - 1) {
            this.bccodes[30][30][k] = 2;
            this.bcval[30][30][k] = -source;
            this.bccodes[30][50][k] = 2;
            this.bcval[30][50][k] = source;
            ++k;
        }
    }

    private void initBCTemperature() {
        double source = 10.0;
        int k = 5;
        while (k < 10) {
            this.bccodes[30][30][k] = 1;
            this.bcval[30][30][k] = -source;
            this.bccodes[30][30][k + 10] = 1;
            this.bcval[30][30][k + 10] = source;
            this.bccodes[30][50][k] = 1;
            this.bcval[30][50][k] = source;
            this.bccodes[30][50][k + 10] = 1;
            this.bcval[30][50][k + 10] = -source;
            ++k;
        }
    }

    public static void main(String[] args) {
        PCG3D g = new PCG3D();
        String dir = "D:/papers/thermalmodel3D/pcgtest";
        Voxet kx = VoxetReader.read(String.valueOf(dir) + "/KH.vo");
        Voxet ky = VoxetReader.read(String.valueOf(dir) + "/KH.vo");
        Voxet kz = VoxetReader.read(String.valueOf(dir) + "/KV.vo");
        Object A = null;
        InputXyzPropData bcd = new InputXyzPropData(String.valueOf(dir) + "/residuals_bcd.txt");
        double rhocp = 2700000.0;
        double rhocpscale = 1.0E-5;
        DIAGSCALE = 1.0;
        g.initGeometryProp(kx, ky, kz, null, rhocpscale, rhocp, 30);
        g.initializeValTemperatureBCD();
        g.setDefaultvalue(0.0);
        g.initializeDirichlet(bcd);
        g.initializeDefaultValue();
        g.setupstartvalue();
        g.outputAsGrids(kx, true);
        g.doPCG(1000, 1);
        System.out.println("ready");
        g.outputAsGrids(kx, false);
    }
}

